/* SPDX-License-Identifier: GPL-2.0 or Linux-OpenIB */
/* Copyright (c) 2018 - 2023 Intel Corporation */

#ifndef IG3RDMA_REGS_APF_H
#define IG3RDMA_REGS_APF_H

#include "irdma.h"

#define IG3_APF_CCQPEXTSTATUS 0xBC00004
#define IG3_APF_CCQPEXTSTATUS_RSVD_S 16
#define IG3_APF_CCQPEXTSTATUS_RSVD GENMASK_ULL(16, 31)
#define IG3_APF_CCQPEXTSTATUS_DBPT_INDEX_S 0
#define IG3_APF_CCQPEXTSTATUS_DBPT_INDEX GENMASK_ULL(0, 15)
#define IG3_APF_CCQPHIGH 0xBC0000C
#define IG3_APF_CCQPHIGH_PECCQPHIGH_S 0
#define IG3_APF_CCQPHIGH_PECCQPHIGH GENMASK_ULL(0, 31)
#define IG3_APF_CCQPLOW 0xBC00008
#define IG3_APF_CCQPLOW_PECCQPLOW_S 0
#define IG3_APF_CCQPLOW_PECCQPLOW GENMASK_ULL(0, 31)
#define IG3_APF_CCQPSTATUS 0xBC00000
#define IG3_APF_CCQPSTATUS_CCQP_ERR_S 31
#define IG3_APF_CCQPSTATUS_CCQP_ERR BIT_ULL(31)
#define IG3_APF_CCQPSTATUS_RSVD2_S 28
#define IG3_APF_CCQPSTATUS_RSVD2 GENMASK_ULL(28, 30)
#define IG3_APF_CCQPSTATUS_RDMA_EN_VFS_S 16
#define IG3_APF_CCQPSTATUS_RDMA_EN_VFS GENMASK_ULL(16, 27)
#define IG3_APF_CCQPSTATUS_RSVD1_S 7
#define IG3_APF_CCQPSTATUS_RSVD1 GENMASK_ULL(7, 15)
#define IG3_APF_CCQPSTATUS_HMC_PROFILE_S 4
#define IG3_APF_CCQPSTATUS_HMC_PROFILE GENMASK_ULL(4, 6)
#define IG3_APF_CCQPSTATUS_RSVD0_S 1
#define IG3_APF_CCQPSTATUS_RSVD0 GENMASK_ULL(1, 3)
#define IG3_APF_CCQPSTATUS_CCQP_DONE_S 0
#define IG3_APF_CCQPSTATUS_CCQP_DONE BIT_ULL(31)
#define IG3_APF_CQPDB 0xBC00014
#define IG3_APF_CQPDB_RSVD_S 11
#define IG3_APF_CQPDB_RSVD GENMASK_ULL(11, 31)
#define IG3_APF_CQPDB_WQHEAD_S 0
#define IG3_APF_CQPDB_WQHEAD GENMASK_ULL(0, 10)
#define IG3_APF_CQPERRCODES 0xBC00010
#define IG3_APF_CQPERRCODES_CQP_MAJOR_CODE_S 16
#define IG3_APF_CQPERRCODES_CQP_MAJOR_CODE GENMASK_ULL(16, 31)
#define IG3_APF_CQPERRCODES_CQP_MINOR_CODE_S 0
#define IG3_APF_CQPERRCODES_CQP_MINOR_CODE GENMASK_ULL(0, 15)
#define IG3_APF_CQPTAIL 0xBC00018
#define IG3_APF_CQPTAIL_CQP_OP_ERR_S 31
#define IG3_APF_CQPTAIL_CQP_OP_ERR BIT_ULL(31)
#define IG3_APF_CQPTAIL_RSVD_S 11
#define IG3_APF_CQPTAIL_RSVD GENMASK_ULL(11, 30)
#define IG3_APF_CQPTAIL_WQTAIL_S 0
#define IG3_APF_CQPTAIL_WQTAIL GENMASK_ULL(0, 10)
#define IG3_APF_IPCONFIG0 0xBC00020
#define IG3_APF_IPCONFIG0_RSVD_S 18
#define IG3_APF_IPCONFIG0_RSVD GENMASK_ULL(18, 31)
#define IG3_APF_IPCONFIG0_UDP_SRC_PORT_MASK_EN_S 17
#define IG3_APF_IPCONFIG0_UDP_SRC_PORT_MASK_EN BIT_ULL(31)
#define IG3_APF_IPCONFIG0_USEENTIREIDRANGE_S 16
#define IG3_APF_IPCONFIG0_USEENTIREIDRANGE BIT_ULL(31)
#define IG3_APF_IPCONFIG0_PEIPID_S 0
#define IG3_APF_IPCONFIG0_PEIPID GENMASK_ULL(0, 15)
#define IG3_APF_TCPNOWTIMER 0xBC0001C
#define IG3_APF_TCPNOWTIMER_TCP_NOW_S 0
#define IG3_APF_TCPNOWTIMER_TCP_NOW GENMASK_ULL(0, 31)
#define IG3_APF_DBL_AEQALLOC 0xC0000C0
#define IG3_APF_DBL_AEQALLOC_AECOUNT_S 0
#define IG3_APF_DBL_AEQALLOC_AECOUNT GENMASK_ULL(0, 31)
#define IG3_APF_DBL_AEQITRMASK 0xC000C00
#define IG3_APF_DBL_AEQITRMASK_RESERVED_S 1
#define IG3_APF_DBL_AEQITRMASK_RESERVED GENMASK_ULL(1, 31)
#define IG3_APF_DBL_AEQITRMASK_AEQ_ITR_MASK_S 0
#define IG3_APF_DBL_AEQITRMASK_AEQ_ITR_MASK BIT_ULL(31)
#define IG3_APF_DBL_CEQITRMASK 0xC000800
#define IG3_APF_DBL_CEQITRMASK_CEQ_ITR_MASK_S 31
#define IG3_APF_DBL_CEQITRMASK_CEQ_ITR_MASK BIT_ULL(31)
#define IG3_APF_DBL_CEQITRMASK_RESERVED2_S 12
#define IG3_APF_DBL_CEQITRMASK_RESERVED2 GENMASK_ULL(12, 30)
#define IG3_APF_DBL_CEQITRMASK_CEQINDEX_S 0
#define IG3_APF_DBL_CEQITRMASK_CEQINDEX GENMASK_ULL(0, 11)
#define IG3_APF_DBL_CQACK 0xC000400
#define IG3_APF_DBL_CQACK_RSVD_S 25
#define IG3_APF_DBL_CQACK_RSVD GENMASK_ULL(25, 31)
#define IG3_APF_DBL_CQACK_PECQID_S 0
#define IG3_APF_DBL_CQACK_PECQID GENMASK_ULL(0, 24)
#define IG3_APF_DBL_CQARM 0xC000040
#define IG3_APF_DBL_CQARM_RSVD_S 25
#define IG3_APF_DBL_CQARM_RSVD GENMASK_ULL(25, 31)
#define IG3_APF_DBL_CQARM_PECQID_S 0
#define IG3_APF_DBL_CQARM_PECQID GENMASK_ULL(0, 24)
#define IG3_APF_DBL_CQPDB 0xC000100
#define IG3_APF_DBL_CQPDB_RSVD_S 11
#define IG3_APF_DBL_CQPDB_RSVD GENMASK_ULL(11, 31)
#define IG3_APF_DBL_CQPDB_CQPHEAD_S 0
#define IG3_APF_DBL_CQPDB_CQPHEAD GENMASK_ULL(0, 10)
#define IG3_APF_DBL_WQEALLOC 0xC000000
#define IG3_APF_DBL_WQEALLOC_WQE_DESC_INDEX_S 20
#define IG3_APF_DBL_WQEALLOC_WQE_DESC_INDEX GENMASK_ULL(20, 31)
#define IG3_APF_DBL_WQEALLOC_PEQPID_S 0
#define IG3_APF_DBL_WQEALLOC_PEQPID GENMASK_ULL(0, 19)

#endif /* IG3RDMA_REGS_APF_H */
