/* SPDX-License-Identifier: GPL-2.0 or Linux-OpenIB */
/* Copyright (C) 2019 Intel Corporation */

#ifndef IG3RDMA_REGS_H
#define IG3RDMA_REGS_H

#include "irdma.h"

#define IG3_CPUW_GLPE_CONFIGPKT_LIMIT 0x4200D7AC
#define IG3_CPUW_GLPE_CONFIGPKT_LIMIT_RSVD0_S 6
#define IG3_CPUW_GLPE_CONFIGPKT_LIMIT_RSVD0 GENMASK_ULL(6, 31)
#define IG3_CPUW_GLPE_CONFIGPKT_LIMIT_PECONFIGPKTLIMIT_S 0
#define IG3_CPUW_GLPE_CONFIGPKT_LIMIT_PECONFIGPKTLIMIT GENMASK_ULL(0, 5)
#define IG3_CPUW_GLPE_CPUGP(_i) (0x4200D020 + ((_i) * 4)) /* _i=0...383 */
#define IG3_CPUW_GLPE_CPUGP_MAX_INDEX_I 383
#define IG3_CPUW_GLPE_CPUGP_PECPUGP_S 0
#define IG3_CPUW_GLPE_CPUGP_PECPUGP GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUSTATUS0 0x4200D620
#define IG4_CPUW_GLPE_CPUSTATUS0 0x4201A6A0
#define IG3_CPUW_GLPE_CPUSTATUS0_PECPUSTATUS0_S 0
#define IG3_CPUW_GLPE_CPUSTATUS0_PECPUSTATUS0 GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUSTATUS1 0x4200D624
#define IG4_CPUW_GLPE_CPUSTATUS1 0x4201A6A4
#define IG3_CPUW_GLPE_CPUSTATUS1_PECPUSTATUS1_S 0
#define IG3_CPUW_GLPE_CPUSTATUS1_PECPUSTATUS1 GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUSTATUS2 0x4200D628
#define IG4_CPUW_GLPE_CPUSTATUS2 0x4201A6A8
#define IG3_CPUW_GLPE_CPUSTATUS2_PECPUSTATUS2_S 0
#define IG3_CPUW_GLPE_CPUSTATUS2_PECPUSTATUS2 GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUTRIG0 0x4200D62C
#define IG3_CPUW_GLPE_CPUTRIG0_RSVD1_S 20
#define IG3_CPUW_GLPE_CPUTRIG0_RSVD1 GENMASK_ULL(20, 31)
#define IG3_CPUW_GLPE_CPUTRIG0_IMC_REQUEST0_S 19
#define IG3_CPUW_GLPE_CPUTRIG0_IMC_REQUEST0_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUTRIG0_OOP_REQUEST0_S 18
#define IG3_CPUW_GLPE_CPUTRIG0_OOP_REQUEST0_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUTRIG0_TEP_REQUEST0_S 17
#define IG3_CPUW_GLPE_CPUTRIG0_TEP_REQUEST0_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUTRIG0_RSVD0_S 16
#define IG3_CPUW_GLPE_CPUTRIG0_RSVD0_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUTRIG0_PECPUTRIG0_S 0
#define IG3_CPUW_GLPE_CPUTRIG0_PECPUTRIG0 GENMASK_ULL(0, 15)
#define IG3_CPUW_GLPE_CPUTRIG1 0x4200D630
#define IG3_CPUW_GLPE_CPUTRIG1_RSVD1_S 20
#define IG3_CPUW_GLPE_CPUTRIG1_RSVD1 GENMASK_ULL(20, 31)
#define IG3_CPUW_GLPE_CPUTRIG1_IMC_REQUEST1_S 19
#define IG3_CPUW_GLPE_CPUTRIG1_IMC_REQUEST1_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUTRIG1_OOP_REQUEST1_S 18
#define IG3_CPUW_GLPE_CPUTRIG1_OOP_REQUEST1_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUTRIG1_RSVD0_S 17
#define IG3_CPUW_GLPE_CPUTRIG1_RSVD0_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUTRIG1_CQP_REQUEST1_S 16
#define IG3_CPUW_GLPE_CPUTRIG1_CQP_REQUEST1_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUTRIG1_PECPUTRIG1_S 0
#define IG3_CPUW_GLPE_CPUTRIG1_PECPUTRIG1 GENMASK_ULL(0, 15)
#define IG3_CPUW_GLPE_CPUTRIG2 0x4200D634
#define IG3_CPUW_GLPE_CPUTRIG2_RSVD1_S 20
#define IG3_CPUW_GLPE_CPUTRIG2_RSVD1 GENMASK_ULL(20, 31)
#define IG3_CPUW_GLPE_CPUTRIG2_IMC_REQUEST2_S 19
#define IG3_CPUW_GLPE_CPUTRIG2_IMC_REQUEST2_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUTRIG2_RSVD0_S 18
#define IG3_CPUW_GLPE_CPUTRIG2_RSVD0_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUTRIG2_TEP_REQUEST2_S 17
#define IG3_CPUW_GLPE_CPUTRIG2_TEP_REQUEST2_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUTRIG2_CQP_REQUEST2_S 16
#define IG3_CPUW_GLPE_CPUTRIG2_CQP_REQUEST2_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUTRIG2_PECPUTRIG2_S 0
#define IG3_CPUW_GLPE_CPUTRIG2_PECPUTRIG2 GENMASK_ULL(0, 15)
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_COUNT 0x4200D838
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_CMD 0x4200D84C
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_DATA_H 0x4200D858
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_DATA_L 0x4200D854
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_PTR 0x4200D850
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_CMD 0x4200D83C
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_DATA_H 0x4200D848
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_DATA_L 0x4200D844
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_PTR 0x4200D840
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL 0x4200D800
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_RSVD1_S 25
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_RSVD2_S 17
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_RSVD3_S 9
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_BYPASS_S 8
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_RSVD4_S 1
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_ECC_COR_ERR 0x4200D868
#define IG3_CPUW_GLPE_CPUW_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_CPUW_GLPE_CPUW_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CPUW_GLPE_CPUW_DTM_ECC_UNCOR_ERR 0x4200D864
#define IG3_CPUW_GLPE_CPUW_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_CPUW_GLPE_CPUW_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CPUW_GLPE_CPUW_DTM_GROUP_CFG 0x4200D80C
#define IG3_CPUW_GLPE_CPUW_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_CPUW_GLPE_CPUW_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_CPUW_GLPE_CPUW_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_CPUW_GLPE_CPUW_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_CPUW_GLPE_CPUW_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_CPUW_GLPE_CPUW_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_CPUW_GLPE_CPUW_DTM_LOG_CFG 0x4200D810
#define IG3_CPUW_GLPE_CPUW_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_CPUW_GLPE_CPUW_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_LOG_CFG_RSVD1_S 2
#define IG3_CPUW_GLPE_CPUW_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_CPUW_GLPE_CPUW_DTM_LOG_CFG_MODE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_CPUW_GLPE_CPUW_DTM_LOG_MASK 0x4200D818
#define IG3_CPUW_GLPE_CPUW_DTM_LOG_MASK_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_LOG_PATTERN 0x4200D814
#define IG3_CPUW_GLPE_CPUW_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_CFG 0x4200D804
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_STS 0x4200D808
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_STS_RSVD1_S 9
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_STS_RSVD2_S 1
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TIMESTAMP 0x4200D830
#define IG3_CPUW_GLPE_CPUW_DTM_TIMESTAMP_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_TIMESTAMP_ROLLOVER 0x4200D834
#define IG3_CPUW_GLPE_CPUW_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG 0x4200D85C
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS 0x4200D860
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_CFG 0x4200D81C
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_CFG_MODE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_COUNT 0x4200D828
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_MASK 0x4200D824
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_MASK_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_PATTERN 0x4200D820
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_TIMESTAMP 0x4200D82C
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_CPUW_GLPE_CPUW_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_CPUW_ECC_COR_ERR 0x4200D8BC
#define IG3_CPUW_GLPE_CPUW_ECC_COR_ERR_RSVD_S 12
#define IG3_CPUW_GLPE_CPUW_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CPUW_GLPE_CPUW_ECC_COR_ERR_CNT_S 0
#define IG3_CPUW_GLPE_CPUW_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CPUW_GLPE_CPUW_ECC_UNCOR_ERR 0x4200D8B8
#define IG3_CPUW_GLPE_CPUW_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_CPUW_GLPE_CPUW_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CPUW_GLPE_CPUW_ECC_UNCOR_ERR_CNT_S 0
#define IG3_CPUW_GLPE_CPUW_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CPUW_GLPE_CPUW_FLR_TXCMP_MKR_CNT 0x4200D7D8
#define IG3_CPUW_GLPE_CPUW_FLR_TXCMP_MKR_CNT_RSVD_S 6
#define IG3_CPUW_GLPE_CPUW_FLR_TXCMP_MKR_CNT_RSVD GENMASK_ULL(6, 31)
#define IG3_CPUW_GLPE_CPUW_FLR_TXCMP_MKR_CNT_MKR_CNT_S 0
#define IG3_CPUW_GLPE_CPUW_FLR_TXCMP_MKR_CNT_MKR_CNT GENMASK_ULL(0, 5)
#define IG3_CPUW_GLPE_CPU_CONFIG 0x4200D7B4
#define IG3_CPUW_GLPE_CPU_CONFIG_RSVD_S 1
#define IG3_CPUW_GLPE_CPU_CONFIG_RSVD GENMASK_ULL(1, 31)
#define IG3_CPUW_GLPE_CPU_CONFIG_PRIVILEGED_S 0
#define IG3_CPUW_GLPE_CPU_CONFIG_PRIVILEGED_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG 0x4200D880
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_RSVD3_S 20
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_RM_S 16
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_RSVD2_S 14
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_RME_S 12
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_RSVD1_S 10
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_ERR_CNT_S 9
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_FIX_CNT_S 8
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_RSVD0_S 6
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_MASK_INT_S 5
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_LS_BYPASS_S 4
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_LS_FORCE_S 3
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_ECC_EN_S 0
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS 0x4200D884
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS_RSVD1_S 30
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS_RSVD0_S 4
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS_INIT_DONE_S 2
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS_ECC_FIX_S 1
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS_ECC_ERR_S 0
#define IG3_CPUW_GLPE_CQP_DRAM_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG 0x4200D888
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_RSVD3_S 20
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_RM_S 16
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_RSVD2_S 14
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_RME_S 12
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_RSVD1_S 10
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_ERR_CNT_S 9
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_FIX_CNT_S 8
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_RSVD0_S 6
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_MASK_INT_S 5
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_LS_BYPASS_S 4
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_LS_FORCE_S 3
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_ECC_EN_S 0
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS 0x4200D88C
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS_RSVD1_S 30
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS_RSVD0_S 4
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS_INIT_DONE_S 2
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS_ECC_FIX_S 1
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS_ECC_ERR_S 0
#define IG3_CPUW_GLPE_CQP_IRAM_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG 0x4200D8B0
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_RSVD3_S 20
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_RM_S 16
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_RSVD2_S 14
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_RME_S 12
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_RSVD1_S 10
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_ERR_CNT_S 9
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_FIX_CNT_S 8
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_RSVD0_S 6
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_MASK_INT_S 5
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_LS_BYPASS_S 4
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_LS_FORCE_S 3
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_ECC_EN_S 0
#define IG3_CPUW_GLPE_CSR_RAM_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS 0x4200D8B4
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS_RSVD1_S 30
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS_RSVD0_S 4
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS_INIT_DONE_S 2
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS_ECC_FIX_S 1
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS_ECC_ERR_S 0
#define IG3_CPUW_GLPE_CSR_RAM_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CPUW_GLPE_DRAIN_MARKER_CNT 0x4200D7BC
#define IG3_CPUW_GLPE_DRAIN_MARKER_CNT_RSVD_S 8
#define IG3_CPUW_GLPE_DRAIN_MARKER_CNT_RSVD GENMASK_ULL(8, 31)
#define IG3_CPUW_GLPE_DRAIN_MARKER_CNT_COUNT_S 0
#define IG3_CPUW_GLPE_DRAIN_MARKER_CNT_COUNT GENMASK_ULL(0, 7)
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG 0x4200D7B8
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_RSVD1_S 16
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_RSVD1 GENMASK_ULL(16, 31)
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_FUNCTION_VALID_S 15
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_FUNCTION_VALID_M BIT_ULL(31)
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_HOST_S 12
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_HOST GENMASK_ULL(12, 14)
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_SRC_PE_DEST_PE_S 10
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_SRC_PE_DEST_PE GENMASK_ULL(10, 11)
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_PORT_ID_S 8
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_PORT_ID GENMASK_ULL(8, 9)
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_TRAFFIC_CLASS_S 5
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_TRAFFIC_CLASS GENMASK_ULL(5, 7)
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_PKT_TYPE_S 3
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_PKT_TYPE GENMASK_ULL(3, 4)
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_CONTROL_COMMAND_S 2
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_CONTROL_COMMAND_M BIT_ULL(31)
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_LOOPBACK_S 1
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_LOOPBACK_M BIT_ULL(31)
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_DIRECTION_S 0
#define IG3_CPUW_GLPE_DRAIN_MARKER_TRIG_DIRECTION_M BIT_ULL(31)
#define IG3_CPUW_GLPE_FWLD_DATA(_i) (0x4200D648 + ((_i) * 4)) /* _i=0...63 */
#define IG3_CPUW_GLPE_FWLD_DATA_MAX_INDEX_I 63
#define IG3_CPUW_GLPE_FWLD_DATA_DATA_S 0
#define IG3_CPUW_GLPE_FWLD_DATA_DATA GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_FWLD_DATA_LEGACY 0x4200D748
#define IG3_CPUW_GLPE_FWLD_DATA_LEGACY_DATA_S 0
#define IG3_CPUW_GLPE_FWLD_DATA_LEGACY_DATA GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_FWLD_ENABLE 0x4200D644
#define IG3_CPUW_GLPE_FWLD_ENABLE_RSVD0_S 1
#define IG3_CPUW_GLPE_FWLD_ENABLE_RSVD0 GENMASK_ULL(1, 31)
#define IG3_CPUW_GLPE_FWLD_ENABLE_CPU_ENABLE_S 0
#define IG3_CPUW_GLPE_FWLD_ENABLE_CPU_ENABLE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_FWLD_STATUS 0x4200D640
#define IG3_CPUW_GLPE_FWLD_STATUS_RSVD0_S 2
#define IG3_CPUW_GLPE_FWLD_STATUS_RSVD0 GENMASK_ULL(2, 31)
#define IG3_CPUW_GLPE_FWLD_STATUS_DONE_S 1
#define IG3_CPUW_GLPE_FWLD_STATUS_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_FWLD_STATUS_AUTOLOAD_REQUESTED_S 0
#define IG3_CPUW_GLPE_FWLD_STATUS_AUTOLOAD_REQUESTED_M BIT_ULL(31)
#define IG3_CPUW_GLPE_FW_PRODUCT_ID 0x4200D638
#define IG3_CPUW_GLPE_FW_PRODUCT_ID_PROD_ID_S 0
#define IG3_CPUW_GLPE_FW_PRODUCT_ID_PROD_ID GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_FW_REV 0x4200D63C
#define IG3_CPUW_GLPE_FW_REV_MAJOR_REV_S 16
#define IG3_CPUW_GLPE_FW_REV_MAJOR_REV GENMASK_ULL(16, 31)
#define IG3_CPUW_GLPE_FW_REV_MINOR_REV_S 0
#define IG3_CPUW_GLPE_FW_REV_MINOR_REV GENMASK_ULL(0, 15)
#define IG3_CPUW_GLPE_IMCREQ(_i) (0x4200D74C + ((_i) * 4)) /* _i=0...7 */
#define IG3_CPUW_GLPE_IMCREQ_MAX_INDEX_I 7
#define IG3_CPUW_GLPE_IMCREQ_PE_IMCREQ_DATA_S 0
#define IG3_CPUW_GLPE_IMCREQ_PE_IMCREQ_DATA GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_IMCRESP(_i) (0x4200D76C + ((_i) * 4)) /* _i=0...15 */
#define IG3_CPUW_GLPE_IMCRESP_MAX_INDEX_I 15
#define IG3_CPUW_GLPE_IMCRESP_PE_IMCRESP_DATA_S 0
#define IG3_CPUW_GLPE_IMCRESP_PE_IMCRESP_DATA GENMASK_ULL(0, 31)
#define IG3_CPUW_GLPE_IPF_CONFIG 0x4200D7B0
#define IG3_CPUW_GLPE_IPF_CONFIG_RSVD_S 6
#define IG3_CPUW_GLPE_IPF_CONFIG_RSVD GENMASK_ULL(6, 31)
#define IG3_CPUW_GLPE_IPF_CONFIG_IPF_PF_NUM_S 0
#define IG3_CPUW_GLPE_IPF_CONFIG_IPF_PF_NUM GENMASK_ULL(0, 5)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG 0x4200D8A0
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_RSVD3_S 20
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_RM_S 16
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_RSVD2_S 14
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_RME_S 12
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_RSVD1_S 10
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_ERR_CNT_S 9
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_FIX_CNT_S 8
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_RSVD0_S 6
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_MASK_INT_S 5
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_LS_BYPASS_S 4
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_LS_FORCE_S 3
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_ECC_EN_S 0
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS 0x4200D8A4
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS_RSVD1_S 30
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS_RSVD0_S 4
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS_INIT_DONE_S 2
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS_ECC_FIX_S 1
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS_ECC_ERR_S 0
#define IG3_CPUW_GLPE_OOP_DRAM_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG 0x4200D8A8
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_RSVD3_S 20
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_RM_S 16
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_RSVD2_S 14
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_RME_S 12
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_RSVD1_S 10
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_ERR_CNT_S 9
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_FIX_CNT_S 8
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_RSVD0_S 6
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_MASK_INT_S 5
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_LS_BYPASS_S 4
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_LS_FORCE_S 3
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_ECC_EN_S 0
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS 0x4200D8AC
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS_RSVD1_S 30
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS_RSVD0_S 4
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS_INIT_DONE_S 2
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS_ECC_FIX_S 1
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS_ECC_ERR_S 0
#define IG3_CPUW_GLPE_OOP_IRAM_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG 0x4200D890
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_RSVD3_S 20
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_RM_S 16
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_RSVD2_S 14
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_RME_S 12
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_RSVD1_S 10
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_ERR_CNT_S 9
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_FIX_CNT_S 8
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_RSVD0_S 6
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_MASK_INT_S 5
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_LS_BYPASS_S 4
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_LS_FORCE_S 3
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_ECC_EN_S 0
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS 0x4200D894
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS_RSVD1_S 30
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS_RSVD0_S 4
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS_INIT_DONE_S 2
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS_ECC_FIX_S 1
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS_ECC_ERR_S 0
#define IG3_CPUW_GLPE_TEP_DRAM_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG 0x4200D898
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_RSVD3_S 20
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_RM_S 16
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_RSVD2_S 14
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_RME_S 12
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_RSVD1_S 10
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_ERR_CNT_S 9
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_FIX_CNT_S 8
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_RSVD0_S 6
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_MASK_INT_S 5
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_LS_BYPASS_S 4
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_LS_FORCE_S 3
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_ECC_EN_S 0
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS 0x4200D89C
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS_RSVD1_S 30
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS_RSVD0_S 4
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS_INIT_DONE_S 2
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS_ECC_FIX_S 1
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS_ECC_ERR_S 0
#define IG3_CPUW_GLPE_TEP_IRAM_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS 0x4200D7CC
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS_DONE_S 31
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS_RSVD1_S 27
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS_RSVD1 GENMASK_ULL(27, 30)
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS_PORT_NUM_S 24
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS_PORT_NUM GENMASK_ULL(24, 26)
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS_RSVD0_S 20
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS_RSVD0 GENMASK_ULL(20, 23)
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS_FUNC_TYPE_S 18
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS_FUNC_TYPE GENMASK_ULL(18, 19)
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS_FUNC_NUM_S 6
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS_FUNC_NUM GENMASK_ULL(6, 17)
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS_PHY_FUNC_S 0
#define IG3_CPUW_GLPE_XLR_CLNCACHE_STATUS_PHY_FUNC GENMASK_ULL(0, 5)
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG 0x4200D7C8
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG_BUSY_S 31
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG_BUSY_M BIT_ULL(31)
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG_RSVD1_S 27
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG_RSVD1 GENMASK_ULL(27, 30)
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG_PORT_NUM_S 24
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG_PORT_NUM GENMASK_ULL(24, 26)
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG_RSVD0_S 20
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG_RSVD0 GENMASK_ULL(20, 23)
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG_FUNC_TYPE_S 18
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG_FUNC_TYPE GENMASK_ULL(18, 19)
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG_FUNC_NUM_S 6
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG_FUNC_NUM GENMASK_ULL(6, 17)
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG_PHY_FUNC_S 0
#define IG3_CPUW_GLPE_XLR_CLNCACHE_TRIG_PHY_FUNC GENMASK_ULL(0, 5)
#define IG3_CPUW_GLPE_XLR_OOP_REQ 0x4200D7E0
#define IG3_CPUW_GLPE_XLR_OOP_REQ_BUSY_S 31
#define IG3_CPUW_GLPE_XLR_OOP_REQ_BUSY_M BIT_ULL(31)
#define IG3_CPUW_GLPE_XLR_OOP_REQ_OP_S 30
#define IG3_CPUW_GLPE_XLR_OOP_REQ_OP_M BIT_ULL(31)
#define IG3_CPUW_GLPE_XLR_OOP_REQ_RSVD_S 20
#define IG3_CPUW_GLPE_XLR_OOP_REQ_RSVD GENMASK_ULL(20, 29)
#define IG3_CPUW_GLPE_XLR_OOP_REQ_VDEV_VF_TYPE_S 18
#define IG3_CPUW_GLPE_XLR_OOP_REQ_VDEV_VF_TYPE GENMASK_ULL(18, 19)
#define IG3_CPUW_GLPE_XLR_OOP_REQ_VDEV_VF_NUM_S 6
#define IG3_CPUW_GLPE_XLR_OOP_REQ_VDEV_VF_NUM GENMASK_ULL(6, 17)
#define IG3_CPUW_GLPE_XLR_OOP_REQ_PF_NUM_S 0
#define IG3_CPUW_GLPE_XLR_OOP_REQ_PF_NUM GENMASK_ULL(0, 5)
#define IG3_CPUW_GLPE_XLR_POST 0x4200D7D0
#define IG3_CPUW_GLPE_XLR_POST_BUSY_S 31
#define IG3_CPUW_GLPE_XLR_POST_BUSY_M BIT_ULL(31)
#define IG3_CPUW_GLPE_XLR_POST_RSVD1_S 27
#define IG3_CPUW_GLPE_XLR_POST_RSVD1 GENMASK_ULL(27, 30)
#define IG3_CPUW_GLPE_XLR_POST_PORT_NUM_S 24
#define IG3_CPUW_GLPE_XLR_POST_PORT_NUM GENMASK_ULL(24, 26)
#define IG3_CPUW_GLPE_XLR_POST_RSVD0_S 20
#define IG3_CPUW_GLPE_XLR_POST_RSVD0 GENMASK_ULL(20, 23)
#define IG3_CPUW_GLPE_XLR_POST_FUNC_TYPE_S 18
#define IG3_CPUW_GLPE_XLR_POST_FUNC_TYPE GENMASK_ULL(18, 19)
#define IG3_CPUW_GLPE_XLR_POST_FUNC_NUM_S 6
#define IG3_CPUW_GLPE_XLR_POST_FUNC_NUM GENMASK_ULL(6, 17)
#define IG3_CPUW_GLPE_XLR_POST_PHY_FUNC_S 0
#define IG3_CPUW_GLPE_XLR_POST_PHY_FUNC GENMASK_ULL(0, 5)
#define IG3_CPUW_GLPE_XLR_POST_STATUS 0x4200D7D4
#define IG3_CPUW_GLPE_XLR_POST_STATUS_DONE_S 31
#define IG3_CPUW_GLPE_XLR_POST_STATUS_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_XLR_POST_STATUS_RSVD1_S 27
#define IG3_CPUW_GLPE_XLR_POST_STATUS_RSVD1 GENMASK_ULL(27, 30)
#define IG3_CPUW_GLPE_XLR_POST_STATUS_PORT_NUM_S 24
#define IG3_CPUW_GLPE_XLR_POST_STATUS_PORT_NUM GENMASK_ULL(24, 26)
#define IG3_CPUW_GLPE_XLR_POST_STATUS_RSVD0_S 20
#define IG3_CPUW_GLPE_XLR_POST_STATUS_RSVD0 GENMASK_ULL(20, 23)
#define IG3_CPUW_GLPE_XLR_POST_STATUS_FUNC_TYPE_S 18
#define IG3_CPUW_GLPE_XLR_POST_STATUS_FUNC_TYPE GENMASK_ULL(18, 19)
#define IG3_CPUW_GLPE_XLR_POST_STATUS_FUNC_NUM_S 6
#define IG3_CPUW_GLPE_XLR_POST_STATUS_FUNC_NUM GENMASK_ULL(6, 17)
#define IG3_CPUW_GLPE_XLR_POST_STATUS_PHY_FUNC_S 0
#define IG3_CPUW_GLPE_XLR_POST_STATUS_PHY_FUNC GENMASK_ULL(0, 5)
#define IG3_CPUW_GLPE_XLR_STP_FUNC 0x4200D7C0
#define IG3_CPUW_GLPE_XLR_STP_FUNC_BUSY_S 31
#define IG3_CPUW_GLPE_XLR_STP_FUNC_BUSY_M BIT_ULL(31)
#define IG3_CPUW_GLPE_XLR_STP_FUNC_RSVD1_S 27
#define IG3_CPUW_GLPE_XLR_STP_FUNC_RSVD1 GENMASK_ULL(27, 30)
#define IG3_CPUW_GLPE_XLR_STP_FUNC_PORT_NUM_S 24
#define IG3_CPUW_GLPE_XLR_STP_FUNC_PORT_NUM GENMASK_ULL(24, 26)
#define IG3_CPUW_GLPE_XLR_STP_FUNC_RSVD0_S 20
#define IG3_CPUW_GLPE_XLR_STP_FUNC_RSVD0 GENMASK_ULL(20, 23)
#define IG3_CPUW_GLPE_XLR_STP_FUNC_FUNC_TYPE_S 18
#define IG3_CPUW_GLPE_XLR_STP_FUNC_FUNC_TYPE GENMASK_ULL(18, 19)
#define IG3_CPUW_GLPE_XLR_STP_FUNC_FUNC_NUM_S 6
#define IG3_CPUW_GLPE_XLR_STP_FUNC_FUNC_NUM GENMASK_ULL(6, 17)
#define IG3_CPUW_GLPE_XLR_STP_FUNC_PHY_FUNC_S 0
#define IG3_CPUW_GLPE_XLR_STP_FUNC_PHY_FUNC GENMASK_ULL(0, 5)
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS 0x4200D7C4
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS_DONE_S 31
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS_DONE_M BIT_ULL(31)
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS_RSVD1_S 27
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS_RSVD1 GENMASK_ULL(27, 30)
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS_PORT_NUM_S 24
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS_PORT_NUM GENMASK_ULL(24, 26)
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS_RSVD0_S 20
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS_RSVD0 GENMASK_ULL(20, 23)
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS_FUNC_TYPE_S 18
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS_FUNC_TYPE GENMASK_ULL(18, 19)
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS_FUNC_NUM_S 6
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS_FUNC_NUM GENMASK_ULL(6, 17)
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS_PHY_FUNC_S 0
#define IG3_CPUW_GLPE_XLR_STP_FUNC_STATUS_PHY_FUNC GENMASK_ULL(0, 5)
#define IG3_CPUW_GLPE_XLR_TEP_REQ 0x4200D7DC
#define IG3_CPUW_GLPE_XLR_TEP_REQ_BUSY_S 31
#define IG3_CPUW_GLPE_XLR_TEP_REQ_BUSY_M BIT_ULL(31)
#define IG3_CPUW_GLPE_XLR_TEP_REQ_OP_S 30
#define IG3_CPUW_GLPE_XLR_TEP_REQ_OP_M BIT_ULL(31)
#define IG3_CPUW_GLPE_XLR_TEP_REQ_RSVD_S 20
#define IG3_CPUW_GLPE_XLR_TEP_REQ_RSVD GENMASK_ULL(20, 29)
#define IG3_CPUW_GLPE_XLR_TEP_REQ_VDEV_VF_TYPE_S 18
#define IG3_CPUW_GLPE_XLR_TEP_REQ_VDEV_VF_TYPE GENMASK_ULL(18, 19)
#define IG3_CPUW_GLPE_XLR_TEP_REQ_VDEV_VF_NUM_S 6
#define IG3_CPUW_GLPE_XLR_TEP_REQ_VDEV_VF_NUM GENMASK_ULL(6, 17)
#define IG3_CPUW_GLPE_XLR_TEP_REQ_PF_NUM_S 0
#define IG3_CPUW_GLPE_XLR_TEP_REQ_PF_NUM GENMASK_ULL(0, 5)
#define IG3_CPUW_PMFPE_CCQPEXTSTATUS(_i) (0x42002000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_CPUW_PMFPE_CCQPEXTSTATUS_MAX_INDEX_I 1031
#define IG3_CPUW_PMFPE_CCQPEXTSTATUS_RSVD_S 16
#define IG3_CPUW_PMFPE_CCQPEXTSTATUS_RSVD GENMASK_ULL(16, 31)
#define IG3_CPUW_PMFPE_CCQPEXTSTATUS_DBPT_INDEX_S 0
#define IG3_CPUW_PMFPE_CCQPEXTSTATUS_DBPT_INDEX GENMASK_ULL(0, 15)
#define IG3_CPUW_PMFPE_CCQPHIGH(_i) (0x42006000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_CPUW_PMFPE_CCQPHIGH_MAX_INDEX_I 1031
#define IG3_CPUW_PMFPE_CCQPHIGH_PECCQPHIGH_S 0
#define IG3_CPUW_PMFPE_CCQPHIGH_PECCQPHIGH GENMASK_ULL(0, 31)
#define IG3_CPUW_PMFPE_CCQPLOW(_i) (0x42004000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_CPUW_PMFPE_CCQPLOW_MAX_INDEX_I 1031
#define IG3_CPUW_PMFPE_CCQPLOW_PECCQPLOW_S 0
#define IG3_CPUW_PMFPE_CCQPLOW_PECCQPLOW GENMASK_ULL(0, 31)
#define IG3_CPUW_PMFPE_CCQPSTATUS(_i) (0x42000000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_CPUW_PMFPE_CCQPSTATUS_MAX_INDEX_I 1031
#define IG3_CPUW_PMFPE_CCQPSTATUS_CCQP_ERR_S 31
#define IG3_CPUW_PMFPE_CCQPSTATUS_CCQP_ERR_M BIT_ULL(31)
#define IG3_CPUW_PMFPE_CCQPSTATUS_RSVD2_S 28
#define IG3_CPUW_PMFPE_CCQPSTATUS_RSVD2 GENMASK_ULL(28, 30)
#define IG3_CPUW_PMFPE_CCQPSTATUS_RDMA_EN_VFS_S 16
#define IG3_CPUW_PMFPE_CCQPSTATUS_RDMA_EN_VFS GENMASK_ULL(16, 27)
#define IG3_CPUW_PMFPE_CCQPSTATUS_RSVD1_S 7
#define IG3_CPUW_PMFPE_CCQPSTATUS_RSVD1 GENMASK_ULL(7, 15)
#define IG3_CPUW_PMFPE_CCQPSTATUS_HMC_PROFILE_S 4
#define IG3_CPUW_PMFPE_CCQPSTATUS_HMC_PROFILE GENMASK_ULL(4, 6)
#define IG3_CPUW_PMFPE_CCQPSTATUS_RSVD0_S 1
#define IG3_CPUW_PMFPE_CCQPSTATUS_RSVD0 GENMASK_ULL(1, 3)
#define IG3_CPUW_PMFPE_CCQPSTATUS_CCQP_DONE_S 0
#define IG3_CPUW_PMFPE_CCQPSTATUS_CCQP_DONE_M BIT_ULL(31)
#define IG3_CPUW_PMFPE_CQPDB(_i) (0x4200A000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_CPUW_PMFPE_CQPDB_MAX_INDEX_I 1031
#define IG3_CPUW_PMFPE_CQPDB_RSVD_S 11
#define IG3_CPUW_PMFPE_CQPDB_RSVD GENMASK_ULL(11, 31)
#define IG3_CPUW_PMFPE_CQPDB_WQHEAD_S 0
#define IG3_CPUW_PMFPE_CQPDB_WQHEAD GENMASK_ULL(0, 10)
#define IG3_CPUW_PMFPE_CQPERRCODES(_i) (0x42008000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_CPUW_PMFPE_CQPERRCODES_MAX_INDEX_I 1031
#define IG3_CPUW_PMFPE_CQPERRCODES_CQP_MAJOR_CODE_S 16
#define IG3_CPUW_PMFPE_CQPERRCODES_CQP_MAJOR_CODE GENMASK_ULL(16, 31)
#define IG3_CPUW_PMFPE_CQPERRCODES_CQP_MINOR_CODE_S 0
#define IG3_CPUW_PMFPE_CQPERRCODES_CQP_MINOR_CODE GENMASK_ULL(0, 15)
#define IG3_CPUW_PMFPE_CQPTAIL(_i) ((0x4200C000 + ((_i) * 4))) /* _i=0...1031 */
#define IG4_CPUW_PMFPE_CQPTAIL(_i) ((0x42018000 + ((_i) * 4))) /* _i=0...1031 */
#define IG3_CPUW_PMFPE_CQPTAIL_MAX_INDEX_I 1031
#define IG3_CPUW_PMFPE_CQPTAIL_CQP_OP_ERR_S 31
#define IG3_CPUW_PMFPE_CQPTAIL_CQP_OP_ERR_M BIT_ULL(31)
#define IG3_CPUW_PMFPE_CQPTAIL_RSVD_S 11
#define IG3_CPUW_PMFPE_CQPTAIL_RSVD GENMASK_ULL(11, 30)
#define IG3_CPUW_PMFPE_CQPTAIL_WQTAIL_S 0
#define IG3_CPUW_PMFPE_CQPTAIL_WQTAIL GENMASK_ULL(0, 10)
#define IG3_CPUW_RDMA_FUSE 0x4200D7E4
#define IG3_CPUW_RDMA_FUSE_RSVD_S 16
#define IG3_CPUW_RDMA_FUSE_RSVD GENMASK_ULL(16, 31)
#define IG3_CPUW_RDMA_FUSE_RDMA_ASO_ENABLE_S 8
#define IG3_CPUW_RDMA_FUSE_RDMA_ASO_ENABLE GENMASK_ULL(8, 15)
#define IG3_CPUW_RDMA_FUSE_RDMA_RESERVED_S 7
#define IG3_CPUW_RDMA_FUSE_RDMA_RESERVED_M BIT_ULL(31)
#define IG3_CPUW_RDMA_FUSE_RDMA_SWFWLD_DISABLE_S 6
#define IG3_CPUW_RDMA_FUSE_RDMA_SWFWLD_DISABLE_M BIT_ULL(31)
#define IG3_CPUW_RDMA_FUSE_RDMA_CRT_DISABLE_S 5
#define IG3_CPUW_RDMA_FUSE_RDMA_CRT_DISABLE_M BIT_ULL(31)
#define IG3_CPUW_RDMA_FUSE_RDMA_TILECLK_DISABLE_S 0
#define IG3_CPUW_RDMA_FUSE_RDMA_TILECLK_DISABLE GENMASK_ULL(0, 4)
#define IG3_FLM_GLHMC_PEOOISCFFLCNT_PE(_i) (0x42086000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_FLM_GLHMC_PEOOISCFFLCNT_PE_MAX_INDEX_I 1031
#define IG3_FLM_GLHMC_PEOOISCFFLCNT_PE_RSVD_S 29
#define IG3_FLM_GLHMC_PEOOISCFFLCNT_PE_RSVD GENMASK_ULL(29, 31)
#define IG3_FLM_GLHMC_PEOOISCFFLCNT_PE_FPMPEOOISCFFLCNT_S 0
#define IG3_FLM_GLHMC_PEOOISCFFLCNT_PE_FPMPEOOISCFFLCNT GENMASK_ULL(0, 28)
#define IG3_FLM_GLHMC_PEQ1FLCNT_PE(_i) (0x42082000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_FLM_GLHMC_PEQ1FLCNT_PE_MAX_INDEX_I 1031
#define IG3_FLM_GLHMC_PEQ1FLCNT_PE_RSVD_S 29
#define IG3_FLM_GLHMC_PEQ1FLCNT_PE_RSVD GENMASK_ULL(29, 31)
#define IG3_FLM_GLHMC_PEQ1FLCNT_PE_FPMPEQ1FLCNT_S 0
#define IG3_FLM_GLHMC_PEQ1FLCNT_PE_FPMPEQ1FLCNT GENMASK_ULL(0, 28)
#define IG3_FLM_GLHMC_PERRFFLCNT_PE(_i) (0x42084000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_FLM_GLHMC_PERRFFLCNT_PE_MAX_INDEX_I 1031
#define IG3_FLM_GLHMC_PERRFFLCNT_PE_RSVD_S 29
#define IG3_FLM_GLHMC_PERRFFLCNT_PE_RSVD GENMASK_ULL(29, 31)
#define IG3_FLM_GLHMC_PERRFFLCNT_PE_FPMPERRFFLCNT_S 0
#define IG3_FLM_GLHMC_PERRFFLCNT_PE_FPMPERRFFLCNT GENMASK_ULL(0, 28)
#define IG3_FLM_GLHMC_PEXFFLCNT_PE(_i) (0x42080000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_FLM_GLHMC_PEXFFLCNT_PE_MAX_INDEX_I 1031
#define IG3_FLM_GLHMC_PEXFFLCNT_PE_RSVD_S 29
#define IG3_FLM_GLHMC_PEXFFLCNT_PE_RSVD GENMASK_ULL(29, 31)
#define IG3_FLM_GLHMC_PEXFFLCNT_PE_FPMPEXFFLCNT_S 0
#define IG3_FLM_GLHMC_PEXFFLCNT_PE_FPMPEXFFLCNT GENMASK_ULL(0, 28)
#define IG3_FLM_GLPE_FLMCTRL0 0x42090000
#define IG3_FLM_GLPE_FLMCTRL0_DISABLE_S 31
#define IG3_FLM_GLPE_FLMCTRL0_DISABLE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLMCTRL0_RSVD2_S 20
#define IG3_FLM_GLPE_FLMCTRL0_RSVD2 GENMASK_ULL(20, 30)
#define IG3_FLM_GLPE_FLMCTRL0_PMF_S 8
#define IG3_FLM_GLPE_FLMCTRL0_PMF GENMASK_ULL(8, 19)
#define IG3_FLM_GLPE_FLMCTRL0_RSVD1_S 6
#define IG3_FLM_GLPE_FLMCTRL0_RSVD1 GENMASK_ULL(6, 7)
#define IG3_FLM_GLPE_FLMCTRL0_FLIST_S 4
#define IG3_FLM_GLPE_FLMCTRL0_FLIST GENMASK_ULL(4, 5)
#define IG3_FLM_GLPE_FLMCTRL0_RSVD0_S 3
#define IG3_FLM_GLPE_FLMCTRL0_RSVD0_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLMCTRL0_OPCODE_S 0
#define IG3_FLM_GLPE_FLMCTRL0_OPCODE GENMASK_ULL(0, 2)
#define IG3_FLM_GLPE_FLMCTRL1 0x42090004
#define IG3_FLM_GLPE_FLMCTRL1_RSVD_S 20
#define IG3_FLM_GLPE_FLMCTRL1_RSVD GENMASK_ULL(20, 31)
#define IG3_FLM_GLPE_FLMCTRL1_VDEV_VF_TYPE_S 18
#define IG3_FLM_GLPE_FLMCTRL1_VDEV_VF_TYPE GENMASK_ULL(18, 19)
#define IG3_FLM_GLPE_FLMCTRL1_VDEV_VF_NUM_S 6
#define IG3_FLM_GLPE_FLMCTRL1_VDEV_VF_NUM GENMASK_ULL(6, 17)
#define IG3_FLM_GLPE_FLMCTRL1_PF_NUM_S 0
#define IG3_FLM_GLPE_FLMCTRL1_PF_NUM GENMASK_ULL(0, 5)
#define IG3_FLM_GLPE_FLMPTR 0x4209000C
#define IG3_FLM_GLPE_FLMPTR_RSVD_S 28
#define IG3_FLM_GLPE_FLMPTR_RSVD GENMASK_ULL(28, 31)
#define IG3_FLM_GLPE_FLMPTR_PEFLMPTR_S 0
#define IG3_FLM_GLPE_FLMPTR_PEFLMPTR GENMASK_ULL(0, 27)
#define IG3_FLM_GLPE_FLMPTRHEAD 0x42090014
#define IG3_FLM_GLPE_FLMPTRHEAD_RSVD_S 28
#define IG3_FLM_GLPE_FLMPTRHEAD_RSVD GENMASK_ULL(28, 31)
#define IG3_FLM_GLPE_FLMPTRHEAD_PTR_S 0
#define IG3_FLM_GLPE_FLMPTRHEAD_PTR GENMASK_ULL(0, 27)
#define IG3_FLM_GLPE_FLMPTRHEADMAX 0x42090018
#define IG3_FLM_GLPE_FLMPTRHEADMAX_RSVD_S 28
#define IG3_FLM_GLPE_FLMPTRHEADMAX_RSVD GENMASK_ULL(28, 31)
#define IG3_FLM_GLPE_FLMPTRHEADMAX_PTR_S 0
#define IG3_FLM_GLPE_FLMPTRHEADMAX_PTR GENMASK_ULL(0, 27)
#define IG3_FLM_GLPE_FLMPTRTAIL 0x42090010
#define IG3_FLM_GLPE_FLMPTRTAIL_RSVD_S 28
#define IG3_FLM_GLPE_FLMPTRTAIL_RSVD GENMASK_ULL(28, 31)
#define IG3_FLM_GLPE_FLMPTRTAIL_PTR_S 0
#define IG3_FLM_GLPE_FLMPTRTAIL_PTR GENMASK_ULL(0, 27)
#define IG3_FLM_GLPE_FLMSTATUS 0x42090008
#define IG3_FLM_GLPE_FLMSTATUS_BUSY_S 31
#define IG3_FLM_GLPE_FLMSTATUS_BUSY_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLMSTATUS_RSVD_S 4
#define IG3_FLM_GLPE_FLMSTATUS_RSVD GENMASK_ULL(4, 30)
#define IG3_FLM_GLPE_FLMSTATUS_STATUS_S 0
#define IG3_FLM_GLPE_FLMSTATUS_STATUS GENMASK_ULL(0, 3)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG 0x42090040
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_RSVD3_S 20
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_RM_S 16
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_RSVD2_S 14
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_RME_S 12
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_RSVD1_S 10
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_ERR_CNT_S 9
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_FIX_CNT_S 8
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_RSVD0_S 6
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_MASK_INT_S 5
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_LS_BYPASS_S 4
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_LS_FORCE_S 3
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_ECC_EN_S 0
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS 0x42090044
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS_RSVD1_S 30
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS_RSVD0_S 4
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS_INIT_DONE_S 2
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS_ECC_FIX_S 1
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS_ECC_ERR_S 0
#define IG3_FLM_GLPE_FLM_CSR_CNT_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG 0x42090048
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_RSVD3_S 20
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_RM_S 16
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_RSVD2_S 14
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_RME_S 12
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_RSVD1_S 10
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_ERR_CNT_S 9
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_FIX_CNT_S 8
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_RSVD0_S 6
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_MASK_INT_S 5
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_LS_BYPASS_S 4
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_LS_FORCE_S 3
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_ECC_EN_S 0
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS 0x4209004C
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS_RSVD1_S 30
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS_RSVD0_S 4
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS_INIT_DONE_S 2
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS_ECC_FIX_S 1
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS_ECC_ERR_S 0
#define IG3_FLM_GLPE_FLM_CSR_ERR_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_COUNT 0x420900B8
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_CMD 0x420900CC
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_DATA_H 0x420900D8
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_DATA_L 0x420900D4
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_PTR 0x420900D0
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_CMD 0x420900BC
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_DATA_H 0x420900C8
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_DATA_L 0x420900C4
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_PTR 0x420900C0
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_FLM_GLPE_FLM_DTM_CONTROL 0x42090080
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_RSVD1_S 25
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_RSVD2_S 17
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_RSVD3_S 9
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_BYPASS_S 8
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_RSVD4_S 1
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_FLM_GLPE_FLM_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_ECC_COR_ERR 0x420900E8
#define IG3_FLM_GLPE_FLM_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_FLM_GLPE_FLM_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_FLM_GLPE_FLM_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_FLM_GLPE_FLM_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_FLM_GLPE_FLM_DTM_ECC_UNCOR_ERR 0x420900E4
#define IG3_FLM_GLPE_FLM_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_FLM_GLPE_FLM_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_FLM_GLPE_FLM_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_FLM_GLPE_FLM_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_FLM_GLPE_FLM_DTM_GROUP_CFG 0x4209008C
#define IG3_FLM_GLPE_FLM_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_FLM_GLPE_FLM_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_FLM_GLPE_FLM_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_FLM_GLPE_FLM_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_FLM_GLPE_FLM_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_FLM_GLPE_FLM_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_FLM_GLPE_FLM_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_FLM_GLPE_FLM_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_FLM_GLPE_FLM_DTM_LOG_CFG 0x42090090
#define IG3_FLM_GLPE_FLM_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_FLM_GLPE_FLM_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_FLM_GLPE_FLM_DTM_LOG_CFG_RSVD1_S 2
#define IG3_FLM_GLPE_FLM_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_FLM_GLPE_FLM_DTM_LOG_CFG_MODE_S 0
#define IG3_FLM_GLPE_FLM_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_FLM_GLPE_FLM_DTM_LOG_MASK 0x42090098
#define IG3_FLM_GLPE_FLM_DTM_LOG_MASK_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_FLM_GLPE_FLM_DTM_LOG_PATTERN 0x42090094
#define IG3_FLM_GLPE_FLM_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_FLM_GLPE_FLM_DTM_MAIN_CFG 0x42090084
#define IG3_FLM_GLPE_FLM_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_FLM_GLPE_FLM_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_FLM_GLPE_FLM_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_FLM_GLPE_FLM_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_FLM_GLPE_FLM_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_FLM_GLPE_FLM_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_FLM_GLPE_FLM_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_FLM_GLPE_FLM_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_FLM_GLPE_FLM_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_FLM_GLPE_FLM_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_FLM_GLPE_FLM_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_MAIN_STS 0x42090088
#define IG3_FLM_GLPE_FLM_DTM_MAIN_STS_RSVD1_S 9
#define IG3_FLM_GLPE_FLM_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_FLM_GLPE_FLM_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_FLM_GLPE_FLM_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_MAIN_STS_RSVD2_S 1
#define IG3_FLM_GLPE_FLM_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_FLM_GLPE_FLM_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_FLM_GLPE_FLM_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TIMESTAMP 0x420900B0
#define IG3_FLM_GLPE_FLM_DTM_TIMESTAMP_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_FLM_GLPE_FLM_DTM_TIMESTAMP_ROLLOVER 0x420900B4
#define IG3_FLM_GLPE_FLM_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG 0x420900DC
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS 0x420900E0
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_FLM_GLPE_FLM_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_DTM_TRIG_CFG 0x4209009C
#define IG3_FLM_GLPE_FLM_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_FLM_GLPE_FLM_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_FLM_GLPE_FLM_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_FLM_GLPE_FLM_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_FLM_GLPE_FLM_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_FLM_GLPE_FLM_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_FLM_GLPE_FLM_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_FLM_GLPE_FLM_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_FLM_GLPE_FLM_DTM_TRIG_CFG_MODE_S 0
#define IG3_FLM_GLPE_FLM_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_FLM_GLPE_FLM_DTM_TRIG_COUNT 0x420900A8
#define IG3_FLM_GLPE_FLM_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_FLM_GLPE_FLM_DTM_TRIG_MASK 0x420900A4
#define IG3_FLM_GLPE_FLM_DTM_TRIG_MASK_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_FLM_GLPE_FLM_DTM_TRIG_PATTERN 0x420900A0
#define IG3_FLM_GLPE_FLM_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_FLM_GLPE_FLM_DTM_TRIG_TIMESTAMP 0x420900AC
#define IG3_FLM_GLPE_FLM_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_FLM_GLPE_FLM_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_FLM_GLPE_FLM_ECC_COR_ERR 0x42090054
#define IG3_FLM_GLPE_FLM_ECC_COR_ERR_RSVD_S 12
#define IG3_FLM_GLPE_FLM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_FLM_GLPE_FLM_ECC_COR_ERR_CNT_S 0
#define IG3_FLM_GLPE_FLM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_FLM_GLPE_FLM_ECC_UNCOR_ERR 0x42090050
#define IG3_FLM_GLPE_FLM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_FLM_GLPE_FLM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_FLM_GLPE_FLM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_FLM_GLPE_FLM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG 0x42090020
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_RSVD3_S 20
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_RM_S 16
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_RSVD2_S 14
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_RME_S 12
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_RSVD1_S 10
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_ERR_CNT_S 9
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_FIX_CNT_S 8
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_RSVD0_S 6
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_MASK_INT_S 5
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_LS_BYPASS_S 4
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_LS_FORCE_S 3
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_ECC_EN_S 0
#define IG3_FLM_GLPE_FLM_LFSR_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS 0x42090024
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS_RSVD1_S 30
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS_RSVD0_S 4
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS_INIT_DONE_S 2
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS_ECC_FIX_S 1
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS_ECC_ERR_S 0
#define IG3_FLM_GLPE_FLM_LFSR_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG 0x42090030
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_RSVD3_S 20
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_RM_S 16
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_RSVD2_S 14
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_RME_S 12
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_RSVD1_S 10
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_ERR_CNT_S 9
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_FIX_CNT_S 8
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_RSVD0_S 6
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_MASK_INT_S 5
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_LS_BYPASS_S 4
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_LS_FORCE_S 3
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_ECC_EN_S 0
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS 0x42090034
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS_RSVD1_S 30
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS_RSVD0_S 4
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS_INIT_DONE_S 2
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS_ECC_FIX_S 1
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS_ECC_ERR_S 0
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MAX_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG 0x42090028
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_RSVD3_S 20
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_RM_S 16
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_RSVD2_S 14
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_RME_S 12
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_RSVD1_S 10
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_ERR_CNT_S 9
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_FIX_CNT_S 8
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_RSVD0_S 6
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_MASK_INT_S 5
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_LS_BYPASS_S 4
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_LS_FORCE_S 3
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_ECC_EN_S 0
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS 0x4209002C
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS_RSVD1_S 30
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS_RSVD0_S 4
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS_INIT_DONE_S 2
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS_ECC_FIX_S 1
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS_ECC_ERR_S 0
#define IG3_FLM_GLPE_FLM_PTR_HEAD_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG 0x42090038
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_RSVD3_S 20
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_RM_S 16
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_RSVD2_S 14
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_RME_S 12
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_RSVD1_S 10
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_ERR_CNT_S 9
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_FIX_CNT_S 8
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_RSVD0_S 6
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_MASK_INT_S 5
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_LS_BYPASS_S 4
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_LS_FORCE_S 3
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_ECC_EN_S 0
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS 0x4209003C
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS_RSVD1_S 30
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS_RSVD0_S 4
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS_INIT_DONE_S 2
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS_ECC_FIX_S 1
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS_ECC_ERR_S 0
#define IG3_FLM_GLPE_FLM_PTR_TAIL_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_FLM_GLPE_OOISC_ALLOCERR(_i) (0x4208E000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_FLM_GLPE_OOISC_ALLOCERR_MAX_INDEX_I 1031
#define IG3_FLM_GLPE_OOISC_ALLOCERR_RSVD_S 16
#define IG3_FLM_GLPE_OOISC_ALLOCERR_RSVD GENMASK_ULL(16, 31)
#define IG3_FLM_GLPE_OOISC_ALLOCERR_ERROR_COUNT_S 0
#define IG3_FLM_GLPE_OOISC_ALLOCERR_ERROR_COUNT GENMASK_ULL(0, 15)
#define IG3_FLM_GLPE_Q1_ALLOCERR(_i) (0x4208A000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_FLM_GLPE_Q1_ALLOCERR_MAX_INDEX_I 1031
#define IG3_FLM_GLPE_Q1_ALLOCERR_RSVD_S 16
#define IG3_FLM_GLPE_Q1_ALLOCERR_RSVD GENMASK_ULL(16, 31)
#define IG3_FLM_GLPE_Q1_ALLOCERR_ERROR_COUNT_S 0
#define IG3_FLM_GLPE_Q1_ALLOCERR_ERROR_COUNT GENMASK_ULL(0, 15)
#define IG3_FLM_GLPE_RRSP_ALLOCERR(_i) (0x4208C000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_FLM_GLPE_RRSP_ALLOCERR_MAX_INDEX_I 1031
#define IG3_FLM_GLPE_RRSP_ALLOCERR_RSVD_S 16
#define IG3_FLM_GLPE_RRSP_ALLOCERR_RSVD GENMASK_ULL(16, 31)
#define IG3_FLM_GLPE_RRSP_ALLOCERR_ERROR_COUNT_S 0
#define IG3_FLM_GLPE_RRSP_ALLOCERR_ERROR_COUNT GENMASK_ULL(0, 15)
#define IG3_FLM_GLPE_XMIT_ALLOCERR(_i) (0x42088000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_FLM_GLPE_XMIT_ALLOCERR_MAX_INDEX_I 1031
#define IG3_FLM_GLPE_XMIT_ALLOCERR_RSVD_S 16
#define IG3_FLM_GLPE_XMIT_ALLOCERR_RSVD GENMASK_ULL(16, 31)
#define IG3_FLM_GLPE_XMIT_ALLOCERR_ERROR_COUNT_S 0
#define IG3_FLM_GLPE_XMIT_ALLOCERR_ERROR_COUNT GENMASK_ULL(0, 15)
#define IG3_FLM_GPLE_FLMDEBUG 0x4209001C
#define IG3_FLM_GPLE_FLMDEBUG_RSVD_S 3
#define IG3_FLM_GPLE_FLMDEBUG_RSVD GENMASK_ULL(3, 31)
#define IG3_FLM_GPLE_FLMDEBUG_SOFT_RESET_S 2
#define IG3_FLM_GPLE_FLMDEBUG_SOFT_RESET_M BIT_ULL(31)
#define IG3_FLM_GPLE_FLMDEBUG_BYPASS_RAM_DISABLE_S 1
#define IG3_FLM_GPLE_FLMDEBUG_BYPASS_RAM_DISABLE_M BIT_ULL(31)
#define IG3_FLM_GPLE_FLMDEBUG_STORE_PTR_RESET_S 0
#define IG3_FLM_GPLE_FLMDEBUG_STORE_PTR_RESET_M BIT_ULL(31)
#define IG3_TMR_GLPE_TCPNOWDIV(_i) (0x420A2000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_TMR_GLPE_TCPNOWDIV_MAX_INDEX_I 1031
#define IG3_TMR_GLPE_TCPNOWDIV_RSVD_S 16
#define IG3_TMR_GLPE_TCPNOWDIV_RSVD GENMASK_ULL(16, 31)
#define IG3_TMR_GLPE_TCPNOWDIV_TCPNOWDIV_S 0
#define IG3_TMR_GLPE_TCPNOWDIV_TCPNOWDIV GENMASK_ULL(0, 15)
#define IG3_TMR_GLPE_TCPNOWINIT 0x420A6014
#define IG3_TMR_GLPE_TCPNOWINIT_TCPNOWINIT_S 0
#define IG3_TMR_GLPE_TCPNOWINIT_TCPNOWINIT GENMASK_ULL(0, 31)
#define IG3_TMR_GLPE_TCPTMRCFG(_i) (0x420A4000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_TMR_GLPE_TCPTMRCFG_MAX_INDEX_I 1031
#define IG3_TMR_GLPE_TCPTMRCFG_PETCPTMREN_S 31
#define IG3_TMR_GLPE_TCPTMRCFG_PETCPTMREN_M BIT_ULL(31)
#define IG3_TMR_GLPE_TCPTMRCFG_PETCPTMRST_S 30
#define IG3_TMR_GLPE_TCPTMRCFG_PETCPTMRST_M BIT_ULL(31)
#define IG3_TMR_GLPE_TCPTMRCFG_RSVD2_S 27
#define IG3_TMR_GLPE_TCPTMRCFG_RSVD2 GENMASK_ULL(27, 29)
#define IG3_TMR_GLPE_TCPTMRCFG_PETCPTMRNUMQP512BLK_S 16
#define IG3_TMR_GLPE_TCPTMRCFG_PETCPTMRNUMQP512BLK GENMASK_ULL(16, 26)
#define IG3_TMR_GLPE_TCPTMRCFG_PEROCEV2RTOPOLICY_S 15
#define IG3_TMR_GLPE_TCPTMRCFG_PEROCEV2RTOPOLICY_M BIT_ULL(31)
#define IG3_TMR_GLPE_TCPTMRCFG_RSVD1_S 13
#define IG3_TMR_GLPE_TCPTMRCFG_RSVD1 GENMASK_ULL(13, 14)
#define IG3_TMR_GLPE_TCPTMRCFG_PETCPTMRBKTSHIFT_S 8
#define IG3_TMR_GLPE_TCPTMRCFG_PETCPTMRBKTSHIFT GENMASK_ULL(8, 12)
#define IG3_TMR_GLPE_TCPTMRCFG_RSVD0_S 5
#define IG3_TMR_GLPE_TCPTMRCFG_RSVD0 GENMASK_ULL(5, 7)
#define IG3_TMR_GLPE_TCPTMRCFG_PETCPTMRBKTMSKBITS_S 0
#define IG3_TMR_GLPE_TCPTMRCFG_PETCPTMRBKTMSKBITS GENMASK_ULL(0, 4)
#define IG3_TMR_GLPE_TMRCTRL0 0x420A6000
#define IG3_TMR_GLPE_TMRCTRL0_TRIG_S 31
#define IG3_TMR_GLPE_TMRCTRL0_TRIG_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMRCTRL0_RSVD_S 26
#define IG3_TMR_GLPE_TMRCTRL0_RSVD GENMASK_ULL(26, 30)
#define IG3_TMR_GLPE_TMRCTRL0_REXMIT_DELTA_S 0
#define IG3_TMR_GLPE_TMRCTRL0_REXMIT_DELTA GENMASK_ULL(0, 25)
#define IG3_TMR_GLPE_TMRCTRL1 0x420A6004
#define IG3_TMR_GLPE_TMRCTRL1_DACK_OP_S 30
#define IG3_TMR_GLPE_TMRCTRL1_DACK_OP GENMASK_ULL(30, 31)
#define IG3_TMR_GLPE_TMRCTRL1_REXMIT_OP_S 28
#define IG3_TMR_GLPE_TMRCTRL1_REXMIT_OP GENMASK_ULL(28, 29)
#define IG3_TMR_GLPE_TMRCTRL1_PERSIST_OP_S 26
#define IG3_TMR_GLPE_TMRCTRL1_PERSIST_OP GENMASK_ULL(26, 27)
#define IG3_TMR_GLPE_TMRCTRL1_IDLE_OP_S 24
#define IG3_TMR_GLPE_TMRCTRL1_IDLE_OP GENMASK_ULL(24, 25)
#define IG3_TMR_GLPE_TMRCTRL1_GP_OP_S 22
#define IG3_TMR_GLPE_TMRCTRL1_GP_OP GENMASK_ULL(22, 23)
#define IG3_TMR_GLPE_TMRCTRL1_RSVD_S 19
#define IG3_TMR_GLPE_TMRCTRL1_RSVD GENMASK_ULL(19, 21)
#define IG3_TMR_GLPE_TMRCTRL1_LINEADDR_S 10
#define IG3_TMR_GLPE_TMRCTRL1_LINEADDR GENMASK_ULL(10, 18)
#define IG3_TMR_GLPE_TMRCTRL1_DACK_DELTA_S 0
#define IG3_TMR_GLPE_TMRCTRL1_DACK_DELTA GENMASK_ULL(0, 9)
#define IG3_TMR_GLPE_TMRCTRL2 0x420A6008
#define IG3_TMR_GLPE_TMRCTRL2_PMF_S 20
#define IG3_TMR_GLPE_TMRCTRL2_PMF GENMASK_ULL(20, 31)
#define IG3_TMR_GLPE_TMRCTRL2_VDEV_VF_TYPE_S 18
#define IG3_TMR_GLPE_TMRCTRL2_VDEV_VF_TYPE GENMASK_ULL(18, 19)
#define IG3_TMR_GLPE_TMRCTRL2_VDEV_VF_NUM_S 6
#define IG3_TMR_GLPE_TMRCTRL2_VDEV_VF_NUM GENMASK_ULL(6, 17)
#define IG3_TMR_GLPE_TMRCTRL2_PF_NUM_S 0
#define IG3_TMR_GLPE_TMRCTRL2_PF_NUM GENMASK_ULL(0, 5)
#define IG3_TMR_GLPE_TMRCTRL3 0x420A600C
#define IG3_TMR_GLPE_TMRCTRL3_RSVD_S 30
#define IG3_TMR_GLPE_TMRCTRL3_RSVD GENMASK_ULL(30, 31)
#define IG3_TMR_GLPE_TMRCTRL3_HOST_S 27
#define IG3_TMR_GLPE_TMRCTRL3_HOST GENMASK_ULL(27, 29)
#define IG3_TMR_GLPE_TMRCTRL3_TILE_S 24
#define IG3_TMR_GLPE_TMRCTRL3_TILE GENMASK_ULL(24, 26)
#define IG3_TMR_GLPE_TMRCTRL3_QP_NUM_S 0
#define IG3_TMR_GLPE_TMRCTRL3_QP_NUM GENMASK_ULL(0, 23)
#define IG3_TMR_GLPE_TMRSTAT 0x420A6010
#define IG3_TMR_GLPE_TMRSTAT_RSVD_S 2
#define IG3_TMR_GLPE_TMRSTAT_RSVD GENMASK_ULL(2, 31)
#define IG3_TMR_GLPE_TMRSTAT_SCN_BUSY_S 1
#define IG3_TMR_GLPE_TMRSTAT_SCN_BUSY_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMRSTAT_CSR_BUSY_S 0
#define IG3_TMR_GLPE_TMRSTAT_CSR_BUSY_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_COUNT 0x420A60B8
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_CMD 0x420A60CC
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_DATA_H 0x420A60D8
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_DATA_L 0x420A60D4
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_PTR 0x420A60D0
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_CMD 0x420A60BC
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_DATA_H 0x420A60C8
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_DATA_L 0x420A60C4
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_PTR 0x420A60C0
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_TMR_GLPE_TMR_DTM_CONTROL 0x420A6080
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_RSVD1_S 25
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_RSVD2_S 17
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_RSVD3_S 9
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_BYPASS_S 8
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_RSVD4_S 1
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_TMR_GLPE_TMR_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_ECC_COR_ERR 0x420A60E8
#define IG3_TMR_GLPE_TMR_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_TMR_GLPE_TMR_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_TMR_GLPE_TMR_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_TMR_GLPE_TMR_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_TMR_GLPE_TMR_DTM_ECC_UNCOR_ERR 0x420A60E4
#define IG3_TMR_GLPE_TMR_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_TMR_GLPE_TMR_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_TMR_GLPE_TMR_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_TMR_GLPE_TMR_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_TMR_GLPE_TMR_DTM_GROUP_CFG 0x420A608C
#define IG3_TMR_GLPE_TMR_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_TMR_GLPE_TMR_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_TMR_GLPE_TMR_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_TMR_GLPE_TMR_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_TMR_GLPE_TMR_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_TMR_GLPE_TMR_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_TMR_GLPE_TMR_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_TMR_GLPE_TMR_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_TMR_GLPE_TMR_DTM_LOG_CFG 0x420A6090
#define IG3_TMR_GLPE_TMR_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_TMR_GLPE_TMR_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_TMR_GLPE_TMR_DTM_LOG_CFG_RSVD1_S 2
#define IG3_TMR_GLPE_TMR_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_TMR_GLPE_TMR_DTM_LOG_CFG_MODE_S 0
#define IG3_TMR_GLPE_TMR_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_TMR_GLPE_TMR_DTM_LOG_MASK 0x420A6098
#define IG3_TMR_GLPE_TMR_DTM_LOG_MASK_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_TMR_GLPE_TMR_DTM_LOG_PATTERN 0x420A6094
#define IG3_TMR_GLPE_TMR_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_TMR_GLPE_TMR_DTM_MAIN_CFG 0x420A6084
#define IG3_TMR_GLPE_TMR_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_TMR_GLPE_TMR_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_TMR_GLPE_TMR_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_TMR_GLPE_TMR_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_TMR_GLPE_TMR_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_TMR_GLPE_TMR_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_TMR_GLPE_TMR_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_TMR_GLPE_TMR_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_TMR_GLPE_TMR_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_TMR_GLPE_TMR_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_TMR_GLPE_TMR_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_MAIN_STS 0x420A6088
#define IG3_TMR_GLPE_TMR_DTM_MAIN_STS_RSVD1_S 9
#define IG3_TMR_GLPE_TMR_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_TMR_GLPE_TMR_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_TMR_GLPE_TMR_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_MAIN_STS_RSVD2_S 1
#define IG3_TMR_GLPE_TMR_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_TMR_GLPE_TMR_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_TMR_GLPE_TMR_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TIMESTAMP 0x420A60B0
#define IG3_TMR_GLPE_TMR_DTM_TIMESTAMP_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_TMR_GLPE_TMR_DTM_TIMESTAMP_ROLLOVER 0x420A60B4
#define IG3_TMR_GLPE_TMR_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG 0x420A60DC
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS 0x420A60E0
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_TMR_GLPE_TMR_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_TMR_GLPE_TMR_DTM_TRIG_CFG 0x420A609C
#define IG3_TMR_GLPE_TMR_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_TMR_GLPE_TMR_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_TMR_GLPE_TMR_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_TMR_GLPE_TMR_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_TMR_GLPE_TMR_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_TMR_GLPE_TMR_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_TMR_GLPE_TMR_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_TMR_GLPE_TMR_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_TMR_GLPE_TMR_DTM_TRIG_CFG_MODE_S 0
#define IG3_TMR_GLPE_TMR_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_TMR_GLPE_TMR_DTM_TRIG_COUNT 0x420A60A8
#define IG3_TMR_GLPE_TMR_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_TMR_GLPE_TMR_DTM_TRIG_MASK 0x420A60A4
#define IG3_TMR_GLPE_TMR_DTM_TRIG_MASK_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_TMR_GLPE_TMR_DTM_TRIG_PATTERN 0x420A60A0
#define IG3_TMR_GLPE_TMR_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_TMR_GLPE_TMR_DTM_TRIG_TIMESTAMP 0x420A60AC
#define IG3_TMR_GLPE_TMR_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_TMR_GLPE_TMR_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_TMR_GLPE_TMR_HF 0x420A6018
#define IG3_TMR_GLPE_TMR_HF_CNT_S 16
#define IG3_TMR_GLPE_TMR_HF_CNT GENMASK_ULL(16, 31)
#define IG3_TMR_GLPE_TMR_HF_VAL_S 0
#define IG3_TMR_GLPE_TMR_HF_VAL GENMASK_ULL(0, 15)
#define IG3_TMR_PMFPE_TCPNOWTIMER(_i) (0x420A0000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_TMR_PMFPE_TCPNOWTIMER_MAX_INDEX_I 1031
#define IG3_TMR_PMFPE_TCPNOWTIMER_TCP_NOW_S 0
#define IG3_TMR_PMFPE_TCPNOWTIMER_TCP_NOW GENMASK_ULL(0, 31)
#define IG3_PTXI_GLPE_PMFCOUNT_CTRL 0x420C6308
#define IG3_PTXI_GLPE_PMFCOUNT_CTRL_RSVD_S 1
#define IG3_PTXI_GLPE_PMFCOUNT_CTRL_RSVD GENMASK_ULL(1, 31)
#define IG3_PTXI_GLPE_PMFCOUNT_CTRL_STALL_S 0
#define IG3_PTXI_GLPE_PMFCOUNT_CTRL_STALL_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG(_i) (0x420C6338 + ((_i) * 4)) /* _i=0...7 */
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_MAX_INDEX_I 7
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_BUSY_S 31
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_BUSY_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_HOSTID_S 28
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_HOSTID GENMASK_ULL(28, 30)
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_VM_VF_TYPE_S 26
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_VM_VF_TYPE GENMASK_ULL(26, 27)
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_PF_NUM_S 20
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_PF_NUM GENMASK_ULL(20, 25)
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_VM_VF_NUM_S 8
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_VM_VF_NUM GENMASK_ULL(8, 19)
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_PORT_S 5
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_PORT GENMASK_ULL(5, 7)
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_RSVD0_S 0
#define IG3_PTXI_GLPE_PTXCMP_MKR_TRIG_RSVD0 GENMASK_ULL(0, 4)
#define IG3_PTXI_GLPE_PTXI_CONFIG 0x420C630C
#define IG3_PTXI_GLPE_PTXI_CONFIG_RSVD_S 2
#define IG3_PTXI_GLPE_PTXI_CONFIG_RSVD GENMASK_ULL(2, 31)
#define IG3_PTXI_GLPE_PTXI_CONFIG_STALL_FLR_ON_FULL_S 1
#define IG3_PTXI_GLPE_PTXI_CONFIG_STALL_FLR_ON_FULL_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_CONFIG_STALL_FLUSH_ON_FULL_S 0
#define IG3_PTXI_GLPE_PTXI_CONFIG_STALL_FLUSH_ON_FULL_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_COUNT 0x420C63B8
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_CMD 0x420C63CC
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_DATA_H 0x420C63D8
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_DATA_L 0x420C63D4
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_PTR 0x420C63D0
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_CMD 0x420C63BC
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_DATA_H 0x420C63C8
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_DATA_L 0x420C63C4
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_PTR 0x420C63C0
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL 0x420C6380
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_RSVD1_S 25
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_RSVD2_S 17
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_RSVD3_S 9
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_BYPASS_S 8
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_RSVD4_S 1
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_ECC_COR_ERR 0x420C63E8
#define IG3_PTXI_GLPE_PTXI_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_PTXI_GLPE_PTXI_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PTXI_GLPE_PTXI_DTM_ECC_UNCOR_ERR 0x420C63E4
#define IG3_PTXI_GLPE_PTXI_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_PTXI_GLPE_PTXI_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PTXI_GLPE_PTXI_DTM_GROUP_CFG 0x420C638C
#define IG3_PTXI_GLPE_PTXI_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_PTXI_GLPE_PTXI_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_PTXI_GLPE_PTXI_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_PTXI_GLPE_PTXI_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_PTXI_GLPE_PTXI_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_PTXI_GLPE_PTXI_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_PTXI_GLPE_PTXI_DTM_LOG_CFG 0x420C6390
#define IG3_PTXI_GLPE_PTXI_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_PTXI_GLPE_PTXI_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_LOG_CFG_RSVD1_S 2
#define IG3_PTXI_GLPE_PTXI_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_PTXI_GLPE_PTXI_DTM_LOG_CFG_MODE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_PTXI_GLPE_PTXI_DTM_LOG_MASK 0x420C6398
#define IG3_PTXI_GLPE_PTXI_DTM_LOG_MASK_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_LOG_PATTERN 0x420C6394
#define IG3_PTXI_GLPE_PTXI_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_CFG 0x420C6384
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_STS 0x420C6388
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_STS_RSVD1_S 9
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_STS_RSVD2_S 1
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TIMESTAMP 0x420C63B0
#define IG3_PTXI_GLPE_PTXI_DTM_TIMESTAMP_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_TIMESTAMP_ROLLOVER 0x420C63B4
#define IG3_PTXI_GLPE_PTXI_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG 0x420C63DC
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS 0x420C63E0
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_CFG 0x420C639C
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_CFG_MODE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_COUNT 0x420C63A8
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_MASK 0x420C63A4
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_MASK_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_PATTERN 0x420C63A0
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_TIMESTAMP 0x420C63AC
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_PTXI_GLPE_PTXI_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_PTXI_GLPE_PTX_FLR_MKR_CNT 0x420C6314
#define IG3_PTXI_GLPE_PTX_FLR_MKR_CNT_RSVD_S 8
#define IG3_PTXI_GLPE_PTX_FLR_MKR_CNT_RSVD GENMASK_ULL(8, 31)
#define IG3_PTXI_GLPE_PTX_FLR_MKR_CNT_MKR_CNT_S 0
#define IG3_PTXI_GLPE_PTX_FLR_MKR_CNT_MKR_CNT GENMASK_ULL(0, 7)
#define IG3_PTXI_GLPE_PTX_FLUSH_MKR_CNT 0x420C6310
#define IG3_PTXI_GLPE_PTX_FLUSH_MKR_CNT_RSVD_S 16
#define IG3_PTXI_GLPE_PTX_FLUSH_MKR_CNT_RSVD GENMASK_ULL(16, 31)
#define IG3_PTXI_GLPE_PTX_FLUSH_MKR_CNT_MKR_CNT_S 0
#define IG3_PTXI_GLPE_PTX_FLUSH_MKR_CNT_MKR_CNT GENMASK_ULL(0, 15)
#define IG3_PTXI_GLPE_XLR_DROP(_i) (0x420C6318 + ((_i) * 4)) /* _i=0...7 */
#define IG3_PTXI_GLPE_XLR_DROP_MAX_INDEX_I 7
#define IG3_PTXI_GLPE_XLR_DROP_DROP_S 31
#define IG3_PTXI_GLPE_XLR_DROP_DROP_M BIT_ULL(31)
#define IG3_PTXI_GLPE_XLR_DROP_RSVD_S 20
#define IG3_PTXI_GLPE_XLR_DROP_RSVD GENMASK_ULL(20, 30)
#define IG3_PTXI_GLPE_XLR_DROP_FUNC_TYPE_S 18
#define IG3_PTXI_GLPE_XLR_DROP_FUNC_TYPE GENMASK_ULL(18, 19)
#define IG3_PTXI_GLPE_XLR_DROP_FUNC_NUM_S 6
#define IG3_PTXI_GLPE_XLR_DROP_FUNC_NUM GENMASK_ULL(6, 17)
#define IG3_PTXI_GLPE_XLR_DROP_PHY_FUNC_S 0
#define IG3_PTXI_GLPE_XLR_DROP_PHY_FUNC GENMASK_ULL(0, 5)
#define IG3_PTXI_PMFPE_IPCONFIG0(_i) (0x420C0000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PTXI_PMFPE_IPCONFIG0_MAX_INDEX_I 1031
#define IG3_PTXI_PMFPE_IPCONFIG0_RSVD_S 18
#define IG3_PTXI_PMFPE_IPCONFIG0_RSVD GENMASK_ULL(18, 31)
#define IG3_PTXI_PMFPE_IPCONFIG0_UDP_SRC_PORT_MASK_EN_S 17
#define IG3_PTXI_PMFPE_IPCONFIG0_UDP_SRC_PORT_MASK_EN_M BIT_ULL(31)
#define IG3_PTXI_PMFPE_IPCONFIG0_USEENTIREIDRANGE_S 16
#define IG3_PTXI_PMFPE_IPCONFIG0_USEENTIREIDRANGE_M BIT_ULL(31)
#define IG3_PTXI_PMFPE_IPCONFIG0_PEIPID_S 0
#define IG3_PTXI_PMFPE_IPCONFIG0_PEIPID GENMASK_ULL(0, 15)
#define IG3_PTXI_PMFPE_PMFCOUNT(_i) (0x420C2000 + ((_i) * 4)) /* _i=0...4127 */
#define IG3_PTXI_PMFPE_PMFCOUNT_MAX_INDEX_I 4127
#define IG3_PTXI_PMFPE_PMFCOUNT_FW_TOKEN_S 24
#define IG3_PTXI_PMFPE_PMFCOUNT_FW_TOKEN GENMASK_ULL(24, 31)
#define IG3_PTXI_PMFPE_PMFCOUNT_RSVD1_S 23
#define IG3_PTXI_PMFPE_PMFCOUNT_RSVD1_M BIT_ULL(31)
#define IG3_PTXI_PMFPE_PMFCOUNT_HOST_ID_S 20
#define IG3_PTXI_PMFPE_PMFCOUNT_HOST_ID GENMASK_ULL(20, 22)
#define IG3_PTXI_PMFPE_PMFCOUNT_FLUSH_PENDING_S 19
#define IG3_PTXI_PMFPE_PMFCOUNT_FLUSH_PENDING_M BIT_ULL(31)
#define IG3_PTXI_PMFPE_PMFCOUNT_RSVD0_S 18
#define IG3_PTXI_PMFPE_PMFCOUNT_RSVD0_M BIT_ULL(31)
#define IG3_PTXI_PMFPE_PMFCOUNT_COUNT_S 0
#define IG3_PTXI_PMFPE_PMFCOUNT_COUNT GENMASK_ULL(0, 17)
#define IG3_PTXI_PMFPE_PMF_EPOCH(_i) (0x420C6200 + ((_i) * 4)) /* _i=0...65 */
#define IG3_PTXI_PMFPE_PMF_EPOCH_MAX_INDEX_I 65
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH15_S 30
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH15 GENMASK_ULL(30, 31)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH14_S 28
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH14 GENMASK_ULL(28, 29)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH13_S 26
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH13 GENMASK_ULL(26, 27)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH12_S 24
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH12 GENMASK_ULL(24, 25)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH11_S 22
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH11 GENMASK_ULL(22, 23)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH10_S 20
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH10 GENMASK_ULL(20, 21)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH9_S 18
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH9 GENMASK_ULL(18, 19)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH8_S 16
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH8 GENMASK_ULL(16, 17)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH7_S 14
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH7 GENMASK_ULL(14, 15)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH6_S 12
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH6 GENMASK_ULL(12, 13)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH5_S 10
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH5 GENMASK_ULL(10, 11)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH4_S 8
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH4 GENMASK_ULL(8, 9)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH3_S 6
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH3 GENMASK_ULL(6, 7)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH2_S 4
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH2 GENMASK_ULL(4, 5)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH1_S 2
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH1 GENMASK_ULL(2, 3)
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH0_S 0
#define IG3_PTXI_PMFPE_PMF_EPOCH_EPOCH0 GENMASK_ULL(0, 1)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_BUS_INDEX 0x420E1110
#define IG3_CORE_GLPE_CORE_BOB0_BOB_BUS_INDEX_BUS_INDEX_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_BUS_INDEX_BUS_INDEX GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL 0x420E1100
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_RESERVED_31_10_S 10
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_RESERVED_31_10 GENMASK_ULL(10, 31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_TRIG_OP_S 8
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_TRIG_OP GENMASK_ULL(8, 9)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_VLD_RDY_FRZ_EN_S 7
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_VLD_RDY_FRZ_EN_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_EN_I_FREEZE_S 6
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_EN_I_FREEZE_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_COUNT_ONLY_TRIG_S 5
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_COUNT_ONLY_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_READ_INPUT_BUS_S 4
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_READ_INPUT_BUS_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_EN_FRZ_ON_CNT_S 3
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_EN_FRZ_ON_CNT_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_EN_FRZ_ON_TRIG_S 2
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_EN_FRZ_ON_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_FREEZE_RESET_S 1
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_FREEZE_RESET_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_FREEZE_SET_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_CTRL_FREEZE_SET_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_FREEZE_ON_CNT_VAL 0x420E1120
#define IG3_CORE_GLPE_CORE_BOB0_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_OBS_BUS 0x420E1140
#define IG3_CORE_GLPE_CORE_BOB0_BOB_OBS_BUS_OBS_BUS_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_OBS_BUS_OBS_BUS GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CNT0 0x420E1160
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CNT0_CNT0_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CNT0_CNT0 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CNT1_0 0x420E1168
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CNT1_0_CNT1_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CNT1_0_CNT1 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CNT1_1 0x420E116C
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CNT1_1_CNT1_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CNT1_1_CNT1 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CTRL 0x420E1158
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CTRL_RESERVED_31_16_S 16
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CTRL_RESERVED_31_16 GENMASK_ULL(16, 31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CTRL_PERF_WIN_S 8
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CTRL_PERF_WIN GENMASK_ULL(8, 15)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CTRL_PERF_CNT1_CFG_S 4
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CTRL_PERF_CNT1_CFG GENMASK_ULL(4, 7)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CTRL_PERF_CNT0_CFG_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_PERF_CTRL_PERF_CNT0_CFG GENMASK_ULL(0, 3)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_RC_CTRL 0x420E1138
#define IG3_CORE_GLPE_CORE_BOB0_BOB_RC_CTRL_RESERVED_31_1_S 1
#define IG3_CORE_GLPE_CORE_BOB0_BOB_RC_CTRL_RESERVED_31_1 GENMASK_ULL(1, 31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_RC_CTRL_RC_TRIG_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_RC_CTRL_RC_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_RC_GAP 0x420E1128
#define IG3_CORE_GLPE_CORE_BOB0_BOB_RC_GAP_RC_GAP_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_RC_GAP_RC_GAP GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_RC_TRNS 0x420E1130
#define IG3_CORE_GLPE_CORE_BOB0_BOB_RC_TRNS_RC_TRNS_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_RC_TRNS_RC_TRNS GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS 0x420E1108
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_RESERVED_31_8_S 8
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_RESERVED_31_8 GENMASK_ULL(8, 31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_FREEZE_UPON_IFRZ_S 7
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_FREEZE_UPON_IFRZ_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_I_FREEZE_S 6
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_I_FREEZE_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_READY_S 5
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_READY_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_VALID_S 4
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_VALID_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_FREEZE_UPON_CNT_S 3
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_FREEZE_UPON_CNT_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_FREEZE_UPON_TRIG_S 2
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_FREEZE_UPON_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_S 1
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_FREEZE_STATUS_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_STATUS_FREEZE_STATUS_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_TRANS_CNT 0x420E1118
#define IG3_CORE_GLPE_CORE_BOB0_BOB_TRANS_CNT_TRANS_CNT_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_TRANS_CNT_TRANS_CNT GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_TRIG_MASK 0x420E1148
#define IG3_CORE_GLPE_CORE_BOB0_BOB_TRIG_MASK_TRIG_MASK_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_TRIG_MASK_TRIG_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB0_BOB_TRIG_VALUE 0x420E1150
#define IG3_CORE_GLPE_CORE_BOB0_BOB_TRIG_VALUE_TRIG_VALUE_S 0
#define IG3_CORE_GLPE_CORE_BOB0_BOB_TRIG_VALUE_TRIG_VALUE GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_BUS_INDEX 0x420E1190
#define IG3_CORE_GLPE_CORE_BOB1_BOB_BUS_INDEX_BUS_INDEX_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_BUS_INDEX_BUS_INDEX GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL 0x420E1180
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_RESERVED_31_10_S 10
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_RESERVED_31_10 GENMASK_ULL(10, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_TRIG_OP_S 8
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_TRIG_OP GENMASK_ULL(8, 9)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_VLD_RDY_FRZ_EN_S 7
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_VLD_RDY_FRZ_EN_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_EN_I_FREEZE_S 6
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_EN_I_FREEZE_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_COUNT_ONLY_TRIG_S 5
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_COUNT_ONLY_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_READ_INPUT_BUS_S 4
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_READ_INPUT_BUS_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_EN_FRZ_ON_CNT_S 3
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_EN_FRZ_ON_CNT_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_EN_FRZ_ON_TRIG_S 2
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_EN_FRZ_ON_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_FREEZE_RESET_S 1
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_FREEZE_RESET_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_FREEZE_SET_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_CTRL_FREEZE_SET_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_FREEZE_ON_CNT_VAL 0x420E11A0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_OBS_BUS 0x420E11C0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_OBS_BUS_OBS_BUS_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_OBS_BUS_OBS_BUS GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CNT0 0x420E11E0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CNT0_CNT0_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CNT0_CNT0 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CNT1_0 0x420E11E8
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CNT1_0_CNT1_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CNT1_0_CNT1 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CNT1_1 0x420E11EC
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CNT1_1_CNT1_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CNT1_1_CNT1 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CTRL 0x420E11D8
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CTRL_RESERVED_31_16_S 16
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CTRL_RESERVED_31_16 GENMASK_ULL(16, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CTRL_PERF_WIN_S 8
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CTRL_PERF_WIN GENMASK_ULL(8, 15)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CTRL_PERF_CNT1_CFG_S 4
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CTRL_PERF_CNT1_CFG GENMASK_ULL(4, 7)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CTRL_PERF_CNT0_CFG_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_PERF_CTRL_PERF_CNT0_CFG GENMASK_ULL(0, 3)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_RC_CTRL 0x420E11B8
#define IG3_CORE_GLPE_CORE_BOB1_BOB_RC_CTRL_RESERVED_31_1_S 1
#define IG3_CORE_GLPE_CORE_BOB1_BOB_RC_CTRL_RESERVED_31_1 GENMASK_ULL(1, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_RC_CTRL_RC_TRIG_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_RC_CTRL_RC_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_RC_GAP 0x420E11A8
#define IG3_CORE_GLPE_CORE_BOB1_BOB_RC_GAP_RC_GAP_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_RC_GAP_RC_GAP GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_RC_TRNS 0x420E11B0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_RC_TRNS_RC_TRNS_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_RC_TRNS_RC_TRNS GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS 0x420E1188
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_RESERVED_31_8_S 8
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_RESERVED_31_8 GENMASK_ULL(8, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_FREEZE_UPON_IFRZ_S 7
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_FREEZE_UPON_IFRZ_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_I_FREEZE_S 6
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_I_FREEZE_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_READY_S 5
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_READY_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_VALID_S 4
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_VALID_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_FREEZE_UPON_CNT_S 3
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_FREEZE_UPON_CNT_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_FREEZE_UPON_TRIG_S 2
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_FREEZE_UPON_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_S 1
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_FREEZE_STATUS_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_STATUS_FREEZE_STATUS_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_TRANS_CNT 0x420E1198
#define IG3_CORE_GLPE_CORE_BOB1_BOB_TRANS_CNT_TRANS_CNT_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_TRANS_CNT_TRANS_CNT GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_TRIG_MASK 0x420E11C8
#define IG3_CORE_GLPE_CORE_BOB1_BOB_TRIG_MASK_TRIG_MASK_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_TRIG_MASK_TRIG_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB1_BOB_TRIG_VALUE 0x420E11D0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_TRIG_VALUE_TRIG_VALUE_S 0
#define IG3_CORE_GLPE_CORE_BOB1_BOB_TRIG_VALUE_TRIG_VALUE GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_BUS_INDEX 0x420E1210
#define IG3_CORE_GLPE_CORE_BOB2_BOB_BUS_INDEX_BUS_INDEX_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_BUS_INDEX_BUS_INDEX GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL 0x420E1200
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_RESERVED_31_10_S 10
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_RESERVED_31_10 GENMASK_ULL(10, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_TRIG_OP_S 8
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_TRIG_OP GENMASK_ULL(8, 9)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_VLD_RDY_FRZ_EN_S 7
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_VLD_RDY_FRZ_EN_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_EN_I_FREEZE_S 6
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_EN_I_FREEZE_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_COUNT_ONLY_TRIG_S 5
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_COUNT_ONLY_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_READ_INPUT_BUS_S 4
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_READ_INPUT_BUS_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_EN_FRZ_ON_CNT_S 3
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_EN_FRZ_ON_CNT_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_EN_FRZ_ON_TRIG_S 2
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_EN_FRZ_ON_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_FREEZE_RESET_S 1
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_FREEZE_RESET_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_FREEZE_SET_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_CTRL_FREEZE_SET_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_FREEZE_ON_CNT_VAL 0x420E1220
#define IG3_CORE_GLPE_CORE_BOB2_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_OBS_BUS 0x420E1240
#define IG3_CORE_GLPE_CORE_BOB2_BOB_OBS_BUS_OBS_BUS_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_OBS_BUS_OBS_BUS GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CNT0 0x420E1260
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CNT0_CNT0_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CNT0_CNT0 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CNT1_0 0x420E1268
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CNT1_0_CNT1_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CNT1_0_CNT1 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CNT1_1 0x420E126C
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CNT1_1_CNT1_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CNT1_1_CNT1 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CTRL 0x420E1258
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CTRL_RESERVED_31_16_S 16
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CTRL_RESERVED_31_16 GENMASK_ULL(16, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CTRL_PERF_WIN_S 8
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CTRL_PERF_WIN GENMASK_ULL(8, 15)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CTRL_PERF_CNT1_CFG_S 4
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CTRL_PERF_CNT1_CFG GENMASK_ULL(4, 7)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CTRL_PERF_CNT0_CFG_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_PERF_CTRL_PERF_CNT0_CFG GENMASK_ULL(0, 3)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_RC_CTRL 0x420E1238
#define IG3_CORE_GLPE_CORE_BOB2_BOB_RC_CTRL_RESERVED_31_1_S 1
#define IG3_CORE_GLPE_CORE_BOB2_BOB_RC_CTRL_RESERVED_31_1 GENMASK_ULL(1, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_RC_CTRL_RC_TRIG_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_RC_CTRL_RC_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_RC_GAP 0x420E1228
#define IG3_CORE_GLPE_CORE_BOB2_BOB_RC_GAP_RC_GAP_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_RC_GAP_RC_GAP GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_RC_TRNS 0x420E1230
#define IG3_CORE_GLPE_CORE_BOB2_BOB_RC_TRNS_RC_TRNS_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_RC_TRNS_RC_TRNS GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS 0x420E1208
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_RESERVED_31_8_S 8
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_RESERVED_31_8 GENMASK_ULL(8, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_FREEZE_UPON_IFRZ_S 7
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_FREEZE_UPON_IFRZ_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_I_FREEZE_S 6
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_I_FREEZE_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_READY_S 5
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_READY_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_VALID_S 4
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_VALID_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_FREEZE_UPON_CNT_S 3
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_FREEZE_UPON_CNT_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_FREEZE_UPON_TRIG_S 2
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_FREEZE_UPON_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_S 1
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_FREEZE_STATUS_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_STATUS_FREEZE_STATUS_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_TRANS_CNT 0x420E1218
#define IG3_CORE_GLPE_CORE_BOB2_BOB_TRANS_CNT_TRANS_CNT_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_TRANS_CNT_TRANS_CNT GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_TRIG_MASK 0x420E1248
#define IG3_CORE_GLPE_CORE_BOB2_BOB_TRIG_MASK_TRIG_MASK_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_TRIG_MASK_TRIG_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB2_BOB_TRIG_VALUE 0x420E1250
#define IG3_CORE_GLPE_CORE_BOB2_BOB_TRIG_VALUE_TRIG_VALUE_S 0
#define IG3_CORE_GLPE_CORE_BOB2_BOB_TRIG_VALUE_TRIG_VALUE GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_BUS_INDEX 0x420E1290
#define IG3_CORE_GLPE_CORE_BOB3_BOB_BUS_INDEX_BUS_INDEX_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_BUS_INDEX_BUS_INDEX GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL 0x420E1280
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_RESERVED_31_10_S 10
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_RESERVED_31_10 GENMASK_ULL(10, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_TRIG_OP_S 8
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_TRIG_OP GENMASK_ULL(8, 9)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_VLD_RDY_FRZ_EN_S 7
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_VLD_RDY_FRZ_EN_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_EN_I_FREEZE_S 6
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_EN_I_FREEZE_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_COUNT_ONLY_TRIG_S 5
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_COUNT_ONLY_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_READ_INPUT_BUS_S 4
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_READ_INPUT_BUS_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_EN_FRZ_ON_CNT_S 3
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_EN_FRZ_ON_CNT_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_EN_FRZ_ON_TRIG_S 2
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_EN_FRZ_ON_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_FREEZE_RESET_S 1
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_FREEZE_RESET_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_FREEZE_SET_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_CTRL_FREEZE_SET_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_FREEZE_ON_CNT_VAL 0x420E12A0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_OBS_BUS 0x420E12C0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_OBS_BUS_OBS_BUS_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_OBS_BUS_OBS_BUS GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CNT0 0x420E12E0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CNT0_CNT0_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CNT0_CNT0 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CNT1_0 0x420E12E8
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CNT1_0_CNT1_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CNT1_0_CNT1 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CNT1_1 0x420E12EC
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CNT1_1_CNT1_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CNT1_1_CNT1 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CTRL 0x420E12D8
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CTRL_RESERVED_31_16_S 16
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CTRL_RESERVED_31_16 GENMASK_ULL(16, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CTRL_PERF_WIN_S 8
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CTRL_PERF_WIN GENMASK_ULL(8, 15)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CTRL_PERF_CNT1_CFG_S 4
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CTRL_PERF_CNT1_CFG GENMASK_ULL(4, 7)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CTRL_PERF_CNT0_CFG_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_PERF_CTRL_PERF_CNT0_CFG GENMASK_ULL(0, 3)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_RC_CTRL 0x420E12B8
#define IG3_CORE_GLPE_CORE_BOB3_BOB_RC_CTRL_RESERVED_31_1_S 1
#define IG3_CORE_GLPE_CORE_BOB3_BOB_RC_CTRL_RESERVED_31_1 GENMASK_ULL(1, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_RC_CTRL_RC_TRIG_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_RC_CTRL_RC_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_RC_GAP 0x420E12A8
#define IG3_CORE_GLPE_CORE_BOB3_BOB_RC_GAP_RC_GAP_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_RC_GAP_RC_GAP GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_RC_TRNS 0x420E12B0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_RC_TRNS_RC_TRNS_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_RC_TRNS_RC_TRNS GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS 0x420E1288
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_RESERVED_31_8_S 8
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_RESERVED_31_8 GENMASK_ULL(8, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_FREEZE_UPON_IFRZ_S 7
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_FREEZE_UPON_IFRZ_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_I_FREEZE_S 6
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_I_FREEZE_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_READY_S 5
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_READY_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_VALID_S 4
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_VALID_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_FREEZE_UPON_CNT_S 3
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_FREEZE_UPON_CNT_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_FREEZE_UPON_TRIG_S 2
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_FREEZE_UPON_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_S 1
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_FREEZE_STATUS_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_STATUS_FREEZE_STATUS_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_TRANS_CNT 0x420E1298
#define IG3_CORE_GLPE_CORE_BOB3_BOB_TRANS_CNT_TRANS_CNT_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_TRANS_CNT_TRANS_CNT GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_TRIG_MASK 0x420E12C8
#define IG3_CORE_GLPE_CORE_BOB3_BOB_TRIG_MASK_TRIG_MASK_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_TRIG_MASK_TRIG_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB3_BOB_TRIG_VALUE 0x420E12D0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_TRIG_VALUE_TRIG_VALUE_S 0
#define IG3_CORE_GLPE_CORE_BOB3_BOB_TRIG_VALUE_TRIG_VALUE GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_BUS_INDEX 0x420E1310
#define IG3_CORE_GLPE_CORE_BOB4_BOB_BUS_INDEX_BUS_INDEX_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_BUS_INDEX_BUS_INDEX GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL 0x420E1300
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_RESERVED_31_10_S 10
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_RESERVED_31_10 GENMASK_ULL(10, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_TRIG_OP_S 8
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_TRIG_OP GENMASK_ULL(8, 9)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_VLD_RDY_FRZ_EN_S 7
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_VLD_RDY_FRZ_EN_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_EN_I_FREEZE_S 6
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_EN_I_FREEZE_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_COUNT_ONLY_TRIG_S 5
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_COUNT_ONLY_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_READ_INPUT_BUS_S 4
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_READ_INPUT_BUS_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_EN_FRZ_ON_CNT_S 3
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_EN_FRZ_ON_CNT_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_EN_FRZ_ON_TRIG_S 2
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_EN_FRZ_ON_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_FREEZE_RESET_S 1
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_FREEZE_RESET_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_FREEZE_SET_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_CTRL_FREEZE_SET_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_FREEZE_ON_CNT_VAL 0x420E1320
#define IG3_CORE_GLPE_CORE_BOB4_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_OBS_BUS 0x420E1340
#define IG3_CORE_GLPE_CORE_BOB4_BOB_OBS_BUS_OBS_BUS_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_OBS_BUS_OBS_BUS GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CNT0 0x420E1360
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CNT0_CNT0_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CNT0_CNT0 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CNT1_0 0x420E1368
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CNT1_0_CNT1_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CNT1_0_CNT1 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CNT1_1 0x420E136C
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CNT1_1_CNT1_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CNT1_1_CNT1 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CTRL 0x420E1358
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CTRL_RESERVED_31_16_S 16
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CTRL_RESERVED_31_16 GENMASK_ULL(16, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CTRL_PERF_WIN_S 8
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CTRL_PERF_WIN GENMASK_ULL(8, 15)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CTRL_PERF_CNT1_CFG_S 4
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CTRL_PERF_CNT1_CFG GENMASK_ULL(4, 7)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CTRL_PERF_CNT0_CFG_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_PERF_CTRL_PERF_CNT0_CFG GENMASK_ULL(0, 3)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_RC_CTRL 0x420E1338
#define IG3_CORE_GLPE_CORE_BOB4_BOB_RC_CTRL_RESERVED_31_1_S 1
#define IG3_CORE_GLPE_CORE_BOB4_BOB_RC_CTRL_RESERVED_31_1 GENMASK_ULL(1, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_RC_CTRL_RC_TRIG_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_RC_CTRL_RC_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_RC_GAP 0x420E1328
#define IG3_CORE_GLPE_CORE_BOB4_BOB_RC_GAP_RC_GAP_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_RC_GAP_RC_GAP GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_RC_TRNS 0x420E1330
#define IG3_CORE_GLPE_CORE_BOB4_BOB_RC_TRNS_RC_TRNS_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_RC_TRNS_RC_TRNS GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS 0x420E1308
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_RESERVED_31_8_S 8
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_RESERVED_31_8 GENMASK_ULL(8, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_FREEZE_UPON_IFRZ_S 7
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_FREEZE_UPON_IFRZ_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_I_FREEZE_S 6
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_I_FREEZE_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_READY_S 5
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_READY_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_VALID_S 4
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_VALID_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_FREEZE_UPON_CNT_S 3
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_FREEZE_UPON_CNT_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_FREEZE_UPON_TRIG_S 2
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_FREEZE_UPON_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_S 1
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_FREEZE_STATUS_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_STATUS_FREEZE_STATUS_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_TRANS_CNT 0x420E1318
#define IG3_CORE_GLPE_CORE_BOB4_BOB_TRANS_CNT_TRANS_CNT_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_TRANS_CNT_TRANS_CNT GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_TRIG_MASK 0x420E1348
#define IG3_CORE_GLPE_CORE_BOB4_BOB_TRIG_MASK_TRIG_MASK_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_TRIG_MASK_TRIG_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB4_BOB_TRIG_VALUE 0x420E1350
#define IG3_CORE_GLPE_CORE_BOB4_BOB_TRIG_VALUE_TRIG_VALUE_S 0
#define IG3_CORE_GLPE_CORE_BOB4_BOB_TRIG_VALUE_TRIG_VALUE GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_BUS_INDEX 0x420E1390
#define IG3_CORE_GLPE_CORE_BOB5_BOB_BUS_INDEX_BUS_INDEX_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_BUS_INDEX_BUS_INDEX GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL 0x420E1380
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_RESERVED_31_10_S 10
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_RESERVED_31_10 GENMASK_ULL(10, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_TRIG_OP_S 8
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_TRIG_OP GENMASK_ULL(8, 9)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_VLD_RDY_FRZ_EN_S 7
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_VLD_RDY_FRZ_EN_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_EN_I_FREEZE_S 6
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_EN_I_FREEZE_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_COUNT_ONLY_TRIG_S 5
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_COUNT_ONLY_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_READ_INPUT_BUS_S 4
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_READ_INPUT_BUS_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_EN_FRZ_ON_CNT_S 3
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_EN_FRZ_ON_CNT_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_EN_FRZ_ON_TRIG_S 2
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_EN_FRZ_ON_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_FREEZE_RESET_S 1
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_FREEZE_RESET_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_FREEZE_SET_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_CTRL_FREEZE_SET_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_FREEZE_ON_CNT_VAL 0x420E13A0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_OBS_BUS 0x420E13C0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_OBS_BUS_OBS_BUS_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_OBS_BUS_OBS_BUS GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CNT0 0x420E13E0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CNT0_CNT0_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CNT0_CNT0 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CNT1_0 0x420E13E8
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CNT1_0_CNT1_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CNT1_0_CNT1 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CNT1_1 0x420E13EC
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CNT1_1_CNT1_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CNT1_1_CNT1 GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CTRL 0x420E13D8
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CTRL_RESERVED_31_16_S 16
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CTRL_RESERVED_31_16 GENMASK_ULL(16, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CTRL_PERF_WIN_S 8
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CTRL_PERF_WIN GENMASK_ULL(8, 15)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CTRL_PERF_CNT1_CFG_S 4
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CTRL_PERF_CNT1_CFG GENMASK_ULL(4, 7)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CTRL_PERF_CNT0_CFG_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_PERF_CTRL_PERF_CNT0_CFG GENMASK_ULL(0, 3)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_RC_CTRL 0x420E13B8
#define IG3_CORE_GLPE_CORE_BOB5_BOB_RC_CTRL_RESERVED_31_1_S 1
#define IG3_CORE_GLPE_CORE_BOB5_BOB_RC_CTRL_RESERVED_31_1 GENMASK_ULL(1, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_RC_CTRL_RC_TRIG_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_RC_CTRL_RC_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_RC_GAP 0x420E13A8
#define IG3_CORE_GLPE_CORE_BOB5_BOB_RC_GAP_RC_GAP_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_RC_GAP_RC_GAP GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_RC_TRNS 0x420E13B0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_RC_TRNS_RC_TRNS_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_RC_TRNS_RC_TRNS GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS 0x420E1388
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_RESERVED_31_8_S 8
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_RESERVED_31_8 GENMASK_ULL(8, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_FREEZE_UPON_IFRZ_S 7
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_FREEZE_UPON_IFRZ_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_I_FREEZE_S 6
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_I_FREEZE_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_READY_S 5
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_READY_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_VALID_S 4
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_VALID_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_FREEZE_UPON_CNT_S 3
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_FREEZE_UPON_CNT_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_FREEZE_UPON_TRIG_S 2
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_FREEZE_UPON_TRIG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_S 1
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_FREEZE_STATUS_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_STATUS_FREEZE_STATUS_M BIT_ULL(31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_TRANS_CNT 0x420E1398
#define IG3_CORE_GLPE_CORE_BOB5_BOB_TRANS_CNT_TRANS_CNT_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_TRANS_CNT_TRANS_CNT GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_TRIG_MASK 0x420E13C8
#define IG3_CORE_GLPE_CORE_BOB5_BOB_TRIG_MASK_TRIG_MASK_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_TRIG_MASK_TRIG_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CORE_BOB5_BOB_TRIG_VALUE 0x420E13D0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_TRIG_VALUE_TRIG_VALUE_S 0
#define IG3_CORE_GLPE_CORE_BOB5_BOB_TRIG_VALUE_TRIG_VALUE GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC0 0x420E104C
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC0_HOST3_THOLD_S 24
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC0_HOST3_THOLD GENMASK_ULL(24, 31)
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC0_HOST2_THOLD_S 16
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC0_HOST2_THOLD GENMASK_ULL(16, 23)
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC0_HOST1_THOLD_S 8
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC0_HOST1_THOLD GENMASK_ULL(8, 15)
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC0_HOST0_THOLD_S 0
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC0_HOST0_THOLD GENMASK_ULL(0, 7)
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC1 0x420E1050
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC1_RSVD_S 16
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC1_RSVD GENMASK_ULL(16, 31)
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC1_HOST5_THOLD_S 8
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC1_HOST5_THOLD GENMASK_ULL(8, 15)
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC1_HOST4_THOLD_S 0
#define IG3_CORE_GLPE_CPAL_HOST_ALLOC1_HOST4_THOLD GENMASK_ULL(0, 7)
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC0 0x420E1054
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC0_HOST3_THOLD_S 24
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC0_HOST3_THOLD GENMASK_ULL(24, 31)
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC0_HOST2_THOLD_S 16
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC0_HOST2_THOLD GENMASK_ULL(16, 23)
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC0_HOST1_THOLD_S 8
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC0_HOST1_THOLD GENMASK_ULL(8, 15)
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC0_HOST0_THOLD_S 0
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC0_HOST0_THOLD GENMASK_ULL(0, 7)
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC1 0x420E1058
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC1_RSVD_S 16
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC1_RSVD GENMASK_ULL(16, 31)
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC1_HOST5_THOLD_S 8
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC1_HOST5_THOLD GENMASK_ULL(8, 15)
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC1_HOST4_THOLD_S 0
#define IG3_CORE_GLPE_DPAL_HOST_ALLOC1_HOST4_THOLD GENMASK_ULL(0, 7)
#define IG3_CORE_GLPE_DTM_GLOBAL_EN 0x420E105C
#define IG3_CORE_GLPE_DTM_GLOBAL_EN_RSVD_S 1
#define IG3_CORE_GLPE_DTM_GLOBAL_EN_RSVD GENMASK_ULL(1, 31)
#define IG3_CORE_GLPE_DTM_GLOBAL_EN_GLOBAL_EN_S 0
#define IG3_CORE_GLPE_DTM_GLOBAL_EN_GLOBAL_EN_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_0_31_0 0x420E1060
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_0_31_0_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_0_31_0_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_0_63_32 0x420E1064
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_0_63_32_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_0_63_32_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_0_75_64 0x420E1068
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_0_75_64_RSVD_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_0_75_64_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_0_75_64_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_0_75_64_MASK GENMASK_ULL(0, 11)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_1_31_0 0x420E106C
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_1_31_0_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_1_31_0_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_1_63_32 0x420E1070
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_1_63_32_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_1_63_32_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_1_75_64 0x420E1074
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_1_75_64_RSVD_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_1_75_64_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_1_75_64_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_1_75_64_MASK GENMASK_ULL(0, 11)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_2_31_0 0x420E1078
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_2_31_0_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_2_31_0_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_2_63_32 0x420E107C
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_2_63_32_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_2_63_32_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_2_75_64 0x420E1080
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_2_75_64_RSVD_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_2_75_64_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_2_75_64_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_2_75_64_MASK GENMASK_ULL(0, 11)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_3_31_0 0x420E1084
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_3_31_0_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_3_31_0_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_3_63_32 0x420E1088
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_3_63_32_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_3_63_32_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_3_75_64 0x420E108C
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_3_75_64_RSVD_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_3_75_64_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_3_75_64_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_3_75_64_MASK GENMASK_ULL(0, 11)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_4_31_0 0x420E1090
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_4_31_0_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_4_31_0_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_4_63_32 0x420E1094
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_4_63_32_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_4_63_32_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_4_75_64 0x420E1098
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_4_75_64_RSVD_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_4_75_64_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_4_75_64_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_4_75_64_MASK GENMASK_ULL(0, 11)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_5_31_0 0x420E109C
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_5_31_0_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_5_31_0_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_5_63_32 0x420E10A0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_5_63_32_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_5_63_32_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_5_75_64 0x420E10A4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_5_75_64_RSVD_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_5_75_64_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_5_75_64_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_5_75_64_MASK GENMASK_ULL(0, 11)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_6_31_0 0x420E10A8
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_6_31_0_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_6_31_0_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_6_63_32 0x420E10AC
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_6_63_32_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_6_63_32_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_6_75_64 0x420E10B0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_6_75_64_RSVD_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_6_75_64_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_6_75_64_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_6_75_64_MASK GENMASK_ULL(0, 11)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_7_31_0 0x420E10B4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_7_31_0_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_7_31_0_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_7_63_32 0x420E10B8
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_7_63_32_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_7_63_32_MASK GENMASK_ULL(0, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_7_75_64 0x420E10BC
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_7_75_64_RSVD_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_7_75_64_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_7_75_64_MASK_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_7_75_64_MASK GENMASK_ULL(0, 11)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8 0x420E10C4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD7_S 31
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD7_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_15_S 28
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_15 GENMASK_ULL(28, 30)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD6_S 27
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD6_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_14_S 24
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_14 GENMASK_ULL(24, 26)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD5_S 23
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD5_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_13_S 20
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_13 GENMASK_ULL(20, 22)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD4_S 19
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD4_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_12_S 16
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_12 GENMASK_ULL(16, 18)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD3_S 15
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD3_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_11_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_11 GENMASK_ULL(12, 14)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD2_S 11
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD2_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_10_S 8
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_10 GENMASK_ULL(8, 10)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD1_S 7
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD1_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_9_S 4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_9 GENMASK_ULL(4, 6)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD0_S 3
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_RSVD0_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_8_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_15_8_MASK_SEL_8 GENMASK_ULL(0, 2)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16 0x420E10C8
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD7_S 31
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD7_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_23_S 28
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_23 GENMASK_ULL(28, 30)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD6_S 27
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD6_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_22_S 24
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_22 GENMASK_ULL(24, 26)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD5_S 23
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD5_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_21_S 20
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_21 GENMASK_ULL(20, 22)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD4_S 19
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD4_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_20_S 16
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_20 GENMASK_ULL(16, 18)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD3_S 15
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD3_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_19_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_19 GENMASK_ULL(12, 14)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD2_S 11
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD2_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_18_S 8
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_18 GENMASK_ULL(8, 10)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD1_S 7
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD1_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_17_S 4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_17 GENMASK_ULL(4, 6)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD0_S 3
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_RSVD0_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_16_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_23_16_MASK_SEL_16 GENMASK_ULL(0, 2)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24 0x420E10CC
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD7_S 31
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD7_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_31_S 28
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_31 GENMASK_ULL(28, 30)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD6_S 27
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD6_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_30_S 24
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_30 GENMASK_ULL(24, 26)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD5_S 23
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD5_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_29_S 20
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_29 GENMASK_ULL(20, 22)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD4_S 19
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD4_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_28_S 16
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_28 GENMASK_ULL(16, 18)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD3_S 15
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD3_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_27_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_27 GENMASK_ULL(12, 14)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD2_S 11
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD2_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_26_S 8
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_26 GENMASK_ULL(8, 10)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD1_S 7
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD1_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_25_S 4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_25 GENMASK_ULL(4, 6)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD0_S 3
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_RSVD0_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_24_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_31_24_MASK_SEL_24 GENMASK_ULL(0, 2)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32 0x420E10D0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD7_S 31
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD7_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_39_S 28
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_39 GENMASK_ULL(28, 30)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD6_S 27
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD6_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_38_S 24
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_38 GENMASK_ULL(24, 26)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD5_S 23
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD5_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_37_S 20
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_37 GENMASK_ULL(20, 22)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD4_S 19
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD4_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_36_S 16
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_36 GENMASK_ULL(16, 18)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD3_S 15
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD3_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_35_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_35 GENMASK_ULL(12, 14)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD2_S 11
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD2_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_34_S 8
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_34 GENMASK_ULL(8, 10)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD1_S 7
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD1_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_33_S 4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_33 GENMASK_ULL(4, 6)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD0_S 3
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_RSVD0_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_32_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_39_32_MASK_SEL_32 GENMASK_ULL(0, 2)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40 0x420E10D4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD7_S 31
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD7_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_47_S 28
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_47 GENMASK_ULL(28, 30)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD6_S 27
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD6_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_46_S 24
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_46 GENMASK_ULL(24, 26)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD5_S 23
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD5_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_45_S 20
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_45 GENMASK_ULL(20, 22)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD4_S 19
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD4_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_44_S 16
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_44 GENMASK_ULL(16, 18)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD3_S 15
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD3_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_43_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_43 GENMASK_ULL(12, 14)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD2_S 11
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD2_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_42_S 8
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_42 GENMASK_ULL(8, 10)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD1_S 7
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD1_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_41_S 4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_41 GENMASK_ULL(4, 6)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD0_S 3
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_RSVD0_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_40_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_47_40_MASK_SEL_40 GENMASK_ULL(0, 2)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48 0x420E10D8
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD7_S 31
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD7_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_55_S 28
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_55 GENMASK_ULL(28, 30)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD6_S 27
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD6_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_54_S 24
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_54 GENMASK_ULL(24, 26)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD5_S 23
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD5_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_53_S 20
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_53 GENMASK_ULL(20, 22)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD4_S 19
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD4_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_52_S 16
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_52 GENMASK_ULL(16, 18)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD3_S 15
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD3_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_51_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_51 GENMASK_ULL(12, 14)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD2_S 11
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD2_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_50_S 8
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_50 GENMASK_ULL(8, 10)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD1_S 7
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD1_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_49_S 4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_49 GENMASK_ULL(4, 6)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD0_S 3
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_RSVD0_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_48_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_55_48_MASK_SEL_48 GENMASK_ULL(0, 2)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56 0x420E10DC
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD7_S 31
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD7_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_63_S 28
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_63 GENMASK_ULL(28, 30)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD6_S 27
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD6_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_62_S 24
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_62 GENMASK_ULL(24, 26)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD5_S 23
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD5_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_61_S 20
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_61 GENMASK_ULL(20, 22)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD4_S 19
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD4_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_60_S 16
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_60 GENMASK_ULL(16, 18)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD3_S 15
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD3_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_59_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_59 GENMASK_ULL(12, 14)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD2_S 11
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD2_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_58_S 8
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_58 GENMASK_ULL(8, 10)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD1_S 7
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD1_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_57_S 4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_57 GENMASK_ULL(4, 6)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD0_S 3
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_RSVD0_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_56_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_63_56_MASK_SEL_56 GENMASK_ULL(0, 2)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64 0x420E10E0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD7_S 31
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD7_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_71_S 28
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_71 GENMASK_ULL(28, 30)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD6_S 27
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD6_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_70_S 24
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_70 GENMASK_ULL(24, 26)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD5_S 23
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD5_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_69_S 20
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_69 GENMASK_ULL(20, 22)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD4_S 19
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD4_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_68_S 16
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_68 GENMASK_ULL(16, 18)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD3_S 15
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD3_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_67_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_67 GENMASK_ULL(12, 14)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD2_S 11
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD2_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_66_S 8
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_66 GENMASK_ULL(8, 10)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD1_S 7
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD1_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_65_S 4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_65 GENMASK_ULL(4, 6)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD0_S 3
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_RSVD0_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_64_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_71_64_MASK_SEL_64 GENMASK_ULL(0, 2)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72 0x420E10E4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_RSVD5_S 15
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_RSVD5 GENMASK_ULL(15, 31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_MASK_SEL_75_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_MASK_SEL_75 GENMASK_ULL(12, 14)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_RSVD2_S 11
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_RSVD2_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_MASK_SEL_74_S 8
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_MASK_SEL_74 GENMASK_ULL(8, 10)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_RSVD1_S 7
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_RSVD1_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_MASK_SEL_73_S 4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_MASK_SEL_73 GENMASK_ULL(4, 6)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_RSVD0_S 3
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_RSVD0_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_MASK_SEL_72_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_75_72_MASK_SEL_72 GENMASK_ULL(0, 2)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0 0x420E10C0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD7_S 31
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD7_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_7_S 28
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_7 GENMASK_ULL(28, 30)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD6_S 27
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD6_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_6_S 24
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_6 GENMASK_ULL(24, 26)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD5_S 23
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD5_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_5_S 20
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_5 GENMASK_ULL(20, 22)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD4_S 19
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD4_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_4_S 16
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_4 GENMASK_ULL(16, 18)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD3_S 15
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD3_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_3_S 12
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_3 GENMASK_ULL(12, 14)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD2_S 11
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD2_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_2_S 8
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_2 GENMASK_ULL(8, 10)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD1_S 7
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD1_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_1_S 4
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_1 GENMASK_ULL(4, 6)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD0_S 3
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_RSVD0_M BIT_ULL(31)
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_0_S 0
#define IG3_CORE_GLPE_DTM_MATRIX_MASK_SEL_7_0_MASK_SEL_0 GENMASK_ULL(0, 2)
#define IG3_CORE_GLPE_FLM_OBJCTRL(_i) (0x420E0000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_CORE_GLPE_FLM_OBJCTRL_MAX_INDEX_I 1031
#define IG3_CORE_GLPE_FLM_OBJCTRL_FLMEN_S 31
#define IG3_CORE_GLPE_FLM_OBJCTRL_FLMEN_M BIT_ULL(31)
#define IG3_CORE_GLPE_FLM_OBJCTRL_FLMST_S 30
#define IG3_CORE_GLPE_FLM_OBJCTRL_FLMST_M BIT_ULL(31)
#define IG3_CORE_GLPE_FLM_OBJCTRL_RSVD3_S 27
#define IG3_CORE_GLPE_FLM_OBJCTRL_RSVD3 GENMASK_ULL(27, 29)
#define IG3_CORE_GLPE_FLM_OBJCTRL_OOISC_BLOCKSIZE_S 24
#define IG3_CORE_GLPE_FLM_OBJCTRL_OOISC_BLOCKSIZE GENMASK_ULL(24, 26)
#define IG3_CORE_GLPE_FLM_OBJCTRL_RSVD2_S 19
#define IG3_CORE_GLPE_FLM_OBJCTRL_RSVD2 GENMASK_ULL(19, 23)
#define IG3_CORE_GLPE_FLM_OBJCTRL_RRSP_BLOCKSIZE_S 16
#define IG3_CORE_GLPE_FLM_OBJCTRL_RRSP_BLOCKSIZE GENMASK_ULL(16, 18)
#define IG3_CORE_GLPE_FLM_OBJCTRL_RSVD1_S 11
#define IG3_CORE_GLPE_FLM_OBJCTRL_RSVD1 GENMASK_ULL(11, 15)
#define IG3_CORE_GLPE_FLM_OBJCTRL_Q1_BLOCKSIZE_S 8
#define IG3_CORE_GLPE_FLM_OBJCTRL_Q1_BLOCKSIZE GENMASK_ULL(8, 10)
#define IG3_CORE_GLPE_FLM_OBJCTRL_RSVD0_S 3
#define IG3_CORE_GLPE_FLM_OBJCTRL_RSVD0 GENMASK_ULL(3, 7)
#define IG3_CORE_GLPE_FLM_OBJCTRL_XMIT_BLOCKSIZE_S 0
#define IG3_CORE_GLPE_FLM_OBJCTRL_XMIT_BLOCKSIZE GENMASK_ULL(0, 2)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0 0x420E1020
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_BUSY_S 31
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_BUSY_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_OP_S 28
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_OP GENMASK_ULL(28, 30)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_ISMASKED_C_MASK_S 27
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_ISMASKED_C_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_ISMASKED_C_S 26
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_ISMASKED_C_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_ISMASKED_W_MASK_S 25
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_ISMASKED_W_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_ISMASKED_W_S 24
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_ISMASKED_W_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INFLR_C_MASK_S 23
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INFLR_C_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INFLR_C_S 22
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INFLR_C_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INFLR_W_MASK_S 21
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INFLR_W_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INFLR_W_S 20
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INFLR_W_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INTEAM_C_MASK_S 19
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INTEAM_C_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INTEAM_C_S 18
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INTEAM_C_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INTEAM_W_MASK_S 17
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INTEAM_W_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INTEAM_W_S 16
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_INTEAM_W_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_VALID_C_MASK_S 15
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_VALID_C_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_VALID_C_S 14
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_VALID_C_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_VALID_W_MASK_S 13
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_VALID_W_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_VALID_W_S 12
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_VALID_W_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_TBL_IDX_S 0
#define IG3_CORE_GLPE_PMF_TABLE_CTRL0_TBL_IDX GENMASK_ULL(0, 11)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL1 0x420E1024
#define IG3_CORE_GLPE_PMF_TABLE_CTRL1_PMF_C_MASK_S 31
#define IG3_CORE_GLPE_PMF_TABLE_CTRL1_PMF_C_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL1_RSVD1_S 28
#define IG3_CORE_GLPE_PMF_TABLE_CTRL1_RSVD1 GENMASK_ULL(28, 30)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL1_PMF_C_S 16
#define IG3_CORE_GLPE_PMF_TABLE_CTRL1_PMF_C GENMASK_ULL(16, 27)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL1_PMF_W_MASK_S 15
#define IG3_CORE_GLPE_PMF_TABLE_CTRL1_PMF_W_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL1_RSVD0_S 12
#define IG3_CORE_GLPE_PMF_TABLE_CTRL1_RSVD0 GENMASK_ULL(12, 14)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL1_PMF_W_S 0
#define IG3_CORE_GLPE_PMF_TABLE_CTRL1_PMF_W GENMASK_ULL(0, 11)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2 0x420E1028
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_HOSTID_W_MASK_S 31
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_HOSTID_W_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_VDEV_VF_TYPE_W_MASK_S 30
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_VDEV_VF_TYPE_W_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_VDEV_VF_W_MASK_S 29
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_VDEV_VF_W_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_PF_W_MASK_S 28
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_PF_W_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_RSVD_S 23
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_RSVD GENMASK_ULL(23, 27)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_HOSTID_W_S 20
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_HOSTID_W GENMASK_ULL(20, 22)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_VDEV_VF_TYPE_W_S 18
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_VDEV_VF_TYPE_W GENMASK_ULL(18, 19)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_VDEV_VF_W_S 6
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_VDEV_VF_W GENMASK_ULL(6, 17)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_PF_W_S 0
#define IG3_CORE_GLPE_PMF_TABLE_CTRL2_PF_W GENMASK_ULL(0, 5)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3 0x420E102C
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_HOSTID_C_MASK_S 31
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_HOSTID_C_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_VDEV_VF_TYPE_C_MASK_S 30
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_VDEV_VF_TYPE_C_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_VDEV_VF_C_MASK_S 29
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_VDEV_VF_C_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_PF_C_MASK_S 28
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_PF_C_MASK_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_RSVD_S 23
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_RSVD GENMASK_ULL(23, 27)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_HOSTID_C_S 20
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_HOSTID_C GENMASK_ULL(20, 22)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_VDEV_VF_TYPE_C_S 18
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_VDEV_VF_TYPE_C GENMASK_ULL(18, 19)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_VDEV_VF_C_S 6
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_VDEV_VF_C GENMASK_ULL(6, 17)
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_PF_C_S 0
#define IG3_CORE_GLPE_PMF_TABLE_CTRL3_PF_C GENMASK_ULL(0, 5)
#define IG3_CORE_GLPE_PMF_TABLE_DATA0 0x420E1030
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_HIT_S 31
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_HIT_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_RSVD_S 28
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_RSVD GENMASK_ULL(28, 30)
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_PMF_S 16
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_PMF GENMASK_ULL(16, 27)
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_INTEAM_S 15
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_INTEAM_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_INFLR_S 14
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_INFLR_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_ISMASKED_S 13
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_ISMASKED_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_VALID_S 12
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_VALID_M BIT_ULL(31)
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_TBL_IDX_S 0
#define IG3_CORE_GLPE_PMF_TABLE_DATA0_TBL_IDX GENMASK_ULL(0, 11)
#define IG3_CORE_GLPE_PMF_TABLE_DATA1 0x420E1034
#define IG3_CORE_GLPE_PMF_TABLE_DATA1_RSVD_S 23
#define IG3_CORE_GLPE_PMF_TABLE_DATA1_RSVD GENMASK_ULL(23, 31)
#define IG3_CORE_GLPE_PMF_TABLE_DATA1_HOSTID_S 20
#define IG3_CORE_GLPE_PMF_TABLE_DATA1_HOSTID GENMASK_ULL(20, 22)
#define IG3_CORE_GLPE_PMF_TABLE_DATA1_VDEV_VF_TYPE_S 18
#define IG3_CORE_GLPE_PMF_TABLE_DATA1_VDEV_VF_TYPE GENMASK_ULL(18, 19)
#define IG3_CORE_GLPE_PMF_TABLE_DATA1_VDEV_VF_S 6
#define IG3_CORE_GLPE_PMF_TABLE_DATA1_VDEV_VF GENMASK_ULL(6, 17)
#define IG3_CORE_GLPE_PMF_TABLE_DATA1_PF_S 0
#define IG3_CORE_GLPE_PMF_TABLE_DATA1_PF GENMASK_ULL(0, 5)
#define IG3_CORE_GLPE_PRECACHE_TABLE_CTRL 0x420E1038
#define IG3_CORE_GLPE_PRECACHE_TABLE_CTRL_BUSY_S 31
#define IG3_CORE_GLPE_PRECACHE_TABLE_CTRL_BUSY_M BIT_ULL(31)
#define IG3_CORE_GLPE_PRECACHE_TABLE_CTRL_RSVD_S 15
#define IG3_CORE_GLPE_PRECACHE_TABLE_CTRL_RSVD GENMASK_ULL(15, 30)
#define IG3_CORE_GLPE_PRECACHE_TABLE_CTRL_OP_S 14
#define IG3_CORE_GLPE_PRECACHE_TABLE_CTRL_OP_M BIT_ULL(31)
#define IG3_CORE_GLPE_PRECACHE_TABLE_CTRL_FTYPE_S 12
#define IG3_CORE_GLPE_PRECACHE_TABLE_CTRL_FTYPE GENMASK_ULL(12, 13)
#define IG3_CORE_GLPE_PRECACHE_TABLE_CTRL_TBL_IDX_S 0
#define IG3_CORE_GLPE_PRECACHE_TABLE_CTRL_TBL_IDX GENMASK_ULL(0, 11)
#define IG3_CORE_GLPE_PRECACHE_TABLE_DATA 0x420E103C
#define IG3_CORE_GLPE_PRECACHE_TABLE_DATA_RSVD_S 3
#define IG3_CORE_GLPE_PRECACHE_TABLE_DATA_RSVD GENMASK_ULL(3, 31)
#define IG3_CORE_GLPE_PRECACHE_TABLE_DATA_PROTOCOL_S 0
#define IG3_CORE_GLPE_PRECACHE_TABLE_DATA_PROTOCOL GENMASK_ULL(0, 2)
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHHI 0x420E1048
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHHI_RSVD0_S 26
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHHI_RSVD0 GENMASK_ULL(26, 31)
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHHI_QPID_S 6
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHHI_QPID GENMASK_ULL(6, 25)
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHHI_PF_NUM_S 0
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHHI_PF_NUM GENMASK_ULL(0, 5)
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO 0x420E1044
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO_BUSY_S 31
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO_BUSY_M BIT_ULL(31)
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO_REQ_TYPE_S 30
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO_REQ_TYPE_M BIT_ULL(31)
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO_RSVD0_S 29
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO_RSVD0_M BIT_ULL(31)
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO_HOSTID_S 26
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO_HOSTID GENMASK_ULL(26, 28)
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO_VM_VF_TYPE_S 24
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO_VM_VF_TYPE GENMASK_ULL(24, 25)
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO_VM_VF_NUM_S 12
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO_VM_VF_NUM GENMASK_ULL(12, 23)
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO_PMF_S 0
#define IG3_CORE_GLPE_SRQ_FWQPFLUSHLO_PMF GENMASK_ULL(0, 11)
#define IG3_CORE_GLPE_TMR_COMP 0x420E1040
#define IG3_CORE_GLPE_TMR_COMP_RSVD_S 8
#define IG3_CORE_GLPE_TMR_COMP_RSVD GENMASK_ULL(8, 31)
#define IG3_CORE_GLPE_TMR_COMP_COMP_S 0
#define IG3_CORE_GLPE_TMR_COMP_COMP GENMASK_ULL(0, 7)
#define IG3_RLCR_GLPE_RLADDR 0x420E2010
#define IG3_RLCR_GLPE_RLADDR_RSVD_S 13
#define IG3_RLCR_GLPE_RLADDR_RSVD GENMASK_ULL(13, 31)
#define IG3_RLCR_GLPE_RLADDR_RL_ADDR_S 0
#define IG3_RLCR_GLPE_RLADDR_RL_ADDR GENMASK_ULL(0, 12)
#define IG3_RLCR_GLPE_RLC_DPC_COMP 0x420E2024
#define IG3_RLCR_GLPE_RLC_DPC_COMP_RSVD_S 13
#define IG3_RLCR_GLPE_RLC_DPC_COMP_RSVD GENMASK_ULL(13, 31)
#define IG3_RLCR_GLPE_RLC_DPC_COMP_COMP_FTYPE_S 11
#define IG3_RLCR_GLPE_RLC_DPC_COMP_COMP_FTYPE GENMASK_ULL(11, 12)
#define IG3_RLCR_GLPE_RLC_DPC_COMP_COMP_FNUM_S 1
#define IG3_RLCR_GLPE_RLC_DPC_COMP_COMP_FNUM GENMASK_ULL(1, 10)
#define IG3_RLCR_GLPE_RLC_DPC_COMP_COMP_VALID_S 0
#define IG3_RLCR_GLPE_RLC_DPC_COMP_COMP_VALID_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DPC_REQ 0x420E2020
#define IG3_RLCR_GLPE_RLC_DPC_REQ_RSVD_S 12
#define IG3_RLCR_GLPE_RLC_DPC_REQ_RSVD GENMASK_ULL(12, 31)
#define IG3_RLCR_GLPE_RLC_DPC_REQ_REQ_FTYPE_S 10
#define IG3_RLCR_GLPE_RLC_DPC_REQ_REQ_FTYPE GENMASK_ULL(10, 11)
#define IG3_RLCR_GLPE_RLC_DPC_REQ_REQ_FNUM_S 0
#define IG3_RLCR_GLPE_RLC_DPC_REQ_REQ_FNUM GENMASK_ULL(0, 9)
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_COUNT 0x420E20B8
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_CMD 0x420E20CC
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_DATA_H 0x420E20D8
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_DATA_L 0x420E20D4
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_PTR 0x420E20D0
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_CMD 0x420E20BC
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_DATA_H 0x420E20C8
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_DATA_L 0x420E20C4
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_PTR 0x420E20C0
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL 0x420E2080
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_RSVD1_S 25
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_RSVD2_S 17
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_RSVD3_S 9
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_BYPASS_S 8
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_RSVD4_S 1
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_RLCR_GLPE_RLC_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_ECC_COR_ERR 0x420E20E8
#define IG3_RLCR_GLPE_RLC_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_RLCR_GLPE_RLC_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_RLCR_GLPE_RLC_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_RLCR_GLPE_RLC_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_RLCR_GLPE_RLC_DTM_ECC_UNCOR_ERR 0x420E20E4
#define IG3_RLCR_GLPE_RLC_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_RLCR_GLPE_RLC_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_RLCR_GLPE_RLC_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_RLCR_GLPE_RLC_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_RLCR_GLPE_RLC_DTM_GROUP_CFG 0x420E208C
#define IG3_RLCR_GLPE_RLC_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_RLCR_GLPE_RLC_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_RLCR_GLPE_RLC_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_RLCR_GLPE_RLC_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_RLCR_GLPE_RLC_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_RLCR_GLPE_RLC_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_RLCR_GLPE_RLC_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_RLCR_GLPE_RLC_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_RLCR_GLPE_RLC_DTM_LOG_CFG 0x420E2090
#define IG3_RLCR_GLPE_RLC_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_RLCR_GLPE_RLC_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_RLCR_GLPE_RLC_DTM_LOG_CFG_RSVD1_S 2
#define IG3_RLCR_GLPE_RLC_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_RLCR_GLPE_RLC_DTM_LOG_CFG_MODE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_RLCR_GLPE_RLC_DTM_LOG_MASK 0x420E2098
#define IG3_RLCR_GLPE_RLC_DTM_LOG_MASK_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCR_GLPE_RLC_DTM_LOG_PATTERN 0x420E2094
#define IG3_RLCR_GLPE_RLC_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_CFG 0x420E2084
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_STS 0x420E2088
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_STS_RSVD1_S 9
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_STS_RSVD2_S 1
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TIMESTAMP 0x420E20B0
#define IG3_RLCR_GLPE_RLC_DTM_TIMESTAMP_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCR_GLPE_RLC_DTM_TIMESTAMP_ROLLOVER 0x420E20B4
#define IG3_RLCR_GLPE_RLC_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG 0x420E20DC
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS 0x420E20E0
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_RLCR_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_CFG 0x420E209C
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_CFG_MODE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_COUNT 0x420E20A8
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_MASK 0x420E20A4
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_MASK_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_PATTERN 0x420E20A0
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_TIMESTAMP 0x420E20AC
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_RLCR_GLPE_RLC_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCR_GLPE_RLC_ERRDATA 0x420E201C
#define IG3_RLCR_GLPE_RLC_ERRDATA_Q_NUM_S 8
#define IG3_RLCR_GLPE_RLC_ERRDATA_Q_NUM GENMASK_ULL(8, 31)
#define IG3_RLCR_GLPE_RLC_ERRDATA_RSVD0_S 7
#define IG3_RLCR_GLPE_RLC_ERRDATA_RSVD0_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_ERRDATA_Q_TYPE_S 4
#define IG3_RLCR_GLPE_RLC_ERRDATA_Q_TYPE GENMASK_ULL(4, 6)
#define IG3_RLCR_GLPE_RLC_ERRDATA_ERROR_CODE_S 0
#define IG3_RLCR_GLPE_RLC_ERRDATA_ERROR_CODE GENMASK_ULL(0, 3)
#define IG3_RLCR_GLPE_RLC_ERRINFO 0x420E2018
#define IG3_RLCR_GLPE_RLC_ERRINFO_RLS_ERROR_CNT_S 24
#define IG3_RLCR_GLPE_RLC_ERRINFO_RLS_ERROR_CNT GENMASK_ULL(24, 31)
#define IG3_RLCR_GLPE_RLC_ERRINFO_RLU_ERROR_CNT_S 16
#define IG3_RLCR_GLPE_RLC_ERRINFO_RLU_ERROR_CNT GENMASK_ULL(16, 23)
#define IG3_RLCR_GLPE_RLC_ERRINFO_DBL_ERROR_CNT_S 8
#define IG3_RLCR_GLPE_RLC_ERRINFO_DBL_ERROR_CNT GENMASK_ULL(8, 15)
#define IG3_RLCR_GLPE_RLC_ERRINFO_RSVD1_S 7
#define IG3_RLCR_GLPE_RLC_ERRINFO_RSVD1_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLC_ERRINFO_ERROR_INST_S 4
#define IG3_RLCR_GLPE_RLC_ERRINFO_ERROR_INST GENMASK_ULL(4, 6)
#define IG3_RLCR_GLPE_RLC_ERRINFO_RSVD0_S 1
#define IG3_RLCR_GLPE_RLC_ERRINFO_RSVD0 GENMASK_ULL(1, 3)
#define IG3_RLCR_GLPE_RLC_ERRINFO_ERROR_VALID_S 0
#define IG3_RLCR_GLPE_RLC_ERRINFO_ERROR_VALID_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLDATA 0x420E2014
#define IG3_RLCR_GLPE_RLDATA_RL_DATA_S 0
#define IG3_RLCR_GLPE_RLDATA_RL_DATA GENMASK_ULL(0, 31)
#define IG3_RLCR_GLPE_RLQUERY(_i) (0x420E2000 + ((_i) * 4)) /* _i=0...1 */
#define IG3_RLCR_GLPE_RLQUERY_MAX_INDEX_I 1
#define IG3_RLCR_GLPE_RLQUERY_RSVD_S 12
#define IG3_RLCR_GLPE_RLQUERY_RSVD GENMASK_ULL(12, 31)
#define IG3_RLCR_GLPE_RLQUERY_RLINDEX_S 0
#define IG3_RLCR_GLPE_RLQUERY_RLINDEX GENMASK_ULL(0, 11)
#define IG3_RLCR_GLPE_RLSTAT(_i) (0x420E2008 + ((_i) * 4)) /* _i=0...1 */
#define IG3_RLCR_GLPE_RLSTAT_MAX_INDEX_I 1
#define IG3_RLCR_GLPE_RLSTAT_RSVD_S 2
#define IG3_RLCR_GLPE_RLSTAT_RSVD GENMASK_ULL(2, 31)
#define IG3_RLCR_GLPE_RLSTAT_RL_EMPTY_S 1
#define IG3_RLCR_GLPE_RLSTAT_RL_EMPTY_M BIT_ULL(31)
#define IG3_RLCR_GLPE_RLSTAT_QUERY_DONE_S 0
#define IG3_RLCR_GLPE_RLSTAT_QUERY_DONE_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLADDR 0x420E2410
#define IG3_RLCC_GLPE_RLADDR_RSVD_S 13
#define IG3_RLCC_GLPE_RLADDR_RSVD GENMASK_ULL(13, 31)
#define IG3_RLCC_GLPE_RLADDR_RL_ADDR_S 0
#define IG3_RLCC_GLPE_RLADDR_RL_ADDR GENMASK_ULL(0, 12)
#define IG3_RLCC_GLPE_RLC_DPC_COMP 0x420E2424
#define IG3_RLCC_GLPE_RLC_DPC_COMP_RSVD_S 13
#define IG3_RLCC_GLPE_RLC_DPC_COMP_RSVD GENMASK_ULL(13, 31)
#define IG3_RLCC_GLPE_RLC_DPC_COMP_COMP_FTYPE_S 11
#define IG3_RLCC_GLPE_RLC_DPC_COMP_COMP_FTYPE GENMASK_ULL(11, 12)
#define IG3_RLCC_GLPE_RLC_DPC_COMP_COMP_FNUM_S 1
#define IG3_RLCC_GLPE_RLC_DPC_COMP_COMP_FNUM GENMASK_ULL(1, 10)
#define IG3_RLCC_GLPE_RLC_DPC_COMP_COMP_VALID_S 0
#define IG3_RLCC_GLPE_RLC_DPC_COMP_COMP_VALID_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DPC_REQ 0x420E2420
#define IG3_RLCC_GLPE_RLC_DPC_REQ_RSVD_S 12
#define IG3_RLCC_GLPE_RLC_DPC_REQ_RSVD GENMASK_ULL(12, 31)
#define IG3_RLCC_GLPE_RLC_DPC_REQ_REQ_FTYPE_S 10
#define IG3_RLCC_GLPE_RLC_DPC_REQ_REQ_FTYPE GENMASK_ULL(10, 11)
#define IG3_RLCC_GLPE_RLC_DPC_REQ_REQ_FNUM_S 0
#define IG3_RLCC_GLPE_RLC_DPC_REQ_REQ_FNUM GENMASK_ULL(0, 9)
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_COUNT 0x420E24B8
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_CMD 0x420E24CC
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_DATA_H 0x420E24D8
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_DATA_L 0x420E24D4
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_PTR 0x420E24D0
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_CMD 0x420E24BC
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_DATA_H 0x420E24C8
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_DATA_L 0x420E24C4
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_PTR 0x420E24C0
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL 0x420E2480
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_RSVD1_S 25
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_RSVD2_S 17
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_RSVD3_S 9
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_BYPASS_S 8
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_RSVD4_S 1
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_RLCC_GLPE_RLC_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_ECC_COR_ERR 0x420E24E8
#define IG3_RLCC_GLPE_RLC_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_RLCC_GLPE_RLC_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_RLCC_GLPE_RLC_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_RLCC_GLPE_RLC_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_RLCC_GLPE_RLC_DTM_ECC_UNCOR_ERR 0x420E24E4
#define IG3_RLCC_GLPE_RLC_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_RLCC_GLPE_RLC_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_RLCC_GLPE_RLC_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_RLCC_GLPE_RLC_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_RLCC_GLPE_RLC_DTM_GROUP_CFG 0x420E248C
#define IG3_RLCC_GLPE_RLC_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_RLCC_GLPE_RLC_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_RLCC_GLPE_RLC_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_RLCC_GLPE_RLC_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_RLCC_GLPE_RLC_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_RLCC_GLPE_RLC_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_RLCC_GLPE_RLC_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_RLCC_GLPE_RLC_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_RLCC_GLPE_RLC_DTM_LOG_CFG 0x420E2490
#define IG3_RLCC_GLPE_RLC_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_RLCC_GLPE_RLC_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_RLCC_GLPE_RLC_DTM_LOG_CFG_RSVD1_S 2
#define IG3_RLCC_GLPE_RLC_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_RLCC_GLPE_RLC_DTM_LOG_CFG_MODE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_RLCC_GLPE_RLC_DTM_LOG_MASK 0x420E2498
#define IG3_RLCC_GLPE_RLC_DTM_LOG_MASK_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCC_GLPE_RLC_DTM_LOG_PATTERN 0x420E2494
#define IG3_RLCC_GLPE_RLC_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_CFG 0x420E2484
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_STS 0x420E2488
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_STS_RSVD1_S 9
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_STS_RSVD2_S 1
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TIMESTAMP 0x420E24B0
#define IG3_RLCC_GLPE_RLC_DTM_TIMESTAMP_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCC_GLPE_RLC_DTM_TIMESTAMP_ROLLOVER 0x420E24B4
#define IG3_RLCC_GLPE_RLC_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG 0x420E24DC
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS 0x420E24E0
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_RLCC_GLPE_RLC_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_CFG 0x420E249C
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_CFG_MODE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_COUNT 0x420E24A8
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_MASK 0x420E24A4
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_MASK_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_PATTERN 0x420E24A0
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_TIMESTAMP 0x420E24AC
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_RLCC_GLPE_RLC_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_RLCC_GLPE_RLC_ERRDATA 0x420E241C
#define IG3_RLCC_GLPE_RLC_ERRDATA_Q_NUM_S 8
#define IG3_RLCC_GLPE_RLC_ERRDATA_Q_NUM GENMASK_ULL(8, 31)
#define IG3_RLCC_GLPE_RLC_ERRDATA_RSVD0_S 7
#define IG3_RLCC_GLPE_RLC_ERRDATA_RSVD0_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_ERRDATA_Q_TYPE_S 4
#define IG3_RLCC_GLPE_RLC_ERRDATA_Q_TYPE GENMASK_ULL(4, 6)
#define IG3_RLCC_GLPE_RLC_ERRDATA_ERROR_CODE_S 0
#define IG3_RLCC_GLPE_RLC_ERRDATA_ERROR_CODE GENMASK_ULL(0, 3)
#define IG3_RLCC_GLPE_RLC_ERRINFO 0x420E2418
#define IG3_RLCC_GLPE_RLC_ERRINFO_RLS_ERROR_CNT_S 24
#define IG3_RLCC_GLPE_RLC_ERRINFO_RLS_ERROR_CNT GENMASK_ULL(24, 31)
#define IG3_RLCC_GLPE_RLC_ERRINFO_RLU_ERROR_CNT_S 16
#define IG3_RLCC_GLPE_RLC_ERRINFO_RLU_ERROR_CNT GENMASK_ULL(16, 23)
#define IG3_RLCC_GLPE_RLC_ERRINFO_DBL_ERROR_CNT_S 8
#define IG3_RLCC_GLPE_RLC_ERRINFO_DBL_ERROR_CNT GENMASK_ULL(8, 15)
#define IG3_RLCC_GLPE_RLC_ERRINFO_RSVD1_S 7
#define IG3_RLCC_GLPE_RLC_ERRINFO_RSVD1_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLC_ERRINFO_ERROR_INST_S 4
#define IG3_RLCC_GLPE_RLC_ERRINFO_ERROR_INST GENMASK_ULL(4, 6)
#define IG3_RLCC_GLPE_RLC_ERRINFO_RSVD0_S 1
#define IG3_RLCC_GLPE_RLC_ERRINFO_RSVD0 GENMASK_ULL(1, 3)
#define IG3_RLCC_GLPE_RLC_ERRINFO_ERROR_VALID_S 0
#define IG3_RLCC_GLPE_RLC_ERRINFO_ERROR_VALID_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLDATA 0x420E2414
#define IG3_RLCC_GLPE_RLDATA_RL_DATA_S 0
#define IG3_RLCC_GLPE_RLDATA_RL_DATA GENMASK_ULL(0, 31)
#define IG3_RLCC_GLPE_RLQUERY(_i) (0x420E2400 + ((_i) * 4)) /* _i=0...1 */
#define IG3_RLCC_GLPE_RLQUERY_MAX_INDEX_I 1
#define IG3_RLCC_GLPE_RLQUERY_RSVD_S 12
#define IG3_RLCC_GLPE_RLQUERY_RSVD GENMASK_ULL(12, 31)
#define IG3_RLCC_GLPE_RLQUERY_RLINDEX_S 0
#define IG3_RLCC_GLPE_RLQUERY_RLINDEX GENMASK_ULL(0, 11)
#define IG3_RLCC_GLPE_RLSTAT(_i) (0x420E2408 + ((_i) * 4)) /* _i=0...1 */
#define IG3_RLCC_GLPE_RLSTAT_MAX_INDEX_I 1
#define IG3_RLCC_GLPE_RLSTAT_RSVD_S 2
#define IG3_RLCC_GLPE_RLSTAT_RSVD GENMASK_ULL(2, 31)
#define IG3_RLCC_GLPE_RLSTAT_RL_EMPTY_S 1
#define IG3_RLCC_GLPE_RLSTAT_RL_EMPTY_M BIT_ULL(31)
#define IG3_RLCC_GLPE_RLSTAT_QUERY_DONE_S 0
#define IG3_RLCC_GLPE_RLSTAT_QUERY_DONE_M BIT_ULL(31)
#define IG3_CEH_GLGEN_PE_STOP_SCREAM_RAS 0x420E2830
#define IG3_CEH_GLGEN_PE_STOP_SCREAM_RAS_RSVD_S 3
#define IG3_CEH_GLGEN_PE_STOP_SCREAM_RAS_RSVD GENMASK_ULL(3, 31)
#define IG3_CEH_GLGEN_PE_STOP_SCREAM_RAS_DISABLE_S 2
#define IG3_CEH_GLGEN_PE_STOP_SCREAM_RAS_DISABLE_M BIT_ULL(31)
#define IG3_CEH_GLGEN_PE_STOP_SCREAM_RAS_STOP_SCREAM_STAT_S 0
#define IG3_CEH_GLGEN_PE_STOP_SCREAM_RAS_STOP_SCREAM_STAT GENMASK_ULL(0, 1)
#define IG3_CEH_GLPE_CRITERR_MODMASK 0x420E2804
#define IG3_CEH_GLPE_CRITERR_MODMASK_MODULE_MASK0_S 1
#define IG3_CEH_GLPE_CRITERR_MODMASK_MODULE_MASK0 GENMASK_ULL(1, 31)
#define IG3_CEH_GLPE_CRITERR_MODMASK_RSVD_S 0
#define IG3_CEH_GLPE_CRITERR_MODMASK_RSVD_M BIT_ULL(31)
#define IG3_CEH_GLPE_CRITERR_MODMASK1 0x420E2808
#define IG3_CEH_GLPE_CRITERR_MODMASK1_MODULE_MASK_S 0
#define IG3_CEH_GLPE_CRITERR_MODMASK1_MODULE_MASK GENMASK_ULL(0, 31)
#define IG3_CEH_GLPE_CRITERR_MODMASK2 0x420E280C
#define IG3_CEH_GLPE_CRITERR_MODMASK2_MODULE_MASK_S 0
#define IG3_CEH_GLPE_CRITERR_MODMASK2_MODULE_MASK GENMASK_ULL(0, 31)
#define IG3_CEH_GLPE_CRITERR_STATUS 0x420E2800
#define IG3_CEH_GLPE_CRITERR_STATUS_RSVD_S 17
#define IG3_CEH_GLPE_CRITERR_STATUS_RSVD GENMASK_ULL(17, 31)
#define IG3_CEH_GLPE_CRITERR_STATUS_ERROR_SET_S 16
#define IG3_CEH_GLPE_CRITERR_STATUS_ERROR_SET_M BIT_ULL(31)
#define IG3_CEH_GLPE_CRITERR_STATUS_ERROR_MODULE_S 8
#define IG3_CEH_GLPE_CRITERR_STATUS_ERROR_MODULE GENMASK_ULL(8, 15)
#define IG3_CEH_GLPE_CRITERR_STATUS_ERROR_TYPE_S 6
#define IG3_CEH_GLPE_CRITERR_STATUS_ERROR_TYPE GENMASK_ULL(6, 7)
#define IG3_CEH_GLPE_CRITERR_STATUS_ERROR_INST_S 0
#define IG3_CEH_GLPE_CRITERR_STATUS_ERROR_INST GENMASK_ULL(0, 5)
#define IG3_CEH_GLPE_CRITERR_TRGTMASK(_i) (0x420E2810 + ((_i) * 4)) /* _i=0...7 */
#define IG3_CEH_GLPE_CRITERR_TRGTMASK_MAX_INDEX_I 7
#define IG3_CEH_GLPE_CRITERR_TRGTMASK_TRGT_MATCH_1_MODULE_S 24
#define IG3_CEH_GLPE_CRITERR_TRGTMASK_TRGT_MATCH_1_MODULE GENMASK_ULL(24, 31)
#define IG3_CEH_GLPE_CRITERR_TRGTMASK_TRGT_MATCH_1_TYPE_S 22
#define IG3_CEH_GLPE_CRITERR_TRGTMASK_TRGT_MATCH_1_TYPE GENMASK_ULL(22, 23)
#define IG3_CEH_GLPE_CRITERR_TRGTMASK_TRGT_MATCH_1_INST_S 16
#define IG3_CEH_GLPE_CRITERR_TRGTMASK_TRGT_MATCH_1_INST GENMASK_ULL(16, 21)
#define IG3_CEH_GLPE_CRITERR_TRGTMASK_TRGT_MATCH_0_MODULE_S 8
#define IG3_CEH_GLPE_CRITERR_TRGTMASK_TRGT_MATCH_0_MODULE GENMASK_ULL(8, 15)
#define IG3_CEH_GLPE_CRITERR_TRGTMASK_TRGT_MATCH_0_TYPE_S 6
#define IG3_CEH_GLPE_CRITERR_TRGTMASK_TRGT_MATCH_0_TYPE GENMASK_ULL(6, 7)
#define IG3_CEH_GLPE_CRITERR_TRGTMASK_TRGT_MATCH_0_INST_S 0
#define IG3_CEH_GLPE_CRITERR_TRGTMASK_TRGT_MATCH_0_INST GENMASK_ULL(0, 5)
#define IG3_TMGR_GLPE_TMGR_CLIENTREQ_HI 0x420E2C44
#define IG3_TMGR_GLPE_TMGR_CLIENTREQ_HI_CLIENTREQ_HI_S 0
#define IG3_TMGR_GLPE_TMGR_CLIENTREQ_HI_CLIENTREQ_HI GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_CLIENTREQ_LO 0x420E2C40
#define IG3_TMGR_GLPE_TMGR_CLIENTREQ_LO_CLIENTREQ_LO_S 0
#define IG3_TMGR_GLPE_TMGR_CLIENTREQ_LO_CLIENTREQ_LO GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_CLIENTRESP_HI 0x420E2C4C
#define IG3_TMGR_GLPE_TMGR_CLIENTRESP_HI_CLIENTRESP_HI_S 0
#define IG3_TMGR_GLPE_TMGR_CLIENTRESP_HI_CLIENTRESP_HI GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_CLIENTRESP_LO 0x420E2C48
#define IG3_TMGR_GLPE_TMGR_CLIENTRESP_LO_CLIENTRESP_LO_S 0
#define IG3_TMGR_GLPE_TMGR_CLIENTRESP_LO_CLIENTRESP_LO GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_CMSNOOPMISS_HI 0x420E2C64
#define IG3_TMGR_GLPE_TMGR_CMSNOOPMISS_HI_CMSNOOPMISS_HI_S 0
#define IG3_TMGR_GLPE_TMGR_CMSNOOPMISS_HI_CMSNOOPMISS_HI GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_CMSNOOPMISS_LO 0x420E2C60
#define IG3_TMGR_GLPE_TMGR_CMSNOOPMISS_LO_CMSNOOPMISS_LOW_S 0
#define IG3_TMGR_GLPE_TMGR_CMSNOOPMISS_LO_CMSNOOPMISS_LOW GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_CMSNOOPREQ_HI 0x420E2C54
#define IG3_TMGR_GLPE_TMGR_CMSNOOPREQ_HI_CMSNOOPREQ_HI_S 0
#define IG3_TMGR_GLPE_TMGR_CMSNOOPREQ_HI_CMSNOOPREQ_HI GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_CMSNOOPREQ_LO 0x420E2C50
#define IG3_TMGR_GLPE_TMGR_CMSNOOPREQ_LO_CMSNOOPREQ_LO_S 0
#define IG3_TMGR_GLPE_TMGR_CMSNOOPREQ_LO_CMSNOOPREQ_LO GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_CMSNOOPRESP_HI 0x420E2C5C
#define IG3_TMGR_GLPE_TMGR_CMSNOOPRESP_HI_CMSNOOPRESP_HI_S 0
#define IG3_TMGR_GLPE_TMGR_CMSNOOPRESP_HI_CMSNOOPRESP_HI GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_CMSNOOPRESP_LO 0x420E2C58
#define IG3_TMGR_GLPE_TMGR_CMSNOOPRESP_LO_CMSNOOPRESP_LO_S 0
#define IG3_TMGR_GLPE_TMGR_CMSNOOPRESP_LO_CMSNOOPRESP_LO GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_COALESCE_HI 0x420E2C3C
#define IG3_TMGR_GLPE_TMGR_COALESCE_HI_COALESCE_HI_S 0
#define IG3_TMGR_GLPE_TMGR_COALESCE_HI_COALESCE_HI GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_COALESCE_LO 0x420E2C38
#define IG3_TMGR_GLPE_TMGR_COALESCE_LO_COALESCE_LO_S 0
#define IG3_TMGR_GLPE_TMGR_COALESCE_LO_COALESCE_LO GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_CONFIG(_i) (0x420E2C04 + ((_i) * 4)) /* _i=0...4 */
#define IG3_TMGR_GLPE_TMGR_CONFIG_MAX_INDEX_I 4
#define IG3_TMGR_GLPE_TMGR_CONFIG_RSVD2_S 25
#define IG3_TMGR_GLPE_TMGR_CONFIG_RSVD2 GENMASK_ULL(25, 31)
#define IG3_TMGR_GLPE_TMGR_CONFIG_NUM_AVAIL_OFFSET_S 16
#define IG3_TMGR_GLPE_TMGR_CONFIG_NUM_AVAIL_OFFSET GENMASK_ULL(16, 24)
#define IG3_TMGR_GLPE_TMGR_CONFIG_RSVD1_S 10
#define IG3_TMGR_GLPE_TMGR_CONFIG_RSVD1 GENMASK_ULL(10, 15)
#define IG3_TMGR_GLPE_TMGR_CONFIG_SEL_MODE_S 8
#define IG3_TMGR_GLPE_TMGR_CONFIG_SEL_MODE GENMASK_ULL(8, 9)
#define IG3_TMGR_GLPE_TMGR_CONFIG_RSVD0_S 5
#define IG3_TMGR_GLPE_TMGR_CONFIG_RSVD0 GENMASK_ULL(5, 7)
#define IG3_TMGR_GLPE_TMGR_CONFIG_TILE_ASSIGNMENT_S 0
#define IG3_TMGR_GLPE_TMGR_CONFIG_TILE_ASSIGNMENT GENMASK_ULL(0, 4)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATS_CTL 0x420E2C2C
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATS_CTL_DEBUG_MODE_S 16
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATS_CTL_DEBUG_MODE GENMASK_ULL(16, 31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATS_CTL_DEBUG_VALUE_S 4
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATS_CTL_DEBUG_VALUE GENMASK_ULL(4, 15)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATS_CTL_SW_RESET_S 3
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATS_CTL_SW_RESET_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATS_CTL_ENABLE_STATS_S 2
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATS_CTL_ENABLE_STATS_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATS_CTL_CLEAR_STATS_S 1
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATS_CTL_CLEAR_STATS_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATS_CTL_STOP_CLIENT_IF_S 0
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATS_CTL_STOP_CLIENT_IF_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1 0x420E2C30
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_RSVD1_S 31
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_RSVD1_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_ORD_FIFO_DOUT_CLIENT_ID_S 27
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_ORD_FIFO_DOUT_CLIENT_ID GENMASK_ULL(27, 30)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_PKT_CNT_COMPLETE_WR_ERR_S 26
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_PKT_CNT_COMPLETE_WR_ERR_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_ORD_FIFO_OVERFLOW_S 25
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_ORD_FIFO_OVERFLOW_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_ORD_FIFO_UNDERFLOW_S 24
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_ORD_FIFO_UNDERFLOW_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_ORD_FIFO_FULL_SPACE_S 18
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_ORD_FIFO_FULL_SPACE GENMASK_ULL(18, 23)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_PKT_CNT_PENDING_WR_ERR_S 17
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_PKT_CNT_PENDING_WR_ERR_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_REQ_FIFO_OVERFLOW_S 16
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_REQ_FIFO_OVERFLOW_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_REQ_FIFO_UNDERFLOW_S 15
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_REQ_FIFO_UNDERFLOW_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_REQ_FIFO_FULL_SPACE_S 9
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_REQ_FIFO_FULL_SPACE GENMASK_ULL(9, 14)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_PKT_CNT_OUTSTANDING_WR_ERR_S 8
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_PKT_CNT_OUTSTANDING_WR_ERR_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_OUT_FIFO_OVERFLOW_S 7
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_OUT_FIFO_OVERFLOW_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_OUT_FIFO_UNDERFLOW_S 6
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_OUT_FIFO_UNDERFLOW_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_OUT_FIFO_FULL_SPACE_S 0
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS1_CSR_OUT_FIFO_FULL_SPACE GENMASK_ULL(0, 5)
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS2 0x420E2C34
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS2_TMGR_DEBUG_STATUS2_S 0
#define IG3_TMGR_GLPE_TMGR_DEBUG_STATUS2_TMGR_DEBUG_STATUS2 GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_COUNT 0x420E2CB8
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_CMD 0x420E2CCC
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_DATA_H 0x420E2CD8
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_DATA_L 0x420E2CD4
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_PTR 0x420E2CD0
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_CMD 0x420E2CBC
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_DATA_H 0x420E2CC8
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_DATA_L 0x420E2CC4
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_PTR 0x420E2CC0
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL 0x420E2C80
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_RSVD1_S 25
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_RSVD2_S 17
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_RSVD3_S 9
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_BYPASS_S 8
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_RSVD4_S 1
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_ECC_COR_ERR 0x420E2CE8
#define IG3_TMGR_GLPE_TMGR_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_TMGR_GLPE_TMGR_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_TMGR_GLPE_TMGR_DTM_ECC_UNCOR_ERR 0x420E2CE4
#define IG3_TMGR_GLPE_TMGR_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_TMGR_GLPE_TMGR_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_TMGR_GLPE_TMGR_DTM_GROUP_CFG 0x420E2C8C
#define IG3_TMGR_GLPE_TMGR_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_TMGR_GLPE_TMGR_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_TMGR_GLPE_TMGR_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_TMGR_GLPE_TMGR_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_TMGR_GLPE_TMGR_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_TMGR_GLPE_TMGR_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_TMGR_GLPE_TMGR_DTM_LOG_CFG 0x420E2C90
#define IG3_TMGR_GLPE_TMGR_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_TMGR_GLPE_TMGR_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_LOG_CFG_RSVD1_S 2
#define IG3_TMGR_GLPE_TMGR_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_TMGR_GLPE_TMGR_DTM_LOG_CFG_MODE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_TMGR_GLPE_TMGR_DTM_LOG_MASK 0x420E2C98
#define IG3_TMGR_GLPE_TMGR_DTM_LOG_MASK_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_LOG_PATTERN 0x420E2C94
#define IG3_TMGR_GLPE_TMGR_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_CFG 0x420E2C84
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_STS 0x420E2C88
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_STS_RSVD1_S 9
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_STS_RSVD2_S 1
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TIMESTAMP 0x420E2CB0
#define IG3_TMGR_GLPE_TMGR_DTM_TIMESTAMP_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_TIMESTAMP_ROLLOVER 0x420E2CB4
#define IG3_TMGR_GLPE_TMGR_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG 0x420E2CDC
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS 0x420E2CE0
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_CFG 0x420E2C9C
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_CFG_MODE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_COUNT 0x420E2CA8
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_MASK 0x420E2CA4
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_MASK_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_PATTERN 0x420E2CA0
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_TIMESTAMP 0x420E2CAC
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_TMGR_GLPE_TMGR_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_TMGR_GLPE_TMGR_SELECTION 0x420E2C00
#define IG3_TMGR_GLPE_TMGR_SELECTION_RSVD1_S 3
#define IG3_TMGR_GLPE_TMGR_SELECTION_RSVD1 GENMASK_ULL(3, 31)
#define IG3_TMGR_GLPE_TMGR_SELECTION_TILE_ASSIGNMENT_S 0
#define IG3_TMGR_GLPE_TMGR_SELECTION_TILE_ASSIGNMENT GENMASK_ULL(0, 2)
#define IG3_TMGR_GLPE_TMGR_STATUS(_i) (0x420E2C18 + ((_i) * 4)) /* _i=0...4 */
#define IG3_TMGR_GLPE_TMGR_STATUS_MAX_INDEX_I 4
#define IG3_TMGR_GLPE_TMGR_STATUS_RSVD_S 16
#define IG3_TMGR_GLPE_TMGR_STATUS_RSVD GENMASK_ULL(16, 31)
#define IG3_TMGR_GLPE_TMGR_STATUS_NUM_CACHELINE_S 0
#define IG3_TMGR_GLPE_TMGR_STATUS_NUM_CACHELINE GENMASK_ULL(0, 15)
#define IG3_SQCE_GLPE_SQCE_CONFIG 0x420E3070
#define IG3_SQCE_GLPE_SQCE_CONFIG_RSVD_S 3
#define IG3_SQCE_GLPE_SQCE_CONFIG_RSVD GENMASK_ULL(3, 31)
#define IG3_SQCE_GLPE_SQCE_CONFIG_CRT_XMIT_RAM_EN_S 2
#define IG3_SQCE_GLPE_SQCE_CONFIG_CRT_XMIT_RAM_EN_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_CONFIG_DBL_DIS_S 1
#define IG3_SQCE_GLPE_SQCE_CONFIG_DBL_DIS_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_CONFIG_COALESCE_DIS_S 0
#define IG3_SQCE_GLPE_SQCE_CONFIG_COALESCE_DIS_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_COUNT 0x420E30B8
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_CMD 0x420E30CC
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_DATA_H 0x420E30D8
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_DATA_L 0x420E30D4
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_PTR 0x420E30D0
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_CMD 0x420E30BC
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_DATA_H 0x420E30C8
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_DATA_L 0x420E30C4
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_PTR 0x420E30C0
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL 0x420E3080
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_RSVD1_S 25
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_RSVD2_S 17
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_RSVD3_S 9
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_BYPASS_S 8
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_RSVD4_S 1
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_ECC_COR_ERR 0x420E30E8
#define IG3_SQCE_GLPE_SQCE_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_SQCE_GLPE_SQCE_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_SQCE_GLPE_SQCE_DTM_ECC_UNCOR_ERR 0x420E30E4
#define IG3_SQCE_GLPE_SQCE_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_SQCE_GLPE_SQCE_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_SQCE_GLPE_SQCE_DTM_GROUP_CFG 0x420E308C
#define IG3_SQCE_GLPE_SQCE_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_SQCE_GLPE_SQCE_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_SQCE_GLPE_SQCE_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_SQCE_GLPE_SQCE_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_SQCE_GLPE_SQCE_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_SQCE_GLPE_SQCE_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_SQCE_GLPE_SQCE_DTM_LOG_CFG 0x420E3090
#define IG3_SQCE_GLPE_SQCE_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_SQCE_GLPE_SQCE_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_LOG_CFG_RSVD1_S 2
#define IG3_SQCE_GLPE_SQCE_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_SQCE_GLPE_SQCE_DTM_LOG_CFG_MODE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_SQCE_GLPE_SQCE_DTM_LOG_MASK 0x420E3098
#define IG3_SQCE_GLPE_SQCE_DTM_LOG_MASK_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_LOG_PATTERN 0x420E3094
#define IG3_SQCE_GLPE_SQCE_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_CFG 0x420E3084
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_STS 0x420E3088
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_STS_RSVD1_S 9
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_STS_RSVD2_S 1
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TIMESTAMP 0x420E30B0
#define IG3_SQCE_GLPE_SQCE_DTM_TIMESTAMP_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_TIMESTAMP_ROLLOVER 0x420E30B4
#define IG3_SQCE_GLPE_SQCE_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG 0x420E30DC
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS 0x420E30E0
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_CFG 0x420E309C
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_CFG_MODE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_COUNT 0x420E30A8
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_MASK 0x420E30A4
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_MASK_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_PATTERN 0x420E30A0
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_TIMESTAMP 0x420E30AC
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_SQCE_GLPE_SQCE_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_SQCE_GLPE_SQCE_FWFLRDROP(_i) (0x420E3040 + ((_i) * 4)) /* _i=0...7 */
#define IG3_SQCE_GLPE_SQCE_FWFLRDROP_MAX_INDEX_I 7
#define IG3_SQCE_GLPE_SQCE_FWFLRDROP_EN_S 31
#define IG3_SQCE_GLPE_SQCE_FWFLRDROP_EN_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_FWFLRDROP_RSVD0_S 12
#define IG3_SQCE_GLPE_SQCE_FWFLRDROP_RSVD0 GENMASK_ULL(12, 30)
#define IG3_SQCE_GLPE_SQCE_FWFLRDROP_PMF_S 0
#define IG3_SQCE_GLPE_SQCE_FWFLRDROP_PMF GENMASK_ULL(0, 11)
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHHI 0x420E3060
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHHI_RSVD0_S 26
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHHI_RSVD0 GENMASK_ULL(26, 31)
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHHI_QPID_S 6
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHHI_QPID GENMASK_ULL(6, 25)
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHHI_PF_NUM_S 0
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHHI_PF_NUM GENMASK_ULL(0, 5)
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO 0x420E3064
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO_BUSY_S 31
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO_BUSY_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO_REQ_TYPE_S 30
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO_REQ_TYPE_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO_RSVD0_S 29
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO_RSVD0_M BIT_ULL(31)
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO_HOSTID_S 26
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO_HOSTID GENMASK_ULL(26, 28)
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO_VM_VF_TYPE_S 24
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO_VM_VF_TYPE GENMASK_ULL(24, 25)
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO_VM_VF_NUM_S 12
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO_VM_VF_NUM GENMASK_ULL(12, 23)
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO_PMF_S 0
#define IG3_SQCE_GLPE_SQCE_FWFLRQPFLUSHLO_PMF GENMASK_ULL(0, 11)
#define IG3_SQCE_GLPE_SQCE_FWSYNCRESP(_i) (0x420E3068 + ((_i) * 4)) /* _i=0...1 */
#define IG3_SQCE_GLPE_SQCE_FWSYNCRESP_MAX_INDEX_I 1
#define IG3_SQCE_GLPE_SQCE_FWSYNCRESP_RSVD_S 18
#define IG3_SQCE_GLPE_SQCE_FWSYNCRESP_RSVD GENMASK_ULL(18, 31)
#define IG3_SQCE_GLPE_SQCE_FWSYNCRESP_COUNT_S 8
#define IG3_SQCE_GLPE_SQCE_FWSYNCRESP_COUNT GENMASK_ULL(8, 17)
#define IG3_SQCE_GLPE_SQCE_FWSYNCRESP_TAG_S 0
#define IG3_SQCE_GLPE_SQCE_FWSYNCRESP_TAG GENMASK_ULL(0, 7)
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPHI(_i) (0x420E3020 + ((_i) * 4)) /* _i=0...7 */
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPHI_MAX_INDEX_I 7
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPHI_RSVD0_S 26
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPHI_RSVD0 GENMASK_ULL(26, 31)
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPHI_QPID_S 6
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPHI_QPID GENMASK_ULL(6, 25)
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPHI_PF_NUM_S 0
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPHI_PF_NUM GENMASK_ULL(0, 5)
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPLO(_i) (0x420E3000 + ((_i) * 4)) /* _i=0...7 */
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPLO_MAX_INDEX_I 7
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPLO_EN_S 31
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPLO_EN_M BIT_ULL(31)
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPLO_RSVD0_S 29
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPLO_RSVD0 GENMASK_ULL(29, 30)
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPLO_HOSTID_S 26
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPLO_HOSTID GENMASK_ULL(26, 28)
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPLO_VM_VF_TYPE_S 24
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPLO_VM_VF_TYPE GENMASK_ULL(24, 25)
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPLO_VM_VF_NUM_S 12
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPLO_VM_VF_NUM GENMASK_ULL(12, 23)
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPLO_PMF_S 0
#define IG3_SQCE_GPLE_SQCE_FWFLUSHDROPLO_PMF GENMASK_ULL(0, 11)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG 0x420E3100
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_ECC_INST_NUM_S 25
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_RSVD3_S 20
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_RM_S 16
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_RM GENMASK_ULL(16, 19)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_RSVD2_S 14
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_POWER_GATE_EN_S 13
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_RME_S 12
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_RME_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_RSVD1_S 10
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_ERR_CNT_S 9
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_FIX_CNT_S 8
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_RSVD0_S 6
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_MASK_INT_S 5
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_LS_BYPASS_S 4
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_LS_FORCE_S 3
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_ECC_INVERT_2_S 2
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_ECC_INVERT_1_S 1
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_ECC_EN_S 0
#define IG3_SQCE_SQCE_CRTBUF_PTR_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS 0x420E3104
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS_RSVD1_S 30
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS_RSVD0_S 4
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS_INIT_DONE_S 2
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS_ECC_FIX_S 1
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS_ECC_ERR_S 0
#define IG3_SQCE_SQCE_CRTBUF_PTR_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG 0x420E3108
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_ECC_INST_NUM_S 25
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_RSVD3_S 20
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_RM_S 16
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_RSVD2_S 14
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_POWER_GATE_EN_S 13
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_RME_S 12
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_RME_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_RSVD1_S 10
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_ERR_CNT_S 9
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_FIX_CNT_S 8
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_RSVD0_S 6
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_MASK_INT_S 5
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_LS_BYPASS_S 4
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_LS_FORCE_S 3
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_ECC_INVERT_2_S 2
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_ECC_INVERT_1_S 1
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_ECC_EN_S 0
#define IG3_SQCE_SQCE_CRTBUF_RAM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS 0x420E310C
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS_RSVD1_S 30
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS_RSVD0_S 4
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS_INIT_DONE_S 2
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS_ECC_FIX_S 1
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS_ECC_ERR_S 0
#define IG3_SQCE_SQCE_CRTBUF_RAM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_SQCE_SQCE_ECC_COR_ERR 0x420E311C
#define IG3_SQCE_SQCE_ECC_COR_ERR_RSVD_S 12
#define IG3_SQCE_SQCE_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_SQCE_SQCE_ECC_COR_ERR_CNT_S 0
#define IG3_SQCE_SQCE_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_SQCE_SQCE_ECC_UNCOR_ERR 0x420E3118
#define IG3_SQCE_SQCE_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_SQCE_SQCE_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_SQCE_SQCE_ECC_UNCOR_ERR_CNT_S 0
#define IG3_SQCE_SQCE_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG 0x420E3110
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_ECC_INST_NUM_S 25
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_RSVD3_S 20
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_RM_S 16
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_RSVD2_S 14
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_POWER_GATE_EN_S 13
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_RME_S 12
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_RME_M BIT_ULL(31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_RSVD1_S 10
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_ERR_CNT_S 9
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_FIX_CNT_S 8
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_RSVD0_S 6
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_MASK_INT_S 5
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_LS_BYPASS_S 4
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_LS_FORCE_S 3
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_ECC_INVERT_2_S 2
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_ECC_INVERT_1_S 1
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_ECC_EN_S 0
#define IG3_SQCE_SQCE_SCN_DBL_RAM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS 0x420E3114
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS_RSVD1_S 30
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS_RSVD0_S 4
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS_INIT_DONE_S 2
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS_ECC_FIX_S 1
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS_ECC_ERR_S 0
#define IG3_SQCE_SQCE_SCN_DBL_RAM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0 0x420E3404
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_RSVD_S 26
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_RSVD GENMASK_ULL(26, 31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_CORE_FAT_ERR_S 25
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_CORE_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_STATS_FAT_ERR_S 24
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_STATS_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_CPUW_FAT_ERR_S 23
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_CPUW_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_TX4_FAT_ERR_S 22
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_TX4_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_TX3_FAT_ERR_S 21
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_TX3_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_TX2_FAT_ERR_S 20
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_TX2_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_TX1_FAT_ERR_S 19
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_TX1_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_TX0_FAT_ERR_S 18
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_TX0_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_RX4_FAT_ERR_S 17
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_RX4_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_RX3_FAT_ERR_S 16
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_RX3_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_RX2_FAT_ERR_S 15
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_RX2_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_RX1_FAT_ERR_S 14
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_RX1_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_RX0_FAT_ERR_S 13
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_RX0_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_DRX4_FAT_ERR_S 12
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_DRX4_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_DRX3_FAT_ERR_S 11
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_DRX3_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_DRX2_FAT_ERR_S 10
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_DRX2_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_DRX1_FAT_ERR_S 9
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_DRX1_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_DRX0_FAT_ERR_S 8
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_DRX0_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_DBL_FAT_ERR_S 7
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_DBL_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_TOC_FAT_ERR_S 6
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_TOC_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_XOC_FAT_ERR_S 5
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_XOC_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_Q1OC_FAT_ERR_S 4
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_Q1OC_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_CQOC_FAT_ERR_S 3
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_CQOC_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_MROC_FAT_ERR_S 2
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_MROC_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_PBLOC1_FAT_ERR_S 1
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_PBLOC1_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_PBLOC0_FAT_ERR_S 0
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR0_PBLOC0_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1 0x420E3408
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_RSVD_S 16
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_RSVD GENMASK_ULL(16, 31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_CPM4_FAT_ERR_S 15
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_CPM4_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_CPM3_FAT_ERR_S 14
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_CPM3_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_CPM2_FAT_ERR_S 13
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_CPM2_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_CPM1_FAT_ERR_S 12
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_CPM1_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_CPM0_FAT_ERR_S 11
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_CPM0_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_PMAT_FAT_ERR_S 10
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_PMAT_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_MSOC_FAT_ERR_S 9
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_MSOC_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_FLOC_FAT_ERR_S 8
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_FLOC_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_CRX_FAT_ERR_S 7
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_CRX_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_BRX_FAT_ERR_S 6
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_BRX_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_AMP_FAT_ERR_S 5
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_AMP_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_CQM_FAT_ERR_S 4
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_CQM_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_TSCD_FAT_ERR_S 3
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_TSCD_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_RMI1_FAT_ERR_S 2
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_RMI1_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_RMI0_FAT_ERR_S 1
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_RMI0_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_RHI_FAT_ERR_S 0
#define IG3_STOP_SCREAM_RDMA_FATAL_ECR1_RHI_FAT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0 0x420E340C
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_RSVD_S 26
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_RSVD GENMASK_ULL(26, 31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_CORE_FAT_MSK_S 25
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_CORE_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_STATS_FAT_MSK_S 24
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_STATS_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_CPUW_FAT_MSK_S 23
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_CPUW_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_TX4_FAT_MSK_S 22
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_TX4_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_TX3_FAT_MSK_S 21
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_TX3_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_TX2_FAT_MSK_S 20
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_TX2_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_TX1_FAT_MSK_S 19
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_TX1_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_TX0_FAT_MSK_S 18
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_TX0_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_RX4_FAT_MSK_S 17
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_RX4_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_RX3_FAT_MSK_S 16
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_RX3_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_RX2_FAT_MSK_S 15
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_RX2_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_RX1_FAT_MSK_S 14
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_RX1_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_RX0_FAT_MSK_S 13
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_RX0_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_DRX4_FAT_MSK_S 12
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_DRX4_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_DRX3_FAT_MSK_S 11
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_DRX3_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_DRX2_FAT_MSK_S 10
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_DRX2_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_DRX1_FAT_MSK_S 9
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_DRX1_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_DRX0_FAT_MSK_S 8
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_DRX0_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_DBL_FAT_MSK_S 7
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_DBL_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_TOC_FAT_MSK_S 6
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_TOC_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_XOC_FAT_MSK_S 5
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_XOC_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_Q1OC_FAT_MSK_S 4
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_Q1OC_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_CQOC_FAT_MSK_S 3
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_CQOC_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_MROC_FAT_MSK_S 2
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_MROC_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_PBLOC1_FAT_MSK_S 1
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_PBLOC1_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_PBLOC0_FAT_MSK_S 0
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK0_PBLOC0_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1 0x420E3410
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_RSVD_S 16
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_RSVD GENMASK_ULL(16, 31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_CPM4_FAT_MSK_S 15
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_CPM4_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_CPM3_FAT_MSK_S 14
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_CPM3_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_CPM2_FAT_MSK_S 13
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_CPM2_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_CPM1_FAT_MSK_S 12
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_CPM1_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_CPM0_FAT_MSK_S 11
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_CPM0_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_PMAT_FAT_MSK_S 10
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_PMAT_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_MSOC_FAT_MSK_S 9
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_MSOC_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_FLOC_FAT_MSK_S 8
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_FLOC_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_CRX_FAT_MSK_S 7
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_CRX_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_BRX_FAT_MSK_S 6
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_BRX_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_AMP_FAT_MSK_S 5
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_AMP_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_CQM_FAT_MSK_S 4
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_CQM_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_TSCD_FAT_MSK_S 3
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_TSCD_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_RMI1_FAT_MSK_S 2
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_RMI1_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_RMI0_FAT_MSK_S 1
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_RMI0_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_RHI_FAT_MSK_S 0
#define IG3_STOP_SCREAM_RDMA_FATAL_MSK1_RHI_FAT_MSK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR0 0x420E341C
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR0_RSVD_S 17
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR0_RSVD GENMASK_ULL(17, 31)
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR0_PECRIT_ERR_S 16
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR0_PECRIT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR0_HMC_ERR_S 0
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR0_HMC_ERR GENMASK_ULL(0, 15)
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR1 0x420E3420
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR1_UNCORR_ERR_S 31
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR1_UNCORR_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR1_RSVD_S 16
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR1_RSVD GENMASK_ULL(16, 30)
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR1_CMPE_CRC_ERR_S 0
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR1_CMPE_CRC_ERR GENMASK_ULL(0, 15)
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR_MSK0 0x420E342C
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR_MSK0_RSVD_S 17
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR_MSK0_RSVD GENMASK_ULL(17, 31)
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR_MSK0_PECRIT_ERR_MASK_S 16
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR_MSK0_PECRIT_ERR_MASK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR_MSK0_HMC_ERR_MASK_S 0
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR_MSK0_HMC_ERR_MASK GENMASK_ULL(0, 15)
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR_MSK1 0x420E3430
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR_MSK1_UNCORR_ERR_MASK_S 31
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR_MSK1_UNCORR_ERR_MASK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR_MSK1_RSVD_S 16
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR_MSK1_RSVD GENMASK_ULL(16, 30)
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR_MSK1_CMPE_CRC_ERR_MASK_S 0
#define IG3_STOP_SCREAM_RDMA_INT_ARES_ICR_MSK1_CMPE_CRC_ERR_MASK GENMASK_ULL(0, 15)
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR0 0x420E3414
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR0_RSVD_S 17
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR0_RSVD GENMASK_ULL(17, 31)
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR0_PECRIT_ERR_S 16
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR0_PECRIT_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR0_HMC_ERR_S 0
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR0_HMC_ERR GENMASK_ULL(0, 15)
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR1 0x420E3418
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR1_UNCORR_ERR_S 31
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR1_UNCORR_ERR_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR1_IMC_FW_REQ_S 30
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR1_IMC_FW_REQ_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR1_RSVD_S 16
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR1_RSVD GENMASK_ULL(16, 29)
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR1_CMPE_CRC_ERR_S 0
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR1_CMPE_CRC_ERR GENMASK_ULL(0, 15)
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK0 0x420E3424
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK0_RSVD_S 17
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK0_RSVD GENMASK_ULL(17, 31)
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK0_PECRIT_ERR_MASK_S 16
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK0_PECRIT_ERR_MASK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK0_HMC_ERR_MASK_S 0
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK0_HMC_ERR_MASK GENMASK_ULL(0, 15)
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK1 0x420E3428
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK1_UNCORR_ERR_MASK_S 31
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK1_UNCORR_ERR_MASK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK1_IMC_FW_REQ_MASK_S 30
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK1_IMC_FW_REQ_MASK_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK1_RSVD_S 16
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK1_RSVD GENMASK_ULL(16, 29)
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK1_CMPE_CRC_ERR_MASK_S 0
#define IG3_STOP_SCREAM_RDMA_INT_IMC_ICR_MSK1_CMPE_CRC_ERR_MASK GENMASK_ULL(0, 15)
#define IG3_STOP_SCREAM_RDMA_STOP_SCREAM_RAS 0x420E3400
#define IG3_STOP_SCREAM_RDMA_STOP_SCREAM_RAS_RSVD_S 3
#define IG3_STOP_SCREAM_RDMA_STOP_SCREAM_RAS_RSVD GENMASK_ULL(3, 31)
#define IG3_STOP_SCREAM_RDMA_STOP_SCREAM_RAS_DISABLE_S 2
#define IG3_STOP_SCREAM_RDMA_STOP_SCREAM_RAS_DISABLE_M BIT_ULL(31)
#define IG3_STOP_SCREAM_RDMA_STOP_SCREAM_RAS_STOP_SCREAM_STAT_S 0
#define IG3_STOP_SCREAM_RDMA_STOP_SCREAM_RAS_STOP_SCREAM_STAT GENMASK_ULL(0, 1)
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_COUNT 0x420E4038
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_CMD 0x420E404C
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_DATA_H 0x420E4058
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_DATA_L 0x420E4054
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_PTR 0x420E4050
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_CMD 0x420E403C
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_DATA_H 0x420E4048
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_DATA_L 0x420E4044
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_PTR 0x420E4040
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_RHA_GLPE_RHA_DTM_CONTROL 0x420E4000
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_RSVD1_S 25
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_RSVD2_S 17
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_RSVD3_S 9
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_BYPASS_S 8
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_RSVD4_S 1
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_RHA_GLPE_RHA_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_ECC_COR_ERR 0x420E4068
#define IG3_RHA_GLPE_RHA_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_RHA_GLPE_RHA_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_RHA_GLPE_RHA_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_RHA_GLPE_RHA_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_RHA_GLPE_RHA_DTM_ECC_UNCOR_ERR 0x420E4064
#define IG3_RHA_GLPE_RHA_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_RHA_GLPE_RHA_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_RHA_GLPE_RHA_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_RHA_GLPE_RHA_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_RHA_GLPE_RHA_DTM_GROUP_CFG 0x420E400C
#define IG3_RHA_GLPE_RHA_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_RHA_GLPE_RHA_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_RHA_GLPE_RHA_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_RHA_GLPE_RHA_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_RHA_GLPE_RHA_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_RHA_GLPE_RHA_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_RHA_GLPE_RHA_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_RHA_GLPE_RHA_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_RHA_GLPE_RHA_DTM_LOG_CFG 0x420E4010
#define IG3_RHA_GLPE_RHA_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_RHA_GLPE_RHA_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_RHA_GLPE_RHA_DTM_LOG_CFG_RSVD1_S 2
#define IG3_RHA_GLPE_RHA_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_RHA_GLPE_RHA_DTM_LOG_CFG_MODE_S 0
#define IG3_RHA_GLPE_RHA_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_RHA_GLPE_RHA_DTM_LOG_MASK 0x420E4018
#define IG3_RHA_GLPE_RHA_DTM_LOG_MASK_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_RHA_GLPE_RHA_DTM_LOG_PATTERN 0x420E4014
#define IG3_RHA_GLPE_RHA_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_RHA_GLPE_RHA_DTM_MAIN_CFG 0x420E4004
#define IG3_RHA_GLPE_RHA_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_RHA_GLPE_RHA_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_RHA_GLPE_RHA_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_RHA_GLPE_RHA_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_RHA_GLPE_RHA_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_RHA_GLPE_RHA_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_RHA_GLPE_RHA_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_RHA_GLPE_RHA_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_RHA_GLPE_RHA_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_RHA_GLPE_RHA_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_RHA_GLPE_RHA_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_MAIN_STS 0x420E4008
#define IG3_RHA_GLPE_RHA_DTM_MAIN_STS_RSVD1_S 9
#define IG3_RHA_GLPE_RHA_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_RHA_GLPE_RHA_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_RHA_GLPE_RHA_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_MAIN_STS_RSVD2_S 1
#define IG3_RHA_GLPE_RHA_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_RHA_GLPE_RHA_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_RHA_GLPE_RHA_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TIMESTAMP 0x420E4030
#define IG3_RHA_GLPE_RHA_DTM_TIMESTAMP_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_RHA_GLPE_RHA_DTM_TIMESTAMP_ROLLOVER 0x420E4034
#define IG3_RHA_GLPE_RHA_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG 0x420E405C
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS 0x420E4060
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_RHA_GLPE_RHA_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_RHA_GLPE_RHA_DTM_TRIG_CFG 0x420E401C
#define IG3_RHA_GLPE_RHA_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_RHA_GLPE_RHA_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_RHA_GLPE_RHA_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_RHA_GLPE_RHA_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_RHA_GLPE_RHA_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_RHA_GLPE_RHA_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_RHA_GLPE_RHA_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_RHA_GLPE_RHA_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_RHA_GLPE_RHA_DTM_TRIG_CFG_MODE_S 0
#define IG3_RHA_GLPE_RHA_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_RHA_GLPE_RHA_DTM_TRIG_COUNT 0x420E4028
#define IG3_RHA_GLPE_RHA_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_RHA_GLPE_RHA_DTM_TRIG_MASK 0x420E4024
#define IG3_RHA_GLPE_RHA_DTM_TRIG_MASK_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_RHA_GLPE_RHA_DTM_TRIG_PATTERN 0x420E4020
#define IG3_RHA_GLPE_RHA_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_RHA_GLPE_RHA_DTM_TRIG_TIMESTAMP 0x420E402C
#define IG3_RHA_GLPE_RHA_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_RHA_GLPE_RHA_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG 0x420E4400
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS 0x420E4404
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_CPAL_ENTRY_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG 0x420E4408
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS 0x420E440C
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_CPAL_LEAFOBJ_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG 0x420E4410
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS 0x420E4414
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_CPAL_PADDROBJ_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG 0x420E4418
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS 0x420E441C
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_DPAL_ENTRY_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG 0x420E4420
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS 0x420E4424
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_DPAL_LEAFOBJ_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG 0x420E4428
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS 0x420E442C
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_DPAL_PADDROBJ_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PAL_ECC_COR_ERR 0x420E4434
#define IG3_CORE_SHCTL_GLPE_PAL_ECC_COR_ERR_RSVD_S 12
#define IG3_CORE_SHCTL_GLPE_PAL_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_SHCTL_GLPE_PAL_ECC_COR_ERR_CNT_S 0
#define IG3_CORE_SHCTL_GLPE_PAL_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CORE_SHCTL_GLPE_PAL_ECC_UNCOR_ERR 0x420E4430
#define IG3_CORE_SHCTL_GLPE_PAL_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_CORE_SHCTL_GLPE_PAL_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_SHCTL_GLPE_PAL_ECC_UNCOR_ERR_CNT_S 0
#define IG3_CORE_SHCTL_GLPE_PAL_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG 0x420E4518
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS 0x420E451C
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_PMF_CNTR_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PTXI_ECC_COR_ERR 0x420E4524
#define IG3_CORE_SHCTL_GLPE_PTXI_ECC_COR_ERR_RSVD_S 12
#define IG3_CORE_SHCTL_GLPE_PTXI_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_SHCTL_GLPE_PTXI_ECC_COR_ERR_CNT_S 0
#define IG3_CORE_SHCTL_GLPE_PTXI_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CORE_SHCTL_GLPE_PTXI_ECC_UNCOR_ERR 0x420E4520
#define IG3_CORE_SHCTL_GLPE_PTXI_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_CORE_SHCTL_GLPE_PTXI_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_SHCTL_GLPE_PTXI_ECC_UNCOR_ERR_CNT_S 0
#define IG3_CORE_SHCTL_GLPE_PTXI_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG 0x420E4510
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS 0x420E4514
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_PTX_CSR_RAM_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_ECC_COR_ERR 0x420E450C
#define IG3_CORE_SHCTL_GLPE_RLC_ECC_COR_ERR_RSVD_S 12
#define IG3_CORE_SHCTL_GLPE_RLC_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_SHCTL_GLPE_RLC_ECC_COR_ERR_CNT_S 0
#define IG3_CORE_SHCTL_GLPE_RLC_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CORE_SHCTL_GLPE_RLC_ECC_UNCOR_ERR 0x420E4508
#define IG3_CORE_SHCTL_GLPE_RLC_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_CORE_SHCTL_GLPE_RLC_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_SHCTL_GLPE_RLC_ECC_UNCOR_ERR_CNT_S 0
#define IG3_CORE_SHCTL_GLPE_RLC_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG 0x420E44D8
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS 0x420E44DC
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG 0x420E44E0
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS 0x420E44E4
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST0_1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG 0x420E44F0
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS 0x420E44F4
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG 0x420E44F8
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS 0x420E44FC
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_RLC_RDYLIST1_1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG 0x420E44E8
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS 0x420E44EC
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG 0x420E4500
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS 0x420E4504
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_RLC_TRIPLET1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG 0x420E44B0
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS 0x420E44B4
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG 0x420E44B8
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS 0x420E44BC
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG 0x420E44C0
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS 0x420E44C4
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_2_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG 0x420E44C8
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS 0x420E44CC
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CFG_3_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG 0x420E4450
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS 0x420E4454
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG 0x420E4458
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS 0x420E445C
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG 0x420E4460
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS 0x420E4464
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_2_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG 0x420E4468
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS 0x420E446C
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_CNT_3_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG 0x420E4470
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS 0x420E4474
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG 0x420E4478
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS 0x420E447C
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG 0x420E4480
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS 0x420E4484
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_2_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG 0x420E4488
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS 0x420E448C
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_DIV_3_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_ECC_COR_ERR 0x420E44D4
#define IG3_CORE_SHCTL_GLPE_TMR_ECC_COR_ERR_RSVD_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_ECC_COR_ERR_CNT_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_ECC_UNCOR_ERR 0x420E44D0
#define IG3_CORE_SHCTL_GLPE_TMR_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_ECC_UNCOR_ERR_CNT_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG 0x420E4490
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS 0x420E4494
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG 0x420E4498
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS 0x420E449C
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG 0x420E44A0
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS 0x420E44A4
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_2_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG 0x420E44A8
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS 0x420E44AC
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_NOW_3_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG 0x420E4448
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS 0x420E444C
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_BUCKET_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG 0x420E4438
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS 0x420E443C
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_SCN_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG 0x420E4440
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_RSVD3_S 20
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_RM_S 16
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_RSVD2_S 14
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_RME_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_RSVD1_S 10
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_ERR_CNT_S 9
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_FIX_CNT_S 8
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_RSVD0_S 6
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_MASK_INT_S 5
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_LS_BYPASS_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_LS_FORCE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_ECC_EN_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS 0x420E4444
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS_RSVD1_S 30
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS_RSVD0_S 4
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS_INIT_DONE_S 2
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS_ECC_FIX_S 1
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS_ECC_ERR_S 0
#define IG3_CORE_SHCTL_GLPE_TMR_UCB_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_APM_THRESHOLDS(_i) (0x42400028 + ((_i) * 4)) /* _i=0...4 */
#define IG3_AMP_GLPE_AMP_APM_THRESHOLDS_MAX_INDEX_I 4
#define IG3_AMP_GLPE_AMP_APM_THRESHOLDS_RSVD_S 24
#define IG3_AMP_GLPE_AMP_APM_THRESHOLDS_RSVD GENMASK_ULL(24, 31)
#define IG3_AMP_GLPE_AMP_APM_THRESHOLDS_PMAT_REQ_THRESHOLD_S 16
#define IG3_AMP_GLPE_AMP_APM_THRESHOLDS_PMAT_REQ_THRESHOLD GENMASK_ULL(16, 23)
#define IG3_AMP_GLPE_AMP_APM_THRESHOLDS_PBLOC_REQ_THRESHOLD_S 8
#define IG3_AMP_GLPE_AMP_APM_THRESHOLDS_PBLOC_REQ_THRESHOLD GENMASK_ULL(8, 15)
#define IG3_AMP_GLPE_AMP_APM_THRESHOLDS_MROC_REQ_THRESHOLD_S 0
#define IG3_AMP_GLPE_AMP_APM_THRESHOLDS_MROC_REQ_THRESHOLD GENMASK_ULL(0, 7)
#define IG3_AMP_GLPE_AMP_CFG 0x42400004
#define IG3_AMP_GLPE_AMP_CFG_RSVD_S 1
#define IG3_AMP_GLPE_AMP_CFG_RSVD GENMASK_ULL(1, 31)
#define IG3_AMP_GLPE_AMP_CFG_EN_TYPE_2B_MW_S 0
#define IG3_AMP_GLPE_AMP_CFG_EN_TYPE_2B_MW_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_CONSUMED_RESOURCES(_i) (0x4240003C + ((_i) * 4)) /* _i=0...4 */
#define IG3_AMP_GLPE_AMP_CONSUMED_RESOURCES_MAX_INDEX_I 4
#define IG3_AMP_GLPE_AMP_CONSUMED_RESOURCES_RSVD_S 24
#define IG3_AMP_GLPE_AMP_CONSUMED_RESOURCES_RSVD GENMASK_ULL(24, 31)
#define IG3_AMP_GLPE_AMP_CONSUMED_RESOURCES_PMAT_CNT_S 16
#define IG3_AMP_GLPE_AMP_CONSUMED_RESOURCES_PMAT_CNT GENMASK_ULL(16, 23)
#define IG3_AMP_GLPE_AMP_CONSUMED_RESOURCES_PBLOC_CNT_S 8
#define IG3_AMP_GLPE_AMP_CONSUMED_RESOURCES_PBLOC_CNT GENMASK_ULL(8, 15)
#define IG3_AMP_GLPE_AMP_CONSUMED_RESOURCES_MROC_CNT_S 0
#define IG3_AMP_GLPE_AMP_CONSUMED_RESOURCES_MROC_CNT GENMASK_ULL(0, 7)
#define IG3_AMP_GLPE_AMP_DBG_CFG(_i) (0x42400008 + ((_i) * 4)) /* _i=0...4 */
#define IG3_AMP_GLPE_AMP_DBG_CFG_MAX_INDEX_I 4
#define IG3_AMP_GLPE_AMP_DBG_CFG_RSVD2_S 23
#define IG3_AMP_GLPE_AMP_DBG_CFG_RSVD2 GENMASK_ULL(23, 31)
#define IG3_AMP_GLPE_AMP_DBG_CFG_DBG_CAM1_IDX_S 16
#define IG3_AMP_GLPE_AMP_DBG_CFG_DBG_CAM1_IDX GENMASK_ULL(16, 22)
#define IG3_AMP_GLPE_AMP_DBG_CFG_RSVD1_S 15
#define IG3_AMP_GLPE_AMP_DBG_CFG_RSVD1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DBG_CFG_DBG_CAM0_IDX_S 8
#define IG3_AMP_GLPE_AMP_DBG_CFG_DBG_CAM0_IDX GENMASK_ULL(8, 14)
#define IG3_AMP_GLPE_AMP_DBG_CFG_RSVD0_S 7
#define IG3_AMP_GLPE_AMP_DBG_CFG_RSVD0_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DBG_CFG_DBG_REQTAG_S 0
#define IG3_AMP_GLPE_AMP_DBG_CFG_DBG_REQTAG GENMASK_ULL(0, 6)
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_COUNT 0x42400138
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_CMD 0x4240014C
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_DATA_H 0x42400158
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_DATA_L 0x42400154
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_PTR 0x42400150
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_CMD 0x4240013C
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_DATA_H 0x42400148
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_DATA_L 0x42400144
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_PTR 0x42400140
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_AMP_GLPE_AMP_DTM_CFG 0x4240001C
#define IG3_AMP_GLPE_AMP_DTM_CFG_RSVD_S 3
#define IG3_AMP_GLPE_AMP_DTM_CFG_RSVD GENMASK_ULL(3, 31)
#define IG3_AMP_GLPE_AMP_DTM_CFG_AMP_ENG_SEL_S 0
#define IG3_AMP_GLPE_AMP_DTM_CFG_AMP_ENG_SEL GENMASK_ULL(0, 2)
#define IG3_AMP_GLPE_AMP_DTM_CONTROL 0x42400100
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_RSVD1_S 25
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_RSVD2_S 17
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_RSVD3_S 9
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_BYPASS_S 8
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_RSVD4_S 1
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_AMP_GLPE_AMP_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_ECC_COR_ERR 0x42400168
#define IG3_AMP_GLPE_AMP_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_AMP_GLPE_AMP_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_AMP_GLPE_AMP_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_AMP_GLPE_AMP_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_AMP_GLPE_AMP_DTM_ECC_UNCOR_ERR 0x42400164
#define IG3_AMP_GLPE_AMP_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_AMP_GLPE_AMP_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_AMP_GLPE_AMP_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_AMP_GLPE_AMP_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_AMP_GLPE_AMP_DTM_GROUP_CFG 0x4240010C
#define IG3_AMP_GLPE_AMP_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_AMP_GLPE_AMP_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_AMP_GLPE_AMP_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_AMP_GLPE_AMP_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_AMP_GLPE_AMP_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_AMP_GLPE_AMP_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_AMP_GLPE_AMP_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_AMP_GLPE_AMP_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_AMP_GLPE_AMP_DTM_LOG_CFG 0x42400110
#define IG3_AMP_GLPE_AMP_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_AMP_GLPE_AMP_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_AMP_GLPE_AMP_DTM_LOG_CFG_RSVD1_S 2
#define IG3_AMP_GLPE_AMP_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_AMP_GLPE_AMP_DTM_LOG_CFG_MODE_S 0
#define IG3_AMP_GLPE_AMP_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_AMP_GLPE_AMP_DTM_LOG_MASK 0x42400118
#define IG3_AMP_GLPE_AMP_DTM_LOG_MASK_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_AMP_GLPE_AMP_DTM_LOG_PATTERN 0x42400114
#define IG3_AMP_GLPE_AMP_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_AMP_GLPE_AMP_DTM_MAIN_CFG 0x42400104
#define IG3_AMP_GLPE_AMP_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_AMP_GLPE_AMP_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_AMP_GLPE_AMP_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_AMP_GLPE_AMP_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_AMP_GLPE_AMP_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_AMP_GLPE_AMP_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_AMP_GLPE_AMP_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_AMP_GLPE_AMP_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_AMP_GLPE_AMP_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_AMP_GLPE_AMP_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_AMP_GLPE_AMP_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_MAIN_STS 0x42400108
#define IG3_AMP_GLPE_AMP_DTM_MAIN_STS_RSVD1_S 9
#define IG3_AMP_GLPE_AMP_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_AMP_GLPE_AMP_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_AMP_GLPE_AMP_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_MAIN_STS_RSVD2_S 1
#define IG3_AMP_GLPE_AMP_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_AMP_GLPE_AMP_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_AMP_GLPE_AMP_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TIMESTAMP 0x42400130
#define IG3_AMP_GLPE_AMP_DTM_TIMESTAMP_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_AMP_GLPE_AMP_DTM_TIMESTAMP_ROLLOVER 0x42400134
#define IG3_AMP_GLPE_AMP_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG 0x4240015C
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS 0x42400160
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_DTM_TRIG_CFG 0x4240011C
#define IG3_AMP_GLPE_AMP_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_AMP_GLPE_AMP_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_AMP_GLPE_AMP_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_AMP_GLPE_AMP_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_AMP_GLPE_AMP_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_AMP_GLPE_AMP_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_AMP_GLPE_AMP_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_AMP_GLPE_AMP_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_AMP_GLPE_AMP_DTM_TRIG_CFG_MODE_S 0
#define IG3_AMP_GLPE_AMP_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_AMP_GLPE_AMP_DTM_TRIG_COUNT 0x42400128
#define IG3_AMP_GLPE_AMP_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_AMP_GLPE_AMP_DTM_TRIG_MASK 0x42400124
#define IG3_AMP_GLPE_AMP_DTM_TRIG_MASK_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_AMP_GLPE_AMP_DTM_TRIG_PATTERN 0x42400120
#define IG3_AMP_GLPE_AMP_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_AMP_GLPE_AMP_DTM_TRIG_TIMESTAMP 0x4240012C
#define IG3_AMP_GLPE_AMP_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_AMP_GLPE_AMP_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_AMP_GLPE_AMP_ECC_COR_ERR 0x424000D4
#define IG3_AMP_GLPE_AMP_ECC_COR_ERR_RSVD_S 12
#define IG3_AMP_GLPE_AMP_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_AMP_GLPE_AMP_ECC_COR_ERR_CNT_S 0
#define IG3_AMP_GLPE_AMP_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_AMP_GLPE_AMP_ECC_UNCOR_ERR 0x424000D0
#define IG3_AMP_GLPE_AMP_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_AMP_GLPE_AMP_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_AMP_GLPE_AMP_ECC_UNCOR_ERR_CNT_S 0
#define IG3_AMP_GLPE_AMP_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG 0x42400050
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS 0x42400054
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG 0x42400068
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS 0x4240006C
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG 0x42400080
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS 0x42400084
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_2_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG 0x42400098
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS 0x4240009C
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_3_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG 0x424000B0
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS 0x424000B4
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_LOOP_FIFO_4_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG 0x424000C8
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS 0x424000CC
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_MIM_TBL_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG 0x42400058
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS 0x4240005C
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_MRTE_0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG 0x42400070
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS 0x42400074
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_MRTE_1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG 0x42400088
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS 0x4240008C
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_MRTE_2_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG 0x424000A0
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS 0x424000A4
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_MRTE_3_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG 0x424000B8
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS 0x424000BC
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_MRTE_4_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG 0x42400060
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS 0x42400064
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_TAG_0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG 0x42400078
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS 0x4240007C
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_TAG_1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG 0x42400090
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS 0x42400094
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_TAG_2_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG 0x424000A8
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS 0x424000AC
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_TAG_3_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG 0x424000C0
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_RSVD3_S 20
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_RM_S 16
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_RSVD2_S 14
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_RME_S 12
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_RSVD1_S 10
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_ERR_CNT_S 9
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_FIX_CNT_S 8
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_RSVD0_S 6
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_MASK_INT_S 5
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_LS_BYPASS_S 4
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_LS_FORCE_S 3
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_ECC_EN_S 0
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS 0x424000C4
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS_RSVD1_S 30
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS_RSVD0_S 4
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS_INIT_DONE_S 2
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS_ECC_FIX_S 1
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS_ECC_ERR_S 0
#define IG3_AMP_GLPE_AMP_TAG_4_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_AMP_GLPE_ATM_CONFIG 0x42400000
#define IG3_AMP_GLPE_ATM_CONFIG_RSVD0_S 2
#define IG3_AMP_GLPE_ATM_CONFIG_RSVD0 GENMASK_ULL(2, 31)
#define IG3_AMP_GLPE_ATM_CONFIG_SEL_MODE_S 0
#define IG3_AMP_GLPE_ATM_CONFIG_SEL_MODE GENMASK_ULL(0, 1)
#define IG3_AMP_GLPE_FWMRTEIDXMASKTBL_CMD 0x42400020
#define IG3_AMP_GLPE_FWMRTEIDXMASKTBL_CMD_TBLWR_S 31
#define IG3_AMP_GLPE_FWMRTEIDXMASKTBL_CMD_TBLWR_M BIT_ULL(31)
#define IG3_AMP_GLPE_FWMRTEIDXMASKTBL_CMD_RSVD_S 12
#define IG3_AMP_GLPE_FWMRTEIDXMASKTBL_CMD_RSVD GENMASK_ULL(12, 30)
#define IG3_AMP_GLPE_FWMRTEIDXMASKTBL_CMD_PMFIDX_S 0
#define IG3_AMP_GLPE_FWMRTEIDXMASKTBL_CMD_PMFIDX GENMASK_ULL(0, 11)
#define IG3_AMP_GLPE_FWMRTEIDXMASKTBL_DATA 0x42400024
#define IG3_AMP_GLPE_FWMRTEIDXMASKTBL_DATA_RSVD_S 5
#define IG3_AMP_GLPE_FWMRTEIDXMASKTBL_DATA_RSVD GENMASK_ULL(5, 31)
#define IG3_AMP_GLPE_FWMRTEIDXMASKTBL_DATA_MRTEIDXMASKBITS_S 0
#define IG3_AMP_GLPE_FWMRTEIDXMASKTBL_DATA_MRTEIDXMASKBITS GENMASK_ULL(0, 4)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG 0x42400410
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_ECC_INST_NUM_S 25
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_RSVD3_S 20
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_RM_S 16
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_RSVD2_S 14
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_POWER_GATE_EN_S 13
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_RME_S 12
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_RME_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_RSVD1_S 10
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_ERR_CNT_S 9
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_FIX_CNT_S 8
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_RSVD0_S 6
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_MASK_INT_S 5
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_LS_BYPASS_S 4
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_LS_FORCE_S 3
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_ECC_INVERT_2_S 2
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_ECC_INVERT_1_S 1
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_ECC_EN_S 0
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS 0x42400414
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS_RSVD1_S 30
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS_RSVD0_S 4
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS_INIT_DONE_S 2
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS_ECC_FIX_S 1
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS_ECC_ERR_S 0
#define IG3_BRX_GLPE_BRX_CHUNK_RAM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG 0x42400418
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_ECC_INST_NUM_S 25
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_RSVD3_S 20
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_RM_S 16
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_RSVD2_S 14
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_POWER_GATE_EN_S 13
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_RME_S 12
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_RME_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_RSVD1_S 10
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_ERR_CNT_S 9
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_FIX_CNT_S 8
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_RSVD0_S 6
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_MASK_INT_S 5
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_LS_BYPASS_S 4
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_LS_FORCE_S 3
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_ECC_INVERT_2_S 2
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_ECC_INVERT_1_S 1
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_ECC_EN_S 0
#define IG3_BRX_GLPE_BRX_CLID_RAM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS 0x4240041C
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS_RSVD1_S 30
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS_RSVD0_S 4
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS_INIT_DONE_S 2
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS_ECC_FIX_S 1
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS_ECC_ERR_S 0
#define IG3_BRX_GLPE_BRX_CLID_RAM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_CONFIG 0x42400400
#define IG3_BRX_GLPE_BRX_CONFIG_RSVD1_S 3
#define IG3_BRX_GLPE_BRX_CONFIG_RSVD1 GENMASK_ULL(3, 31)
#define IG3_BRX_GLPE_BRX_CONFIG_CRC_MASK_S 0
#define IG3_BRX_GLPE_BRX_CONFIG_CRC_MASK GENMASK_ULL(0, 2)
#define IG3_BRX_GLPE_BRX_DEBUG 0x42400404
#define IG3_BRX_GLPE_BRX_DEBUG_RSVD0_S 11
#define IG3_BRX_GLPE_BRX_DEBUG_RSVD0 GENMASK_ULL(11, 31)
#define IG3_BRX_GLPE_BRX_DEBUG_USED_RX_CHUNKS_S 0
#define IG3_BRX_GLPE_BRX_DEBUG_USED_RX_CHUNKS GENMASK_ULL(0, 10)
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_COUNT 0x424004B8
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_CMD 0x424004CC
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_DATA_H 0x424004D8
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_DATA_L 0x424004D4
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_PTR 0x424004D0
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_CMD 0x424004BC
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_DATA_H 0x424004C8
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_DATA_L 0x424004C4
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_PTR 0x424004C0
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_BRX_GLPE_BRX_DTM_CONTROL 0x42400480
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_RSVD1_S 25
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_RSVD2_S 17
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_RSVD3_S 9
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_BYPASS_S 8
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_RSVD4_S 1
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_BRX_GLPE_BRX_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_ECC_COR_ERR 0x424004E8
#define IG3_BRX_GLPE_BRX_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_BRX_GLPE_BRX_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_BRX_GLPE_BRX_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_BRX_GLPE_BRX_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_BRX_GLPE_BRX_DTM_ECC_UNCOR_ERR 0x424004E4
#define IG3_BRX_GLPE_BRX_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_BRX_GLPE_BRX_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_BRX_GLPE_BRX_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_BRX_GLPE_BRX_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_BRX_GLPE_BRX_DTM_GROUP_CFG 0x4240048C
#define IG3_BRX_GLPE_BRX_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_BRX_GLPE_BRX_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_BRX_GLPE_BRX_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_BRX_GLPE_BRX_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_BRX_GLPE_BRX_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_BRX_GLPE_BRX_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_BRX_GLPE_BRX_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_BRX_GLPE_BRX_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_BRX_GLPE_BRX_DTM_LOG_CFG 0x42400490
#define IG3_BRX_GLPE_BRX_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_BRX_GLPE_BRX_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_BRX_GLPE_BRX_DTM_LOG_CFG_RSVD1_S 2
#define IG3_BRX_GLPE_BRX_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_BRX_GLPE_BRX_DTM_LOG_CFG_MODE_S 0
#define IG3_BRX_GLPE_BRX_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_BRX_GLPE_BRX_DTM_LOG_MASK 0x42400498
#define IG3_BRX_GLPE_BRX_DTM_LOG_MASK_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_BRX_GLPE_BRX_DTM_LOG_PATTERN 0x42400494
#define IG3_BRX_GLPE_BRX_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_BRX_GLPE_BRX_DTM_MAIN_CFG 0x42400484
#define IG3_BRX_GLPE_BRX_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_BRX_GLPE_BRX_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_BRX_GLPE_BRX_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_BRX_GLPE_BRX_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_BRX_GLPE_BRX_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_BRX_GLPE_BRX_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_BRX_GLPE_BRX_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_BRX_GLPE_BRX_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_BRX_GLPE_BRX_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_BRX_GLPE_BRX_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_BRX_GLPE_BRX_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_MAIN_STS 0x42400488
#define IG3_BRX_GLPE_BRX_DTM_MAIN_STS_RSVD1_S 9
#define IG3_BRX_GLPE_BRX_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_BRX_GLPE_BRX_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_BRX_GLPE_BRX_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_MAIN_STS_RSVD2_S 1
#define IG3_BRX_GLPE_BRX_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_BRX_GLPE_BRX_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_BRX_GLPE_BRX_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TIMESTAMP 0x424004B0
#define IG3_BRX_GLPE_BRX_DTM_TIMESTAMP_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_BRX_GLPE_BRX_DTM_TIMESTAMP_ROLLOVER 0x424004B4
#define IG3_BRX_GLPE_BRX_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG 0x424004DC
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS 0x424004E0
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_BRX_GLPE_BRX_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_DTM_TRIG_CFG 0x4240049C
#define IG3_BRX_GLPE_BRX_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_BRX_GLPE_BRX_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_BRX_GLPE_BRX_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_BRX_GLPE_BRX_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_BRX_GLPE_BRX_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_BRX_GLPE_BRX_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_BRX_GLPE_BRX_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_BRX_GLPE_BRX_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_BRX_GLPE_BRX_DTM_TRIG_CFG_MODE_S 0
#define IG3_BRX_GLPE_BRX_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_BRX_GLPE_BRX_DTM_TRIG_COUNT 0x424004A8
#define IG3_BRX_GLPE_BRX_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_BRX_GLPE_BRX_DTM_TRIG_MASK 0x424004A4
#define IG3_BRX_GLPE_BRX_DTM_TRIG_MASK_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_BRX_GLPE_BRX_DTM_TRIG_PATTERN 0x424004A0
#define IG3_BRX_GLPE_BRX_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_BRX_GLPE_BRX_DTM_TRIG_TIMESTAMP 0x424004AC
#define IG3_BRX_GLPE_BRX_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_BRX_GLPE_BRX_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_BRX_GLPE_BRX_ECC_COR_ERR 0x4240040C
#define IG3_BRX_GLPE_BRX_ECC_COR_ERR_RSVD_S 12
#define IG3_BRX_GLPE_BRX_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_BRX_GLPE_BRX_ECC_COR_ERR_CNT_S 0
#define IG3_BRX_GLPE_BRX_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_BRX_GLPE_BRX_ECC_UNCOR_ERR 0x42400408
#define IG3_BRX_GLPE_BRX_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_BRX_GLPE_BRX_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_BRX_GLPE_BRX_ECC_UNCOR_ERR_CNT_S 0
#define IG3_BRX_GLPE_BRX_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG 0x42400420
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_ECC_INST_NUM_S 25
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_RSVD3_S 20
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_RM_S 16
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_RSVD2_S 14
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_POWER_GATE_EN_S 13
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_RME_S 12
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_RME_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_RSVD1_S 10
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_ERR_CNT_S 9
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_FIX_CNT_S 8
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_RSVD0_S 6
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_MASK_INT_S 5
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_LS_BYPASS_S 4
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_LS_FORCE_S 3
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_ECC_INVERT_2_S 2
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_ECC_INVERT_1_S 1
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_ECC_EN_S 0
#define IG3_BRX_GLPE_BRX_FREE_RAM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS 0x42400424
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS_RSVD1_S 30
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS_RSVD0_S 4
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS_INIT_DONE_S 2
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS_ECC_FIX_S 1
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS_ECC_ERR_S 0
#define IG3_BRX_GLPE_BRX_FREE_RAM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_BUS_INDEX 0x42400A10
#define IG3_CRX_GLPE_CRX_BOB0_BOB_BUS_INDEX_BUS_INDEX_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_BUS_INDEX_BUS_INDEX GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL 0x42400A00
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_RESERVED_31_10_S 10
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_RESERVED_31_10 GENMASK_ULL(10, 31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_TRIG_OP_S 8
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_TRIG_OP GENMASK_ULL(8, 9)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_VLD_RDY_FRZ_EN_S 7
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_VLD_RDY_FRZ_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_EN_I_FREEZE_S 6
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_EN_I_FREEZE_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_COUNT_ONLY_TRIG_S 5
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_COUNT_ONLY_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_READ_INPUT_BUS_S 4
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_READ_INPUT_BUS_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_EN_FRZ_ON_CNT_S 3
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_EN_FRZ_ON_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_EN_FRZ_ON_TRIG_S 2
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_EN_FRZ_ON_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_FREEZE_RESET_S 1
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_FREEZE_RESET_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_FREEZE_SET_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_CTRL_FREEZE_SET_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_FREEZE_ON_CNT_VAL 0x42400A20
#define IG3_CRX_GLPE_CRX_BOB0_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_OBS_BUS 0x42400A40
#define IG3_CRX_GLPE_CRX_BOB0_BOB_OBS_BUS_OBS_BUS_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_OBS_BUS_OBS_BUS GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CNT0 0x42400A60
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CNT0_CNT0_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CNT0_CNT0 GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CNT1_0 0x42400A68
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CNT1_0_CNT1_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CNT1_0_CNT1 GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CNT1_1 0x42400A6C
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CNT1_1_CNT1_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CNT1_1_CNT1 GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CTRL 0x42400A58
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CTRL_RESERVED_31_16_S 16
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CTRL_RESERVED_31_16 GENMASK_ULL(16, 31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CTRL_PERF_WIN_S 8
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CTRL_PERF_WIN GENMASK_ULL(8, 15)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CTRL_PERF_CNT1_CFG_S 4
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CTRL_PERF_CNT1_CFG GENMASK_ULL(4, 7)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CTRL_PERF_CNT0_CFG_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_PERF_CTRL_PERF_CNT0_CFG GENMASK_ULL(0, 3)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_RC_CTRL 0x42400A38
#define IG3_CRX_GLPE_CRX_BOB0_BOB_RC_CTRL_RESERVED_31_1_S 1
#define IG3_CRX_GLPE_CRX_BOB0_BOB_RC_CTRL_RESERVED_31_1 GENMASK_ULL(1, 31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_RC_CTRL_RC_TRIG_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_RC_CTRL_RC_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_RC_GAP 0x42400A28
#define IG3_CRX_GLPE_CRX_BOB0_BOB_RC_GAP_RC_GAP_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_RC_GAP_RC_GAP GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_RC_TRNS 0x42400A30
#define IG3_CRX_GLPE_CRX_BOB0_BOB_RC_TRNS_RC_TRNS_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_RC_TRNS_RC_TRNS GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS 0x42400A08
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_RESERVED_31_8_S 8
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_RESERVED_31_8 GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_FREEZE_UPON_IFRZ_S 7
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_FREEZE_UPON_IFRZ_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_I_FREEZE_S 6
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_I_FREEZE_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_READY_S 5
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_READY_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_VALID_S 4
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_VALID_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_FREEZE_UPON_CNT_S 3
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_FREEZE_UPON_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_FREEZE_UPON_TRIG_S 2
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_FREEZE_UPON_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_S 1
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_FREEZE_STATUS_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_STATUS_FREEZE_STATUS_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_TRANS_CNT 0x42400A18
#define IG3_CRX_GLPE_CRX_BOB0_BOB_TRANS_CNT_TRANS_CNT_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_TRANS_CNT_TRANS_CNT GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_TRIG_MASK 0x42400A48
#define IG3_CRX_GLPE_CRX_BOB0_BOB_TRIG_MASK_TRIG_MASK_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_TRIG_MASK_TRIG_MASK GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB0_BOB_TRIG_VALUE 0x42400A50
#define IG3_CRX_GLPE_CRX_BOB0_BOB_TRIG_VALUE_TRIG_VALUE_S 0
#define IG3_CRX_GLPE_CRX_BOB0_BOB_TRIG_VALUE_TRIG_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_BUS_INDEX 0x42400A90
#define IG3_CRX_GLPE_CRX_BOB1_BOB_BUS_INDEX_BUS_INDEX_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_BUS_INDEX_BUS_INDEX GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL 0x42400A80
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_RESERVED_31_10_S 10
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_RESERVED_31_10 GENMASK_ULL(10, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_TRIG_OP_S 8
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_TRIG_OP GENMASK_ULL(8, 9)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_VLD_RDY_FRZ_EN_S 7
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_VLD_RDY_FRZ_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_EN_I_FREEZE_S 6
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_EN_I_FREEZE_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_COUNT_ONLY_TRIG_S 5
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_COUNT_ONLY_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_READ_INPUT_BUS_S 4
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_READ_INPUT_BUS_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_EN_FRZ_ON_CNT_S 3
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_EN_FRZ_ON_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_EN_FRZ_ON_TRIG_S 2
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_EN_FRZ_ON_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_FREEZE_RESET_S 1
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_FREEZE_RESET_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_FREEZE_SET_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_CTRL_FREEZE_SET_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_FREEZE_ON_CNT_VAL 0x42400AA0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_OBS_BUS 0x42400AC0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_OBS_BUS_OBS_BUS_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_OBS_BUS_OBS_BUS GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CNT0 0x42400AE0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CNT0_CNT0_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CNT0_CNT0 GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CNT1_0 0x42400AE8
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CNT1_0_CNT1_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CNT1_0_CNT1 GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CNT1_1 0x42400AEC
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CNT1_1_CNT1_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CNT1_1_CNT1 GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CTRL 0x42400AD8
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CTRL_RESERVED_31_16_S 16
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CTRL_RESERVED_31_16 GENMASK_ULL(16, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CTRL_PERF_WIN_S 8
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CTRL_PERF_WIN GENMASK_ULL(8, 15)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CTRL_PERF_CNT1_CFG_S 4
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CTRL_PERF_CNT1_CFG GENMASK_ULL(4, 7)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CTRL_PERF_CNT0_CFG_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_PERF_CTRL_PERF_CNT0_CFG GENMASK_ULL(0, 3)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_RC_CTRL 0x42400AB8
#define IG3_CRX_GLPE_CRX_BOB1_BOB_RC_CTRL_RESERVED_31_1_S 1
#define IG3_CRX_GLPE_CRX_BOB1_BOB_RC_CTRL_RESERVED_31_1 GENMASK_ULL(1, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_RC_CTRL_RC_TRIG_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_RC_CTRL_RC_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_RC_GAP 0x42400AA8
#define IG3_CRX_GLPE_CRX_BOB1_BOB_RC_GAP_RC_GAP_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_RC_GAP_RC_GAP GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_RC_TRNS 0x42400AB0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_RC_TRNS_RC_TRNS_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_RC_TRNS_RC_TRNS GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS 0x42400A88
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_RESERVED_31_8_S 8
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_RESERVED_31_8 GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_FREEZE_UPON_IFRZ_S 7
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_FREEZE_UPON_IFRZ_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_I_FREEZE_S 6
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_I_FREEZE_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_READY_S 5
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_READY_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_VALID_S 4
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_VALID_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_FREEZE_UPON_CNT_S 3
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_FREEZE_UPON_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_FREEZE_UPON_TRIG_S 2
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_FREEZE_UPON_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_S 1
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_FREEZE_STATUS_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_STATUS_FREEZE_STATUS_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_TRANS_CNT 0x42400A98
#define IG3_CRX_GLPE_CRX_BOB1_BOB_TRANS_CNT_TRANS_CNT_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_TRANS_CNT_TRANS_CNT GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_TRIG_MASK 0x42400AC8
#define IG3_CRX_GLPE_CRX_BOB1_BOB_TRIG_MASK_TRIG_MASK_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_TRIG_MASK_TRIG_MASK GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB1_BOB_TRIG_VALUE 0x42400AD0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_TRIG_VALUE_TRIG_VALUE_S 0
#define IG3_CRX_GLPE_CRX_BOB1_BOB_TRIG_VALUE_TRIG_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_BUS_INDEX 0x42400B10
#define IG3_CRX_GLPE_CRX_BOB2_BOB_BUS_INDEX_BUS_INDEX_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_BUS_INDEX_BUS_INDEX GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL 0x42400B00
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_RESERVED_31_10_S 10
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_RESERVED_31_10 GENMASK_ULL(10, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_TRIG_OP_S 8
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_TRIG_OP GENMASK_ULL(8, 9)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_VLD_RDY_FRZ_EN_S 7
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_VLD_RDY_FRZ_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_EN_I_FREEZE_S 6
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_EN_I_FREEZE_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_COUNT_ONLY_TRIG_S 5
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_COUNT_ONLY_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_READ_INPUT_BUS_S 4
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_READ_INPUT_BUS_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_EN_FRZ_ON_CNT_S 3
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_EN_FRZ_ON_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_EN_FRZ_ON_TRIG_S 2
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_EN_FRZ_ON_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_FREEZE_RESET_S 1
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_FREEZE_RESET_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_FREEZE_SET_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_CTRL_FREEZE_SET_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_FREEZE_ON_CNT_VAL 0x42400B20
#define IG3_CRX_GLPE_CRX_BOB2_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_OBS_BUS 0x42400B40
#define IG3_CRX_GLPE_CRX_BOB2_BOB_OBS_BUS_OBS_BUS_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_OBS_BUS_OBS_BUS GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CNT0 0x42400B60
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CNT0_CNT0_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CNT0_CNT0 GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CNT1_0 0x42400B68
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CNT1_0_CNT1_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CNT1_0_CNT1 GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CNT1_1 0x42400B6C
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CNT1_1_CNT1_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CNT1_1_CNT1 GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CTRL 0x42400B58
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CTRL_RESERVED_31_16_S 16
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CTRL_RESERVED_31_16 GENMASK_ULL(16, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CTRL_PERF_WIN_S 8
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CTRL_PERF_WIN GENMASK_ULL(8, 15)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CTRL_PERF_CNT1_CFG_S 4
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CTRL_PERF_CNT1_CFG GENMASK_ULL(4, 7)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CTRL_PERF_CNT0_CFG_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_PERF_CTRL_PERF_CNT0_CFG GENMASK_ULL(0, 3)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_RC_CTRL 0x42400B38
#define IG3_CRX_GLPE_CRX_BOB2_BOB_RC_CTRL_RESERVED_31_1_S 1
#define IG3_CRX_GLPE_CRX_BOB2_BOB_RC_CTRL_RESERVED_31_1 GENMASK_ULL(1, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_RC_CTRL_RC_TRIG_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_RC_CTRL_RC_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_RC_GAP 0x42400B28
#define IG3_CRX_GLPE_CRX_BOB2_BOB_RC_GAP_RC_GAP_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_RC_GAP_RC_GAP GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_RC_TRNS 0x42400B30
#define IG3_CRX_GLPE_CRX_BOB2_BOB_RC_TRNS_RC_TRNS_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_RC_TRNS_RC_TRNS GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS 0x42400B08
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_RESERVED_31_8_S 8
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_RESERVED_31_8 GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_FREEZE_UPON_IFRZ_S 7
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_FREEZE_UPON_IFRZ_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_I_FREEZE_S 6
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_I_FREEZE_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_READY_S 5
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_READY_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_VALID_S 4
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_VALID_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_FREEZE_UPON_CNT_S 3
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_FREEZE_UPON_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_FREEZE_UPON_TRIG_S 2
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_FREEZE_UPON_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_S 1
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_FREEZE_STATUS_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_STATUS_FREEZE_STATUS_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_TRANS_CNT 0x42400B18
#define IG3_CRX_GLPE_CRX_BOB2_BOB_TRANS_CNT_TRANS_CNT_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_TRANS_CNT_TRANS_CNT GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_TRIG_MASK 0x42400B48
#define IG3_CRX_GLPE_CRX_BOB2_BOB_TRIG_MASK_TRIG_MASK_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_TRIG_MASK_TRIG_MASK GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB2_BOB_TRIG_VALUE 0x42400B50
#define IG3_CRX_GLPE_CRX_BOB2_BOB_TRIG_VALUE_TRIG_VALUE_S 0
#define IG3_CRX_GLPE_CRX_BOB2_BOB_TRIG_VALUE_TRIG_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_BUS_INDEX 0x42400B90
#define IG3_CRX_GLPE_CRX_BOB3_BOB_BUS_INDEX_BUS_INDEX_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_BUS_INDEX_BUS_INDEX GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL 0x42400B80
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_RESERVED_31_10_S 10
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_RESERVED_31_10 GENMASK_ULL(10, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_TRIG_OP_S 8
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_TRIG_OP GENMASK_ULL(8, 9)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_VLD_RDY_FRZ_EN_S 7
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_VLD_RDY_FRZ_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_EN_I_FREEZE_S 6
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_EN_I_FREEZE_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_COUNT_ONLY_TRIG_S 5
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_COUNT_ONLY_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_READ_INPUT_BUS_S 4
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_READ_INPUT_BUS_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_EN_FRZ_ON_CNT_S 3
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_EN_FRZ_ON_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_EN_FRZ_ON_TRIG_S 2
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_EN_FRZ_ON_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_FREEZE_RESET_S 1
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_FREEZE_RESET_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_FREEZE_SET_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_CTRL_FREEZE_SET_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_FREEZE_ON_CNT_VAL 0x42400BA0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_OBS_BUS 0x42400BC0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_OBS_BUS_OBS_BUS_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_OBS_BUS_OBS_BUS GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CNT0 0x42400BE0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CNT0_CNT0_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CNT0_CNT0 GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CNT1_0 0x42400BE8
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CNT1_0_CNT1_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CNT1_0_CNT1 GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CNT1_1 0x42400BEC
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CNT1_1_CNT1_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CNT1_1_CNT1 GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CTRL 0x42400BD8
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CTRL_RESERVED_31_16_S 16
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CTRL_RESERVED_31_16 GENMASK_ULL(16, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CTRL_PERF_WIN_S 8
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CTRL_PERF_WIN GENMASK_ULL(8, 15)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CTRL_PERF_CNT1_CFG_S 4
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CTRL_PERF_CNT1_CFG GENMASK_ULL(4, 7)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CTRL_PERF_CNT0_CFG_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_PERF_CTRL_PERF_CNT0_CFG GENMASK_ULL(0, 3)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_RC_CTRL 0x42400BB8
#define IG3_CRX_GLPE_CRX_BOB3_BOB_RC_CTRL_RESERVED_31_1_S 1
#define IG3_CRX_GLPE_CRX_BOB3_BOB_RC_CTRL_RESERVED_31_1 GENMASK_ULL(1, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_RC_CTRL_RC_TRIG_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_RC_CTRL_RC_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_RC_GAP 0x42400BA8
#define IG3_CRX_GLPE_CRX_BOB3_BOB_RC_GAP_RC_GAP_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_RC_GAP_RC_GAP GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_RC_TRNS 0x42400BB0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_RC_TRNS_RC_TRNS_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_RC_TRNS_RC_TRNS GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS 0x42400B88
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_RESERVED_31_8_S 8
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_RESERVED_31_8 GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_FREEZE_UPON_IFRZ_S 7
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_FREEZE_UPON_IFRZ_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_I_FREEZE_S 6
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_I_FREEZE_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_READY_S 5
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_READY_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_VALID_S 4
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_VALID_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_FREEZE_UPON_CNT_S 3
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_FREEZE_UPON_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_FREEZE_UPON_TRIG_S 2
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_FREEZE_UPON_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_S 1
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_FREEZE_STATUS_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_STATUS_FREEZE_STATUS_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_TRANS_CNT 0x42400B98
#define IG3_CRX_GLPE_CRX_BOB3_BOB_TRANS_CNT_TRANS_CNT_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_TRANS_CNT_TRANS_CNT GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_TRIG_MASK 0x42400BC8
#define IG3_CRX_GLPE_CRX_BOB3_BOB_TRIG_MASK_TRIG_MASK_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_TRIG_MASK_TRIG_MASK GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_BOB3_BOB_TRIG_VALUE 0x42400BD0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_TRIG_VALUE_TRIG_VALUE_S 0
#define IG3_CRX_GLPE_CRX_BOB3_BOB_TRIG_VALUE_TRIG_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_CONFIG 0x42400800
#define IG3_CRX_GLPE_CRX_CONFIG_RSVD1_S 3
#define IG3_CRX_GLPE_CRX_CONFIG_RSVD1 GENMASK_ULL(3, 31)
#define IG3_CRX_GLPE_CRX_CONFIG_CRC_MASK_S 0
#define IG3_CRX_GLPE_CRX_CONFIG_CRC_MASK GENMASK_ULL(0, 2)
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_COUNT 0x424009B8
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_CMD 0x424009CC
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_DATA_H 0x424009D8
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_DATA_L 0x424009D4
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_PTR 0x424009D0
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_CMD 0x424009BC
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_DATA_H 0x424009C8
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_DATA_L 0x424009C4
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_PTR 0x424009C0
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_CRX_GLPE_CRX_DTM_CONTROL 0x42400980
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_RSVD1_S 25
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_RSVD2_S 17
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_RSVD3_S 9
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_BYPASS_S 8
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_RSVD4_S 1
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_CRX_GLPE_CRX_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_ECC_COR_ERR 0x424009E8
#define IG3_CRX_GLPE_CRX_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_CRX_GLPE_CRX_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CRX_GLPE_CRX_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_CRX_GLPE_CRX_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CRX_GLPE_CRX_DTM_ECC_UNCOR_ERR 0x424009E4
#define IG3_CRX_GLPE_CRX_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_CRX_GLPE_CRX_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CRX_GLPE_CRX_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_CRX_GLPE_CRX_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CRX_GLPE_CRX_DTM_GROUP_CFG 0x4240098C
#define IG3_CRX_GLPE_CRX_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_CRX_GLPE_CRX_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_CRX_GLPE_CRX_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_CRX_GLPE_CRX_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_CRX_GLPE_CRX_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_CRX_GLPE_CRX_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_CRX_GLPE_CRX_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_CRX_GLPE_CRX_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_CRX_GLPE_CRX_DTM_LOG_CFG 0x42400990
#define IG3_CRX_GLPE_CRX_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_CRX_GLPE_CRX_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_CRX_GLPE_CRX_DTM_LOG_CFG_RSVD1_S 2
#define IG3_CRX_GLPE_CRX_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_CRX_GLPE_CRX_DTM_LOG_CFG_MODE_S 0
#define IG3_CRX_GLPE_CRX_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_CRX_GLPE_CRX_DTM_LOG_MASK 0x42400998
#define IG3_CRX_GLPE_CRX_DTM_LOG_MASK_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_DTM_LOG_PATTERN 0x42400994
#define IG3_CRX_GLPE_CRX_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_DTM_MAIN_CFG 0x42400984
#define IG3_CRX_GLPE_CRX_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_CRX_GLPE_CRX_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_CRX_GLPE_CRX_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_CRX_GLPE_CRX_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_CRX_GLPE_CRX_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_CRX_GLPE_CRX_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_CRX_GLPE_CRX_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_CRX_GLPE_CRX_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_CRX_GLPE_CRX_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_CRX_GLPE_CRX_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_CRX_GLPE_CRX_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_MAIN_STS 0x42400988
#define IG3_CRX_GLPE_CRX_DTM_MAIN_STS_RSVD1_S 9
#define IG3_CRX_GLPE_CRX_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_CRX_GLPE_CRX_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_CRX_GLPE_CRX_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_MAIN_STS_RSVD2_S 1
#define IG3_CRX_GLPE_CRX_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_CRX_GLPE_CRX_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_CRX_GLPE_CRX_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TIMESTAMP 0x424009B0
#define IG3_CRX_GLPE_CRX_DTM_TIMESTAMP_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_DTM_TIMESTAMP_ROLLOVER 0x424009B4
#define IG3_CRX_GLPE_CRX_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG 0x424009DC
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS 0x424009E0
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_CRX_GLPE_CRX_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CRX_GLPE_CRX_DTM_TRIG_CFG 0x4240099C
#define IG3_CRX_GLPE_CRX_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_CRX_GLPE_CRX_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_CRX_GLPE_CRX_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_CRX_GLPE_CRX_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_CRX_GLPE_CRX_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_CRX_GLPE_CRX_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_CRX_GLPE_CRX_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_CRX_GLPE_CRX_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_CRX_GLPE_CRX_DTM_TRIG_CFG_MODE_S 0
#define IG3_CRX_GLPE_CRX_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_CRX_GLPE_CRX_DTM_TRIG_COUNT 0x424009A8
#define IG3_CRX_GLPE_CRX_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_DTM_TRIG_MASK 0x424009A4
#define IG3_CRX_GLPE_CRX_DTM_TRIG_MASK_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_DTM_TRIG_PATTERN 0x424009A0
#define IG3_CRX_GLPE_CRX_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_DTM_TRIG_TIMESTAMP 0x424009AC
#define IG3_CRX_GLPE_CRX_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_CRX_GLPE_CRX_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_CRX_GLPE_CRX_ECC_COR_ERR 0x424008E0
#define IG3_CRX_GLPE_CRX_ECC_COR_ERR_RSVD_S 12
#define IG3_CRX_GLPE_CRX_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CRX_GLPE_CRX_ECC_COR_ERR_CNT_S 0
#define IG3_CRX_GLPE_CRX_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CRX_GLPE_CRX_ECC_UNCOR_ERR 0x424008DC
#define IG3_CRX_GLPE_CRX_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_CRX_GLPE_CRX_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_CRX_GLPE_CRX_ECC_UNCOR_ERR_CNT_S 0
#define IG3_CRX_GLPE_CRX_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG 0x424008E4
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_ECC_INST_NUM_S 25
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_RSVD3_S 20
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_RM_S 16
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_RSVD2_S 14
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_POWER_GATE_EN_S 13
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_RME_S 12
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_RME_M BIT_ULL(31)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_RSVD1_S 10
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_ERR_CNT_S 9
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_FIX_CNT_S 8
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_RSVD0_S 6
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_MASK_INT_S 5
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_LS_BYPASS_S 4
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_LS_FORCE_S 3
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_ECC_INVERT_2_S 2
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_ECC_INVERT_1_S 1
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_ECC_EN_S 0
#define IG3_CRX_GLPE_MC_OC_BUF_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS 0x424008E8
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS_RSVD1_S 30
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS_RSVD0_S 4
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS_INIT_DONE_S 2
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS_ECC_FIX_S 1
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS_ECC_ERR_S 0
#define IG3_CRX_GLPE_MC_OC_BUF_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD 0x424008AC
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_RSVD_S 8
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_RSVD GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST7_CREDIT_EN_S 7
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST7_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST6_CREDIT_EN_S 6
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST6_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST5_CREDIT_EN_S 5
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST5_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST4_CREDIT_EN_S 4
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST4_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST3_CREDIT_EN_S 3
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST3_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST2_CREDIT_EN_S 2
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST2_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST1_CREDIT_EN_S 1
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST1_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST0_CREDIT_EN_S 0
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PD_HOST0_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD 0x424008C4
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_RSVD_S 8
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_RSVD GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST7_CREDIT_EN_S 7
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST7_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST6_CREDIT_EN_S 6
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST6_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST5_CREDIT_EN_S 5
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST5_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST4_CREDIT_EN_S 4
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST4_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST3_CREDIT_EN_S 3
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST3_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST2_CREDIT_EN_S 2
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST2_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST1_CREDIT_EN_S 1
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST1_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST0_CREDIT_EN_S 0
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_CRT_PMD_HOST0_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD 0x4240087C
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_RSVD_S 8
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_RSVD GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST7_CREDIT_EN_S 7
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST7_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST6_CREDIT_EN_S 6
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST6_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST5_CREDIT_EN_S 5
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST5_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST4_CREDIT_EN_S 4
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST4_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST3_CREDIT_EN_S 3
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST3_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST2_CREDIT_EN_S 2
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST2_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST1_CREDIT_EN_S 1
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST1_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST0_CREDIT_EN_S 0
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PD_HOST0_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD 0x42400894
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_RSVD_S 8
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_RSVD GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST7_CREDIT_EN_S 7
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST7_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST6_CREDIT_EN_S 6
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST6_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST5_CREDIT_EN_S 5
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST5_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST4_CREDIT_EN_S 4
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST4_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST3_CREDIT_EN_S 3
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST3_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST2_CREDIT_EN_S 2
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST2_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST1_CREDIT_EN_S 1
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST1_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST0_CREDIT_EN_S 0
#define IG3_CRX_GLPE_MIF_HOST_CREDIT_ENABLE_PR_PMD_HOST0_CREDIT_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_MIF_PD_INITIAL_CREDIT_VALUE_CRT_PD(_i) (0x424008B0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_CRX_GLPE_MIF_PD_INITIAL_CREDIT_VALUE_CRT_PD_MAX_INDEX_I 4
#define IG3_CRX_GLPE_MIF_PD_INITIAL_CREDIT_VALUE_CRT_PD_RSVD_S 12
#define IG3_CRX_GLPE_MIF_PD_INITIAL_CREDIT_VALUE_CRT_PD_RSVD GENMASK_ULL(12, 31)
#define IG3_CRX_GLPE_MIF_PD_INITIAL_CREDIT_VALUE_CRT_PD_INIT_VALUE_S 0
#define IG3_CRX_GLPE_MIF_PD_INITIAL_CREDIT_VALUE_CRT_PD_INIT_VALUE GENMASK_ULL(0, 11)
#define IG3_CRX_GLPE_MIF_PD_INITIAL_CREDIT_VALUE_PR_PD(_i) (0x42400880 + ((_i) * 4)) /* _i=0...4 */
#define IG3_CRX_GLPE_MIF_PD_INITIAL_CREDIT_VALUE_PR_PD_MAX_INDEX_I 4
#define IG3_CRX_GLPE_MIF_PD_INITIAL_CREDIT_VALUE_PR_PD_RSVD_S 12
#define IG3_CRX_GLPE_MIF_PD_INITIAL_CREDIT_VALUE_PR_PD_RSVD GENMASK_ULL(12, 31)
#define IG3_CRX_GLPE_MIF_PD_INITIAL_CREDIT_VALUE_PR_PD_INIT_VALUE_S 0
#define IG3_CRX_GLPE_MIF_PD_INITIAL_CREDIT_VALUE_PR_PD_INIT_VALUE GENMASK_ULL(0, 11)
#define IG3_CRX_GLPE_MIF_PMD_INITIAL_CREDIT_VALUE_CRT_PMD(_i) (0x424008C8 + ((_i) * 4)) /* _i=0...4 */
#define IG3_CRX_GLPE_MIF_PMD_INITIAL_CREDIT_VALUE_CRT_PMD_MAX_INDEX_I 4
#define IG3_CRX_GLPE_MIF_PMD_INITIAL_CREDIT_VALUE_CRT_PMD_RSVD_S 12
#define IG3_CRX_GLPE_MIF_PMD_INITIAL_CREDIT_VALUE_CRT_PMD_RSVD GENMASK_ULL(12, 31)
#define IG3_CRX_GLPE_MIF_PMD_INITIAL_CREDIT_VALUE_CRT_PMD_INIT_VALUE_S 0
#define IG3_CRX_GLPE_MIF_PMD_INITIAL_CREDIT_VALUE_CRT_PMD_INIT_VALUE GENMASK_ULL(0, 11)
#define IG3_CRX_GLPE_MIF_PMD_INITIAL_CREDIT_VALUE_PR_PMD(_i) (0x42400898 + ((_i) * 4)) /* _i=0...4 */
#define IG3_CRX_GLPE_MIF_PMD_INITIAL_CREDIT_VALUE_PR_PMD_MAX_INDEX_I 4
#define IG3_CRX_GLPE_MIF_PMD_INITIAL_CREDIT_VALUE_PR_PMD_RSVD_S 12
#define IG3_CRX_GLPE_MIF_PMD_INITIAL_CREDIT_VALUE_PR_PMD_RSVD GENMASK_ULL(12, 31)
#define IG3_CRX_GLPE_MIF_PMD_INITIAL_CREDIT_VALUE_PR_PMD_INIT_VALUE_S 0
#define IG3_CRX_GLPE_MIF_PMD_INITIAL_CREDIT_VALUE_PR_PMD_INIT_VALUE GENMASK_ULL(0, 11)
#define IG3_CRX_GLPE_PARSEPTR_CRT_DEF 0x42400844
#define IG3_CRX_GLPE_PARSEPTR_CRT_DEF_RSVD_S 8
#define IG3_CRX_GLPE_PARSEPTR_CRT_DEF_RSVD GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_PARSEPTR_CRT_DEF_PARSEPTRID_S 0
#define IG3_CRX_GLPE_PARSEPTR_CRT_DEF_PARSEPTRID GENMASK_ULL(0, 7)
#define IG3_CRX_GLPE_PARSEPTR_IPV4_DEF(_i) (0x42400810 + ((_i) * 4)) /* _i=0...2 */
#define IG3_CRX_GLPE_PARSEPTR_IPV4_DEF_MAX_INDEX_I 2
#define IG3_CRX_GLPE_PARSEPTR_IPV4_DEF_RSVD_S 8
#define IG3_CRX_GLPE_PARSEPTR_IPV4_DEF_RSVD GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_PARSEPTR_IPV4_DEF_PARSEPTRID_S 0
#define IG3_CRX_GLPE_PARSEPTR_IPV4_DEF_PARSEPTRID GENMASK_ULL(0, 7)
#define IG3_CRX_GLPE_PARSEPTR_IPV6_DEF(_i) (0x4240081C + ((_i) * 4)) /* _i=0...2 */
#define IG3_CRX_GLPE_PARSEPTR_IPV6_DEF_MAX_INDEX_I 2
#define IG3_CRX_GLPE_PARSEPTR_IPV6_DEF_RSVD_S 8
#define IG3_CRX_GLPE_PARSEPTR_IPV6_DEF_RSVD GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_PARSEPTR_IPV6_DEF_PARSEPTRID_S 0
#define IG3_CRX_GLPE_PARSEPTR_IPV6_DEF_PARSEPTRID GENMASK_ULL(0, 7)
#define IG3_CRX_GLPE_PARSEPTR_MAC_DEF(_i) (0x42400804 + ((_i) * 4)) /* _i=0...2 */
#define IG3_CRX_GLPE_PARSEPTR_MAC_DEF_MAX_INDEX_I 2
#define IG3_CRX_GLPE_PARSEPTR_MAC_DEF_RSVD_S 8
#define IG3_CRX_GLPE_PARSEPTR_MAC_DEF_RSVD GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_PARSEPTR_MAC_DEF_PARSEPTRID_S 0
#define IG3_CRX_GLPE_PARSEPTR_MAC_DEF_PARSEPTRID GENMASK_ULL(0, 7)
#define IG3_CRX_GLPE_PARSEPTR_PAY_DEF 0x42400848
#define IG3_CRX_GLPE_PARSEPTR_PAY_DEF_RSVD_S 8
#define IG3_CRX_GLPE_PARSEPTR_PAY_DEF_RSVD GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_PARSEPTR_PAY_DEF_PARSEPTRID_S 0
#define IG3_CRX_GLPE_PARSEPTR_PAY_DEF_PARSEPTRID GENMASK_ULL(0, 7)
#define IG3_CRX_GLPE_PARSEPTR_ROCEV2_DEF 0x42400840
#define IG3_CRX_GLPE_PARSEPTR_ROCEV2_DEF_RSVD_S 8
#define IG3_CRX_GLPE_PARSEPTR_ROCEV2_DEF_RSVD GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_PARSEPTR_ROCEV2_DEF_PARSEPTRID_S 0
#define IG3_CRX_GLPE_PARSEPTR_ROCEV2_DEF_PARSEPTRID GENMASK_ULL(0, 7)
#define IG3_CRX_GLPE_PARSEPTR_TCP_DEF 0x4240083C
#define IG3_CRX_GLPE_PARSEPTR_TCP_DEF_RSVD_S 8
#define IG3_CRX_GLPE_PARSEPTR_TCP_DEF_RSVD GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_PARSEPTR_TCP_DEF_PARSEPTRID_S 0
#define IG3_CRX_GLPE_PARSEPTR_TCP_DEF_PARSEPTRID GENMASK_ULL(0, 7)
#define IG3_CRX_GLPE_PARSEPTR_UDP_DEF 0x42400838
#define IG3_CRX_GLPE_PARSEPTR_UDP_DEF_RSVD_S 8
#define IG3_CRX_GLPE_PARSEPTR_UDP_DEF_RSVD GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_PARSEPTR_UDP_DEF_PARSEPTRID_S 0
#define IG3_CRX_GLPE_PARSEPTR_UDP_DEF_PARSEPTRID GENMASK_ULL(0, 7)
#define IG3_CRX_GLPE_PARSEPTR_VLAN_EXTERNAL_DEF(_i) (0x42400830 + ((_i) * 4)) /* _i=0...1 */
#define IG3_CRX_GLPE_PARSEPTR_VLAN_EXTERNAL_DEF_MAX_INDEX_I 1
#define IG3_CRX_GLPE_PARSEPTR_VLAN_EXTERNAL_DEF_RSVD_S 8
#define IG3_CRX_GLPE_PARSEPTR_VLAN_EXTERNAL_DEF_RSVD GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_PARSEPTR_VLAN_EXTERNAL_DEF_PARSEPTRID_S 0
#define IG3_CRX_GLPE_PARSEPTR_VLAN_EXTERNAL_DEF_PARSEPTRID GENMASK_ULL(0, 7)
#define IG3_CRX_GLPE_PARSEPTR_VLAN_INTERNAL_DEF(_i) (0x42400828 + ((_i) * 4)) /* _i=0...1 */
#define IG3_CRX_GLPE_PARSEPTR_VLAN_INTERNAL_DEF_MAX_INDEX_I 1
#define IG3_CRX_GLPE_PARSEPTR_VLAN_INTERNAL_DEF_RSVD_S 8
#define IG3_CRX_GLPE_PARSEPTR_VLAN_INTERNAL_DEF_RSVD GENMASK_ULL(8, 31)
#define IG3_CRX_GLPE_PARSEPTR_VLAN_INTERNAL_DEF_PARSEPTRID_S 0
#define IG3_CRX_GLPE_PARSEPTR_VLAN_INTERNAL_DEF_PARSEPTRID GENMASK_ULL(0, 7)
#define IG3_CRX_GLPE_RB_CREDIT_LIMIT(_i) (0x4240084C + ((_i) * 4)) /* _i=0...4 */
#define IG3_CRX_GLPE_RB_CREDIT_LIMIT_MAX_INDEX_I 4
#define IG3_CRX_GLPE_RB_CREDIT_LIMIT_RSVD_S 22
#define IG3_CRX_GLPE_RB_CREDIT_LIMIT_RSVD GENMASK_ULL(22, 31)
#define IG3_CRX_GLPE_RB_CREDIT_LIMIT_SHARED_S 11
#define IG3_CRX_GLPE_RB_CREDIT_LIMIT_SHARED GENMASK_ULL(11, 21)
#define IG3_CRX_GLPE_RB_CREDIT_LIMIT_DEDICATED_S 0
#define IG3_CRX_GLPE_RB_CREDIT_LIMIT_DEDICATED GENMASK_ULL(0, 10)
#define IG3_CRX_GLPE_RB_CREDIT_USED(_i) (0x42400864 + ((_i) * 4)) /* _i=0...4 */
#define IG3_CRX_GLPE_RB_CREDIT_USED_MAX_INDEX_I 4
#define IG3_CRX_GLPE_RB_CREDIT_USED_RSVD_S 22
#define IG3_CRX_GLPE_RB_CREDIT_USED_RSVD GENMASK_ULL(22, 31)
#define IG3_CRX_GLPE_RB_CREDIT_USED_SHARED_S 11
#define IG3_CRX_GLPE_RB_CREDIT_USED_SHARED GENMASK_ULL(11, 21)
#define IG3_CRX_GLPE_RB_CREDIT_USED_DEDICATED_S 0
#define IG3_CRX_GLPE_RB_CREDIT_USED_DEDICATED GENMASK_ULL(0, 10)
#define IG3_CRX_GLPE_RB_DATA_0_CFG 0x424008EC
#define IG3_CRX_GLPE_RB_DATA_0_CFG_ECC_INST_NUM_S 25
#define IG3_CRX_GLPE_RB_DATA_0_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_RSVD3_S 20
#define IG3_CRX_GLPE_RB_DATA_0_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_RM_S 16
#define IG3_CRX_GLPE_RB_DATA_0_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_RSVD2_S 14
#define IG3_CRX_GLPE_RB_DATA_0_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_POWER_GATE_EN_S 13
#define IG3_CRX_GLPE_RB_DATA_0_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_RME_S 12
#define IG3_CRX_GLPE_RB_DATA_0_CFG_RME_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_RSVD1_S 10
#define IG3_CRX_GLPE_RB_DATA_0_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_ERR_CNT_S 9
#define IG3_CRX_GLPE_RB_DATA_0_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_FIX_CNT_S 8
#define IG3_CRX_GLPE_RB_DATA_0_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_RSVD0_S 6
#define IG3_CRX_GLPE_RB_DATA_0_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_MASK_INT_S 5
#define IG3_CRX_GLPE_RB_DATA_0_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_LS_BYPASS_S 4
#define IG3_CRX_GLPE_RB_DATA_0_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_LS_FORCE_S 3
#define IG3_CRX_GLPE_RB_DATA_0_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_ECC_INVERT_2_S 2
#define IG3_CRX_GLPE_RB_DATA_0_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_ECC_INVERT_1_S 1
#define IG3_CRX_GLPE_RB_DATA_0_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_0_CFG_ECC_EN_S 0
#define IG3_CRX_GLPE_RB_DATA_0_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_0_STATUS 0x424008F0
#define IG3_CRX_GLPE_RB_DATA_0_STATUS_RSVD1_S 30
#define IG3_CRX_GLPE_RB_DATA_0_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CRX_GLPE_RB_DATA_0_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CRX_GLPE_RB_DATA_0_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CRX_GLPE_RB_DATA_0_STATUS_RSVD0_S 4
#define IG3_CRX_GLPE_RB_DATA_0_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CRX_GLPE_RB_DATA_0_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CRX_GLPE_RB_DATA_0_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_0_STATUS_INIT_DONE_S 2
#define IG3_CRX_GLPE_RB_DATA_0_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_0_STATUS_ECC_FIX_S 1
#define IG3_CRX_GLPE_RB_DATA_0_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_0_STATUS_ECC_ERR_S 0
#define IG3_CRX_GLPE_RB_DATA_0_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_1_CFG 0x424008F4
#define IG3_CRX_GLPE_RB_DATA_1_CFG_ECC_INST_NUM_S 25
#define IG3_CRX_GLPE_RB_DATA_1_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_RSVD3_S 20
#define IG3_CRX_GLPE_RB_DATA_1_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_RM_S 16
#define IG3_CRX_GLPE_RB_DATA_1_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_RSVD2_S 14
#define IG3_CRX_GLPE_RB_DATA_1_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_POWER_GATE_EN_S 13
#define IG3_CRX_GLPE_RB_DATA_1_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_RME_S 12
#define IG3_CRX_GLPE_RB_DATA_1_CFG_RME_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_RSVD1_S 10
#define IG3_CRX_GLPE_RB_DATA_1_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_ERR_CNT_S 9
#define IG3_CRX_GLPE_RB_DATA_1_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_FIX_CNT_S 8
#define IG3_CRX_GLPE_RB_DATA_1_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_RSVD0_S 6
#define IG3_CRX_GLPE_RB_DATA_1_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_MASK_INT_S 5
#define IG3_CRX_GLPE_RB_DATA_1_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_LS_BYPASS_S 4
#define IG3_CRX_GLPE_RB_DATA_1_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_LS_FORCE_S 3
#define IG3_CRX_GLPE_RB_DATA_1_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_ECC_INVERT_2_S 2
#define IG3_CRX_GLPE_RB_DATA_1_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_ECC_INVERT_1_S 1
#define IG3_CRX_GLPE_RB_DATA_1_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_1_CFG_ECC_EN_S 0
#define IG3_CRX_GLPE_RB_DATA_1_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_1_STATUS 0x424008F8
#define IG3_CRX_GLPE_RB_DATA_1_STATUS_RSVD1_S 30
#define IG3_CRX_GLPE_RB_DATA_1_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CRX_GLPE_RB_DATA_1_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CRX_GLPE_RB_DATA_1_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CRX_GLPE_RB_DATA_1_STATUS_RSVD0_S 4
#define IG3_CRX_GLPE_RB_DATA_1_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CRX_GLPE_RB_DATA_1_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CRX_GLPE_RB_DATA_1_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_1_STATUS_INIT_DONE_S 2
#define IG3_CRX_GLPE_RB_DATA_1_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_1_STATUS_ECC_FIX_S 1
#define IG3_CRX_GLPE_RB_DATA_1_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_DATA_1_STATUS_ECC_ERR_S 0
#define IG3_CRX_GLPE_RB_DATA_1_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG 0x424008FC
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_ECC_INST_NUM_S 25
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_RSVD3_S 20
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_RM_S 16
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_RSVD2_S 14
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_POWER_GATE_EN_S 13
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_RME_S 12
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_RME_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_RSVD1_S 10
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_ERR_CNT_S 9
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_FIX_CNT_S 8
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_RSVD0_S 6
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_MASK_INT_S 5
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_LS_BYPASS_S 4
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_LS_FORCE_S 3
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_ECC_INVERT_2_S 2
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_ECC_INVERT_1_S 1
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_ECC_EN_S 0
#define IG3_CRX_GLPE_RB_METADATA_0_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS 0x42400900
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS_RSVD1_S 30
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS_RSVD0_S 4
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS_INIT_DONE_S 2
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS_ECC_FIX_S 1
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS_ECC_ERR_S 0
#define IG3_CRX_GLPE_RB_METADATA_0_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG 0x42400904
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_ECC_INST_NUM_S 25
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_RSVD3_S 20
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_RM_S 16
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_RM GENMASK_ULL(16, 19)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_RSVD2_S 14
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_POWER_GATE_EN_S 13
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_RME_S 12
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_RME_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_RSVD1_S 10
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_ERR_CNT_S 9
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_FIX_CNT_S 8
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_RSVD0_S 6
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_MASK_INT_S 5
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_LS_BYPASS_S 4
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_LS_FORCE_S 3
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_ECC_INVERT_2_S 2
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_ECC_INVERT_1_S 1
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_ECC_EN_S 0
#define IG3_CRX_GLPE_RB_METADATA_1_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS 0x42400908
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS_RSVD1_S 30
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS_RSVD0_S 4
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS_INIT_DONE_S 2
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS_ECC_FIX_S 1
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS_ECC_ERR_S 0
#define IG3_CRX_GLPE_RB_METADATA_1_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_CRX_GLPE_RB_TOTAL_CREDIT_LIMIT 0x42400860
#define IG3_CRX_GLPE_RB_TOTAL_CREDIT_LIMIT_RSVD_S 22
#define IG3_CRX_GLPE_RB_TOTAL_CREDIT_LIMIT_RSVD GENMASK_ULL(22, 31)
#define IG3_CRX_GLPE_RB_TOTAL_CREDIT_LIMIT_TOTAL_SHARED_S 11
#define IG3_CRX_GLPE_RB_TOTAL_CREDIT_LIMIT_TOTAL_SHARED GENMASK_ULL(11, 21)
#define IG3_CRX_GLPE_RB_TOTAL_CREDIT_LIMIT_TOTAL_CREDIT_S 0
#define IG3_CRX_GLPE_RB_TOTAL_CREDIT_LIMIT_TOTAL_CREDIT GENMASK_ULL(0, 10)
#define IG3_CRX_GLPE_RB_TOTAL_CREDIT_USED 0x42400878
#define IG3_CRX_GLPE_RB_TOTAL_CREDIT_USED_RSVD_S 22
#define IG3_CRX_GLPE_RB_TOTAL_CREDIT_USED_RSVD GENMASK_ULL(22, 31)
#define IG3_CRX_GLPE_RB_TOTAL_CREDIT_USED_TOTAL_SHARED_S 11
#define IG3_CRX_GLPE_RB_TOTAL_CREDIT_USED_TOTAL_SHARED GENMASK_ULL(11, 21)
#define IG3_CRX_GLPE_RB_TOTAL_CREDIT_USED_TOTAL_DEDICATED_S 0
#define IG3_CRX_GLPE_RB_TOTAL_CREDIT_USED_TOTAL_DEDICATED GENMASK_ULL(0, 10)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_CRED(_i) (0x424837C0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_CRED_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_CRED_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_CRED_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_CRED_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_CRED_COUNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_HW(_i) (0x42483880 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_HW_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_HW_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_HW_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_HW_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_HW_THRESH GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_LW(_i) (0x42483940 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_LW_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_LW_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_LW_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_LW_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_BUF_LW_THRESH GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_CRED(_i) (0x424837A0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_CRED_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_CRED_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_CRED_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_CRED_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_CRED_COUNT GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_HW(_i) (0x42483860 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_HW_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_HW_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_HW_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_HW_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_HW_THRESH GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_LW(_i) (0x42483920 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_LW_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_LW_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_LW_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_LW_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_RX_PKT_LW_THRESH GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_CRED(_i) (0x42483780 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_CRED_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_CRED_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_CRED_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_CRED_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_CRED_COUNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_HW(_i) (0x42483840 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_HW_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_HW_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_HW_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_HW_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_HW_THRESH GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_LW(_i) (0x42483900 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_LW_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_LW_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_LW_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_LW_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_BUF_LW_THRESH GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_CRED(_i) (0x42483760 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_CRED_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_CRED_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_CRED_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_CRED_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_CRED_COUNT GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_HW(_i) (0x42483820 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_HW_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_HW_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_HW_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_HW_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_HW_THRESH GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_LW(_i) (0x424838E0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_LW_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_LW_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_LW_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_LW_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_REQ_TX_PKT_LW_THRESH GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_CRED(_i) (0x42483740 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_CRED_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_CRED_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_CRED_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_CRED_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_CRED_COUNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_HW(_i) (0x42483800 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_HW_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_HW_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_HW_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_HW_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_HW_THRESH GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_LW(_i) (0x424838C0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_LW_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_LW_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_LW_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_LW_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_BUF_LW_THRESH GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_CRED(_i) (0x42483720 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_CRED_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_CRED_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_CRED_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_CRED_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_CRED_COUNT GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_HW(_i) (0x424837E0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_HW_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_HW_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_HW_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_HW_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_HW_THRESH GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_LW(_i) (0x424838A0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_LW_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_LW_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_LW_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_LW_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_HOST_RSP_TX_PKT_LW_THRESH GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC 0x4248B0C4
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC_REQ_BUF_CREDIT_RX_S 21
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC_REQ_BUF_CREDIT_RX GENMASK_ULL(21, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC_RSVD3_S 19
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC_RSVD3 GENMASK_ULL(19, 20)
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC_REQ_PKT_CREDIT_RX_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC_REQ_PKT_CREDIT_RX GENMASK_ULL(16, 18)
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC_RSVD2_S 13
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC_RSVD2 GENMASK_ULL(13, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC_REQ_BUF_CREDIT_TX_S 8
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC_REQ_BUF_CREDIT_TX GENMASK_ULL(8, 12)
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC_RSVD1_S 3
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC_RSVD1 GENMASK_ULL(3, 7)
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC_REQ_PKT_CREDIT_TX_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_PUSH_REQ_ALLOC_REQ_PKT_CREDIT_TX GENMASK_ULL(0, 2)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_BUF_HW_PROFILE(_i) (0x4248B050 + ((_i) * 4)) /* _i=0...3 */
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_BUF_HW_PROFILE_MAX_INDEX_I 3
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_BUF_HW_PROFILE_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_BUF_HW_PROFILE_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_BUF_HW_PROFILE_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_BUF_HW_PROFILE_THRESH GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_BUF_LW_PROFILE(_i) (0x4248B0B0 + ((_i) * 4)) /* _i=0...3 */
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_BUF_LW_PROFILE_MAX_INDEX_I 3
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_BUF_LW_PROFILE_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_BUF_LW_PROFILE_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_BUF_LW_PROFILE_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_BUF_LW_PROFILE_THRESH GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_PKT_HW_PROFILE(_i) (0x4248B040 + ((_i) * 4)) /* _i=0...3 */
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_PKT_HW_PROFILE_MAX_INDEX_I 3
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_PKT_HW_PROFILE_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_PKT_HW_PROFILE_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_PKT_HW_PROFILE_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_PKT_HW_PROFILE_THRESH GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_PKT_LW_PROFILE(_i) (0x4248B0A0 + ((_i) * 4)) /* _i=0...3 */
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_PKT_LW_PROFILE_MAX_INDEX_I 3
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_PKT_LW_PROFILE_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_PKT_LW_PROFILE_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_PKT_LW_PROFILE_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_RX_PKT_LW_PROFILE_THRESH GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_BUF_HW_PROFILE(_i) (0x4248B030 + ((_i) * 4)) /* _i=0...3 */
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_BUF_HW_PROFILE_MAX_INDEX_I 3
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_BUF_HW_PROFILE_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_BUF_HW_PROFILE_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_BUF_HW_PROFILE_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_BUF_HW_PROFILE_THRESH GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_BUF_LW_PROFILE(_i) (0x4248B090 + ((_i) * 4)) /* _i=0...3 */
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_BUF_LW_PROFILE_MAX_INDEX_I 3
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_BUF_LW_PROFILE_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_BUF_LW_PROFILE_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_BUF_LW_PROFILE_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_BUF_LW_PROFILE_THRESH GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_PKT_HW_PROFILE(_i) (0x4248B020 + ((_i) * 4)) /* _i=0...3 */
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_PKT_HW_PROFILE_MAX_INDEX_I 3
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_PKT_HW_PROFILE_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_PKT_HW_PROFILE_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_PKT_HW_PROFILE_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_PKT_HW_PROFILE_THRESH GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_PKT_LW_PROFILE(_i) (0x4248B080 + ((_i) * 4)) /* _i=0...3 */
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_PKT_LW_PROFILE_MAX_INDEX_I 3
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_PKT_LW_PROFILE_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_PKT_LW_PROFILE_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_PKT_LW_PROFILE_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_REQ_TX_PKT_LW_PROFILE_THRESH GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_BUF_HW_PROFILE(_i) (0x4248B010 + ((_i) * 4)) /* _i=0...3 */
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_BUF_HW_PROFILE_MAX_INDEX_I 3
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_BUF_HW_PROFILE_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_BUF_HW_PROFILE_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_BUF_HW_PROFILE_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_BUF_HW_PROFILE_THRESH GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_BUF_LW_PROFILE(_i) (0x4248B070 + ((_i) * 4)) /* _i=0...3 */
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_BUF_LW_PROFILE_MAX_INDEX_I 3
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_BUF_LW_PROFILE_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_BUF_LW_PROFILE_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_BUF_LW_PROFILE_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_BUF_LW_PROFILE_THRESH GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_PKT_HW_PROFILE(_i) (0x4248B000 + ((_i) * 4)) /* _i=0...3 */
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_PKT_HW_PROFILE_MAX_INDEX_I 3
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_PKT_HW_PROFILE_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_PKT_HW_PROFILE_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_PKT_HW_PROFILE_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_PKT_HW_PROFILE_THRESH GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_PKT_LW_PROFILE(_i) (0x4248B060 + ((_i) * 4)) /* _i=0...3 */
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_PKT_LW_PROFILE_MAX_INDEX_I 3
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_PKT_LW_PROFILE_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_PKT_LW_PROFILE_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_PKT_LW_PROFILE_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_RSP_TX_PKT_LW_PROFILE_THRESH GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC 0x4248B0C0
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC_REQ_BUF_CREDIT_RX_S 21
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC_REQ_BUF_CREDIT_RX GENMASK_ULL(21, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC_RSVD3_S 20
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC_RSVD3_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC_REQ_PKT_CREDIT_RX_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC_REQ_PKT_CREDIT_RX GENMASK_ULL(16, 19)
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC_RSVD2_S 13
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC_RSVD2 GENMASK_ULL(13, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC_REQ_BUF_CREDIT_TX_S 8
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC_REQ_BUF_CREDIT_TX GENMASK_ULL(8, 12)
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC_RSVD1_S 4
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC_RSVD1 GENMASK_ULL(4, 7)
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC_REQ_PKT_CREDIT_TX_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_REQ_ALLOC_REQ_PKT_CREDIT_TX GENMASK_ULL(0, 3)
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_RSP_ALLOC 0x4248B0C8
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_RSP_ALLOC_RSVD2_S 13
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_RSP_ALLOC_RSVD2 GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_RSP_ALLOC_RSP_BUF_CREDIT_TX_S 8
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_RSP_ALLOC_RSP_BUF_CREDIT_TX GENMASK_ULL(8, 12)
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_RSP_ALLOC_RSVD1_S 4
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_RSP_ALLOC_RSVD1 GENMASK_ULL(4, 7)
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_RSP_ALLOC_RSP_PKT_CREDIT_TX_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_TSCD_RSP_ALLOC_RSP_PKT_CREDIT_TX GENMASK_ULL(0, 3)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG 0x4248B200
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_RSVD3_S 20
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_RM_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_RSVD2_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_RME_S 12
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_RSVD1_S 10
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_ERR_CNT_S 9
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_FIX_CNT_S 8
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_RSVD0_S 6
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_MASK_INT_S 5
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_LS_BYPASS_S 4
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_LS_FORCE_S 3
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_ECC_EN_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS 0x4248B204
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS_RSVD1_S 30
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS_RSVD0_S 4
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS_INIT_DONE_S 2
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS_ECC_FIX_S 1
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS_ECC_ERR_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_VF_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_PROFILE(_i) (0x4248A000 + ((_i) * 4)) /* _i=0...1023 */
#define IG3_PEPM_GLPE_PEPM_CRT_VF_PROFILE_MAX_INDEX_I 1023
#define IG3_PEPM_GLPE_PEPM_CRT_VF_PROFILE_RSVD_S 2
#define IG3_PEPM_GLPE_PEPM_CRT_VF_PROFILE_RSVD GENMASK_ULL(2, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_PROFILE_PROFILE_ID_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_VF_PROFILE_PROFILE_ID GENMASK_ULL(0, 1)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_RX_BUF_CRED(_i) (0x42489000 + ((_i) * 4)) /* _i=0...1023 */
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_RX_BUF_CRED_MAX_INDEX_I 1023
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_RX_BUF_CRED_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_RX_BUF_CRED_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_RX_BUF_CRED_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_RX_BUF_CRED_COUNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_RX_PKT_CRED(_i) (0x42488000 + ((_i) * 4)) /* _i=0...1023 */
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_RX_PKT_CRED_MAX_INDEX_I 1023
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_RX_PKT_CRED_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_RX_PKT_CRED_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_RX_PKT_CRED_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_RX_PKT_CRED_COUNT GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_TX_BUF_CRED(_i) (0x42487000 + ((_i) * 4)) /* _i=0...1023 */
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_TX_BUF_CRED_MAX_INDEX_I 1023
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_TX_BUF_CRED_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_TX_BUF_CRED_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_TX_BUF_CRED_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_TX_BUF_CRED_COUNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_TX_PKT_CRED(_i) (0x42486000 + ((_i) * 4)) /* _i=0...1023 */
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_TX_PKT_CRED_MAX_INDEX_I 1023
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_TX_PKT_CRED_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_TX_PKT_CRED_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_TX_PKT_CRED_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_VF_REQ_TX_PKT_CRED_COUNT GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_RSP_TX_BUF_CRED(_i) (0x42485000 + ((_i) * 4)) /* _i=0...1023 */
#define IG3_PEPM_GLPE_PEPM_CRT_VF_RSP_TX_BUF_CRED_MAX_INDEX_I 1023
#define IG3_PEPM_GLPE_PEPM_CRT_VF_RSP_TX_BUF_CRED_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CRT_VF_RSP_TX_BUF_CRED_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_RSP_TX_BUF_CRED_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_VF_RSP_TX_BUF_CRED_COUNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_RSP_TX_PKT_CRED(_i) (0x42484000 + ((_i) * 4)) /* _i=0...1023 */
#define IG3_PEPM_GLPE_PEPM_CRT_VF_RSP_TX_PKT_CRED_MAX_INDEX_I 1023
#define IG3_PEPM_GLPE_PEPM_CRT_VF_RSP_TX_PKT_CRED_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_CRT_VF_RSP_TX_PKT_CRED_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_CRT_VF_RSP_TX_PKT_CRED_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_CRT_VF_RSP_TX_PKT_CRED_COUNT GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_CSR_CNT_HI 0x4248B160
#define IG3_PEPM_GLPE_PEPM_CSR_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_CSR_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_CSR_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_CSR_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_CSR_CNT_LO 0x4248B164
#define IG3_PEPM_GLPE_PEPM_CSR_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_CSR_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_CTRL 0x42480000
#define IG3_PEPM_GLPE_PEPM_CTRL_PEPM_IDLE_S 31
#define IG3_PEPM_GLPE_PEPM_CTRL_PEPM_IDLE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CTRL_RSVD2_S 24
#define IG3_PEPM_GLPE_PEPM_CTRL_RSVD2 GENMASK_ULL(24, 30)
#define IG3_PEPM_GLPE_PEPM_CTRL_PEPM_PUSH_MARGIN_S 16
#define IG3_PEPM_GLPE_PEPM_CTRL_PEPM_PUSH_MARGIN GENMASK_ULL(16, 23)
#define IG3_PEPM_GLPE_PEPM_CTRL_RSVD1_S 9
#define IG3_PEPM_GLPE_PEPM_CTRL_RSVD1 GENMASK_ULL(9, 15)
#define IG3_PEPM_GLPE_PEPM_CTRL_PEPM_HALT_S 8
#define IG3_PEPM_GLPE_PEPM_CTRL_PEPM_HALT_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CTRL_RSVD0_S 4
#define IG3_PEPM_GLPE_PEPM_CTRL_RSVD0 GENMASK_ULL(4, 7)
#define IG3_PEPM_GLPE_PEPM_CTRL_PEPM_TS_UPDATE_S 3
#define IG3_PEPM_GLPE_PEPM_CTRL_PEPM_TS_UPDATE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_CTRL_PEPM_MODE_S 1
#define IG3_PEPM_GLPE_PEPM_CTRL_PEPM_MODE GENMASK_ULL(1, 2)
#define IG3_PEPM_GLPE_PEPM_CTRL_PEPM_ENABLE_S 0
#define IG3_PEPM_GLPE_PEPM_CTRL_PEPM_ENABLE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DEALLOC_CNT_HI 0x4248B148
#define IG3_PEPM_GLPE_PEPM_DEALLOC_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_DEALLOC_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_DEALLOC_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_DEALLOC_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_DEALLOC_CNT_LO 0x4248B14C
#define IG3_PEPM_GLPE_PEPM_DEALLOC_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_DEALLOC_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_COUNT 0x4248B1B8
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_CMD 0x4248B1CC
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_DATA_H 0x4248B1D8
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_DATA_L 0x4248B1D4
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_PTR 0x4248B1D0
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_CMD 0x4248B1BC
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_DATA_H 0x4248B1C8
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_DATA_L 0x4248B1C4
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_PTR 0x4248B1C0
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL 0x4248B180
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_RSVD1_S 25
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_RSVD2_S 17
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_RSVD3_S 9
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_BYPASS_S 8
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_RSVD4_S 1
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_ECC_COR_ERR 0x4248B1E8
#define IG3_PEPM_GLPE_PEPM_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_PEPM_GLPE_PEPM_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PEPM_GLPE_PEPM_DTM_ECC_UNCOR_ERR 0x4248B1E4
#define IG3_PEPM_GLPE_PEPM_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_PEPM_GLPE_PEPM_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PEPM_GLPE_PEPM_DTM_GROUP_CFG 0x4248B18C
#define IG3_PEPM_GLPE_PEPM_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_PEPM_GLPE_PEPM_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_PEPM_GLPE_PEPM_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_PEPM_GLPE_PEPM_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_PEPM_GLPE_PEPM_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_PEPM_GLPE_PEPM_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_PEPM_GLPE_PEPM_DTM_LOG_CFG 0x4248B190
#define IG3_PEPM_GLPE_PEPM_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_PEPM_GLPE_PEPM_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_LOG_CFG_RSVD1_S 2
#define IG3_PEPM_GLPE_PEPM_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_PEPM_GLPE_PEPM_DTM_LOG_CFG_MODE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_PEPM_GLPE_PEPM_DTM_LOG_MASK 0x4248B198
#define IG3_PEPM_GLPE_PEPM_DTM_LOG_MASK_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_LOG_PATTERN 0x4248B194
#define IG3_PEPM_GLPE_PEPM_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_CFG 0x4248B184
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_STS 0x4248B188
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_STS_RSVD1_S 9
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_STS_RSVD2_S 1
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TIMESTAMP 0x4248B1B0
#define IG3_PEPM_GLPE_PEPM_DTM_TIMESTAMP_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_TIMESTAMP_ROLLOVER 0x4248B1B4
#define IG3_PEPM_GLPE_PEPM_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG 0x4248B1DC
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS 0x4248B1E0
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_CFG 0x4248B19C
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_CFG_MODE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_COUNT 0x4248B1A8
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_MASK 0x4248B1A4
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_MASK_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_PATTERN 0x4248B1A0
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_TIMESTAMP 0x4248B1AC
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_PEPM_GLPE_PEPM_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_ECC_COR_ERR 0x4248B214
#define IG3_PEPM_GLPE_PEPM_ECC_COR_ERR_RSVD_S 12
#define IG3_PEPM_GLPE_PEPM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PEPM_GLPE_PEPM_ECC_COR_ERR_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PEPM_GLPE_PEPM_ECC_UNCOR_ERR 0x4248B210
#define IG3_PEPM_GLPE_PEPM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_PEPM_GLPE_PEPM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PEPM_GLPE_PEPM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PEPM_GLPE_PEPM_ERLID_CNT_HI 0x4248B108
#define IG3_PEPM_GLPE_PEPM_ERLID_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_ERLID_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_ERLID_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_ERLID_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_ERLID_CNT_LO 0x4248B10C
#define IG3_PEPM_GLPE_PEPM_ERLID_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_ERLID_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_ERLID_QUANTA_TX_ALLOC 0x4248B0CC
#define IG3_PEPM_GLPE_PEPM_ERLID_QUANTA_TX_ALLOC_RSVD2_S 30
#define IG3_PEPM_GLPE_PEPM_ERLID_QUANTA_TX_ALLOC_RSVD2 GENMASK_ULL(30, 31)
#define IG3_PEPM_GLPE_PEPM_ERLID_QUANTA_TX_ALLOC_RSP_ERLID_ALLOC_SIZE_S 16
#define IG3_PEPM_GLPE_PEPM_ERLID_QUANTA_TX_ALLOC_RSP_ERLID_ALLOC_SIZE GENMASK_ULL(16, 29)
#define IG3_PEPM_GLPE_PEPM_ERLID_QUANTA_TX_ALLOC_RSVD1_S 14
#define IG3_PEPM_GLPE_PEPM_ERLID_QUANTA_TX_ALLOC_RSVD1 GENMASK_ULL(14, 15)
#define IG3_PEPM_GLPE_PEPM_ERLID_QUANTA_TX_ALLOC_REQ_ERLID_ALLOC_SIZE_S 0
#define IG3_PEPM_GLPE_PEPM_ERLID_QUANTA_TX_ALLOC_REQ_ERLID_ALLOC_SIZE GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_ERLID_QUANTA_TX_PUSH 0x4248B0D0
#define IG3_PEPM_GLPE_PEPM_ERLID_QUANTA_TX_PUSH_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_ERLID_QUANTA_TX_PUSH_RSVD GENMASK_ULL(14, 31)
#define IG3_PEPM_GLPE_PEPM_ERLID_QUANTA_TX_PUSH_PUSH_ERLID_ALLOC_SIZE_S 0
#define IG3_PEPM_GLPE_PEPM_ERLID_QUANTA_TX_PUSH_PUSH_ERLID_ALLOC_SIZE GENMASK_ULL(0, 13)
#define IG3_PEPM_GLPE_PEPM_ERR_MSK 0x4248B174
#define IG3_PEPM_GLPE_PEPM_ERR_MSK_MASK_S 0
#define IG3_PEPM_GLPE_PEPM_ERR_MSK_MASK GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC 0x4248B178
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_RSVD_S 30
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_RSVD GENMASK_ULL(30, 31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_BUF_CNTR_FTZ_S 29
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_BUF_CNTR_FTZ_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_PKT_CNTR_FTZ_S 28
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_PKT_CNTR_FTZ_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_VMIF_FIFO_OVF_S 27
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_VMIF_FIFO_OVF_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_VMIF_FIFO_UDF_S 26
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_VMIF_FIFO_UDF_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_TS_UPDATE_FIFO_OVF_S 25
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_TS_UPDATE_FIFO_OVF_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_TS_UPDATE_FIFO_UDF_S 24
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_TS_UPDATE_FIFO_UDF_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_DEALLOC_FIFO_OVF_S 23
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_DEALLOC_FIFO_OVF_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_DEALLOC_FIFO_UDF_S 22
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_DEALLOC_FIFO_UDF_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_TSIF_RSP_FIFO_UDF_S 21
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_TSIF_RSP_FIFO_UDF_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_TSIF_REQ_FIFO_UDF_S 20
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_TSIF_REQ_FIFO_UDF_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_TSIF_RSP_FIFO_OVF_S 19
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_TSIF_RSP_FIFO_OVF_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_TSIF_REQ_FIFO_OVF_S 18
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_TSIF_REQ_FIFO_OVF_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_VMRL_DRP_TXBW_ERR_S 17
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_VMRL_DRP_TXBW_ERR_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_VMRL_DRP_TRANS_ERR_S 16
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_VMRL_DRP_TRANS_ERR_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_ERL_CAM_VMISS_S 15
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_ERL_CAM_VMISS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_ERL_CAM_MISS_S 14
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_ERL_CAM_MISS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_ERL_CAM_ALIGN_ERR_S 13
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_ERL_CAM_ALIGN_ERR_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_VF_CAM_VMISS_S 12
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_VF_CAM_VMISS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_VF_CAM_MISS_S 11
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_VF_CAM_MISS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_VF_CAM_ALIGN_ERR_S 10
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_VF_CAM_ALIGN_ERR_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_HOST_CAM_VMISS_S 9
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_HOST_CAM_VMISS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_HOST_CAM_MISS_S 8
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_HOST_CAM_MISS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_HOST_CAM_ALIGN_ERR_S 7
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_HOST_CAM_ALIGN_ERR_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_UNEXPECTED_ARB_TRAN_S 6
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_UNEXPECTED_ARB_TRAN_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_DISABLED_W_ACT_REQS_S 5
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_DISABLED_W_ACT_REQS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_UNEXPECTED_PROTOCOL_S 4
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_UNEXPECTED_PROTOCOL_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_POP_NO_PROTO_VLD_S 3
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_POP_NO_PROTO_VLD_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_POP_NO_READ_VLD_S 2
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_POP_NO_READ_VLD_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_PROTO_VLD_NO_POP_S 1
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_PROTO_VLD_NO_POP_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_READ_VLD_NO_POP_S 0
#define IG3_PEPM_GLPE_PEPM_ERR_SRC_READ_VLD_NO_POP_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_ERR_STS 0x4248B170
#define IG3_PEPM_GLPE_PEPM_ERR_STS_ERR_S 0
#define IG3_PEPM_GLPE_PEPM_ERR_STS_ERR GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_FCG_MAP(_i) (0x42480800 + ((_i) * 4)) /* _i=0...2175 */
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_MAX_INDEX_I 2175
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_VALID_S 31
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_VALID_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_RSVD1_S 30
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_RSVD1_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_LLTC_S 29
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_LLTC_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_CGD_S 23
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_CGD GENMASK_ULL(23, 28)
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_VF_S 13
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_VF GENMASK_ULL(13, 22)
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_HOST_S 10
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_HOST GENMASK_ULL(10, 12)
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_ERLID_S 0
#define IG3_PEPM_GLPE_PEPM_FCG_MAP_ERLID GENMASK_ULL(0, 9)
#define IG3_PEPM_GLPE_PEPM_FREE_CNT_HI 0x4248B168
#define IG3_PEPM_GLPE_PEPM_FREE_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_FREE_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_FREE_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_FREE_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_FREE_CNT_LO 0x4248B16C
#define IG3_PEPM_GLPE_PEPM_FREE_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_FREE_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_FUNC_CNT_HI 0x4248B0E8
#define IG3_PEPM_GLPE_PEPM_FUNC_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_FUNC_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_FUNC_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_FUNC_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_FUNC_CNT_LO 0x4248B0EC
#define IG3_PEPM_GLPE_PEPM_FUNC_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_FUNC_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_GLOBAL_CNT_HI 0x4248B120
#define IG3_PEPM_GLPE_PEPM_GLOBAL_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_GLOBAL_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_GLOBAL_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_GLOBAL_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_GLOBAL_CNT_LO 0x4248B124
#define IG3_PEPM_GLPE_PEPM_GLOBAL_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_GLOBAL_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_HOST_CNT_HI 0x4248B0E0
#define IG3_PEPM_GLPE_PEPM_HOST_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_HOST_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_HOST_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_HOST_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_HOST_CNT_LO 0x4248B0E4
#define IG3_PEPM_GLPE_PEPM_HOST_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_HOST_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_INFLT_CNT_HI 0x4248B0F0
#define IG3_PEPM_GLPE_PEPM_INFLT_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_INFLT_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_INFLT_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_INFLT_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_INFLT_CNT_LO 0x4248B0F4
#define IG3_PEPM_GLPE_PEPM_INFLT_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_INFLT_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_LLTC_CNT_HI 0x4248B0F8
#define IG3_PEPM_GLPE_PEPM_LLTC_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_LLTC_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_LLTC_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_LLTC_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_LLTC_CNT_LO 0x4248B0FC
#define IG3_PEPM_GLPE_PEPM_LLTC_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_LLTC_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_PFC_CNT_HI 0x4248B158
#define IG3_PEPM_GLPE_PEPM_PFC_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_PFC_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_PFC_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_PFC_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_PFC_CNT_LO 0x4248B15C
#define IG3_PEPM_GLPE_PEPM_PFC_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_PFC_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_PFC_FC_CNT_HI 0x4248B118
#define IG3_PEPM_GLPE_PEPM_PFC_FC_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_PFC_FC_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_PFC_FC_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_PFC_FC_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_PFC_FC_CNT_LO 0x4248B11C
#define IG3_PEPM_GLPE_PEPM_PFC_FC_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_PFC_FC_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1 0x4248B0D4
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_RSVD2_S 30
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_RSVD2 GENMASK_ULL(30, 31)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_ERLID_SEL_S 20
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_ERLID_SEL GENMASK_ULL(20, 29)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_VF_SEL_S 8
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_VF_SEL GENMASK_ULL(8, 19)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_RSVD1_S 7
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_RSVD1_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_HOST_SEL_S 4
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_HOST_SEL GENMASK_ULL(4, 6)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_GLOBAL_SEL_S 2
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_GLOBAL_SEL GENMASK_ULL(2, 3)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_START_CNTS_S 1
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_START_CNTS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_CLEAR_CNTS_S 0
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL1_CLEAR_CNTS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2 0x4248B0D8
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_RSVD1_S 30
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_ICQ_PORT_S 28
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_ICQ_PORT GENMASK_ULL(28, 29)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_ICQ_TC_S 25
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_ICQ_TC GENMASK_ULL(25, 27)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_TC_SEL_S 22
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_TC_SEL GENMASK_ULL(22, 24)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_LLTC_SEL_S 19
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_LLTC_SEL GENMASK_ULL(19, 21)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_INFLT_SEL_S 16
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_INFLT_SEL GENMASK_ULL(16, 18)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_RSVD_S 14
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_RSVD GENMASK_ULL(14, 15)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_QSET_GRP_S 12
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_QSET_GRP GENMASK_ULL(12, 13)
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_QSET_SEL_S 0
#define IG3_PEPM_GLPE_PEPM_PMON_CTRL2_QSET_SEL GENMASK_ULL(0, 11)
#define IG3_PEPM_GLPE_PEPM_PMON_SMPL 0x4248B0DC
#define IG3_PEPM_GLPE_PEPM_PMON_SMPL_SAMPLE_CLKS_S 0
#define IG3_PEPM_GLPE_PEPM_PMON_SMPL_SAMPLE_CLKS GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_PUSH_CNT_HI 0x4248B140
#define IG3_PEPM_GLPE_PEPM_PUSH_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_PUSH_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_PUSH_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_PUSH_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_PUSH_CNT_LO 0x4248B144
#define IG3_PEPM_GLPE_PEPM_PUSH_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_PUSH_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_PUSH_NAK_CNT_HI 0x4248B130
#define IG3_PEPM_GLPE_PEPM_PUSH_NAK_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_PUSH_NAK_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_PUSH_NAK_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_PUSH_NAK_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_PUSH_NAK_CNT_LO 0x4248B134
#define IG3_PEPM_GLPE_PEPM_PUSH_NAK_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_PUSH_NAK_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_QSET_CNT_HI 0x4248B110
#define IG3_PEPM_GLPE_PEPM_QSET_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_QSET_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_QSET_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_QSET_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_QSET_CNT_LO 0x4248B114
#define IG3_PEPM_GLPE_PEPM_QSET_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_QSET_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_TC_CNT_HI 0x4248B100
#define IG3_PEPM_GLPE_PEPM_TC_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_TC_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_TC_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_TC_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_TC_CNT_LO 0x4248B104
#define IG3_PEPM_GLPE_PEPM_TC_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_TC_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_TSCD_CNT_HI 0x4248B138
#define IG3_PEPM_GLPE_PEPM_TSCD_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_TSCD_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_TSCD_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_TSCD_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_TSCD_CNT_LO 0x4248B13C
#define IG3_PEPM_GLPE_PEPM_TSCD_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_TSCD_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_TSCD_NAK_CNT_HI 0x4248B128
#define IG3_PEPM_GLPE_PEPM_TSCD_NAK_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_TSCD_NAK_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_TSCD_NAK_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_TSCD_NAK_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_TSCD_NAK_CNT_LO 0x4248B12C
#define IG3_PEPM_GLPE_PEPM_TSCD_NAK_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_TSCD_NAK_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_TSUPD_CNT_HI 0x4248B150
#define IG3_PEPM_GLPE_PEPM_TSUPD_CNT_HI_RSVD_S 16
#define IG3_PEPM_GLPE_PEPM_TSUPD_CNT_HI_RSVD GENMASK_ULL(16, 31)
#define IG3_PEPM_GLPE_PEPM_TSUPD_CNT_HI_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_TSUPD_CNT_HI_CNT GENMASK_ULL(0, 15)
#define IG3_PEPM_GLPE_PEPM_TSUPD_CNT_LO 0x4248B154
#define IG3_PEPM_GLPE_PEPM_TSUPD_CNT_LO_CNT_S 0
#define IG3_PEPM_GLPE_PEPM_TSUPD_CNT_LO_CNT GENMASK_ULL(0, 31)
#define IG3_PEPM_GLPE_PEPM_TS_AGG_BYTES(_i) (0x424833C0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_AGG_BYTES_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_AGG_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_AGG_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_AGG_BYTES_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_AGG_BYTES_COUNT GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HBUF(_i) (0x424833A0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HBUF_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HBUF_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HBUF_COUNT GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HW_BYTES(_i) (0x42483400 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HW_BYTES_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HW_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HW_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HW_BYTES_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HW_BYTES_THRESH GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HW_HBUF(_i) (0x424833E0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HW_HBUF_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HW_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HW_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HW_HBUF_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_AGG_HW_HBUF_THRESH GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_AGG_LW_BYTES(_i) (0x42483440 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_AGG_LW_BYTES_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_AGG_LW_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_AGG_LW_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_AGG_LW_BYTES_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_AGG_LW_BYTES_THRESH GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_AGG_LW_HBUF(_i) (0x42483420 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_AGG_LW_HBUF_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_AGG_LW_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_AGG_LW_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_AGG_LW_HBUF_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_AGG_LW_HBUF_THRESH GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_ALLOC_BYTES 0x42483704
#define IG3_PEPM_GLPE_PEPM_TS_ALLOC_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_ALLOC_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_ALLOC_BYTES_BYTES_S 0
#define IG3_PEPM_GLPE_PEPM_TS_ALLOC_BYTES_BYTES GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_ALLOC_HBUF 0x42483700
#define IG3_PEPM_GLPE_PEPM_TS_ALLOC_HBUF_RSVD_S 4
#define IG3_PEPM_GLPE_PEPM_TS_ALLOC_HBUF_RSVD GENMASK_ULL(4, 31)
#define IG3_PEPM_GLPE_PEPM_TS_ALLOC_HBUF_CREDIT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_ALLOC_HBUF_CREDIT GENMASK_ULL(0, 3)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG 0x4248B208
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_RSVD3_S 20
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_RM_S 16
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_RSVD2_S 14
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_RME_S 12
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_RSVD1_S 10
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_ERR_CNT_S 9
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_FIX_CNT_S 8
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_RSVD0_S 6
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_MASK_INT_S 5
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_LS_BYPASS_S 4
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_LS_FORCE_S 3
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_ECC_EN_S 0
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS 0x4248B20C
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS_RSVD1_S 30
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS_RSVD0_S 4
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS_INIT_DONE_S 2
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS_ECC_FIX_S 1
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS_ECC_ERR_S 0
#define IG3_PEPM_GLPE_PEPM_TS_CGD_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PEPM_GLPE_PEPM_TS_HW_BYTES(_i) (0x42483100 + ((_i) * 4)) /* _i=0...39 */
#define IG3_PEPM_GLPE_PEPM_TS_HW_BYTES_MAX_INDEX_I 39
#define IG3_PEPM_GLPE_PEPM_TS_HW_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_HW_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_HW_BYTES_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_HW_BYTES_THRESH GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_HW_HBUF(_i) (0x42483000 + ((_i) * 4)) /* _i=0...39 */
#define IG3_PEPM_GLPE_PEPM_TS_HW_HBUF_MAX_INDEX_I 39
#define IG3_PEPM_GLPE_PEPM_TS_HW_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_HW_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_HW_HBUF_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_HW_HBUF_THRESH GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_IB_BYTES(_i) (0x42482B00 + ((_i) * 4)) /* _i=0...39 */
#define IG3_PEPM_GLPE_PEPM_TS_IB_BYTES_MAX_INDEX_I 39
#define IG3_PEPM_GLPE_PEPM_TS_IB_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_IB_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_IB_BYTES_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_IB_BYTES_COUNT GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_IB_HBUF(_i) (0x42482A00 + ((_i) * 4)) /* _i=0...39 */
#define IG3_PEPM_GLPE_PEPM_TS_IB_HBUF_MAX_INDEX_I 39
#define IG3_PEPM_GLPE_PEPM_TS_IB_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_IB_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_IB_HBUF_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_IB_HBUF_COUNT GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_IB_BYTES(_i) (0x424835C0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_IB_BYTES_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_IB_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_IB_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_IB_BYTES_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_IB_BYTES_COUNT GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_IB_HBUF(_i) (0x424835A0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_IB_HBUF_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_IB_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_IB_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_IB_HBUF_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_IB_HBUF_COUNT GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_RB_BYTES(_i) (0x42483600 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_RB_BYTES_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_RB_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_RB_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_RB_BYTES_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_RB_BYTES_COUNT GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_RB_HBUF(_i) (0x424835E0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_RB_HBUF_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_RB_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_RB_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_RB_HBUF_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_RB_HBUF_COUNT GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_WB_BYTES(_i) (0x42483640 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_WB_BYTES_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_WB_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_WB_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_WB_BYTES_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_WB_BYTES_COUNT GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_WB_HBUF(_i) (0x42483620 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_WB_HBUF_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_WB_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_WB_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_WB_HBUF_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_AGG_WB_HBUF_COUNT GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_HW_BYTES(_i) (0x42483680 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_HW_BYTES_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_HW_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_HW_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_HW_BYTES_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_HW_BYTES_THRESH GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_HW_HBUF(_i) (0x42483660 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_HW_HBUF_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_HW_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_HW_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_HW_HBUF_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_HW_HBUF_THRESH GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_LW_BYTES(_i) (0x424836C0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_LW_BYTES_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_LW_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_LW_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_LW_BYTES_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_LW_BYTES_THRESH GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_LW_HBUF(_i) (0x424836A0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_LW_HBUF_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_LW_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_LW_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_LW_HBUF_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_LW_HBUF_THRESH GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_MAP(_i) (0x424836E0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_MAP_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_MAP_RSVD_S 8
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_MAP_RSVD GENMASK_ULL(8, 31)
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_MAP_TCMAP_S 0
#define IG3_PEPM_GLPE_PEPM_TS_LLTC_MAP_TCMAP GENMASK_ULL(0, 7)
#define IG3_PEPM_GLPE_PEPM_TS_LW_BYTES(_i) (0x42483300 + ((_i) * 4)) /* _i=0...39 */
#define IG3_PEPM_GLPE_PEPM_TS_LW_BYTES_MAX_INDEX_I 39
#define IG3_PEPM_GLPE_PEPM_TS_LW_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_LW_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_LW_BYTES_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_LW_BYTES_THRESH GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_LW_HBUF(_i) (0x42483200 + ((_i) * 4)) /* _i=0...39 */
#define IG3_PEPM_GLPE_PEPM_TS_LW_HBUF_MAX_INDEX_I 39
#define IG3_PEPM_GLPE_PEPM_TS_LW_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_LW_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_LW_HBUF_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_LW_HBUF_THRESH GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_RB_BYTES(_i) (0x42482D00 + ((_i) * 4)) /* _i=0...39 */
#define IG3_PEPM_GLPE_PEPM_TS_RB_BYTES_MAX_INDEX_I 39
#define IG3_PEPM_GLPE_PEPM_TS_RB_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_RB_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_RB_BYTES_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_RB_BYTES_COUNT GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_RB_HBUF(_i) (0x42482C00 + ((_i) * 4)) /* _i=0...39 */
#define IG3_PEPM_GLPE_PEPM_TS_RB_HBUF_MAX_INDEX_I 39
#define IG3_PEPM_GLPE_PEPM_TS_RB_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_RB_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_RB_HBUF_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_RB_HBUF_COUNT GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_IB_BYTES(_i) (0x42483480 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_IB_BYTES_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_IB_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_IB_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_IB_BYTES_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_IB_BYTES_COUNT GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_IB_HBUF(_i) (0x42483460 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_IB_HBUF_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_IB_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_IB_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_IB_HBUF_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_IB_HBUF_COUNT GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_RB_BYTES(_i) (0x424834C0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_RB_BYTES_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_RB_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_RB_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_RB_BYTES_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_RB_BYTES_COUNT GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_RB_HBUF(_i) (0x424834A0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_RB_HBUF_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_RB_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_RB_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_RB_HBUF_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_RB_HBUF_COUNT GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_WB_BYTES(_i) (0x42483500 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_WB_BYTES_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_WB_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_WB_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_WB_BYTES_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_WB_BYTES_COUNT GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_WB_HBUF(_i) (0x424834E0 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_WB_HBUF_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_WB_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_WB_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_WB_HBUF_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_TC_AGG_WB_HBUF_COUNT GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_TC_HW_BYTES(_i) (0x42483540 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_TC_HW_BYTES_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_TC_HW_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_TC_HW_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_TC_HW_BYTES_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_TC_HW_BYTES_THRESH GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_TC_HW_HBUF(_i) (0x42483520 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_TC_HW_HBUF_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_TC_HW_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_TC_HW_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_TC_HW_HBUF_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_TC_HW_HBUF_THRESH GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_TC_LW_BYTES(_i) (0x42483580 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_TC_LW_BYTES_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_TC_LW_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_TC_LW_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_TC_LW_BYTES_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_TC_LW_BYTES_THRESH GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_TC_LW_HBUF(_i) (0x42483560 + ((_i) * 4)) /* _i=0...4 */
#define IG3_PEPM_GLPE_PEPM_TS_TC_LW_HBUF_MAX_INDEX_I 4
#define IG3_PEPM_GLPE_PEPM_TS_TC_LW_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_TC_LW_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_TC_LW_HBUF_THRESH_S 0
#define IG3_PEPM_GLPE_PEPM_TS_TC_LW_HBUF_THRESH GENMASK_ULL(0, 12)
#define IG3_PEPM_GLPE_PEPM_TS_WB_BYTES(_i) (0x42482F00 + ((_i) * 4)) /* _i=0...39 */
#define IG3_PEPM_GLPE_PEPM_TS_WB_BYTES_MAX_INDEX_I 39
#define IG3_PEPM_GLPE_PEPM_TS_WB_BYTES_RSVD_S 20
#define IG3_PEPM_GLPE_PEPM_TS_WB_BYTES_RSVD GENMASK_ULL(20, 31)
#define IG3_PEPM_GLPE_PEPM_TS_WB_BYTES_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_WB_BYTES_COUNT GENMASK_ULL(0, 19)
#define IG3_PEPM_GLPE_PEPM_TS_WB_HBUF(_i) (0x42482E00 + ((_i) * 4)) /* _i=0...39 */
#define IG3_PEPM_GLPE_PEPM_TS_WB_HBUF_MAX_INDEX_I 39
#define IG3_PEPM_GLPE_PEPM_TS_WB_HBUF_RSVD_S 13
#define IG3_PEPM_GLPE_PEPM_TS_WB_HBUF_RSVD GENMASK_ULL(13, 31)
#define IG3_PEPM_GLPE_PEPM_TS_WB_HBUF_COUNT_S 0
#define IG3_PEPM_GLPE_PEPM_TS_WB_HBUF_COUNT GENMASK_ULL(0, 12)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_BUS_INDEX 0x424C0290
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_BUS_INDEX_BUS_INDEX_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_BUS_INDEX_BUS_INDEX GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL 0x424C0280
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_RESERVED_31_10_S 10
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_RESERVED_31_10 GENMASK_ULL(10, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_TRIG_OP_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_TRIG_OP GENMASK_ULL(8, 9)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_VLD_RDY_FRZ_EN_S 7
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_VLD_RDY_FRZ_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_EN_I_FREEZE_S 6
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_EN_I_FREEZE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_COUNT_ONLY_TRIG_S 5
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_COUNT_ONLY_TRIG_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_READ_INPUT_BUS_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_READ_INPUT_BUS_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_EN_FRZ_ON_CNT_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_EN_FRZ_ON_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_EN_FRZ_ON_TRIG_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_EN_FRZ_ON_TRIG_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_FREEZE_RESET_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_FREEZE_RESET_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_FREEZE_SET_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_CTRL_FREEZE_SET_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_FREEZE_ON_CNT_VAL 0x424C02A0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_FREEZE_ON_CNT_VAL_FREEZE_ON_CNT_VAL GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_OBS_BUS 0x424C02C0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_OBS_BUS_OBS_BUS_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_OBS_BUS_OBS_BUS GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CNT0 0x424C02E0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CNT0_CNT0_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CNT0_CNT0 GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CNT1_0 0x424C02E8
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CNT1_0_CNT1_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CNT1_0_CNT1 GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CNT1_1 0x424C02EC
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CNT1_1_CNT1_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CNT1_1_CNT1 GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CTRL 0x424C02D8
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CTRL_RESERVED_31_16_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CTRL_RESERVED_31_16 GENMASK_ULL(16, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CTRL_PERF_WIN_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CTRL_PERF_WIN GENMASK_ULL(8, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CTRL_PERF_CNT1_CFG_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CTRL_PERF_CNT1_CFG GENMASK_ULL(4, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CTRL_PERF_CNT0_CFG_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_PERF_CTRL_PERF_CNT0_CFG GENMASK_ULL(0, 3)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_RC_CTRL 0x424C02B8
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_RC_CTRL_RESERVED_31_1_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_RC_CTRL_RESERVED_31_1 GENMASK_ULL(1, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_RC_CTRL_RC_TRIG_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_RC_CTRL_RC_TRIG_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_RC_GAP 0x424C02A8
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_RC_GAP_RC_GAP_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_RC_GAP_RC_GAP GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_RC_TRNS 0x424C02B0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_RC_TRNS_RC_TRNS_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_RC_TRNS_RC_TRNS GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS 0x424C0288
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_RESERVED_31_8_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_RESERVED_31_8 GENMASK_ULL(8, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_FREEZE_UPON_IFRZ_S 7
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_FREEZE_UPON_IFRZ_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_I_FREEZE_S 6
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_I_FREEZE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_READY_S 5
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_READY_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_VALID_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_VALID_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_FREEZE_UPON_CNT_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_FREEZE_UPON_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_FREEZE_UPON_TRIG_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_FREEZE_UPON_TRIG_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_FREEZE_SET_BY_SW_FLAG_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_FREEZE_STATUS_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_STATUS_FREEZE_STATUS_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_TRANS_CNT 0x424C0298
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_TRANS_CNT_TRANS_CNT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_TRANS_CNT_TRANS_CNT GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_TRIG_MASK 0x424C02C8
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_TRIG_MASK_TRIG_MASK_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_TRIG_MASK_TRIG_MASK GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_TRIG_VALUE 0x424C02D0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_TRIG_VALUE_TRIG_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BOB_BOB_TRIG_VALUE_TRIG_VALUE GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_DBG_CTL 0x424C024C
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_DBG_CTL_DONE_S 31
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_DBG_CTL_RD_EN_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_DBG_CTL_RSVD_S 26
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_DBG_CTL_DW_SEL_S 18
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_DBG_CTL_ADR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_DBG_DATA 0x424C0250
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_DBG_DATA_RD_DW_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG 0x424C0244
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_RSVD3_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_RM_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_RSVD2_S 14
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_RME_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_RSVD1_S 10
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_ERR_CNT_S 9
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_FIX_CNT_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_RSVD0_S 6
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_MASK_INT_S 5
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_LS_BYPASS_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_LS_FORCE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_ECC_EN_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS 0x424C0248
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS_RSVD1_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS_RSVD0_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS_INIT_DONE_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS_ECC_FIX_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS_ECC_ERR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_BRANCH_TABLE_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_COUNT 0x424C0338
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_CMD 0x424C034C
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_DATA_H 0x424C0358
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_DATA_L 0x424C0354
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_PTR 0x424C0350
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_CMD 0x424C033C
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_DATA_H 0x424C0348
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_DATA_L 0x424C0344
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_PTR 0x424C0340
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL 0x424C0300
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_RSVD1_S 25
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_RSVD2_S 17
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_RSVD3_S 9
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_BYPASS_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_RSVD4_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_ECC_COR_ERR 0x424C0368
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_ECC_UNCOR_ERR 0x424C0364
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_GROUP_CFG 0x424C030C
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_LOG_CFG 0x424C0310
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_LOG_CFG_RSVD1_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_LOG_CFG_MODE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_LOG_MASK 0x424C0318
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_LOG_MASK_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_LOG_PATTERN 0x424C0314
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_CFG 0x424C0304
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_STS 0x424C0308
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_STS_RSVD1_S 9
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_STS_RSVD2_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TIMESTAMP 0x424C0330
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TIMESTAMP_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TIMESTAMP_ROLLOVER 0x424C0334
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG 0x424C035C
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS 0x424C0360
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_CFG 0x424C031C
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_CFG_MODE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_COUNT 0x424C0328
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_MASK 0x424C0324
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_MASK_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_PATTERN 0x424C0320
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_TIMESTAMP 0x424C032C
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_ECC_COR_ERR 0x424C01F0
#define IG3_MEV_TSCD_GLPE_TSCD_ECC_COR_ERR_RSVD_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_ECC_COR_ERR_CNT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_ECC_UNCOR_ERR 0x424C01EC
#define IG3_MEV_TSCD_GLPE_TSCD_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_ECC_UNCOR_ERR_CNT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_ERRSTATREG 0x424C015C
#define IG3_MEV_TSCD_GLPE_TSCD_ERRSTATREG_RSVD_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_ERRSTATREG_RSVD GENMASK_ULL(2, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_ERRSTATREG_BRANCH_LOOP_DETECTED_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_ERRSTATREG_BRANCH_LOOP_DETECTED_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_ERRSTATREG_FWERR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_ERRSTATREG_FWERR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_FIFO_OVF_CAPTURE 0x424C01E4
#define IG3_MEV_TSCD_GLPE_TSCD_FIFO_OVF_CAPTURE_FIFO_OVF_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_FIFO_OVF_CAPTURE_FIFO_OVF GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_FIFO_UDF_CAPTURE 0x424C01E8
#define IG3_MEV_TSCD_GLPE_TSCD_FIFO_UDF_CAPTURE_FIFO_UDF_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_FIFO_UDF_CAPTURE_FIFO_UDF GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_FLR(_i) (0x424C016C + ((_i) * 4)) /* _i=0...7 */
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_MAX_INDEX_I 7
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_BUSY_S 31
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_BUSY_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_HOSTID_S 28
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_HOSTID GENMASK_ULL(28, 30)
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_VM_VF_TYPE_S 26
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_VM_VF_TYPE GENMASK_ULL(26, 27)
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_PF_NUM_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_PF_NUM GENMASK_ULL(20, 25)
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_VM_VF_NUM_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_VM_VF_NUM GENMASK_ULL(8, 19)
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_PORT_S 5
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_PORT GENMASK_ULL(5, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_RSVD0_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_FLR_RSVD0 GENMASK_ULL(0, 4)
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQHI 0x424C0168
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQHI_PMF_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQHI_PMF GENMASK_ULL(20, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQHI_RSVD_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQHI_RSVD GENMASK_ULL(0, 19)
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQLO 0x424C0164
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQLO_BUSY_S 31
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQLO_BUSY_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQLO_HOSTID_S 28
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQLO_HOSTID GENMASK_ULL(28, 30)
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQLO_VM_VF_TYPE_S 26
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQLO_VM_VF_TYPE GENMASK_ULL(26, 27)
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQLO_PF_NUM_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQLO_PF_NUM GENMASK_ULL(20, 25)
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQLO_VM_VF_NUM_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQLO_VM_VF_NUM GENMASK_ULL(8, 19)
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQLO_TAG_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_FWSYNCREQLO_TAG GENMASK_ULL(0, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDH 0x424C009C
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDH_RSVD_S 31
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDH_RSVD_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDH_VALUE_ENTRYIDX_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDH_VALUE_ENTRYIDX GENMASK_ULL(12, 30)
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDH_FLDSZ_S 7
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDH_FLDSZ GENMASK_ULL(7, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDH_FLDOFFS_NUMENTS_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDH_FLDOFFS_NUMENTS GENMASK_ULL(0, 6)
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL 0x424C0098
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL_NTROOTNODE_S 29
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL_NTROOTNODE GENMASK_ULL(29, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL_RSVD_S 28
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL_RSVD_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL_NTLEVEL_S 25
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL_NTLEVEL GENMASK_ULL(25, 27)
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL_CTRLTYPE_S 22
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL_CTRLTYPE GENMASK_ULL(22, 24)
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL_TBLENTRYIDX_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL_TBLENTRYIDX GENMASK_ULL(8, 21)
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL_TBLTYPE_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL_TBLTYPE GENMASK_ULL(4, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL_OPCODE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_IFBCMDL_OPCODE GENMASK_ULL(0, 3)
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL 0x424C00A4
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_PATHMASKCLRCNT_S 24
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_PATHMASKCLRCNT GENMASK_ULL(24, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_NWATIMER_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_NWATIMER GENMASK_ULL(16, 23)
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_RSVD_S 9
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_RSVD GENMASK_ULL(9, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_IOQDEPTH1_EN_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_IOQDEPTH1_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_NODE_SCAN_EN_S 7
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_NODE_SCAN_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_ISSUE_FILTER_EN_S 6
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_ISSUE_FILTER_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_NODE_HIERARCHY_EN_S 5
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_NODE_HIERARCHY_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_QSET_DIRECT_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_QSET_DIRECT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_SCH_ENA_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_SCH_ENA_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_BCMDCLRERR_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_BCMDCLRERR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_ICMDCLRERR_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_ICMDCLRERR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_BCMDDB_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_IFCTRL_BCMDDB_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFDATA(_i) (0x424C0080 + ((_i) * 4)) /* _i=0...3 */
#define IG3_MEV_TSCD_GLPE_TSCD_IFDATA_MAX_INDEX_I 3
#define IG3_MEV_TSCD_GLPE_TSCD_IFDATA_TSCDIFDATA_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_IFDATA_TSCDIFDATA GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFDATA_INFO 0x424C0000
#define IG3_MEV_TSCD_GLPE_TSCD_IFDATA_INFO_RSVD_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_IFDATA_INFO_RSVD GENMASK_ULL(8, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFDATA_INFO_NUM_IFDATA_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_IFDATA_INFO_NUM_IFDATA GENMASK_ULL(0, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDH 0x424C0094
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDH_RSVD_S 31
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDH_RSVD_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDH_VALUE_ENTRYIDX_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDH_VALUE_ENTRYIDX GENMASK_ULL(12, 30)
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDH_FLDSZ_S 7
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDH_FLDSZ GENMASK_ULL(7, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDH_FLDOFFS_NUMENTS_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDH_FLDOFFS_NUMENTS GENMASK_ULL(0, 6)
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL 0x424C0090
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL_NTROOTNODE_S 29
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL_NTROOTNODE GENMASK_ULL(29, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL_RSVD_S 28
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL_RSVD_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL_NTLEVEL_S 25
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL_NTLEVEL GENMASK_ULL(25, 27)
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL_CTRLTYPE_S 22
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL_CTRLTYPE GENMASK_ULL(22, 24)
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL_TBLENTRYIDX_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL_TBLENTRYIDX GENMASK_ULL(8, 21)
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL_TBLTYPE_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL_TBLTYPE GENMASK_ULL(4, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL_OPCODE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_IFICMDL_OPCODE GENMASK_ULL(0, 3)
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS 0x424C00A0
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS_RSVD_S 11
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS_RSVD GENMASK_ULL(11, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS_SCH_IDLE_S 10
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS_SCH_IDLE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS_SCH_ENA_S 9
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS_SCH_ENA_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS_BCMDERR_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS_BCMDERR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS_ICMDERR_S 7
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS_ICMDERR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS_ICMDBZ_S 6
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS_ICMDBZ_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS_ENTRAVAIL_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_IFSTATUS_ENTRAVAIL GENMASK_ULL(0, 5)
#define IG3_MEV_TSCD_GLPE_TSCD_INCSCHEDCFGCOUNT 0x424C0158
#define IG3_MEV_TSCD_GLPE_TSCD_INCSCHEDCFGCOUNT_INCSCHEDCFGCOUNT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_INCSCHEDCFGCOUNT_INCSCHEDCFGCOUNT GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_DBG_CTL 0x424C01FC
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_DBG_CTL_DONE_S 31
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_DBG_CTL_RD_EN_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_DBG_CTL_RSVD_S 26
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_DBG_CTL_DW_SEL_S 18
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_DBG_CTL_ADR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_DBG_DATA 0x424C0200
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_DBG_DATA_RD_DW_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG 0x424C01F4
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_RSVD3_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_RM_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_RSVD2_S 14
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_RME_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_RSVD1_S 10
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_ERR_CNT_S 9
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_FIX_CNT_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_RSVD0_S 6
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_MASK_INT_S 5
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_LS_BYPASS_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_LS_FORCE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_ECC_EN_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS 0x424C01F8
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS_RSVD1_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS_RSVD0_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS_INIT_DONE_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS_ECC_FIX_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS_ECC_ERR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L3_NODE_TABLE_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_DBG_CTL 0x424C020C
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_DBG_CTL_DONE_S 31
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_DBG_CTL_RD_EN_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_DBG_CTL_RSVD_S 26
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_DBG_CTL_DW_SEL_S 18
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_DBG_CTL_ADR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_DBG_DATA 0x424C0210
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_DBG_DATA_RD_DW_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG 0x424C0204
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_RSVD3_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_RM_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_RSVD2_S 14
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_RME_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_RSVD1_S 10
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_ERR_CNT_S 9
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_FIX_CNT_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_RSVD0_S 6
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_MASK_INT_S 5
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_LS_BYPASS_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_LS_FORCE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_ECC_EN_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS 0x424C0208
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS_RSVD1_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS_RSVD0_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS_INIT_DONE_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS_ECC_FIX_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS_ECC_ERR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L4_NODE_TABLE_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_DBG_CTL 0x424C021C
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_DBG_CTL_DONE_S 31
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_DBG_CTL_RD_EN_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_DBG_CTL_RSVD_S 26
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_DBG_CTL_DW_SEL_S 18
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_DBG_CTL_ADR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_DBG_DATA 0x424C0220
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_DBG_DATA_RD_DW_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG 0x424C0214
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_RSVD3_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_RM_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_RSVD2_S 14
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_RME_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_RSVD1_S 10
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_ERR_CNT_S 9
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_FIX_CNT_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_RSVD0_S 6
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_MASK_INT_S 5
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_LS_BYPASS_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_LS_FORCE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_ECC_EN_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS 0x424C0218
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS_RSVD1_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS_RSVD0_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS_INIT_DONE_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS_ECC_FIX_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS_ECC_ERR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L5_NODE_TABLE_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_DBG_CTL 0x424C022C
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_DBG_CTL_DONE_S 31
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_DBG_CTL_RD_EN_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_DBG_CTL_RSVD_S 26
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_DBG_CTL_DW_SEL_S 18
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_DBG_CTL_ADR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_DBG_DATA 0x424C0230
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_DBG_DATA_RD_DW_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG 0x424C0224
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_RSVD3_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_RM_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_RSVD2_S 14
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_RME_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_RSVD1_S 10
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_ERR_CNT_S 9
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_FIX_CNT_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_RSVD0_S 6
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_MASK_INT_S 5
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_LS_BYPASS_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_LS_FORCE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_ECC_EN_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS 0x424C0228
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS_RSVD1_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS_RSVD0_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS_INIT_DONE_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS_ECC_FIX_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS_ECC_ERR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L6_NODE_TABLE_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_DBG_CTL 0x424C023C
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_DBG_CTL_DONE_S 31
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_DBG_CTL_RD_EN_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_DBG_CTL_RSVD_S 26
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_DBG_CTL_DW_SEL_S 18
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_DBG_CTL_ADR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_DBG_DATA 0x424C0240
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_DBG_DATA_RD_DW_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG 0x424C0234
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_RSVD3_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_RM_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_RSVD2_S 14
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_RME_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_RSVD1_S 10
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_ERR_CNT_S 9
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_FIX_CNT_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_RSVD0_S 6
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_MASK_INT_S 5
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_LS_BYPASS_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_LS_FORCE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_ECC_EN_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS 0x424C0238
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS_RSVD1_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS_RSVD0_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS_INIT_DONE_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS_ECC_FIX_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS_ECC_ERR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_L7_NODE_TABLE_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_NT_INFO 0x424C0008
#define IG3_MEV_TSCD_GLPE_TSCD_NT_INFO_MAX_RN_S 24
#define IG3_MEV_TSCD_GLPE_TSCD_NT_INFO_MAX_RN GENMASK_ULL(24, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_NT_INFO_MIN_RN_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_NT_INFO_MIN_RN GENMASK_ULL(16, 23)
#define IG3_MEV_TSCD_GLPE_TSCD_NT_INFO_MAX_LVL_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_NT_INFO_MAX_LVL GENMASK_ULL(8, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_NT_INFO_MIN_LVL_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_NT_INFO_MIN_LVL GENMASK_ULL(0, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL(_i) (0x424C002C + ((_i) * 16)) /* _i=0...0 */
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_MAX_INDEX_I 0
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_RESERVED3_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_RESERVED3 GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO0 0x424C0010
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO0_MAX_TOTAL_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO0_MAX_TOTAL GENMASK_ULL(16, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO0_MAX_PER_ROOT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO0_MAX_PER_ROOT GENMASK_ULL(0, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO1 0x424C0014
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO1_RESERVED1_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO1_RESERVED1 GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO2 0x424C0018
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO2_MAX_CHILDREN_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO2_MAX_CHILDREN GENMASK_ULL(16, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO2_CHILD_NALLOC_SIZE_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO2_CHILD_NALLOC_SIZE GENMASK_ULL(8, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO2_CHILD_ALIGNMENT_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO2_CHILD_ALIGNMENT GENMASK_ULL(4, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO2_MIN_CHILDREN_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO2_MIN_CHILDREN GENMASK_ULL(0, 3)
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO3 0x424C001C
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO3_RESERVED3_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_NT_LVL_L1_INFO3_RESERVED3 GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_PEPM 0x424C0160
#define IG3_MEV_TSCD_GLPE_TSCD_PEPM_RSVD_S 14
#define IG3_MEV_TSCD_GLPE_TSCD_PEPM_RSVD GENMASK_ULL(14, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_PEPM_QUANTA_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_PEPM_QUANTA GENMASK_ULL(0, 13)
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL(_i) (0x424C0118 + ((_i) * 4)) /* _i=0...15 */
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_MAX_INDEX_I 15
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_RSVD1_S 26
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_RSVD1 GENMASK_ULL(26, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_QSINDEX_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_QSINDEX GENMASK_ULL(16, 25)
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_RSVD0_S 13
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_RSVD0 GENMASK_ULL(13, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_TCINDEX_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_TCINDEX GENMASK_ULL(8, 12)
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_PORTINDEX_S 5
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_PORTINDEX GENMASK_ULL(5, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_RESOURCESELECT_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_RESOURCESELECT GENMASK_ULL(3, 4)
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_COUNTERTYPE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCONTROL_COUNTERTYPE GENMASK_ULL(0, 2)
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCOUNT(_i) (0x424C00D8 + ((_i) * 4)) /* _i=0...15 */
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCOUNT_MAX_INDEX_I 15
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCOUNT_PRGPERFCOUNT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_PRGPERFCOUNT_PRGPERFCOUNT GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_QST_INFO 0x424C0004
#define IG3_MEV_TSCD_GLPE_TSCD_QST_INFO_MAX_QS_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_QST_INFO_MAX_QS GENMASK_ULL(16, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_QST_INFO_MIN_QS_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_QST_INFO_MIN_QS GENMASK_ULL(0, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_DBG_CTL 0x424C025C
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_DBG_CTL_DONE_S 31
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_DBG_CTL_RD_EN_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_DBG_CTL_RSVD_S 26
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_DBG_CTL_DW_SEL_S 18
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_DBG_CTL_ADR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_DBG_DATA 0x424C0260
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_DBG_DATA_RD_DW_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG 0x424C0254
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_RSVD3_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_RM_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_RSVD2_S 14
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_RME_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_RSVD1_S 10
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_ERR_CNT_S 9
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_FIX_CNT_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_RSVD0_S 6
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_MASK_INT_S 5
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_LS_BYPASS_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_LS_FORCE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_ECC_EN_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS 0x424C0258
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS_RSVD1_S 30
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS_RSVD0_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS_INIT_DONE_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS_ECC_FIX_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS_ECC_ERR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_QUEUE_SET_TABLE_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2CMD 0x424C00AC
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2CMD_RSVD_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2CMD_RSVD GENMASK_ULL(12, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2CMD_RLMTBLIDX_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2CMD_RLMTBLIDX GENMASK_ULL(0, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2DATAHI 0x424C00D4
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2DATAHI_DATA_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2DATAHI_DATA GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2DATALO 0x424C00C8
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2DATALO_DATA_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2DATALO_DATA GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2DATAMIDHI 0x424C00D0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2DATAMIDHI_DATA_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2DATAMIDHI_DATA GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2DATAMIDLO 0x424C00CC
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2DATAMIDLO_DATA_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2DATAMIDLO_DATA GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2STATUS 0x424C00B4
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2STATUS_RSVD_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2STATUS_RSVD GENMASK_ULL(1, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2STATUS_VALID_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRD2STATUS_VALID_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDCMD 0x424C00A8
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDCMD_RSVD_S 12
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDCMD_RSVD GENMASK_ULL(12, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDCMD_RLMTBLIDX_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDCMD_RLMTBLIDX GENMASK_ULL(0, 11)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDDATAHI 0x424C00C4
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDDATAHI_DATA_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDDATAHI_DATA GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDDATALO 0x424C00B8
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDDATALO_DATA_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDDATALO_DATA GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDDATAMIDHI 0x424C00C0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDDATAMIDHI_DATA_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDDATAMIDHI_DATA GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDDATAMIDLO 0x424C00BC
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDDATAMIDLO_DATA_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDDATAMIDLO_DATA GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDSTATUS 0x424C00B0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDSTATUS_RSVD_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDSTATUS_RSVD GENMASK_ULL(1, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDSTATUS_VALID_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_RLMTBLRDSTATUS_VALID_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_CTL 0x424C018C
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_CTL_RSVD_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_CTL_RSVD GENMASK_ULL(2, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_CTL_FREERUN_TOGGLE_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_CTL_FREERUN_TOGGLE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_CTL_ONESHOT_TOGGLE_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_CTL_ONESHOT_TOGGLE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_ENTRY_OP_CNT(_i) (0x424C01CC + ((_i) * 4)) /* _i=0...1 */
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_ENTRY_OP_CNT_MAX_INDEX_I 1
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_ENTRY_OP_CNT_ENTRY_OP_CNT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_ENTRY_OP_CNT_ENTRY_OP_CNT GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_EXIT_DISPOSITION_CNT(_i) (0x424C01C4 + ((_i) * 4)) /* _i=0...1 */
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_EXIT_DISPOSITION_CNT_MAX_INDEX_I 1
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_EXIT_DISPOSITION_CNT_EXIT_DISPOSITION_CNT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_EXIT_DISPOSITION_CNT_EXIT_DISPOSITION_CNT GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_EXIT_LATENCY_HISTO_BINCNT(_i) (0x424C01A4 + ((_i) * 4)) /* _i=0...7 */
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_EXIT_LATENCY_HISTO_BINCNT_MAX_INDEX_I 7
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_EXIT_LATENCY_HISTO_BINCNT_EXITLATENCY_HISTO_BINCNT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_EXIT_LATENCY_HISTO_BINCNT_EXITLATENCY_HISTO_BINCNT GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_NWA_DONE_CNT 0x424C01D8
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_NWA_DONE_CNT_NWA_DONE_CNT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_NWA_DONE_CNT_NWA_DONE_CNT GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_PREFETCH_LOAD_CNT 0x424C01D4
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_PREFETCH_LOAD_CNT_PREFETCH_LOAD_CNT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_PREFETCH_LOAD_CNT_PREFETCH_LOAD_CNT GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_QSETS_ISSUED_CTL 0x424C01DC
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_QSETS_ISSUED_CTL_RSVD_S 7
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_QSETS_ISSUED_CTL_RSVD GENMASK_ULL(7, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_QSETS_ISSUED_CTL_QSETS_ISSUED_INDEX_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_QSETS_ISSUED_CTL_QSETS_ISSUED_INDEX GENMASK_ULL(0, 6)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_QSETS_ISSUED_DATA 0x424C01E0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_QSETS_ISSUED_DATA_QSETS_ISSUED_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_QSETS_ISSUED_DATA_QSETS_ISSUED GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS 0x424C0194
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_FREERUN_ROLLOVER_CNT_S 24
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_FREERUN_ROLLOVER_CNT GENMASK_ULL(24, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_RSVD2_S 23
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_RSVD2_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_WAMON_EDGE_ROLLOVER_S 22
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_WAMON_EDGE_ROLLOVER_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_WAMON_LVL_ROLLOVER_S 21
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_WAMON_LVL_ROLLOVER_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_PREFETCH_ROLLOVER_S 20
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_PREFETCH_ROLLOVER_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_EXIT_DISCARD_ROLLOVER_S 19
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_EXIT_DISCARD_ROLLOVER_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_EXIT_ISSUE_ROLLOVER_S 18
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_EXIT_ISSUE_ROLLOVER_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_ENTRY_NWA_ROLLOVER_S 17
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_ENTRY_NWA_ROLLOVER_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_ENTRY_WA_ROLLOVER_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_ENTRY_WA_ROLLOVER_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_RSVD1_S 8
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_RSVD1 GENMASK_ULL(8, 15)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_HISTO_BIN7_ROLLOVER_S 7
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_HISTO_BIN7_ROLLOVER_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_HISTO_BIN6_ROLLOVER_S 6
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_HISTO_BIN6_ROLLOVER_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_HISTO_BIN5_ROLLOVER_S 5
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_HISTO_BIN5_ROLLOVER_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_HISTO_BIN4_ROLLOVER_S 4
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_HISTO_BIN4_ROLLOVER_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_HISTO_BIN3_ROLLOVER_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_HISTO_BIN3_ROLLOVER_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_HISTO_BIN2_ROLLOVER_S 2
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_HISTO_BIN2_ROLLOVER_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_RSVD0_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_RSVD0_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_HISTO_BIN0_ROLLOVER_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_STATUS_HISTO_BIN0_ROLLOVER_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_TMR 0x424C0190
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_TMR_STATSTMR_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_TMR_STATSTMR GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL 0x424C0198
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL_RSVD1_S 18
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL_RSVD1 GENMASK_ULL(18, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL_FINAL_WA_EDGE_S 17
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL_FINAL_WA_EDGE_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL_WA_EDGE_VALID_S 16
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL_WA_EDGE_VALID_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL_RSVD0_S 15
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL_RSVD0_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL_WA_QSET_S 3
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL_WA_QSET GENMASK_ULL(3, 14)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL_WA_SEL_S 1
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL_WA_SEL GENMASK_ULL(1, 2)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL_WA_LVL_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_CTL_WA_LVL_M BIT_ULL(31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_EDGECNT 0x424C01A0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_EDGECNT_WA_EDGECNT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_EDGECNT_WA_EDGECNT GENMASK_ULL(0, 31)
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_LVLCNT 0x424C019C
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_LVLCNT_WA_LVLCNT_S 0
#define IG3_MEV_TSCD_GLPE_TSCD_STATS_WAMON_LVLCNT_WA_LVLCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_CNPPROCESSEDHI 0x4266E8A4
#define IG3_STATS_GLPES_CNPPROCESSEDHI_CNPPROCESSEDLO_S 0
#define IG3_STATS_GLPES_CNPPROCESSEDHI_CNPPROCESSEDLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_CNPPROCESSEDLO 0x4266E8A0
#define IG3_STATS_GLPES_CNPPROCESSEDLO_CNPPROCESSEDLO_S 0
#define IG3_STATS_GLPES_CNPPROCESSEDLO_CNPPROCESSEDLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_DUPRREQRCVDHI 0x4266E8F4
#define IG3_STATS_GLPES_DUPRREQRCVDHI_DUPRREQRCVDHI_S 0
#define IG3_STATS_GLPES_DUPRREQRCVDHI_DUPRREQRCVDHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_DUPRREQRCVDLO 0x4266E8F0
#define IG3_STATS_GLPES_DUPRREQRCVDLO_DUPRREQRCVDLO_S 0
#define IG3_STATS_GLPES_DUPRREQRCVDLO_DUPRREQRCVDLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_HMCERRCNTHI 0x4266E8FC
#define IG3_STATS_GLPES_HMCERRCNTHI_HMCERRCNTHI_S 0
#define IG3_STATS_GLPES_HMCERRCNTHI_HMCERRCNTHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_HMCERRCNTLO 0x4266E8F8
#define IG3_STATS_GLPES_HMCERRCNTLO_HMCERRCNTLO_S 0
#define IG3_STATS_GLPES_HMCERRCNTLO_HMCERRCNTLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_OOPCNTGP0HI 0x4266E884
#define IG3_STATS_GLPES_OOPCNTGP0HI_OOPGP0_S 0
#define IG3_STATS_GLPES_OOPCNTGP0HI_OOPGP0 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_OOPCNTGP0LO 0x4266E880
#define IG3_STATS_GLPES_OOPCNTGP0LO_OOPGP0_S 0
#define IG3_STATS_GLPES_OOPCNTGP0LO_OOPGP0 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_OOPCNTGP1HI 0x4266E88C
#define IG3_STATS_GLPES_OOPCNTGP1HI_OOPGP1_S 0
#define IG3_STATS_GLPES_OOPCNTGP1HI_OOPGP1 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_OOPCNTGP1LO 0x4266E888
#define IG3_STATS_GLPES_OOPCNTGP1LO_OOPGP1_S 0
#define IG3_STATS_GLPES_OOPCNTGP1LO_OOPGP1 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_OOPCNTGP2HI 0x4266E894
#define IG3_STATS_GLPES_OOPCNTGP2HI_OOPGP2_S 0
#define IG3_STATS_GLPES_OOPCNTGP2HI_OOPGP2 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_OOPCNTGP2LO 0x4266E890
#define IG3_STATS_GLPES_OOPCNTGP2LO_OOPGP2_S 0
#define IG3_STATS_GLPES_OOPCNTGP2LO_OOPGP2 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_OOPCNTGP3HI 0x4266E89C
#define IG3_STATS_GLPES_OOPCNTGP3HI_OOPGP3_S 0
#define IG3_STATS_GLPES_OOPCNTGP3HI_OOPGP3 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_OOPCNTGP3LO 0x4266E898
#define IG3_STATS_GLPES_OOPCNTGP3LO_OOPGP3_S 0
#define IG3_STATS_GLPES_OOPCNTGP3LO_OOPGP3 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PERNRRCVDHI(_i) (0x42669300 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PERNRRCVDHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PERNRRCVDHI_PERNRRCVDHI_S 0
#define IG3_STATS_GLPES_PERNRRCVDHI_PERNRRCVDHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PERNRRCVDLO(_i) (0x42668200 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PERNRRCVDLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PERNRRCVDLO_PERNRRCVDLO_S 0
#define IG3_STATS_GLPES_PERNRRCVDLO_PERNRRCVDLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PERNRSENTHI(_i) (0x4263A700 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PERNRSENTHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PERNRSENTHI_PERNRSENTHI_S 0
#define IG3_STATS_GLPES_PERNRSENTHI_PERNRSENTHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PERNRSENTLO(_i) (0x42639600 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PERNRSENTLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PERNRSENTLO_PERNRSENTLO_S 0
#define IG3_STATS_GLPES_PERNRSENTLO_PERNRSENTLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4RXDISCARDHI(_i) (0x42614300 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4RXDISCARDHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4RXDISCARDHI_IP4RXDISCARD_S 0
#define IG3_STATS_GLPES_PFIP4RXDISCARDHI_IP4RXDISCARD GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4RXDISCARDLO(_i) (0x42613200 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4RXDISCARDLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4RXDISCARDLO_IP4RXDISCARD_S 0
#define IG3_STATS_GLPES_PFIP4RXDISCARDLO_IP4RXDISCARD GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4RXFRAGSHI(_i) (0x42616500 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4RXFRAGSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4RXFRAGSHI_IP4RXFRAGSHI_S 0
#define IG3_STATS_GLPES_PFIP4RXFRAGSHI_IP4RXFRAGSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4RXFRAGSLO(_i) (0x42615400 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4RXFRAGSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4RXFRAGSLO_IP4RXFRAGSLO_S 0
#define IG3_STATS_GLPES_PFIP4RXFRAGSLO_IP4RXFRAGSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4RXMCOCTSHI(_i) (0x42605500 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4RXMCOCTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4RXMCOCTSHI_IP4RXMCOCTSHI_S 0
#define IG3_STATS_GLPES_PFIP4RXMCOCTSHI_IP4RXMCOCTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4RXMCOCTSLO(_i) (0x42604400 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4RXMCOCTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4RXMCOCTSLO_IP4RXMCOCTSLO_S 0
#define IG3_STATS_GLPES_PFIP4RXMCOCTSLO_IP4RXMCOCTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4RXMCPKTSHI(_i) (0x42607700 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4RXMCPKTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4RXMCPKTSHI_IP4RXMCPKTSHI_S 0
#define IG3_STATS_GLPES_PFIP4RXMCPKTSHI_IP4RXMCPKTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4RXMCPKTSLO(_i) (0x42606600 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4RXMCPKTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4RXMCPKTSLO_IP4RXMCPKTSLO_S 0
#define IG3_STATS_GLPES_PFIP4RXMCPKTSLO_IP4RXMCPKTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4RXOCTSHI(_i) (0x42601100 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4RXOCTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4RXOCTSHI_IP4RXOCTSHI_S 0
#define IG3_STATS_GLPES_PFIP4RXOCTSHI_IP4RXOCTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4RXOCTSLO(_i) (0x42600000 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4RXOCTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4RXOCTSLO_IP4RXOCTSLO_S 0
#define IG3_STATS_GLPES_PFIP4RXOCTSLO_IP4RXOCTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4RXPKTSHI(_i) (0x42603300 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4RXPKTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4RXPKTSHI_IP4RXPKTSHI_S 0
#define IG3_STATS_GLPES_PFIP4RXPKTSHI_IP4RXPKTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4RXPKTSLO(_i) (0x42602200 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4RXPKTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4RXPKTSLO_IP4RXPKTSLO_S 0
#define IG3_STATS_GLPES_PFIP4RXPKTSLO_IP4RXPKTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4RXTRUNCHI(_i) (0x42618700 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4RXTRUNCHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4RXTRUNCHI_IP4RXTRUNC_S 0
#define IG3_STATS_GLPES_PFIP4RXTRUNCHI_IP4RXTRUNC GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4RXTRUNCLO(_i) (0x42617600 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4RXTRUNCLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4RXTRUNCLO_IP4RXTRUNC_S 0
#define IG3_STATS_GLPES_PFIP4RXTRUNCLO_IP4RXTRUNC GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4TXFRAGSHI(_i) (0x42653F00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4TXFRAGSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4TXFRAGSHI_IP4TXFRAGSHI_S 0
#define IG3_STATS_GLPES_PFIP4TXFRAGSHI_IP4TXFRAGSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4TXFRAGSLO(_i) (0x42652E00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4TXFRAGSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4TXFRAGSLO_IP4TXFRAGSLO_S 0
#define IG3_STATS_GLPES_PFIP4TXFRAGSLO_IP4TXFRAGSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4TXMCOCTSHI(_i) (0x42645100 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4TXMCOCTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4TXMCOCTSHI_IP4TXMCOCTSHI_S 0
#define IG3_STATS_GLPES_PFIP4TXMCOCTSHI_IP4TXMCOCTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4TXMCOCTSLO(_i) (0x42644000 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4TXMCOCTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4TXMCOCTSLO_IP4TXMCOCTSLO_S 0
#define IG3_STATS_GLPES_PFIP4TXMCOCTSLO_IP4TXMCOCTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4TXMCPKTSHI(_i) (0x42647300 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4TXMCPKTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4TXMCPKTSHI_IP4TXMCPKTSHI_S 0
#define IG3_STATS_GLPES_PFIP4TXMCPKTSHI_IP4TXMCPKTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4TXMCPKTSLO(_i) (0x42646200 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4TXMCPKTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4TXMCPKTSLO_IP4TXMCPKTSLO_S 0
#define IG3_STATS_GLPES_PFIP4TXMCPKTSLO_IP4TXMCPKTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4TXNOROUTEHI(_i) (0x42651D00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4TXNOROUTEHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4TXNOROUTEHI_IP4TXNOROUTE_S 0
#define IG3_STATS_GLPES_PFIP4TXNOROUTEHI_IP4TXNOROUTE GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4TXNOROUTELO(_i) (0x42650C00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4TXNOROUTELO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4TXNOROUTELO_IP4TXNOROUTE_S 0
#define IG3_STATS_GLPES_PFIP4TXNOROUTELO_IP4TXNOROUTE GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4TXOCTSHI(_i) (0x42640D00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4TXOCTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4TXOCTSHI_IP4TXOCTSHI_S 0
#define IG3_STATS_GLPES_PFIP4TXOCTSHI_IP4TXOCTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4TXOCTSLO(_i) (0x4263FC00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4TXOCTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4TXOCTSLO_IP4TXOCTSLO_S 0
#define IG3_STATS_GLPES_PFIP4TXOCTSLO_IP4TXOCTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4TXPKTSHI(_i) (0x42642F00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4TXPKTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4TXPKTSHI_IP4TXPKTSHI_S 0
#define IG3_STATS_GLPES_PFIP4TXPKTSHI_IP4TXPKTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP4TXPKTSLO(_i) (0x42641E00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP4TXPKTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP4TXPKTSLO_IP4TXPKTSLO_S 0
#define IG3_STATS_GLPES_PFIP4TXPKTSLO_IP4TXPKTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6RXDISCARDHI(_i) (0x4261CB00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6RXDISCARDHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6RXDISCARDHI_IP6RXDISCARD_S 0
#define IG3_STATS_GLPES_PFIP6RXDISCARDHI_IP6RXDISCARD GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6RXDISCARDLO(_i) (0x4261BA00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6RXDISCARDLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6RXDISCARDLO_IP6RXDISCARD_S 0
#define IG3_STATS_GLPES_PFIP6RXDISCARDLO_IP6RXDISCARD GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6RXFRAGSHI(_i) (0x4261ED00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6RXFRAGSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6RXFRAGSHI_IP6RXFRAGSHI_S 0
#define IG3_STATS_GLPES_PFIP6RXFRAGSHI_IP6RXFRAGSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6RXFRAGSLO(_i) (0x4261DC00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6RXFRAGSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6RXFRAGSLO_IP6RXFRAGSLO_S 0
#define IG3_STATS_GLPES_PFIP6RXFRAGSLO_IP6RXFRAGSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6RXMCOCTSHI(_i) (0x4260DD00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6RXMCOCTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6RXMCOCTSHI_IP6RXMCOCTSHI_S 0
#define IG3_STATS_GLPES_PFIP6RXMCOCTSHI_IP6RXMCOCTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6RXMCOCTSLO(_i) (0x4260CC00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6RXMCOCTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6RXMCOCTSLO_IP6RXMCOCTSLO_S 0
#define IG3_STATS_GLPES_PFIP6RXMCOCTSLO_IP6RXMCOCTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6RXMCPKTSHI(_i) (0x4260FF00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6RXMCPKTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6RXMCPKTSHI_IP6RXMCPKTSHI_S 0
#define IG3_STATS_GLPES_PFIP6RXMCPKTSHI_IP6RXMCPKTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6RXMCPKTSLO(_i) (0x4260EE00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6RXMCPKTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6RXMCPKTSLO_IP6RXMCPKTSLO_S 0
#define IG3_STATS_GLPES_PFIP6RXMCPKTSLO_IP6RXMCPKTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6RXOCTSHI(_i) (0x42609900 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6RXOCTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6RXOCTSHI_IP6RXOCTSHI_S 0
#define IG3_STATS_GLPES_PFIP6RXOCTSHI_IP6RXOCTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6RXOCTSLO(_i) (0x42608800 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6RXOCTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6RXOCTSLO_IP6RXOCTSLO_S 0
#define IG3_STATS_GLPES_PFIP6RXOCTSLO_IP6RXOCTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6RXPKTSHI(_i) (0x4260BB00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6RXPKTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6RXPKTSHI_IP6RXPKTSHI_S 0
#define IG3_STATS_GLPES_PFIP6RXPKTSHI_IP6RXPKTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6RXPKTSLO(_i) (0x4260AA00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6RXPKTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6RXPKTSLO_IP6RXPKTSLO_S 0
#define IG3_STATS_GLPES_PFIP6RXPKTSLO_IP6RXPKTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6RXTRUNCHI(_i) (0x42623100 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6RXTRUNCHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6RXTRUNCHI_IP6RXTRUNC_S 0
#define IG3_STATS_GLPES_PFIP6RXTRUNCHI_IP6RXTRUNC GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6RXTRUNCLO(_i) (0x42622000 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6RXTRUNCLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6RXTRUNCLO_IP6RXTRUNC_S 0
#define IG3_STATS_GLPES_PFIP6RXTRUNCLO_IP6RXTRUNC GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6TXFRAGSHI(_i) (0x42658300 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6TXFRAGSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6TXFRAGSHI_IP6TXFRAGSHI_S 0
#define IG3_STATS_GLPES_PFIP6TXFRAGSHI_IP6TXFRAGSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6TXFRAGSLO(_i) (0x42657200 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6TXFRAGSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6TXFRAGSLO_IP6TXFRAGSLO_S 0
#define IG3_STATS_GLPES_PFIP6TXFRAGSLO_IP6TXFRAGSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6TXMCOCTSHI(_i) (0x4264D900 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6TXMCOCTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6TXMCOCTSHI_IP6TXMCOCTSHI_S 0
#define IG3_STATS_GLPES_PFIP6TXMCOCTSHI_IP6TXMCOCTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6TXMCOCTSLO(_i) (0x4264C800 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6TXMCOCTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6TXMCOCTSLO_IP6TXMCOCTSLO_S 0
#define IG3_STATS_GLPES_PFIP6TXMCOCTSLO_IP6TXMCOCTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6TXMCPKTSHI(_i) (0x4264FB00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6TXMCPKTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6TXMCPKTSHI_IP6TXMCPKTSHI_S 0
#define IG3_STATS_GLPES_PFIP6TXMCPKTSHI_IP6TXMCPKTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6TXMCPKTSLO(_i) (0x4264EA00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6TXMCPKTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6TXMCPKTSLO_IP6TXMCPKTSLO_S 0
#define IG3_STATS_GLPES_PFIP6TXMCPKTSLO_IP6TXMCPKTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6TXNOROUTEHI(_i) (0x42656100 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6TXNOROUTEHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6TXNOROUTEHI_IP6TXNOROUTE_S 0
#define IG3_STATS_GLPES_PFIP6TXNOROUTEHI_IP6TXNOROUTE GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6TXNOROUTELO(_i) (0x42655000 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6TXNOROUTELO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6TXNOROUTELO_IP6TXNOROUTE_S 0
#define IG3_STATS_GLPES_PFIP6TXNOROUTELO_IP6TXNOROUTE GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6TXOCTSHI(_i) (0x42649500 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6TXOCTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6TXOCTSHI_IP6TXOCTSHI_S 0
#define IG3_STATS_GLPES_PFIP6TXOCTSHI_IP6TXOCTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6TXOCTSLO(_i) (0x42648400 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6TXOCTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6TXOCTSLO_IP6TXOCTSLO_S 0
#define IG3_STATS_GLPES_PFIP6TXOCTSLO_IP6TXOCTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6TXPKTSHI(_i) (0x4264B700 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6TXPKTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6TXPKTSHI_IP6TXPKTSHI_S 0
#define IG3_STATS_GLPES_PFIP6TXPKTSHI_IP6TXPKTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFIP6TXPKTSLO(_i) (0x4264A600 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFIP6TXPKTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFIP6TXPKTSLO_IP6TXPKTSLO_S 0
#define IG3_STATS_GLPES_PFIP6TXPKTSLO_IP6TXPKTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMARXATSHI(_i) (0x4262B900 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMARXATSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMARXATSHI_RDMARXATSHI_S 0
#define IG3_STATS_GLPES_PFRDMARXATSHI_RDMARXATSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMARXATSLO(_i) (0x4262A800 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMARXATSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMARXATSLO_RDMARXATSLO_S 0
#define IG3_STATS_GLPES_PFRDMARXATSLO_RDMARXATSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMARXRDSHI(_i) (0x4262FD00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMARXRDSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMARXRDSHI_RDMARXRDSHI_S 0
#define IG3_STATS_GLPES_PFRDMARXRDSHI_RDMARXRDSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMARXRDSLO(_i) (0x4262EC00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMARXRDSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMARXRDSLO_RDMARXRDSLO_S 0
#define IG3_STATS_GLPES_PFRDMARXRDSLO_RDMARXRDSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMARXSNDSHI(_i) (0x42631F00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMARXSNDSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMARXSNDSHI_RDMARXSNDSHI_S 0
#define IG3_STATS_GLPES_PFRDMARXSNDSHI_RDMARXSNDSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMARXSNDSLO(_i) (0x42630E00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMARXSNDSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMARXSNDSLO_RDMARXSNDSLO_S 0
#define IG3_STATS_GLPES_PFRDMARXSNDSLO_RDMARXSNDSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMARXWRSHI(_i) (0x4262DB00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMARXWRSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMARXWRSHI_RDMARXWRSHI_S 0
#define IG3_STATS_GLPES_PFRDMARXWRSHI_RDMARXWRSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMARXWRSLO(_i) (0x4262CA00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMARXWRSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMARXWRSLO_RDMARXWRSLO_S 0
#define IG3_STATS_GLPES_PFRDMARXWRSLO_RDMARXWRSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMATXATSHI(_i) (0x4265E900 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMATXATSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMATXATSHI_RDMARXATSHI_S 0
#define IG3_STATS_GLPES_PFRDMATXATSHI_RDMARXATSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMATXATSLO(_i) (0x4265D800 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMATXATSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMATXATSLO_RDMARXATSLO_S 0
#define IG3_STATS_GLPES_PFRDMATXATSLO_RDMARXATSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMATXRDSHI(_i) (0x42662D00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMATXRDSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMATXRDSHI_RDMARXRDSHI_S 0
#define IG3_STATS_GLPES_PFRDMATXRDSHI_RDMARXRDSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMATXRDSLO(_i) (0x42661C00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMATXRDSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMATXRDSLO_RDMARXRDSLO_S 0
#define IG3_STATS_GLPES_PFRDMATXRDSLO_RDMARXRDSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMATXSNDSHI(_i) (0x42664F00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMATXSNDSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMATXSNDSHI_RDMARXSNDSHI_S 0
#define IG3_STATS_GLPES_PFRDMATXSNDSHI_RDMARXSNDSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMATXSNDSLO(_i) (0x42663E00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMATXSNDSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMATXSNDSLO_RDMARXSNDSLO_S 0
#define IG3_STATS_GLPES_PFRDMATXSNDSLO_RDMARXSNDSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMATXWRSHI(_i) (0x42660B00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMATXWRSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMATXWRSHI_RDMARXWRSHI_S 0
#define IG3_STATS_GLPES_PFRDMATXWRSHI_RDMARXWRSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMATXWRSLO(_i) (0x4265FA00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMATXWRSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMATXWRSLO_RDMARXWRSLO_S 0
#define IG3_STATS_GLPES_PFRDMATXWRSLO_RDMARXWRSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMAVBNDHI(_i) (0x42634100 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMAVBNDHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMAVBNDHI_RDMAVBNDHI_S 0
#define IG3_STATS_GLPES_PFRDMAVBNDHI_RDMAVBNDHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMAVBNDLO(_i) (0x42633000 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMAVBNDLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMAVBNDLO_RDMAVBNDLO_S 0
#define IG3_STATS_GLPES_PFRDMAVBNDLO_RDMAVBNDLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMAVINVHI(_i) (0x42636300 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMAVINVHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMAVINVHI_RDMAVINVHI_S 0
#define IG3_STATS_GLPES_PFRDMAVINVHI_RDMAVINVHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRDMAVINVLO(_i) (0x42635200 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRDMAVINVLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRDMAVINVLO_RDMAVINVLO_S 0
#define IG3_STATS_GLPES_PFRDMAVINVLO_RDMAVINVLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRXNPECNMARKEDPKTSHI(_i) (0x42638500 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRXNPECNMARKEDPKTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRXNPECNMARKEDPKTSHI_FRXNPECNMARKEDPKTSHI_S 0
#define IG3_STATS_GLPES_PFRXNPECNMARKEDPKTSHI_FRXNPECNMARKEDPKTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRXNPECNMARKEDPKTSLO(_i) (0x42637400 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRXNPECNMARKEDPKTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRXNPECNMARKEDPKTSLO_RXNPECNMARKEDPKTSLO_S 0
#define IG3_STATS_GLPES_PFRXNPECNMARKEDPKTSLO_RXNPECNMARKEDPKTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRXRPCNPHANDLEDHI(_i) (0x42629700 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRXRPCNPHANDLEDHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRXRPCNPHANDLEDHI_RXRPCNPHANDLED_S 0
#define IG3_STATS_GLPES_PFRXRPCNPHANDLEDHI_RXRPCNPHANDLED GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRXRPCNPHANDLEDLO(_i) (0x42628600 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRXRPCNPHANDLEDLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRXRPCNPHANDLEDLO_RXRPCNPHANDLED_S 0
#define IG3_STATS_GLPES_PFRXRPCNPHANDLEDLO_RXRPCNPHANDLED GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRXRPCNPIGNOREDHI(_i) (0x4261A900 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRXRPCNPIGNOREDHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRXRPCNPIGNOREDHI_RPCNPIGNORED_S 0
#define IG3_STATS_GLPES_PFRXRPCNPIGNOREDHI_RPCNPIGNORED GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRXRPCNPIGNOREDLO(_i) (0x42619800 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRXRPCNPIGNOREDLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRXRPCNPIGNOREDLO_RPCNPIGNORED_S 0
#define IG3_STATS_GLPES_PFRXRPCNPIGNOREDLO_RPCNPIGNORED GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRXVLANERRHI(_i) (0x42612100 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRXVLANERRHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRXVLANERRHI_RXVLANERR_S 0
#define IG3_STATS_GLPES_PFRXVLANERRHI_RXVLANERR GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFRXVLANERRLO(_i) (0x42611000 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFRXVLANERRLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFRXVLANERRLO_RXVLANERR_S 0
#define IG3_STATS_GLPES_PFRXVLANERRLO_RXVLANERR GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFTCPRTXSEGHI(_i) (0x4265C700 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFTCPRTXSEGHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFTCPRTXSEGHI_TCPRTXSEG_S 0
#define IG3_STATS_GLPES_PFTCPRTXSEGHI_TCPRTXSEG GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFTCPRTXSEGLO(_i) (0x4265B600 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFTCPRTXSEGLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFTCPRTXSEGLO_TCPRTXSEG_S 0
#define IG3_STATS_GLPES_PFTCPRTXSEGLO_TCPRTXSEG GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFTCPRXOPTERRHI(_i) (0x42627500 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFTCPRXOPTERRHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFTCPRXOPTERRHI_TCPRXOPTERR_S 0
#define IG3_STATS_GLPES_PFTCPRXOPTERRHI_TCPRXOPTERR GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFTCPRXOPTERRLO(_i) (0x42626400 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFTCPRXOPTERRLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFTCPRXOPTERRLO_TCPRXOPTERR_S 0
#define IG3_STATS_GLPES_PFTCPRXOPTERRLO_TCPRXOPTERR GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFTCPRXPROTOERRHI(_i) (0x42620F00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFTCPRXPROTOERRHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFTCPRXPROTOERRHI_TCPRXPROTOERR_S 0
#define IG3_STATS_GLPES_PFTCPRXPROTOERRHI_TCPRXPROTOERR GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFTCPRXPROTOERRLO(_i) (0x4261FE00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFTCPRXPROTOERRLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFTCPRXPROTOERRLO_TCPRXPROTOERR_S 0
#define IG3_STATS_GLPES_PFTCPRXPROTOERRLO_TCPRXPROTOERR GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFTCPRXSEGSHI(_i) (0x4263C900 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFTCPRXSEGSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFTCPRXSEGSHI_TCPRXSEGSHI_S 0
#define IG3_STATS_GLPES_PFTCPRXSEGSHI_TCPRXSEGSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFTCPRXSEGSLO(_i) (0x4263B800 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFTCPRXSEGSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFTCPRXSEGSLO_TCPRXSEGSLO_S 0
#define IG3_STATS_GLPES_PFTCPRXSEGSLO_TCPRXSEGSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFTCPTXSEGSHI(_i) (0x4266B500 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFTCPTXSEGSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFTCPTXSEGSHI_TCPTXSEGHI_S 0
#define IG3_STATS_GLPES_PFTCPTXSEGSHI_TCPTXSEGHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFTCPTXSEGSLO(_i) (0x4266A400 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFTCPTXSEGSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFTCPTXSEGSLO_TCPTXSEGLO_S 0
#define IG3_STATS_GLPES_PFTCPTXSEGSLO_TCPTXSEGLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFTXNPCNPSENTHI(_i) (0x42667100 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFTXNPCNPSENTHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFTXNPCNPSENTHI_PFTXNPCNPSENT_S 0
#define IG3_STATS_GLPES_PFTXNPCNPSENTHI_PFTXNPCNPSENT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFTXNPCNPSENTLO(_i) (0x42666000 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFTXNPCNPSENTLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFTXNPCNPSENTLO_PFTXNPCNPSENT_S 0
#define IG3_STATS_GLPES_PFTXNPCNPSENTLO_PFTXNPCNPSENT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFUDPRXPKTSHI(_i) (0x4263EB00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFUDPRXPKTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFUDPRXPKTSHI_UDPRXPKTSHI_S 0
#define IG3_STATS_GLPES_PFUDPRXPKTSHI_UDPRXPKTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFUDPRXPKTSLO(_i) (0x4263DA00 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFUDPRXPKTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFUDPRXPKTSLO_UDPRXPKTSLO_S 0
#define IG3_STATS_GLPES_PFUDPRXPKTSLO_UDPRXPKTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFUDPTXPKTSHI(_i) (0x4266D700 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFUDPTXPKTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFUDPTXPKTSHI_UDPTXPKTSHI_S 0
#define IG3_STATS_GLPES_PFUDPTXPKTSHI_UDPTXPKTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PFUDPTXPKTSLO(_i) (0x4266C600 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_PFUDPTXPKTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_PFUDPTXPKTSLO_UDPTXPKTSLO_S 0
#define IG3_STATS_GLPES_PFUDPTXPKTSLO_UDPTXPKTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHGCTRKTBLCNTHI 0x4266EEAC
#define IG3_STATS_GLPES_PSHGCTRKTBLCNTHI_PSHGCTRKTBLCNT_S 0
#define IG3_STATS_GLPES_PSHGCTRKTBLCNTHI_PSHGCTRKTBLCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHGCTRKTBLCNTLO 0x4266EEA8
#define IG3_STATS_GLPES_PSHGCTRKTBLCNTLO_PSHGCTRKTBLCNT_S 0
#define IG3_STATS_GLPES_PSHGCTRKTBLCNTLO_PSHGCTRKTBLCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHINCWQECNTHI 0x4266EE94
#define IG3_STATS_GLPES_PSHINCWQECNTHI_PSHINCWQECNT_S 0
#define IG3_STATS_GLPES_PSHINCWQECNTHI_PSHINCWQECNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHINCWQECNTLO 0x4266EE90
#define IG3_STATS_GLPES_PSHINCWQECNTLO_PSHINCWQECNT_S 0
#define IG3_STATS_GLPES_PSHINCWQECNTLO_PSHINCWQECNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHINVACCESSCNTHI 0x4266EE9C
#define IG3_STATS_GLPES_PSHINVACCESSCNTHI_PSHINVACCESSCNT_S 0
#define IG3_STATS_GLPES_PSHINVACCESSCNTHI_PSHINVACCESSCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHINVACCESSCNTLO 0x4266EE98
#define IG3_STATS_GLPES_PSHINVACCESSCNTLO_PSHINVACCESSCNT_S 0
#define IG3_STATS_GLPES_PSHINVACCESSCNTLO_PSHINVACCESSCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T0(_i) (0x4266EEC8 + ((_i) * 4)) /* _i=0...7 */
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T0_MAX_INDEX_I 7
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T0_VALID_S 31
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T0_VALID_M BIT_ULL(31)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T0_RSVD_S 30
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T0_RSVD_M BIT_ULL(31)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T0_PAGE_OFST_S 24
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T0_PAGE_OFST GENMASK_ULL(24, 29)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T0_PAGE_IDX_S 14
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T0_PAGE_IDX GENMASK_ULL(14, 23)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T0_VF_IDX_S 2
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T0_VF_IDX GENMASK_ULL(2, 13)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T0_VM_VF_TYPE_S 0
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T0_VM_VF_TYPE GENMASK_ULL(0, 1)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T1(_i) (0x4266EEE8 + ((_i) * 4)) /* _i=0...7 */
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T1_MAX_INDEX_I 7
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T1_VALID_S 31
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T1_VALID_M BIT_ULL(31)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T1_RSVD_S 30
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T1_RSVD_M BIT_ULL(31)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T1_PAGE_OFST_S 24
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T1_PAGE_OFST GENMASK_ULL(24, 29)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T1_PAGE_IDX_S 14
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T1_PAGE_IDX GENMASK_ULL(14, 23)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T1_VF_IDX_S 2
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T1_VF_IDX GENMASK_ULL(2, 13)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T1_VM_VF_TYPE_S 0
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T1_VM_VF_TYPE GENMASK_ULL(0, 1)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T2(_i) (0x4266EF08 + ((_i) * 4)) /* _i=0...7 */
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T2_MAX_INDEX_I 7
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T2_VALID_S 31
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T2_VALID_M BIT_ULL(31)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T2_RSVD_S 30
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T2_RSVD_M BIT_ULL(31)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T2_PAGE_OFST_S 24
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T2_PAGE_OFST GENMASK_ULL(24, 29)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T2_PAGE_IDX_S 14
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T2_PAGE_IDX GENMASK_ULL(14, 23)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T2_VF_IDX_S 2
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T2_VF_IDX GENMASK_ULL(2, 13)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T2_VM_VF_TYPE_S 0
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T2_VM_VF_TYPE GENMASK_ULL(0, 1)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T3(_i) (0x4266EF28 + ((_i) * 4)) /* _i=0...7 */
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T3_MAX_INDEX_I 7
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T3_VALID_S 31
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T3_VALID_M BIT_ULL(31)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T3_RSVD_S 30
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T3_RSVD_M BIT_ULL(31)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T3_PAGE_OFST_S 24
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T3_PAGE_OFST GENMASK_ULL(24, 29)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T3_PAGE_IDX_S 14
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T3_PAGE_IDX GENMASK_ULL(14, 23)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T3_VF_IDX_S 2
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T3_VF_IDX GENMASK_ULL(2, 13)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T3_VM_VF_TYPE_S 0
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T3_VM_VF_TYPE GENMASK_ULL(0, 1)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T4(_i) (0x4266EF48 + ((_i) * 4)) /* _i=0...7 */
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T4_MAX_INDEX_I 7
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T4_VALID_S 31
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T4_VALID_M BIT_ULL(31)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T4_RSVD_S 30
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T4_RSVD_M BIT_ULL(31)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T4_PAGE_OFST_S 24
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T4_PAGE_OFST GENMASK_ULL(24, 29)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T4_PAGE_IDX_S 14
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T4_PAGE_IDX GENMASK_ULL(14, 23)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T4_VF_IDX_S 2
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T4_VF_IDX GENMASK_ULL(2, 13)
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T4_VM_VF_TYPE_S 0
#define IG3_STATS_GLPES_PSHINVACCESSTRC_T4_VM_VF_TYPE GENMASK_ULL(0, 1)
#define IG3_STATS_GLPES_PSHINVSQHDCNTHI 0x4266EEB4
#define IG3_STATS_GLPES_PSHINVSQHDCNTHI_PSHINVSQHDCNT_S 0
#define IG3_STATS_GLPES_PSHINVSQHDCNTHI_PSHINVSQHDCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHINVSQHDCNTLO 0x4266EEB0
#define IG3_STATS_GLPES_PSHINVSQHDCNTLO_PSHINVSQHDCNT_S 0
#define IG3_STATS_GLPES_PSHINVSQHDCNTLO_PSHINVSQHDCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHNOCREDCNTHI 0x4266EE84
#define IG3_STATS_GLPES_PSHNOCREDCNTHI_PSHNOCREDCNT_S 0
#define IG3_STATS_GLPES_PSHNOCREDCNTHI_PSHNOCREDCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHNOCREDCNTLO 0x4266EE80
#define IG3_STATS_GLPES_PSHNOCREDCNTLO_PSHNOCREDCNT_S 0
#define IG3_STATS_GLPES_PSHNOCREDCNTLO_PSHNOCREDCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHNOTRKTBLDBCNTHI 0x4266EE8C
#define IG3_STATS_GLPES_PSHNOTRKTBLDBCNTHI_PSHNOTRKTBLDBCNT_S 0
#define IG3_STATS_GLPES_PSHNOTRKTBLDBCNTHI_PSHNOTRKTBLDBCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHNOTRKTBLDBCNTLO 0x4266EE88
#define IG3_STATS_GLPES_PSHNOTRKTBLDBCNTLO_PSHNOTRKTBLDBCNT_S 0
#define IG3_STATS_GLPES_PSHNOTRKTBLDBCNTLO_PSHNOTRKTBLDBCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHNOTRKTBLTRNCNTHI 0x4266EEC4
#define IG3_STATS_GLPES_PSHNOTRKTBLTRNCNTHI_PSHNOTRKTBLCNT_S 0
#define IG3_STATS_GLPES_PSHNOTRKTBLTRNCNTHI_PSHNOTRKTBLCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHNOTRKTBLTRNCNTLO 0x4266EEC0
#define IG3_STATS_GLPES_PSHNOTRKTBLTRNCNTLO_PSHNOTRKTBLCNT_S 0
#define IG3_STATS_GLPES_PSHNOTRKTBLTRNCNTLO_PSHNOTRKTBLCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHPFCDROPCNTHI 0x4266EEBC
#define IG3_STATS_GLPES_PSHPFCDROPCNTHI_PSHPFCDROPCNT_S 0
#define IG3_STATS_GLPES_PSHPFCDROPCNTHI_PSHPFCDROPCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHPFCDROPCNTLO 0x4266EEB8
#define IG3_STATS_GLPES_PSHPFCDROPCNTLO_PSHPFCDROPCNT_S 0
#define IG3_STATS_GLPES_PSHPFCDROPCNTLO_PSHPFCDROPCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHSQXMITCNTHI 0x4266EEA4
#define IG3_STATS_GLPES_PSHSQXMITCNTHI_PSHSQXMITCNT_S 0
#define IG3_STATS_GLPES_PSHSQXMITCNTHI_PSHSQXMITCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_PSHSQXMITCNTLO 0x4266EEA0
#define IG3_STATS_GLPES_PSHSQXMITCNTLO_PSHSQXMITCNT_S 0
#define IG3_STATS_GLPES_PSHSQXMITCNTLO_PSHSQXMITCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RDMAIRDLMTCNTSHI(_i) (0x42625300 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_RDMAIRDLMTCNTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_RDMAIRDLMTCNTSHI_RDMAIRDLMTCNTLCNTSHI_S 0
#define IG3_STATS_GLPES_RDMAIRDLMTCNTSHI_RDMAIRDLMTCNTLCNTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RDMAIRDLMTCNTSLO(_i) (0x42624200 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_RDMAIRDLMTCNTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_RDMAIRDLMTCNTSLO_RDMAIRDLMTCNTLCNTSLO_S 0
#define IG3_STATS_GLPES_RDMAIRDLMTCNTSLO_RDMAIRDLMTCNTLCNTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RDMAORDLMTCNTSHI(_i) (0x4265A500 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_RDMAORDLMTCNTSHI_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_RDMAORDLMTCNTSHI_RDMAORDLMTCNTLCNTSHI_S 0
#define IG3_STATS_GLPES_RDMAORDLMTCNTSHI_RDMAORDLMTCNTLCNTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RDMAORDLMTCNTSLO(_i) (0x42659400 + ((_i) * 4)) /* _i=0...1087 */
#define IG3_STATS_GLPES_RDMAORDLMTCNTSLO_MAX_INDEX_I 1087
#define IG3_STATS_GLPES_RDMAORDLMTCNTSLO_RDMAORDLMTCNTLCNTSLO_S 0
#define IG3_STATS_GLPES_RDMAORDLMTCNTSLO_RDMAORDLMTCNTLCNTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RDMARXMULTFPDUSHI 0x4266E81C
#define IG3_STATS_GLPES_RDMARXMULTFPDUSHI_RDMARXMULTFPDUSHI_S 0
#define IG3_STATS_GLPES_RDMARXMULTFPDUSHI_RDMARXMULTFPDUSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RDMARXMULTFPDUSLO 0x4266E818
#define IG3_STATS_GLPES_RDMARXMULTFPDUSLO_RDMARXMULTFPDUSLO_S 0
#define IG3_STATS_GLPES_RDMARXMULTFPDUSLO_RDMARXMULTFPDUSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RDMARXOOODDPHI 0x4266E824
#define IG3_STATS_GLPES_RDMARXOOODDPHI_RDMARXOOODDPHI_S 0
#define IG3_STATS_GLPES_RDMARXOOODDPHI_RDMARXOOODDPHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RDMARXOOODDPLO 0x4266E820
#define IG3_STATS_GLPES_RDMARXOOODDPLO_RDMARXOOODDPLO_S 0
#define IG3_STATS_GLPES_RDMARXOOODDPLO_RDMARXOOODDPLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RDMARXOOONOMARKHI 0x4266E814
#define IG3_STATS_GLPES_RDMARXOOONOMARKHI_RDMAOOONOMARK_S 0
#define IG3_STATS_GLPES_RDMARXOOONOMARKHI_RDMAOOONOMARK GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RDMARXOOONOMARKLO 0x4266E810
#define IG3_STATS_GLPES_RDMARXOOONOMARKLO_RDMAOOONOMARK_S 0
#define IG3_STATS_GLPES_RDMARXOOONOMARKLO_RDMAOOONOMARK GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RDMARXUNALIGNHI 0x4266E804
#define IG3_STATS_GLPES_RDMARXUNALIGNHI_RDMRXAUNALIGN_S 0
#define IG3_STATS_GLPES_RDMARXUNALIGNHI_RDMRXAUNALIGN GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RDMARXUNALIGNLO 0x4266E800
#define IG3_STATS_GLPES_RDMARXUNALIGNLO_RDMRXAUNALIGN_S 0
#define IG3_STATS_GLPES_RDMARXUNALIGNLO_RDMRXAUNALIGN GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RNRNAKREQHI 0x4266E8EC
#define IG3_STATS_GLPES_RNRNAKREQHI_RNRNAKREQHI_S 0
#define IG3_STATS_GLPES_RNRNAKREQHI_RNRNAKREQHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RNRNAKREQLO 0x4266E8E8
#define IG3_STATS_GLPES_RNRNAKREQLO_RNRNAKREQLO_S 0
#define IG3_STATS_GLPES_RNRNAKREQLO_RNRNAKREQLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID11HI 0x4266E80C
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID11HI_RXRAM2RSVDCNTRID11HI_S 0
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID11HI_RXRAM2RSVDCNTRID11HI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID11LO 0x4266E808
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID11LO_RXRAM2RSVDCNTRID11LO_S 0
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID11LO_RXRAM2RSVDCNTRID11LO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1AHI 0x4266E854
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1AHI_RXRAM2RSVDCNTRID1AHI_S 0
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1AHI_RXRAM2RSVDCNTRID1AHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1ALO 0x4266E850
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1ALO_RXRAM2RSVDCNTRID1ALO_S 0
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1ALO_RXRAM2RSVDCNTRID1ALO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1BHI 0x4266E85C
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1BHI_RXRAM2RSVDCNTRID1BHI_S 0
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1BHI_RXRAM2RSVDCNTRID1BHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1BLO 0x4266E858
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1BLO_RXRAM2RSVDCNTRID1BLO_S 0
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1BLO_RXRAM2RSVDCNTRID1BLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1CHI 0x4266E864
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1CHI_RXRAM2RSVDCNTRID1CHI_S 0
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1CHI_RXRAM2RSVDCNTRID1CHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1CLO 0x4266E860
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1CLO_RXRAM2RSVDCNTRID1CLO_S 0
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1CLO_RXRAM2RSVDCNTRID1CLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1DHI 0x4266E86C
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1DHI_RXRAM2RSVDCNTRID1DHI_S 0
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1DHI_RXRAM2RSVDCNTRID1DHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1DLO 0x4266E868
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1DLO_RXRAM2RSVDCNTRID1DLO_S 0
#define IG3_STATS_GLPES_RXRAM2RSVDCNTRID1DLO_RXRAM2RSVDCNTRID1DLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_MAX_VAL(_i) (0x4266EE40 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_MAX_VAL_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_MAX_VAL_THRESHOLD_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_MAX_VAL_THRESHOLD GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H0(_i) (0x4266E940 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H0_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H0_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H0_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H1(_i) (0x4266E980 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H1_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H1_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H1_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H2(_i) (0x4266E9C0 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H2_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H2_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H2_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H3(_i) (0x4266EA00 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H3_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H3_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H3_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H4(_i) (0x4266EA40 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H4_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H4_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P0_H4_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H0(_i) (0x4266EA80 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H0_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H0_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H0_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H1(_i) (0x4266EAC0 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H1_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H1_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H1_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H2(_i) (0x4266EB00 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H2_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H2_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H2_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H3(_i) (0x4266EB40 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H3_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H3_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H3_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H4(_i) (0x4266EB80 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H4_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H4_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P1_H4_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H0(_i) (0x4266EBC0 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H0_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H0_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H0_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H1(_i) (0x4266EC00 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H1_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H1_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H1_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H2(_i) (0x4266EC40 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H2_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H2_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H2_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H3(_i) (0x4266EC80 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H3_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H3_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H3_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H4(_i) (0x4266ECC0 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H4_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H4_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P2_H4_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H0(_i) (0x4266ED00 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H0_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H0_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H0_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H1(_i) (0x4266ED40 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H1_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H1_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H1_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H2(_i) (0x4266ED80 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H2_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H2_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H2_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H3(_i) (0x4266EDC0 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H3_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H3_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H3_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H4(_i) (0x4266EE00 + ((_i) * 4)) /* _i=0...15 */
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H4_MAX_INDEX_I 15
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H4_COUNT_S 0
#define IG3_STATS_GLPES_RX_LATENCY_HIS_P3_H4_COUNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPRXFOURHOLEHI 0x4266E84C
#define IG3_STATS_GLPES_TCPRXFOURHOLEHI_TCPRXFOURHOLEHI_S 0
#define IG3_STATS_GLPES_TCPRXFOURHOLEHI_TCPRXFOURHOLEHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPRXFOURHOLELO 0x4266E848
#define IG3_STATS_GLPES_TCPRXFOURHOLELO_TCPRXFOURHOLELO_S 0
#define IG3_STATS_GLPES_TCPRXFOURHOLELO_TCPRXFOURHOLELO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPRXONEHOLEHI 0x4266E834
#define IG3_STATS_GLPES_TCPRXONEHOLEHI_TCPRXONEHOLEHI_S 0
#define IG3_STATS_GLPES_TCPRXONEHOLEHI_TCPRXONEHOLEHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPRXONEHOLELO 0x4266E830
#define IG3_STATS_GLPES_TCPRXONEHOLELO_TCPRXONEHOLELO_S 0
#define IG3_STATS_GLPES_TCPRXONEHOLELO_TCPRXONEHOLELO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPRXPUREACKSHI 0x4266E82C
#define IG3_STATS_GLPES_TCPRXPUREACKSHI_TCPRXPUREACKSHI_S 0
#define IG3_STATS_GLPES_TCPRXPUREACKSHI_TCPRXPUREACKSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPRXPUREACKSLO 0x4266E828
#define IG3_STATS_GLPES_TCPRXPUREACKSLO_TCPRXPUREACKLO_S 0
#define IG3_STATS_GLPES_TCPRXPUREACKSLO_TCPRXPUREACKLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPRXTHREEHOLEHI 0x4266E844
#define IG3_STATS_GLPES_TCPRXTHREEHOLEHI_TCPRXTHREEHOLEHI_S 0
#define IG3_STATS_GLPES_TCPRXTHREEHOLEHI_TCPRXTHREEHOLEHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPRXTHREEHOLELO 0x4266E840
#define IG3_STATS_GLPES_TCPRXTHREEHOLELO_TCPRXTHREEHOLELO_S 0
#define IG3_STATS_GLPES_TCPRXTHREEHOLELO_TCPRXTHREEHOLELO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPRXTWOHOLEHI 0x4266E83C
#define IG3_STATS_GLPES_TCPRXTWOHOLEHI_TCPRXTWOHOLEHI_S 0
#define IG3_STATS_GLPES_TCPRXTWOHOLEHI_TCPRXTWOHOLEHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPRXTWOHOLELO 0x4266E838
#define IG3_STATS_GLPES_TCPRXTWOHOLELO_TCPRXTWOHOLELO_S 0
#define IG3_STATS_GLPES_TCPRXTWOHOLELO_TCPRXTWOHOLELO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPTXRETRANSFASTHI 0x4266E8AC
#define IG3_STATS_GLPES_TCPTXRETRANSFASTHI_TCPTXRETRANSFASTHI_S 0
#define IG3_STATS_GLPES_TCPTXRETRANSFASTHI_TCPTXRETRANSFASTHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPTXRETRANSFASTLO 0x4266E8A8
#define IG3_STATS_GLPES_TCPTXRETRANSFASTLO_TCPTXRETRANSFASTLO_S 0
#define IG3_STATS_GLPES_TCPTXRETRANSFASTLO_TCPTXRETRANSFASTLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPTXTOUTSFASTHI 0x4266E8B4
#define IG3_STATS_GLPES_TCPTXTOUTSFASTHI_TCPTXTOUTSFASTHI_S 0
#define IG3_STATS_GLPES_TCPTXTOUTSFASTHI_TCPTXTOUTSFASTHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPTXTOUTSFASTLO 0x4266E8B0
#define IG3_STATS_GLPES_TCPTXTOUTSFASTLO_TCPTXTOUTSFASTLO_S 0
#define IG3_STATS_GLPES_TCPTXTOUTSFASTLO_TCPTXTOUTSFASTLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPTXTOUTSHI 0x4266E8BC
#define IG3_STATS_GLPES_TCPTXTOUTSHI_TCPTXTOUTSHI_S 0
#define IG3_STATS_GLPES_TCPTXTOUTSHI_TCPTXTOUTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TCPTXTOUTSLO 0x4266E8B8
#define IG3_STATS_GLPES_TCPTXTOUTSLO_TCPTXTOUTSLO_S 0
#define IG3_STATS_GLPES_TCPTXTOUTSLO_TCPTXTOUTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TEPCNTGP0HI 0x4266E8C4
#define IG3_STATS_GLPES_TEPCNTGP0HI_TEPGP0_S 0
#define IG3_STATS_GLPES_TEPCNTGP0HI_TEPGP0 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TEPCNTGP0LO 0x4266E8C0
#define IG3_STATS_GLPES_TEPCNTGP0LO_TEPGP0_S 0
#define IG3_STATS_GLPES_TEPCNTGP0LO_TEPGP0 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TEPCNTGP1HI 0x4266E8CC
#define IG3_STATS_GLPES_TEPCNTGP1HI_TEPGP1_S 0
#define IG3_STATS_GLPES_TEPCNTGP1HI_TEPGP1 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TEPCNTGP1LO 0x4266E8C8
#define IG3_STATS_GLPES_TEPCNTGP1LO_TEPGP1_S 0
#define IG3_STATS_GLPES_TEPCNTGP1LO_TEPGP1 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TEPCNTGP2HI 0x4266E8D4
#define IG3_STATS_GLPES_TEPCNTGP2HI_TEPGP2_S 0
#define IG3_STATS_GLPES_TEPCNTGP2HI_TEPGP2 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TEPCNTGP2LO 0x4266E8D0
#define IG3_STATS_GLPES_TEPCNTGP2LO_TEPGP2_S 0
#define IG3_STATS_GLPES_TEPCNTGP2LO_TEPGP2 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TEPCNTGP3HI 0x4266E8DC
#define IG3_STATS_GLPES_TEPCNTGP3HI_TEPGP3_S 0
#define IG3_STATS_GLPES_TEPCNTGP3HI_TEPGP3 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TEPCNTGP3LO 0x4266E8D8
#define IG3_STATS_GLPES_TEPCNTGP3LO_TEPGP3_S 0
#define IG3_STATS_GLPES_TEPCNTGP3LO_TEPGP3 GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TXABORTSHI 0x4266E8E4
#define IG3_STATS_GLPES_TXABORTSHI_TXABORTSHI_S 0
#define IG3_STATS_GLPES_TXABORTSHI_TXABORTSHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_TXABORTSLO 0x4266E8E0
#define IG3_STATS_GLPES_TXABORTSLO_TXABORTSLO_S 0
#define IG3_STATS_GLPES_TXABORTSLO_TXABORTSLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_UDPMCDPIGNREPLCNTHI 0x4266E87C
#define IG3_STATS_GLPES_UDPMCDPIGNREPLCNTHI_GLPE_UDAMCDPIGNREPLCNT_S 0
#define IG3_STATS_GLPES_UDPMCDPIGNREPLCNTHI_GLPE_UDAMCDPIGNREPLCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_UDPMCDPIGNREPLCNTLO 0x4266E878
#define IG3_STATS_GLPES_UDPMCDPIGNREPLCNTLO_GLPE_UDAMCDPIGNREPLCNT_S 0
#define IG3_STATS_GLPES_UDPMCDPIGNREPLCNTLO_GLPE_UDAMCDPIGNREPLCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_UDPMCREPLCNTHI 0x4266E874
#define IG3_STATS_GLPES_UDPMCREPLCNTHI_UDAMCREPLCNT_S 0
#define IG3_STATS_GLPES_UDPMCREPLCNTHI_UDAMCREPLCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_UDPMCREPLCNTLO 0x4266E870
#define IG3_STATS_GLPES_UDPMCREPLCNTLO_UDAMCREPLCNT_S 0
#define IG3_STATS_GLPES_UDPMCREPLCNTLO_UDAMCREPLCNT GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_XLRCOUNTHI 0x4266E904
#define IG3_STATS_GLPES_XLRCOUNTHI_XLRCOUNTHI_S 0
#define IG3_STATS_GLPES_XLRCOUNTHI_XLRCOUNTHI GENMASK_ULL(0, 31)
#define IG3_STATS_GLPES_XLRCOUNTLO 0x4266E900
#define IG3_STATS_GLPES_XLRCOUNTLO_XLRCOUNTLO_S 0
#define IG3_STATS_GLPES_XLRCOUNTLO_XLRCOUNTLO GENMASK_ULL(0, 31)
#define IG3_STATS_GLPE_STATS_ECC_COR_ERR 0x4266EFA4
#define IG3_STATS_GLPE_STATS_ECC_COR_ERR_RSVD_S 12
#define IG3_STATS_GLPE_STATS_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_STATS_GLPE_STATS_ECC_COR_ERR_CNT_S 0
#define IG3_STATS_GLPE_STATS_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_STATS_GLPE_STATS_ECC_UNCOR_ERR 0x4266EFA0
#define IG3_STATS_GLPE_STATS_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_STATS_GLPE_STATS_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_STATS_GLPE_STATS_ECC_UNCOR_ERR_CNT_S 0
#define IG3_STATS_GLPE_STATS_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG 0x4266EF98
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_RSVD3_S 20
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_RM_S 16
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_RSVD2_S 14
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_RME_S 12
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_RSVD1_S 10
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_ERR_CNT_S 9
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_FIX_CNT_S 8
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_RSVD0_S 6
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_MASK_INT_S 5
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_LS_BYPASS_S 4
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_LS_FORCE_S 3
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_ECC_EN_S 0
#define IG3_STATS_GLPE_STATS_FOUR_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS 0x4266EF9C
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS_RSVD1_S 30
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS_RSVD0_S 4
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS_INIT_DONE_S 2
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS_ECC_FIX_S 1
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS_ECC_ERR_S 0
#define IG3_STATS_GLPE_STATS_FOUR_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG 0x4266EF68
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_RSVD3_S 20
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_RM_S 16
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_RSVD2_S 14
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_RME_S 12
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_RSVD1_S 10
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_ERR_CNT_S 9
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_FIX_CNT_S 8
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_RSVD0_S 6
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_MASK_INT_S 5
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_LS_FORCE_S 3
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_ECC_EN_S 0
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS 0x4266EF6C
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS_RSVD1_S 30
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS_RSVD0_S 4
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS_INIT_DONE_S 2
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS_ECC_FIX_S 1
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS_ECC_ERR_S 0
#define IG3_STATS_GLPE_STATS_ONE_0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG 0x4266EF70
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_RSVD3_S 20
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_RM_S 16
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_RSVD2_S 14
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_RME_S 12
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_RSVD1_S 10
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_ERR_CNT_S 9
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_FIX_CNT_S 8
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_RSVD0_S 6
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_MASK_INT_S 5
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_LS_BYPASS_S 4
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_LS_FORCE_S 3
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_ECC_EN_S 0
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS 0x4266EF74
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS_RSVD1_S 30
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS_RSVD0_S 4
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS_INIT_DONE_S 2
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS_ECC_FIX_S 1
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS_ECC_ERR_S 0
#define IG3_STATS_GLPE_STATS_ONE_1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG 0x4266EF88
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_RSVD3_S 20
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_RM_S 16
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_RSVD2_S 14
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_RME_S 12
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_RSVD1_S 10
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_ERR_CNT_S 9
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_FIX_CNT_S 8
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_RSVD0_S 6
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_MASK_INT_S 5
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_LS_FORCE_S 3
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_ECC_EN_S 0
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS 0x4266EF8C
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS_RSVD1_S 30
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS_RSVD0_S 4
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS_INIT_DONE_S 2
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS_ECC_FIX_S 1
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS_ECC_ERR_S 0
#define IG3_STATS_GLPE_STATS_THREE_0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG 0x4266EF90
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_RSVD3_S 20
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_RM_S 16
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_RSVD2_S 14
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_RME_S 12
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_RSVD1_S 10
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_ERR_CNT_S 9
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_FIX_CNT_S 8
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_RSVD0_S 6
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_MASK_INT_S 5
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_LS_BYPASS_S 4
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_LS_FORCE_S 3
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_ECC_EN_S 0
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS 0x4266EF94
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS_RSVD1_S 30
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS_RSVD0_S 4
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS_INIT_DONE_S 2
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS_ECC_FIX_S 1
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS_ECC_ERR_S 0
#define IG3_STATS_GLPE_STATS_THREE_1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG 0x4266EF78
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_RSVD3_S 20
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_RM_S 16
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_RSVD2_S 14
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_RME_S 12
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_RSVD1_S 10
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_ERR_CNT_S 9
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_FIX_CNT_S 8
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_RSVD0_S 6
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_MASK_INT_S 5
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_LS_FORCE_S 3
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_ECC_EN_S 0
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS 0x4266EF7C
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS_RSVD1_S 30
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS_RSVD0_S 4
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS_INIT_DONE_S 2
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS_ECC_FIX_S 1
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS_ECC_ERR_S 0
#define IG3_STATS_GLPE_STATS_TWO_0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG 0x4266EF80
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_RSVD3_S 20
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_RM_S 16
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_RSVD2_S 14
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_RME_S 12
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_RSVD1_S 10
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_ERR_CNT_S 9
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_FIX_CNT_S 8
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_RSVD0_S 6
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_MASK_INT_S 5
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_LS_BYPASS_S 4
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_LS_FORCE_S 3
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_ECC_EN_S 0
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS 0x4266EF84
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS_RSVD1_S 30
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS_RSVD0_S 4
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS_INIT_DONE_S 2
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS_ECC_FIX_S 1
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS_ECC_ERR_S 0
#define IG3_STATS_GLPE_STATS_TWO_1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_CEQMAX 0x42807214
#define IG3_PMAT_GLHMC_CEQMAX_RSVD_S 12
#define IG3_PMAT_GLHMC_CEQMAX_RSVD GENMASK_ULL(12, 31)
#define IG3_PMAT_GLHMC_CEQMAX_GLHMC_CEQMAX_S 0
#define IG3_PMAT_GLHMC_CEQMAX_GLHMC_CEQMAX GENMASK_ULL(0, 11)
#define IG3_PMAT_GLHMC_DBCQMAX 0x42807210
#define IG3_PMAT_GLHMC_DBCQMAX_RSVD_S 22
#define IG3_PMAT_GLHMC_DBCQMAX_RSVD GENMASK_ULL(22, 31)
#define IG3_PMAT_GLHMC_DBCQMAX_GLHMC_DBCQMAX_S 0
#define IG3_PMAT_GLHMC_DBCQMAX_GLHMC_DBCQMAX GENMASK_ULL(0, 21)
#define IG3_PMAT_GLHMC_DBQPMAX 0x4280720C
#define IG3_PMAT_GLHMC_DBQPMAX_RSVD_S 21
#define IG3_PMAT_GLHMC_DBQPMAX_RSVD GENMASK_ULL(21, 31)
#define IG3_PMAT_GLHMC_DBQPMAX_GLHMC_DBQPMAX_S 0
#define IG3_PMAT_GLHMC_DBQPMAX_GLHMC_DBQPMAX GENMASK_ULL(0, 20)
#define IG3_PMAT_GLHMC_DEBUG 0x428071C4
#define IG3_PMAT_GLHMC_DEBUG_RSVD_S 4
#define IG3_PMAT_GLHMC_DEBUG_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_DEBUG_NAK_DIS_S 3
#define IG3_PMAT_GLHMC_DEBUG_NAK_DIS_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_DEBUG_PD_DIS_S 2
#define IG3_PMAT_GLHMC_DEBUG_PD_DIS_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_DEBUG_MEM_DIS_S 1
#define IG3_PMAT_GLHMC_DEBUG_MEM_DIS_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_DEBUG_SOFT_RESET_S 0
#define IG3_PMAT_GLHMC_DEBUG_SOFT_RESET_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_DOMAIN_ID 0x4280721C
#define IG3_PMAT_GLHMC_DOMAIN_ID_RSVD_S 3
#define IG3_PMAT_GLHMC_DOMAIN_ID_RSVD GENMASK_ULL(3, 31)
#define IG3_PMAT_GLHMC_DOMAIN_ID_ATOMIC_DOMAIN_ID_S 0
#define IG3_PMAT_GLHMC_DOMAIN_ID_ATOMIC_DOMAIN_ID GENMASK_ULL(0, 2)
#define IG3_PMAT_GLHMC_FSIAVBASE(_i) (0x42830000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_FSIAVBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_FSIAVBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_FSIAVBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_FSIAVBASE_FPMFSIAVBASE_S 0
#define IG3_PMAT_GLHMC_FSIAVBASE_FPMFSIAVBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_FSIAVCNT(_i) (0x42832000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_FSIAVCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_FSIAVCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_FSIAVCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_FSIAVCNT_FPMFSIAVCNT_S 0
#define IG3_PMAT_GLHMC_FSIAVCNT_FPMFSIAVCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_FSIAVMAX 0x428071A0
#define IG3_PMAT_GLHMC_FSIAVMAX_RSVD_S 22
#define IG3_PMAT_GLHMC_FSIAVMAX_RSVD GENMASK_ULL(22, 31)
#define IG3_PMAT_GLHMC_FSIAVMAX_PMFSIAVMAX_S 0
#define IG3_PMAT_GLHMC_FSIAVMAX_PMFSIAVMAX GENMASK_ULL(0, 21)
#define IG3_PMAT_GLHMC_FSIAVOBJSZ 0x4280719C
#define IG3_PMAT_GLHMC_FSIAVOBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_FSIAVOBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_FSIAVOBJSZ_PMFSIAVOBJSZ_S 0
#define IG3_PMAT_GLHMC_FSIAVOBJSZ_PMFSIAVOBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_FSIMCBASE(_i) (0x42844000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_FSIMCBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_FSIMCBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_FSIMCBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_FSIMCBASE_FPMFSIMCBASE_S 0
#define IG3_PMAT_GLHMC_FSIMCBASE_FPMFSIMCBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_FSIMCCNT(_i) (0x42846000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_FSIMCCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_FSIMCCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_FSIMCCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_FSIMCCNT_FPMFSIMCSZ_S 0
#define IG3_PMAT_GLHMC_FSIMCCNT_FPMFSIMCSZ GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_FSIMCMAX 0x42807198
#define IG3_PMAT_GLHMC_FSIMCMAX_RSVD_S 14
#define IG3_PMAT_GLHMC_FSIMCMAX_RSVD GENMASK_ULL(14, 31)
#define IG3_PMAT_GLHMC_FSIMCMAX_PMFSIMCMAX_S 0
#define IG3_PMAT_GLHMC_FSIMCMAX_PMFSIMCMAX GENMASK_ULL(0, 13)
#define IG3_PMAT_GLHMC_FSIMCOBJSZ 0x42807194
#define IG3_PMAT_GLHMC_FSIMCOBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_FSIMCOBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_FSIMCOBJSZ_PMFSIMCOBJSZ_S 0
#define IG3_PMAT_GLHMC_FSIMCOBJSZ_PMFSIMCOBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_FWPDINV 0x428071B8
#define IG3_PMAT_GLHMC_FWPDINV_RSVD1_S 25
#define IG3_PMAT_GLHMC_FWPDINV_RSVD1 GENMASK_ULL(25, 31)
#define IG3_PMAT_GLHMC_FWPDINV_PMPDIDX_S 16
#define IG3_PMAT_GLHMC_FWPDINV_PMPDIDX GENMASK_ULL(16, 24)
#define IG3_PMAT_GLHMC_FWPDINV_RSVD_S 15
#define IG3_PMAT_GLHMC_FWPDINV_RSVD_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_FWPDINV_PMSDIDX_S 0
#define IG3_PMAT_GLHMC_FWPDINV_PMSDIDX GENMASK_ULL(0, 14)
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0 0x428071F8
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_CMD_DONE_S 31
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_CMD_DONE_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_CMD_FAILED_S 30
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_CMD_FAILED_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_RSVD2_S 29
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_RSVD2_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_OBJ_VDEV_VF_TYPE_S 27
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_OBJ_VDEV_VF_TYPE GENMASK_ULL(27, 28)
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_RSVD1_S 26
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_RSVD1_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_OBJ_VDEV_VF_NUM_S 16
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_OBJ_VDEV_VF_NUM GENMASK_ULL(16, 25)
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_CMD_S 13
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_CMD GENMASK_ULL(13, 15)
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_OBJ_TYPE_S 8
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_OBJ_TYPE GENMASK_ULL(8, 12)
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_RSVD0_S 6
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_OBJ_PF_NUM_S 0
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL0_OBJ_PF_NUM GENMASK_ULL(0, 5)
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL1 0x428071FC
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL1_RSVD_S 28
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL1_RSVD GENMASK_ULL(28, 31)
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL1_OBJ_INDEX_S 0
#define IG3_PMAT_GLHMC_IMCOBJCACHECTL1_OBJ_INDEX GENMASK_ULL(0, 27)
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0(_i) (0x42807000 + ((_i) * 4)) /* _i=0...15 */
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_MAX_INDEX_I 15
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_CMD_DONE_S 31
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_CMD_DONE_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_CMD_FAILED_S 30
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_CMD_FAILED_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_RSVD2_S 29
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_RSVD2_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_OBJ_VDEV_VF_TYPE_S 27
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_OBJ_VDEV_VF_TYPE GENMASK_ULL(27, 28)
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_RSVD1_S 26
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_RSVD1_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_OBJ_VDEV_VF_NUM_S 16
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_OBJ_VDEV_VF_NUM GENMASK_ULL(16, 25)
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_CMD_S 13
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_CMD GENMASK_ULL(13, 15)
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_OBJ_TYPE_S 8
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_OBJ_TYPE GENMASK_ULL(8, 12)
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_RSVD0_S 6
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_OBJ_PF_NUM_S 0
#define IG3_PMAT_GLHMC_OBJECTCACHECTL0_OBJ_PF_NUM GENMASK_ULL(0, 5)
#define IG3_PMAT_GLHMC_OBJECTCACHECTL1(_i) (0x42807100 + ((_i) * 4)) /* _i=0...15 */
#define IG3_PMAT_GLHMC_OBJECTCACHECTL1_MAX_INDEX_I 15
#define IG3_PMAT_GLHMC_OBJECTCACHECTL1_RSVD_S 28
#define IG3_PMAT_GLHMC_OBJECTCACHECTL1_RSVD GENMASK_ULL(28, 31)
#define IG3_PMAT_GLHMC_OBJECTCACHECTL1_OBJ_INDEX_S 0
#define IG3_PMAT_GLHMC_OBJECTCACHECTL1_OBJ_INDEX GENMASK_ULL(0, 27)
#define IG3_PMAT_GLHMC_PASID(_i) (0x42802000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PASID_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PASID_RSVD_S 21
#define IG3_PMAT_GLHMC_PASID_RSVD GENMASK_ULL(21, 31)
#define IG3_PMAT_GLHMC_PASID_PASID_VALID_S 20
#define IG3_PMAT_GLHMC_PASID_PASID_VALID_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_PASID_PASID_S 0
#define IG3_PMAT_GLHMC_PASID_PASID GENMASK_ULL(0, 19)
#define IG3_PMAT_GLHMC_PE32BRSVDBASE(_i) (0x4283C000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PE32BRSVDBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PE32BRSVDBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PE32BRSVDBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PE32BRSVDBASE_FPMPE32BRSVDBASE_S 0
#define IG3_PMAT_GLHMC_PE32BRSVDBASE_FPMPE32BRSVDBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PE32BRSVDCNT(_i) (0x4283E000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PE32BRSVDCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PE32BRSVDCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PE32BRSVDCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PE32BRSVDCNT_FPMPE32BRSVDCNT_S 0
#define IG3_PMAT_GLHMC_PE32BRSVDCNT_FPMPE32BRSVDCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PE32BRSVDMAX 0x428071D4
#define IG3_PMAT_GLHMC_PE32BRSVDMAX_RSVD_S 29
#define IG3_PMAT_GLHMC_PE32BRSVDMAX_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PE32BRSVDMAX_PMPE32BRSVDMAX_S 0
#define IG3_PMAT_GLHMC_PE32BRSVDMAX_PMPE32BRSVDMAX GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PE32BRSVDOBJSZ 0x428071D0
#define IG3_PMAT_GLHMC_PE32BRSVDOBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_PE32BRSVDOBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_PE32BRSVDOBJSZ_PMPE32BRSVDOBJSZ_S 0
#define IG3_PMAT_GLHMC_PE32BRSVDOBJSZ_PMPE32BRSVDOBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_PE64BRSVDBASE(_i) (0x42840000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PE64BRSVDBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PE64BRSVDBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PE64BRSVDBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PE64BRSVDBASE_FPMPE64BRSVDBASE_S 0
#define IG3_PMAT_GLHMC_PE64BRSVDBASE_FPMPE64BRSVDBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PE64BRSVDCNT(_i) (0x42842000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PE64BRSVDCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PE64BRSVDCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PE64BRSVDCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PE64BRSVDCNT_FPMPE64BRSVDCNT_S 0
#define IG3_PMAT_GLHMC_PE64BRSVDCNT_FPMPE64BRSVDCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PE64BRSVDMAX 0x428071DC
#define IG3_PMAT_GLHMC_PE64BRSVDMAX_RSVD_S 29
#define IG3_PMAT_GLHMC_PE64BRSVDMAX_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PE64BRSVDMAX_PMPE64BRSVDMAX_S 0
#define IG3_PMAT_GLHMC_PE64BRSVDMAX_PMPE64BRSVDMAX GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PE64BRSVDOBJSZ 0x428071D8
#define IG3_PMAT_GLHMC_PE64BRSVDOBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_PE64BRSVDOBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_PE64BRSVDOBJSZ_PMPE64BRSVDOBJSZ_S 0
#define IG3_PMAT_GLHMC_PE64BRSVDOBJSZ_PMPE64BRSVDOBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_PEARPBASE(_i) (0x42818000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEARPBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEARPBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PEARPBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PEARPBASE_FPMPEARPBASE_S 0
#define IG3_PMAT_GLHMC_PEARPBASE_FPMPEARPBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PEARPCNT(_i) (0x4281A000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEARPCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEARPCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PEARPCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PEARPCNT_FPMPEARPCNT_S 0
#define IG3_PMAT_GLHMC_PEARPCNT_FPMPEARPCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PEARPMAX 0x42807170
#define IG3_PMAT_GLHMC_PEARPMAX_RSVD_S 17
#define IG3_PMAT_GLHMC_PEARPMAX_RSVD GENMASK_ULL(17, 31)
#define IG3_PMAT_GLHMC_PEARPMAX_PMPEARPMAX_S 0
#define IG3_PMAT_GLHMC_PEARPMAX_PMPEARPMAX GENMASK_ULL(0, 16)
#define IG3_PMAT_GLHMC_PEARPOBJSZ 0x4280716C
#define IG3_PMAT_GLHMC_PEARPOBJSZ_RSVD_S 3
#define IG3_PMAT_GLHMC_PEARPOBJSZ_RSVD GENMASK_ULL(3, 31)
#define IG3_PMAT_GLHMC_PEARPOBJSZ_PMPEARPOBJSZ_S 0
#define IG3_PMAT_GLHMC_PEARPOBJSZ_PMPEARPOBJSZ GENMASK_ULL(0, 2)
#define IG3_PMAT_GLHMC_PECQBASE(_i) (0x4280C000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PECQBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PECQBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PECQBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PECQBASE_FPMPECQBASE_S 0
#define IG3_PMAT_GLHMC_PECQBASE_FPMPECQBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PECQCNT(_i) (0x4280E000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PECQCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PECQCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PECQCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PECQCNT_FPMPECQCNT_S 0
#define IG3_PMAT_GLHMC_PECQCNT_FPMPECQCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PECQOBJSZ 0x42807158
#define IG3_PMAT_GLHMC_PECQOBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_PECQOBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_PECQOBJSZ_PMPECQOBJSZ_S 0
#define IG3_PMAT_GLHMC_PECQOBJSZ_PMPECQOBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_PEHDRBASE(_i) (0x42848000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEHDRBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEHDRBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PEHDRBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PEHDRBASE_GLHMC_PEHDRBASE_S 0
#define IG3_PMAT_GLHMC_PEHDRBASE_GLHMC_PEHDRBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PEHDRCNT(_i) (0x4284A000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEHDRCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEHDRCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PEHDRCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PEHDRCNT_GLHMC_PEHDRCNT_S 0
#define IG3_PMAT_GLHMC_PEHDRCNT_GLHMC_PEHDRCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PEHDRMAX 0x42807148
#define IG3_PMAT_GLHMC_PEHDRMAX_RSVD_S 21
#define IG3_PMAT_GLHMC_PEHDRMAX_RSVD GENMASK_ULL(21, 31)
#define IG3_PMAT_GLHMC_PEHDRMAX_PMPEHDRMAX_S 0
#define IG3_PMAT_GLHMC_PEHDRMAX_PMPEHDRMAX GENMASK_ULL(0, 20)
#define IG3_PMAT_GLHMC_PEHDROBJSZ 0x42807144
#define IG3_PMAT_GLHMC_PEHDROBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_PEHDROBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_PEHDROBJSZ_PMPEHDROBJSZ_S 0
#define IG3_PMAT_GLHMC_PEHDROBJSZ_PMPEHDROBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_PEHTCNT(_i) (0x42816000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEHTCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEHTCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PEHTCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PEHTCNT_FPMPEHTCNT_S 0
#define IG3_PMAT_GLHMC_PEHTCNT_FPMPEHTCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PEHTEBASE(_i) (0x42814000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEHTEBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEHTEBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PEHTEBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PEHTEBASE_FPMPEHTEBASE_S 0
#define IG3_PMAT_GLHMC_PEHTEBASE_FPMPEHTEBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PEHTEOBJSZ 0x42807164
#define IG3_PMAT_GLHMC_PEHTEOBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_PEHTEOBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_PEHTEOBJSZ_PMPEHTEOBJSZ_S 0
#define IG3_PMAT_GLHMC_PEHTEOBJSZ_PMPEHTEOBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_PEHTMAX 0x42807168
#define IG3_PMAT_GLHMC_PEHTMAX_RSVD_S 21
#define IG3_PMAT_GLHMC_PEHTMAX_RSVD GENMASK_ULL(21, 31)
#define IG3_PMAT_GLHMC_PEHTMAX_PMPEHTMAX_S 0
#define IG3_PMAT_GLHMC_PEHTMAX_PMPEHTMAX GENMASK_ULL(0, 20)
#define IG3_PMAT_GLHMC_PEMRBASE(_i) (0x4281C000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEMRBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEMRBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PEMRBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PEMRBASE_FPMPEMRBASE_S 0
#define IG3_PMAT_GLHMC_PEMRBASE_FPMPEMRBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PEMRCNT(_i) (0x4281E000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEMRCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEMRCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PEMRCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PEMRCNT_FPMPEMRSZ_S 0
#define IG3_PMAT_GLHMC_PEMRCNT_FPMPEMRSZ GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PEMRMAX 0x42807178
#define IG3_PMAT_GLHMC_PEMRMAX_RSVD_S 23
#define IG3_PMAT_GLHMC_PEMRMAX_RSVD GENMASK_ULL(23, 31)
#define IG3_PMAT_GLHMC_PEMRMAX_PMPEMRMAX_S 0
#define IG3_PMAT_GLHMC_PEMRMAX_PMPEMRMAX GENMASK_ULL(0, 22)
#define IG3_PMAT_GLHMC_PEMROBJSZ 0x42807174
#define IG3_PMAT_GLHMC_PEMROBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_PEMROBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_PEMROBJSZ_PMPEMROBJSZ_S 0
#define IG3_PMAT_GLHMC_PEMROBJSZ_PMPEMROBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0 0x428071F0
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_CMD_DONE_S 31
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_CMD_DONE_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_CMD_FAILED_S 30
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_CMD_FAILED_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_RSVD2_S 29
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_RSVD2_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_OBJ_VDEV_VF_TYPE_S 27
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_OBJ_VDEV_VF_TYPE GENMASK_ULL(27, 28)
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_RSVD1_S 26
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_RSVD1_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_OBJ_VDEV_VF_NUM_S 16
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_OBJ_VDEV_VF_NUM GENMASK_ULL(16, 25)
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_CMD_S 13
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_CMD GENMASK_ULL(13, 15)
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_OBJ_TYPE_S 8
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_OBJ_TYPE GENMASK_ULL(8, 12)
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_RSVD0_S 6
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_OBJ_PF_NUM_S 0
#define IG3_PMAT_GLHMC_PEOBJCACHECTL0_OBJ_PF_NUM GENMASK_ULL(0, 5)
#define IG3_PMAT_GLHMC_PEOBJCACHECTL1 0x428071F4
#define IG3_PMAT_GLHMC_PEOBJCACHECTL1_RSVD_S 28
#define IG3_PMAT_GLHMC_PEOBJCACHECTL1_RSVD GENMASK_ULL(28, 31)
#define IG3_PMAT_GLHMC_PEOBJCACHECTL1_OBJ_INDEX_S 0
#define IG3_PMAT_GLHMC_PEOBJCACHECTL1_OBJ_INDEX GENMASK_ULL(0, 27)
#define IG3_PMAT_GLHMC_PEOOISCBASE(_i) (0x4284C000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEOOISCBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEOOISCBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PEOOISCBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PEOOISCBASE_GLHMC_PEOOISCBASE_S 0
#define IG3_PMAT_GLHMC_PEOOISCBASE_GLHMC_PEOOISCBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PEOOISCCNT(_i) (0x4284E000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEOOISCCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEOOISCCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PEOOISCCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PEOOISCCNT_GLHMC_PEOOISCCNT_S 0
#define IG3_PMAT_GLHMC_PEOOISCCNT_GLHMC_PEOOISCCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PEOOISCFFLBASE(_i) (0x42858000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEOOISCFFLBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEOOISCFFLBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PEOOISCFFLBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PEOOISCFFLBASE_GLHMC_PEOOISCFFLBASE_S 0
#define IG3_PMAT_GLHMC_PEOOISCFFLBASE_GLHMC_PEOOISCFFLBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PEOOISCFFLCNT_PMAT(_i) (0x4285A000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEOOISCFFLCNT_PMAT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEOOISCFFLCNT_PMAT_RSVD_S 29
#define IG3_PMAT_GLHMC_PEOOISCFFLCNT_PMAT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PEOOISCFFLCNT_PMAT_FPMPEOOISCFFLCNT_S 0
#define IG3_PMAT_GLHMC_PEOOISCFFLCNT_PMAT_FPMPEOOISCFFLCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PEOOISCFFLMAX 0x428071EC
#define IG3_PMAT_GLHMC_PEOOISCFFLMAX_RSVD_S 21
#define IG3_PMAT_GLHMC_PEOOISCFFLMAX_RSVD GENMASK_ULL(21, 31)
#define IG3_PMAT_GLHMC_PEOOISCFFLMAX_PMPEOOISCFFLMAX_S 0
#define IG3_PMAT_GLHMC_PEOOISCFFLMAX_PMPEOOISCFFLMAX GENMASK_ULL(0, 20)
#define IG3_PMAT_GLHMC_PEOOISCMAX 0x42807150
#define IG3_PMAT_GLHMC_PEOOISCMAX_RSVD_S 21
#define IG3_PMAT_GLHMC_PEOOISCMAX_RSVD GENMASK_ULL(21, 31)
#define IG3_PMAT_GLHMC_PEOOISCMAX_PMPEOOISCMAX_S 0
#define IG3_PMAT_GLHMC_PEOOISCMAX_PMPEOOISCMAX GENMASK_ULL(0, 20)
#define IG3_PMAT_GLHMC_PEOOISCOBJSZ 0x4280714C
#define IG3_PMAT_GLHMC_PEOOISCOBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_PEOOISCOBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_PEOOISCOBJSZ_PMPEOOISCOBJSZ_S 0
#define IG3_PMAT_GLHMC_PEOOISCOBJSZ_PMPEOOISCOBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_PEPBLBASE(_i) (0x42834000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEPBLBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEPBLBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PEPBLBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PEPBLBASE_FPMPEPBLBASE_S 0
#define IG3_PMAT_GLHMC_PEPBLBASE_FPMPEPBLBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PEPBLCNT(_i) (0x42836000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEPBLCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEPBLCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PEPBLCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PEPBLCNT_FPMPEPBLCNT_S 0
#define IG3_PMAT_GLHMC_PEPBLCNT_FPMPEPBLCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PEPBLMAX 0x428071A4
#define IG3_PMAT_GLHMC_PEPBLMAX_RSVD_S 29
#define IG3_PMAT_GLHMC_PEPBLMAX_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PEPBLMAX_PMPEPBLMAX_S 0
#define IG3_PMAT_GLHMC_PEPBLMAX_PMPEPBLMAX GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PEQ1BASE(_i) (0x42828000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEQ1BASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEQ1BASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PEQ1BASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PEQ1BASE_FPMPEQ1BASE_S 0
#define IG3_PMAT_GLHMC_PEQ1BASE_FPMPEQ1BASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PEQ1CNT(_i) (0x4282A000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEQ1CNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEQ1CNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PEQ1CNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PEQ1CNT_FPMPEQ1CNT_S 0
#define IG3_PMAT_GLHMC_PEQ1CNT_FPMPEQ1CNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PEQ1FLBASE(_i) (0x4282C000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEQ1FLBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEQ1FLBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PEQ1FLBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PEQ1FLBASE_FPMPEQ1FLBASE_S 0
#define IG3_PMAT_GLHMC_PEQ1FLBASE_FPMPEQ1FLBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PEQ1FLCNT_PMAT(_i) (0x4282E000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEQ1FLCNT_PMAT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEQ1FLCNT_PMAT_RSVD_S 29
#define IG3_PMAT_GLHMC_PEQ1FLCNT_PMAT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PEQ1FLCNT_PMAT_FPMPEQ1FLCNT_S 0
#define IG3_PMAT_GLHMC_PEQ1FLCNT_PMAT_FPMPEQ1FLCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PEQ1FLMAX 0x42807190
#define IG3_PMAT_GLHMC_PEQ1FLMAX_RSVD_S 28
#define IG3_PMAT_GLHMC_PEQ1FLMAX_RSVD GENMASK_ULL(28, 31)
#define IG3_PMAT_GLHMC_PEQ1FLMAX_PMPEQ1FLMAX_S 0
#define IG3_PMAT_GLHMC_PEQ1FLMAX_PMPEQ1FLMAX GENMASK_ULL(0, 27)
#define IG3_PMAT_GLHMC_PEQ1MAX 0x4280718C
#define IG3_PMAT_GLHMC_PEQ1MAX_RSVD_S 28
#define IG3_PMAT_GLHMC_PEQ1MAX_RSVD GENMASK_ULL(28, 31)
#define IG3_PMAT_GLHMC_PEQ1MAX_PMPEQ1MAX_S 0
#define IG3_PMAT_GLHMC_PEQ1MAX_PMPEQ1MAX GENMASK_ULL(0, 27)
#define IG3_PMAT_GLHMC_PEQ1OBJSZ 0x42807188
#define IG3_PMAT_GLHMC_PEQ1OBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_PEQ1OBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_PEQ1OBJSZ_PMPEQ1OBJSZ_S 0
#define IG3_PMAT_GLHMC_PEQ1OBJSZ_PMPEQ1OBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_PEQPBASE(_i) (0x42808000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEQPBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEQPBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PEQPBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PEQPBASE_FPMPEQPBASE_S 0
#define IG3_PMAT_GLHMC_PEQPBASE_FPMPEQPBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PEQPCNT(_i) (0x4280A000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEQPCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEQPCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PEQPCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PEQPCNT_FPMPEQPCNT_S 0
#define IG3_PMAT_GLHMC_PEQPCNT_FPMPEQPCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PEQPOBJSZ 0x42807154
#define IG3_PMAT_GLHMC_PEQPOBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_PEQPOBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_PEQPOBJSZ_PMPEQPOBJSZ_S 0
#define IG3_PMAT_GLHMC_PEQPOBJSZ_PMPEQPOBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_PERRFBASE(_i) (0x42850000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PERRFBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PERRFBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PERRFBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PERRFBASE_GLHMC_PERRFBASE_S 0
#define IG3_PMAT_GLHMC_PERRFBASE_GLHMC_PERRFBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PERRFCNT(_i) (0x42852000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PERRFCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PERRFCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PERRFCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PERRFCNT_GLHMC_PERRFCNT_S 0
#define IG3_PMAT_GLHMC_PERRFCNT_GLHMC_PERRFCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PERRFFLBASE(_i) (0x42854000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PERRFFLBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PERRFFLBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PERRFFLBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PERRFFLBASE_GLHMC_PERRFFLBASE_S 0
#define IG3_PMAT_GLHMC_PERRFFLBASE_GLHMC_PERRFFLBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PERRFFLCNT_PMAT(_i) (0x42856000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PERRFFLCNT_PMAT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PERRFFLCNT_PMAT_RSVD_S 29
#define IG3_PMAT_GLHMC_PERRFFLCNT_PMAT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PERRFFLCNT_PMAT_FPMPERRFFLCNT_S 0
#define IG3_PMAT_GLHMC_PERRFFLCNT_PMAT_FPMPERRFFLCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PERRFFLMAX 0x428071E8
#define IG3_PMAT_GLHMC_PERRFFLMAX_RSVD_S 27
#define IG3_PMAT_GLHMC_PERRFFLMAX_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PERRFFLMAX_PMPERRFFLMAX_S 0
#define IG3_PMAT_GLHMC_PERRFFLMAX_PMPERRFFLMAX GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PERRFMAX 0x428071E4
#define IG3_PMAT_GLHMC_PERRFMAX_RSVD_S 28
#define IG3_PMAT_GLHMC_PERRFMAX_RSVD GENMASK_ULL(28, 31)
#define IG3_PMAT_GLHMC_PERRFMAX_PMPERRFMAX_S 0
#define IG3_PMAT_GLHMC_PERRFMAX_PMPERRFMAX GENMASK_ULL(0, 27)
#define IG3_PMAT_GLHMC_PERRFOBJSZ 0x428071E0
#define IG3_PMAT_GLHMC_PERRFOBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_PERRFOBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_PERRFOBJSZ_PMPERRFOBJSZ_S 0
#define IG3_PMAT_GLHMC_PERRFOBJSZ_PMPERRFOBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_PESRQBASE(_i) (0x42810000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PESRQBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PESRQBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PESRQBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PESRQBASE_FPMPESRQBASE_S 0
#define IG3_PMAT_GLHMC_PESRQBASE_FPMPESRQBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PESRQCNT(_i) (0x42812000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PESRQCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PESRQCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PESRQCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PESRQCNT_FPMPESRQCNT_S 0
#define IG3_PMAT_GLHMC_PESRQCNT_FPMPESRQCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PESRQMAX 0x42807160
#define IG3_PMAT_GLHMC_PESRQMAX_RSVD_S 17
#define IG3_PMAT_GLHMC_PESRQMAX_RSVD GENMASK_ULL(17, 31)
#define IG3_PMAT_GLHMC_PESRQMAX_PMPESRQMAX_S 0
#define IG3_PMAT_GLHMC_PESRQMAX_PMPESRQMAX GENMASK_ULL(0, 16)
#define IG3_PMAT_GLHMC_PESRQOBJSZ 0x4280715C
#define IG3_PMAT_GLHMC_PESRQOBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_PESRQOBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_PESRQOBJSZ_PMPESRQOBJSZ_S 0
#define IG3_PMAT_GLHMC_PESRQOBJSZ_PMPESRQOBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_PETIMERBASE(_i) (0x42838000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PETIMERBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PETIMERBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PETIMERBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PETIMERBASE_FPMPETIMERBASE_S 0
#define IG3_PMAT_GLHMC_PETIMERBASE_FPMPETIMERBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PETIMERCNT(_i) (0x4283A000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PETIMERCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PETIMERCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PETIMERCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PETIMERCNT_FPMPETIMERCNT_S 0
#define IG3_PMAT_GLHMC_PETIMERCNT_FPMPETIMERCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PETIMERMAX 0x428071CC
#define IG3_PMAT_GLHMC_PETIMERMAX_RSVD_S 29
#define IG3_PMAT_GLHMC_PETIMERMAX_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PETIMERMAX_PMPETIMERMAX_S 0
#define IG3_PMAT_GLHMC_PETIMERMAX_PMPETIMERMAX GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PETIMEROBJSZ 0x428071C8
#define IG3_PMAT_GLHMC_PETIMEROBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_PETIMEROBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_PETIMEROBJSZ_PMPETIMEROBJSZ_S 0
#define IG3_PMAT_GLHMC_PETIMEROBJSZ_PMPETIMEROBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_PEXFBASE(_i) (0x42820000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEXFBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEXFBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PEXFBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PEXFBASE_FPMPEXFBASE_S 0
#define IG3_PMAT_GLHMC_PEXFBASE_FPMPEXFBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PEXFCNT(_i) (0x42822000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEXFCNT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEXFCNT_RSVD_S 29
#define IG3_PMAT_GLHMC_PEXFCNT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PEXFCNT_FPMPEXFCNT_S 0
#define IG3_PMAT_GLHMC_PEXFCNT_FPMPEXFCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PEXFFLBASE(_i) (0x42824000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEXFFLBASE_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEXFFLBASE_RSVD_S 27
#define IG3_PMAT_GLHMC_PEXFFLBASE_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PEXFFLBASE_FPMPEXFFLBASE_S 0
#define IG3_PMAT_GLHMC_PEXFFLBASE_FPMPEXFFLBASE GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PEXFFLCNT_PMAT(_i) (0x42826000 + ((_i) * 4)) /* _i=0...1031 */
#define IG3_PMAT_GLHMC_PEXFFLCNT_PMAT_MAX_INDEX_I 1031
#define IG3_PMAT_GLHMC_PEXFFLCNT_PMAT_RSVD_S 29
#define IG3_PMAT_GLHMC_PEXFFLCNT_PMAT_RSVD GENMASK_ULL(29, 31)
#define IG3_PMAT_GLHMC_PEXFFLCNT_PMAT_FPMPEXFFLCNT_S 0
#define IG3_PMAT_GLHMC_PEXFFLCNT_PMAT_FPMPEXFFLCNT GENMASK_ULL(0, 28)
#define IG3_PMAT_GLHMC_PEXFFLMAX 0x42807184
#define IG3_PMAT_GLHMC_PEXFFLMAX_RSVD_S 27
#define IG3_PMAT_GLHMC_PEXFFLMAX_RSVD GENMASK_ULL(27, 31)
#define IG3_PMAT_GLHMC_PEXFFLMAX_PMPEXFFLMAX_S 0
#define IG3_PMAT_GLHMC_PEXFFLMAX_PMPEXFFLMAX GENMASK_ULL(0, 26)
#define IG3_PMAT_GLHMC_PEXFMAX 0x42807180
#define IG3_PMAT_GLHMC_PEXFMAX_RSVD_S 28
#define IG3_PMAT_GLHMC_PEXFMAX_RSVD GENMASK_ULL(28, 31)
#define IG3_PMAT_GLHMC_PEXFMAX_PMPEXFMAX_S 0
#define IG3_PMAT_GLHMC_PEXFMAX_PMPEXFMAX GENMASK_ULL(0, 27)
#define IG3_PMAT_GLHMC_PEXFOBJSZ 0x4280717C
#define IG3_PMAT_GLHMC_PEXFOBJSZ_RSVD_S 4
#define IG3_PMAT_GLHMC_PEXFOBJSZ_RSVD GENMASK_ULL(4, 31)
#define IG3_PMAT_GLHMC_PEXFOBJSZ_PMPEXFOBJSZ_S 0
#define IG3_PMAT_GLHMC_PEXFOBJSZ_PMPEXFOBJSZ GENMASK_ULL(0, 3)
#define IG3_PMAT_GLHMC_PMATCFG 0x42807140
#define IG3_PMAT_GLHMC_PMATCFG_RSVD_S 1
#define IG3_PMAT_GLHMC_PMATCFG_RSVD GENMASK_ULL(1, 31)
#define IG3_PMAT_GLHMC_PMATCFG_DISABLE_PCIE_CLK_GATING_S 0
#define IG3_PMAT_GLHMC_PMATCFG_DISABLE_PCIE_CLK_GATING_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_SDCMD 0x428071A8
#define IG3_PMAT_GLHMC_SDCMD_PMSDWR_S 31
#define IG3_PMAT_GLHMC_SDCMD_PMSDWR_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_SDCMD_RSVD_S 15
#define IG3_PMAT_GLHMC_SDCMD_RSVD GENMASK_ULL(15, 30)
#define IG3_PMAT_GLHMC_SDCMD_PMSDIDX_S 0
#define IG3_PMAT_GLHMC_SDCMD_PMSDIDX GENMASK_ULL(0, 14)
#define IG3_PMAT_GLHMC_SDDATA0 0x428071AC
#define IG3_PMAT_GLHMC_SDDATA0_PMSDDATALOW_S 12
#define IG3_PMAT_GLHMC_SDDATA0_PMSDDATALOW GENMASK_ULL(12, 31)
#define IG3_PMAT_GLHMC_SDDATA0_PMSDBPCOUNT_S 2
#define IG3_PMAT_GLHMC_SDDATA0_PMSDBPCOUNT GENMASK_ULL(2, 11)
#define IG3_PMAT_GLHMC_SDDATA0_PMSDTYPE_S 1
#define IG3_PMAT_GLHMC_SDDATA0_PMSDTYPE_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_SDDATA0_PMSDVALID_S 0
#define IG3_PMAT_GLHMC_SDDATA0_PMSDVALID_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_SDDATA1 0x428071B0
#define IG3_PMAT_GLHMC_SDDATA1_PMSDDATAHIGH_S 0
#define IG3_PMAT_GLHMC_SDDATA1_PMSDDATAHIGH GENMASK_ULL(0, 31)
#define IG3_PMAT_GLHMC_SDDATA2 0x428071B4
#define IG3_PMAT_GLHMC_SDDATA2_RSVD0_S 25
#define IG3_PMAT_GLHMC_SDDATA2_RSVD0 GENMASK_ULL(25, 31)
#define IG3_PMAT_GLHMC_SDDATA2_PMSDHOSTID_S 22
#define IG3_PMAT_GLHMC_SDDATA2_PMSDHOSTID GENMASK_ULL(22, 24)
#define IG3_PMAT_GLHMC_SDDATA2_PMF_TYPE_S 20
#define IG3_PMAT_GLHMC_SDDATA2_PMF_TYPE GENMASK_ULL(20, 21)
#define IG3_PMAT_GLHMC_SDDATA2_VF_S 10
#define IG3_PMAT_GLHMC_SDDATA2_VF GENMASK_ULL(10, 19)
#define IG3_PMAT_GLHMC_SDDATA2_PF_S 4
#define IG3_PMAT_GLHMC_SDDATA2_PF GENMASK_ULL(4, 9)
#define IG3_PMAT_GLHMC_SDDATA2_PMCHAN_S 3
#define IG3_PMAT_GLHMC_SDDATA2_PMCHAN_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_SDDATA2_PMSDMEM_S 0
#define IG3_PMAT_GLHMC_SDDATA2_PMSDMEM GENMASK_ULL(0, 2)
#define IG3_PMAT_GLHMC_SDMAX 0x42807218
#define IG3_PMAT_GLHMC_SDMAX_RSVD_S 16
#define IG3_PMAT_GLHMC_SDMAX_RSVD GENMASK_ULL(16, 31)
#define IG3_PMAT_GLHMC_SDMAX_GLHMC_SDMAX_S 0
#define IG3_PMAT_GLHMC_SDMAX_GLHMC_SDMAX GENMASK_ULL(0, 15)
#define IG3_PMAT_GLHMC_SDPARTTABLE(_i) (0x42804000 + ((_i) * 4)) /* _i=0...3071 */
#define IG3_PMAT_GLHMC_SDPARTTABLE_MAX_INDEX_I 3071
#define IG3_PMAT_GLHMC_SDPARTTABLE_SDPTVALID_S 31
#define IG3_PMAT_GLHMC_SDPARTTABLE_SDPTVALID_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_SDPARTTABLE_RSVD_S 30
#define IG3_PMAT_GLHMC_SDPARTTABLE_RSVD_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_SDPARTTABLE_SDPTPF_S 24
#define IG3_PMAT_GLHMC_SDPARTTABLE_SDPTPF GENMASK_ULL(24, 29)
#define IG3_PMAT_GLHMC_SDPARTTABLE_SDPTPMF_S 12
#define IG3_PMAT_GLHMC_SDPARTTABLE_SDPTPMF GENMASK_ULL(12, 23)
#define IG3_PMAT_GLHMC_SDPARTTABLE_SDPTBASE_S 0
#define IG3_PMAT_GLHMC_SDPARTTABLE_SDPTBASE GENMASK_ULL(0, 11)
#define IG3_PMAT_GLHMC_SPDT_LKUP_CMD 0x428071BC
#define IG3_PMAT_GLHMC_SPDT_LKUP_CMD_SDPTLKVLD_S 31
#define IG3_PMAT_GLHMC_SPDT_LKUP_CMD_SDPTLKVLD_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_SPDT_LKUP_CMD_RSVD1_S 30
#define IG3_PMAT_GLHMC_SPDT_LKUP_CMD_RSVD1_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_SPDT_LKUP_CMD_SDPTLKPF_S 24
#define IG3_PMAT_GLHMC_SPDT_LKUP_CMD_SDPTLKPF GENMASK_ULL(24, 29)
#define IG3_PMAT_GLHMC_SPDT_LKUP_CMD_SDPTLKPMF_S 12
#define IG3_PMAT_GLHMC_SPDT_LKUP_CMD_SDPTLKPMF GENMASK_ULL(12, 23)
#define IG3_PMAT_GLHMC_SPDT_LKUP_CMD_SDPTLKBASE_S 0
#define IG3_PMAT_GLHMC_SPDT_LKUP_CMD_SDPTLKBASE GENMASK_ULL(0, 11)
#define IG3_PMAT_GLHMC_SPDT_LKUP_STATUS 0x428071C0
#define IG3_PMAT_GLHMC_SPDT_LKUP_STATUS_RSVD1_S 16
#define IG3_PMAT_GLHMC_SPDT_LKUP_STATUS_RSVD1 GENMASK_ULL(16, 31)
#define IG3_PMAT_GLHMC_SPDT_LKUP_STATUS_SDPTINDEX_S 4
#define IG3_PMAT_GLHMC_SPDT_LKUP_STATUS_SDPTINDEX GENMASK_ULL(4, 15)
#define IG3_PMAT_GLHMC_SPDT_LKUP_STATUS_RSVD0_S 2
#define IG3_PMAT_GLHMC_SPDT_LKUP_STATUS_RSVD0 GENMASK_ULL(2, 3)
#define IG3_PMAT_GLHMC_SPDT_LKUP_STATUS_HIT_S 1
#define IG3_PMAT_GLHMC_SPDT_LKUP_STATUS_HIT_M BIT_ULL(31)
#define IG3_PMAT_GLHMC_SPDT_LKUP_STATUS_VLD_S 0
#define IG3_PMAT_GLHMC_SPDT_LKUP_STATUS_VLD_M BIT_ULL(31)
#define IG3_PMAT_GLPE_PMAT_XLR_ZERO 0x42807204
#define IG3_PMAT_GLPE_PMAT_XLR_ZERO_RSVD0_S 12
#define IG3_PMAT_GLPE_PMAT_XLR_ZERO_RSVD0 GENMASK_ULL(12, 31)
#define IG3_PMAT_GLPE_PMAT_XLR_ZERO_PMF_S 0
#define IG3_PMAT_GLPE_PMAT_XLR_ZERO_PMF GENMASK_ULL(0, 11)
#define IG3_PMAT_GLPE_PMAT_XLR_ZERO_STATUS 0x42807208
#define IG3_PMAT_GLPE_PMAT_XLR_ZERO_STATUS_DONE_S 31
#define IG3_PMAT_GLPE_PMAT_XLR_ZERO_STATUS_DONE_M BIT_ULL(31)
#define IG3_PMAT_GLPE_PMAT_XLR_ZERO_STATUS_RSVD0_S 12
#define IG3_PMAT_GLPE_PMAT_XLR_ZERO_STATUS_RSVD0 GENMASK_ULL(12, 30)
#define IG3_PMAT_GLPE_PMAT_XLR_ZERO_STATUS_PMF_S 0
#define IG3_PMAT_GLPE_PMAT_XLR_ZERO_STATUS_PMF GENMASK_ULL(0, 11)
#define IG3_PMAT_PFHMC_ERRORDATA(_i) (0x42800100 + ((_i) * 4)) /* _i=0...15 */
#define IG3_PMAT_PFHMC_ERRORDATA_MAX_INDEX_I 15
#define IG3_PMAT_PFHMC_ERRORDATA_RSVD_S 30
#define IG3_PMAT_PFHMC_ERRORDATA_RSVD GENMASK_ULL(30, 31)
#define IG3_PMAT_PFHMC_ERRORDATA_HMC_ERROR_DATA_S 0
#define IG3_PMAT_PFHMC_ERRORDATA_HMC_ERROR_DATA GENMASK_ULL(0, 29)
#define IG3_PMAT_PFHMC_ERRORINFO(_i) (0x42800000 + ((_i) * 4)) /* _i=0...15 */
#define IG3_PMAT_PFHMC_ERRORINFO_MAX_INDEX_I 15
#define IG3_PMAT_PFHMC_ERRORINFO_ERROR_DETECTED_S 31
#define IG3_PMAT_PFHMC_ERRORINFO_ERROR_DETECTED_M BIT_ULL(31)
#define IG3_PMAT_PFHMC_ERRORINFO_RSVD2_S 25
#define IG3_PMAT_PFHMC_ERRORINFO_RSVD2 GENMASK_ULL(25, 30)
#define IG3_PMAT_PFHMC_ERRORINFO_HMC_OBJECT_TYPE_S 20
#define IG3_PMAT_PFHMC_ERRORINFO_HMC_OBJECT_TYPE GENMASK_ULL(20, 24)
#define IG3_PMAT_PFHMC_ERRORINFO_HMC_ERROR_TYPE_S 16
#define IG3_PMAT_PFHMC_ERRORINFO_HMC_ERROR_TYPE GENMASK_ULL(16, 19)
#define IG3_PMAT_PFHMC_ERRORINFO_RSVD1_S 13
#define IG3_PMAT_PFHMC_ERRORINFO_RSVD1 GENMASK_ULL(13, 15)
#define IG3_PMAT_PFHMC_ERRORINFO_PMF_ISVF_S 12
#define IG3_PMAT_PFHMC_ERRORINFO_PMF_ISVF_M BIT_ULL(31)
#define IG3_PMAT_PFHMC_ERRORINFO_PMF_INDEX_S 0
#define IG3_PMAT_PFHMC_ERRORINFO_PMF_INDEX GENMASK_ULL(0, 11)
#define IG3_PMAT_PMAT_ECC_COR_ERR 0x4285B09C
#define IG3_PMAT_PMAT_ECC_COR_ERR_RSVD_S 12
#define IG3_PMAT_PMAT_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PMAT_PMAT_ECC_COR_ERR_CNT_S 0
#define IG3_PMAT_PMAT_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PMAT_PMAT_ECC_UNCOR_ERR 0x4285B098
#define IG3_PMAT_PMAT_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_PMAT_PMAT_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PMAT_PMAT_ECC_UNCOR_ERR_CNT_S 0
#define IG3_PMAT_PMAT_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG 0x4285B068
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_RSVD1_S 10
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS 0x4285B06C
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_LOCA0_CMPL_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG 0x4285B070
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_RSVD1_S 10
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS 0x4285B074
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_LOCA0_CQ_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG 0x4285B078
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_RSVD1_S 10
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS 0x4285B07C
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_LOCA1_CMPL_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG 0x4285B080
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_RSVD1_S 10
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS 0x4285B084
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_LOCA1_CQ_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG 0x4285B028
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_RSVD1_S 10
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS 0x4285B02C
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_OBJ_BASE_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG 0x4285B030
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_RSVD1_S 10
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS 0x4285B034
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_OBJ_BNDS_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG 0x4285B040
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_RSVD1_S 10
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS 0x4285B044
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_OBJ_BP_LNK_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG 0x4285B038
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_RSVD1_S 10
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_OBJ_BP_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS 0x4285B03C
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_OBJ_BP_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PASID_MEM_CFG 0x4285B088
#define IG3_PMAT_PMAT_PASID_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_PASID_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_PASID_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_PASID_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_PASID_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_PASID_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_PASID_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_RSVD1_S 10
#define IG3_PMAT_PMAT_PASID_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_PASID_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_PASID_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_PASID_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_PASID_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_PASID_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_PASID_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_PASID_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_PASID_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PASID_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_PASID_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PASID_MEM_STATUS 0x4285B08C
#define IG3_PMAT_PMAT_PASID_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_PASID_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_PASID_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_PASID_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_PASID_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_PASID_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_PASID_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_PASID_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PASID_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_PASID_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PASID_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_PASID_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PASID_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_PASID_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG 0x4285B058
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_RSVD1_S 10
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS 0x4285B05C
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_PCIE_CMPL_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CMP_NRDY_CNT 0x42807200
#define IG3_PMAT_PMAT_PCIE_CMP_NRDY_CNT_PCIECMPNRDYCNT_S 0
#define IG3_PMAT_PMAT_PCIE_CMP_NRDY_CNT_PCIECMPNRDYCNT GENMASK_ULL(0, 31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG 0x4285B060
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_RSVD1_S 10
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS 0x4285B064
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_PCIE_CQ_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG 0x4285B048
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_RSVD1_S 10
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS 0x4285B04C
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_PCIE_NAK_DAT_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG 0x4285B050
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_RSVD1_S 10
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS 0x4285B054
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_PCIE_NAK_HDR_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_PMAT_ST_MEM_CFG 0x4285B020
#define IG3_PMAT_PMAT_ST_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_ST_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_ST_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_ST_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_ST_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_ST_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_ST_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_ST_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_ST_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_ST_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_ST_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_ST_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_ST_MEM_CFG_RSVD1_S 10
#define IG3_PMAT_PMAT_ST_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_PMAT_ST_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_ST_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_ST_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_ST_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_ST_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_ST_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_ST_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_ST_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_ST_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_ST_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_ST_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_ST_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_ST_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_ST_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_ST_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_ST_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_ST_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_ST_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_ST_MEM_STATUS 0x4285B024
#define IG3_PMAT_PMAT_ST_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_ST_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_ST_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_ST_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_ST_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_ST_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_ST_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_ST_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_ST_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_ST_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_ST_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_ST_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_ST_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_ST_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG 0x4285B090
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_RSVD3_S 20
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_RM_S 16
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_RSVD2_S 14
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_RME_S 12
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_UPDATE_DISABLE_S 11
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_UPDATE_DISABLE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_CHECK_ERR_DISABLE_S 10
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_CHECK_ERR_DISABLE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_ERR_CNT_S 9
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_FIX_CNT_S 8
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_RSVD0_S 6
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_MASK_INT_S 5
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_LS_BYPASS_S 4
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_LS_FORCE_S 3
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_ECC_EN_S 0
#define IG3_PMAT_PMAT_TCAM_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS 0x4285B094
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS_RSVD1_S 30
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS_RSVD0_S 4
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS_INIT_DONE_S 2
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS_ECC_FIX_S 1
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS_ECC_ERR_S 0
#define IG3_PMAT_PMAT_TCAM_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_COUNT 0x42880038
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_CMD 0x4288004C
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_DATA_H 0x42880058
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_DATA_L 0x42880054
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_PTR 0x42880050
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_CMD 0x4288003C
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_DATA_H 0x42880048
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_DATA_L 0x42880044
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_PTR 0x42880040
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL 0x42880000
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_RSVD1_S 25
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_RSVD2_S 17
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_RSVD3_S 9
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_BYPASS_S 8
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_RSVD4_S 1
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_ECC_COR_ERR 0x42880068
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_ECC_UNCOR_ERR 0x42880064
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_GROUP_CFG 0x4288000C
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_LOG_CFG 0x42880010
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_LOG_CFG_RSVD1_S 2
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_LOG_CFG_MODE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_LOG_MASK 0x42880018
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_LOG_MASK_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_LOG_PATTERN 0x42880014
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_CFG 0x42880004
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_STS 0x42880008
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_STS_RSVD1_S 9
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_STS_RSVD2_S 1
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TIMESTAMP 0x42880030
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TIMESTAMP_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TIMESTAMP_ROLLOVER 0x42880034
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG 0x4288005C
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS 0x42880060
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_CFG 0x4288001C
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_CFG_MODE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_COUNT 0x42880028
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_MASK 0x42880024
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_MASK_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_PATTERN 0x42880020
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_TIMESTAMP 0x4288002C
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_PMAT_DTM_GLPE_PMAT_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_CACHESIZE 0x42880480
#define IG3_PDOC_GLPDOC_CACHESIZE_RSVD_S 24
#define IG3_PDOC_GLPDOC_CACHESIZE_RSVD GENMASK_ULL(24, 31)
#define IG3_PDOC_GLPDOC_CACHESIZE_WAYS_S 20
#define IG3_PDOC_GLPDOC_CACHESIZE_WAYS GENMASK_ULL(20, 23)
#define IG3_PDOC_GLPDOC_CACHESIZE_SETS_S 8
#define IG3_PDOC_GLPDOC_CACHESIZE_SETS GENMASK_ULL(8, 19)
#define IG3_PDOC_GLPDOC_CACHESIZE_WORD_SIZE_S 0
#define IG3_PDOC_GLPDOC_CACHESIZE_WORD_SIZE GENMASK_ULL(0, 7)
#define IG3_PDOC_GLPDOC_CACHE_0_DBG_CTL 0x4288050C
#define IG3_PDOC_GLPDOC_CACHE_0_DBG_CTL_DONE_S 31
#define IG3_PDOC_GLPDOC_CACHE_0_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_DBG_CTL_RD_EN_S 30
#define IG3_PDOC_GLPDOC_CACHE_0_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_DBG_CTL_RSVD_S 26
#define IG3_PDOC_GLPDOC_CACHE_0_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PDOC_GLPDOC_CACHE_0_DBG_CTL_DW_SEL_S 18
#define IG3_PDOC_GLPDOC_CACHE_0_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PDOC_GLPDOC_CACHE_0_DBG_CTL_ADR_S 0
#define IG3_PDOC_GLPDOC_CACHE_0_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PDOC_GLPDOC_CACHE_0_DBG_DATA 0x42880510
#define IG3_PDOC_GLPDOC_CACHE_0_DBG_DATA_RD_DW_S 0
#define IG3_PDOC_GLPDOC_CACHE_0_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG 0x428804C4
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_RSVD3_S 20
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_RM_S 16
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_RSVD2_S 14
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_RME_S 12
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_RSVD1_S 10
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_ERR_CNT_S 9
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_FIX_CNT_S 8
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_RSVD0_S 6
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_LS_FORCE_S 3
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS 0x428804C8
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS_RSVD1_S 30
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS_RSVD0_S 4
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS_INIT_DONE_S 2
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS_ECC_FIX_S 1
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS_ECC_ERR_S 0
#define IG3_PDOC_GLPDOC_CACHE_0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_DBG_CTL 0x42880514
#define IG3_PDOC_GLPDOC_CACHE_1_DBG_CTL_DONE_S 31
#define IG3_PDOC_GLPDOC_CACHE_1_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_DBG_CTL_RD_EN_S 30
#define IG3_PDOC_GLPDOC_CACHE_1_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_DBG_CTL_RSVD_S 26
#define IG3_PDOC_GLPDOC_CACHE_1_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PDOC_GLPDOC_CACHE_1_DBG_CTL_DW_SEL_S 18
#define IG3_PDOC_GLPDOC_CACHE_1_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PDOC_GLPDOC_CACHE_1_DBG_CTL_ADR_S 0
#define IG3_PDOC_GLPDOC_CACHE_1_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PDOC_GLPDOC_CACHE_1_DBG_DATA 0x42880518
#define IG3_PDOC_GLPDOC_CACHE_1_DBG_DATA_RD_DW_S 0
#define IG3_PDOC_GLPDOC_CACHE_1_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG 0x428804CC
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_RSVD3_S 20
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_RM_S 16
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_RSVD2_S 14
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_RME_S 12
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_RSVD1_S 10
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_ERR_CNT_S 9
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_FIX_CNT_S 8
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_RSVD0_S 6
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_LS_BYPASS_S 4
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_LS_FORCE_S 3
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS 0x428804D0
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS_RSVD1_S 30
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS_RSVD0_S 4
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS_INIT_DONE_S 2
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS_ECC_FIX_S 1
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS_ECC_ERR_S 0
#define IG3_PDOC_GLPDOC_CACHE_1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_DBG_CTL 0x4288051C
#define IG3_PDOC_GLPDOC_CACHE_2_DBG_CTL_DONE_S 31
#define IG3_PDOC_GLPDOC_CACHE_2_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_DBG_CTL_RD_EN_S 30
#define IG3_PDOC_GLPDOC_CACHE_2_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_DBG_CTL_RSVD_S 26
#define IG3_PDOC_GLPDOC_CACHE_2_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PDOC_GLPDOC_CACHE_2_DBG_CTL_DW_SEL_S 18
#define IG3_PDOC_GLPDOC_CACHE_2_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PDOC_GLPDOC_CACHE_2_DBG_CTL_ADR_S 0
#define IG3_PDOC_GLPDOC_CACHE_2_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PDOC_GLPDOC_CACHE_2_DBG_DATA 0x42880520
#define IG3_PDOC_GLPDOC_CACHE_2_DBG_DATA_RD_DW_S 0
#define IG3_PDOC_GLPDOC_CACHE_2_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG 0x428804D4
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_RSVD3_S 20
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_RM_S 16
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_RSVD2_S 14
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_RME_S 12
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_RSVD1_S 10
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_ERR_CNT_S 9
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_FIX_CNT_S 8
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_RSVD0_S 6
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_LS_BYPASS_S 4
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_LS_FORCE_S 3
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS 0x428804D8
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS_RSVD1_S 30
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS_RSVD0_S 4
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS_INIT_DONE_S 2
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS_ECC_FIX_S 1
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS_ECC_ERR_S 0
#define IG3_PDOC_GLPDOC_CACHE_2_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_DBG_CTL 0x42880524
#define IG3_PDOC_GLPDOC_CACHE_3_DBG_CTL_DONE_S 31
#define IG3_PDOC_GLPDOC_CACHE_3_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_DBG_CTL_RD_EN_S 30
#define IG3_PDOC_GLPDOC_CACHE_3_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_DBG_CTL_RSVD_S 26
#define IG3_PDOC_GLPDOC_CACHE_3_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PDOC_GLPDOC_CACHE_3_DBG_CTL_DW_SEL_S 18
#define IG3_PDOC_GLPDOC_CACHE_3_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PDOC_GLPDOC_CACHE_3_DBG_CTL_ADR_S 0
#define IG3_PDOC_GLPDOC_CACHE_3_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PDOC_GLPDOC_CACHE_3_DBG_DATA 0x42880528
#define IG3_PDOC_GLPDOC_CACHE_3_DBG_DATA_RD_DW_S 0
#define IG3_PDOC_GLPDOC_CACHE_3_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG 0x428804DC
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_RSVD3_S 20
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_RM_S 16
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_RSVD2_S 14
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_RME_S 12
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_RSVD1_S 10
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_ERR_CNT_S 9
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_FIX_CNT_S 8
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_RSVD0_S 6
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_LS_BYPASS_S 4
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_LS_FORCE_S 3
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS 0x428804E0
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS_RSVD1_S 30
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS_RSVD0_S 4
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS_INIT_DONE_S 2
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS_ECC_FIX_S 1
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS_ECC_ERR_S 0
#define IG3_PDOC_GLPDOC_CACHE_3_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_DBG_CTL 0x4288052C
#define IG3_PDOC_GLPDOC_CACHE_4_DBG_CTL_DONE_S 31
#define IG3_PDOC_GLPDOC_CACHE_4_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_DBG_CTL_RD_EN_S 30
#define IG3_PDOC_GLPDOC_CACHE_4_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_DBG_CTL_RSVD_S 26
#define IG3_PDOC_GLPDOC_CACHE_4_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PDOC_GLPDOC_CACHE_4_DBG_CTL_DW_SEL_S 18
#define IG3_PDOC_GLPDOC_CACHE_4_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PDOC_GLPDOC_CACHE_4_DBG_CTL_ADR_S 0
#define IG3_PDOC_GLPDOC_CACHE_4_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PDOC_GLPDOC_CACHE_4_DBG_DATA 0x42880530
#define IG3_PDOC_GLPDOC_CACHE_4_DBG_DATA_RD_DW_S 0
#define IG3_PDOC_GLPDOC_CACHE_4_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG 0x428804E4
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_RSVD3_S 20
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_RM_S 16
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_RSVD2_S 14
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_RME_S 12
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_RSVD1_S 10
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_ERR_CNT_S 9
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_FIX_CNT_S 8
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_RSVD0_S 6
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_LS_BYPASS_S 4
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_LS_FORCE_S 3
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS 0x428804E8
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS_RSVD1_S 30
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS_RSVD0_S 4
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS_INIT_DONE_S 2
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS_ECC_FIX_S 1
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS_ECC_ERR_S 0
#define IG3_PDOC_GLPDOC_CACHE_4_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_DBG_CTL 0x42880534
#define IG3_PDOC_GLPDOC_CACHE_5_DBG_CTL_DONE_S 31
#define IG3_PDOC_GLPDOC_CACHE_5_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_DBG_CTL_RD_EN_S 30
#define IG3_PDOC_GLPDOC_CACHE_5_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_DBG_CTL_RSVD_S 26
#define IG3_PDOC_GLPDOC_CACHE_5_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PDOC_GLPDOC_CACHE_5_DBG_CTL_DW_SEL_S 18
#define IG3_PDOC_GLPDOC_CACHE_5_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PDOC_GLPDOC_CACHE_5_DBG_CTL_ADR_S 0
#define IG3_PDOC_GLPDOC_CACHE_5_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PDOC_GLPDOC_CACHE_5_DBG_DATA 0x42880538
#define IG3_PDOC_GLPDOC_CACHE_5_DBG_DATA_RD_DW_S 0
#define IG3_PDOC_GLPDOC_CACHE_5_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG 0x428804EC
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_RSVD3_S 20
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_RM_S 16
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_RSVD2_S 14
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_RME_S 12
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_RSVD1_S 10
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_ERR_CNT_S 9
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_FIX_CNT_S 8
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_RSVD0_S 6
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_LS_BYPASS_S 4
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_LS_FORCE_S 3
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS 0x428804F0
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS_RSVD1_S 30
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS_RSVD0_S 4
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS_INIT_DONE_S 2
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS_ECC_FIX_S 1
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS_ECC_ERR_S 0
#define IG3_PDOC_GLPDOC_CACHE_5_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_DBG_CTL 0x4288053C
#define IG3_PDOC_GLPDOC_CACHE_6_DBG_CTL_DONE_S 31
#define IG3_PDOC_GLPDOC_CACHE_6_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_DBG_CTL_RD_EN_S 30
#define IG3_PDOC_GLPDOC_CACHE_6_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_DBG_CTL_RSVD_S 26
#define IG3_PDOC_GLPDOC_CACHE_6_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PDOC_GLPDOC_CACHE_6_DBG_CTL_DW_SEL_S 18
#define IG3_PDOC_GLPDOC_CACHE_6_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PDOC_GLPDOC_CACHE_6_DBG_CTL_ADR_S 0
#define IG3_PDOC_GLPDOC_CACHE_6_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PDOC_GLPDOC_CACHE_6_DBG_DATA 0x42880540
#define IG3_PDOC_GLPDOC_CACHE_6_DBG_DATA_RD_DW_S 0
#define IG3_PDOC_GLPDOC_CACHE_6_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG 0x428804F4
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_RSVD3_S 20
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_RM_S 16
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_RSVD2_S 14
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_RME_S 12
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_RSVD1_S 10
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_ERR_CNT_S 9
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_FIX_CNT_S 8
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_RSVD0_S 6
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_LS_BYPASS_S 4
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_LS_FORCE_S 3
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS 0x428804F8
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS_RSVD1_S 30
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS_RSVD0_S 4
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS_INIT_DONE_S 2
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS_ECC_FIX_S 1
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS_ECC_ERR_S 0
#define IG3_PDOC_GLPDOC_CACHE_6_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_DBG_CTL 0x42880544
#define IG3_PDOC_GLPDOC_CACHE_7_DBG_CTL_DONE_S 31
#define IG3_PDOC_GLPDOC_CACHE_7_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_DBG_CTL_RD_EN_S 30
#define IG3_PDOC_GLPDOC_CACHE_7_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_DBG_CTL_RSVD_S 26
#define IG3_PDOC_GLPDOC_CACHE_7_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PDOC_GLPDOC_CACHE_7_DBG_CTL_DW_SEL_S 18
#define IG3_PDOC_GLPDOC_CACHE_7_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PDOC_GLPDOC_CACHE_7_DBG_CTL_ADR_S 0
#define IG3_PDOC_GLPDOC_CACHE_7_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PDOC_GLPDOC_CACHE_7_DBG_DATA 0x42880548
#define IG3_PDOC_GLPDOC_CACHE_7_DBG_DATA_RD_DW_S 0
#define IG3_PDOC_GLPDOC_CACHE_7_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG 0x428804FC
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_RSVD3_S 20
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_RM_S 16
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_RSVD2_S 14
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_RME_S 12
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_RSVD1_S 10
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_ERR_CNT_S 9
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_FIX_CNT_S 8
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_RSVD0_S 6
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_LS_BYPASS_S 4
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_LS_FORCE_S 3
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS 0x42880500
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS_RSVD1_S 30
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS_RSVD0_S 4
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS_INIT_DONE_S 2
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS_ECC_FIX_S 1
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS_ECC_ERR_S 0
#define IG3_PDOC_GLPDOC_CACHE_7_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CACHE_CTRL 0x42880400
#define IG3_PDOC_GLPDOC_CACHE_CTRL_RSVD_S 2
#define IG3_PDOC_GLPDOC_CACHE_CTRL_RSVD GENMASK_ULL(2, 31)
#define IG3_PDOC_GLPDOC_CACHE_CTRL_SCALE_FACTOR_S 0
#define IG3_PDOC_GLPDOC_CACHE_CTRL_SCALE_FACTOR GENMASK_ULL(0, 1)
#define IG3_PDOC_GLPDOC_CECC_ERR 0x42880470
#define IG3_PDOC_GLPDOC_CECC_ERR_RSVD1_S 28
#define IG3_PDOC_GLPDOC_CECC_ERR_RSVD1 GENMASK_ULL(28, 31)
#define IG3_PDOC_GLPDOC_CECC_ERR_COR_ECC_ERR_CNT_S 16
#define IG3_PDOC_GLPDOC_CECC_ERR_COR_ECC_ERR_CNT GENMASK_ULL(16, 27)
#define IG3_PDOC_GLPDOC_CECC_ERR_RSVD0_S 12
#define IG3_PDOC_GLPDOC_CECC_ERR_RSVD0 GENMASK_ULL(12, 15)
#define IG3_PDOC_GLPDOC_CECC_ERR_UNCOR_ECC_ERR_CNT_S 0
#define IG3_PDOC_GLPDOC_CECC_ERR_UNCOR_ECC_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PDOC_GLPDOC_CSTATELKUP_CFG 0x42880478
#define IG3_PDOC_GLPDOC_CSTATELKUP_CFG_RSVD1_S 9
#define IG3_PDOC_GLPDOC_CSTATELKUP_CFG_RSVD1 GENMASK_ULL(9, 31)
#define IG3_PDOC_GLPDOC_CSTATELKUP_CFG_LKUP_REPLAY_ON_PEND_CLR_S 8
#define IG3_PDOC_GLPDOC_CSTATELKUP_CFG_LKUP_REPLAY_ON_PEND_CLR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_CSTATELKUP_CFG_RSVD0_S 3
#define IG3_PDOC_GLPDOC_CSTATELKUP_CFG_RSVD0 GENMASK_ULL(3, 7)
#define IG3_PDOC_GLPDOC_CSTATELKUP_CFG_LKUP_RATE_LIMIT_WTCYCLES_S 0
#define IG3_PDOC_GLPDOC_CSTATELKUP_CFG_LKUP_RATE_LIMIT_WTCYCLES GENMASK_ULL(0, 2)
#define IG3_PDOC_GLPDOC_DPC_COMP 0x42880488
#define IG3_PDOC_GLPDOC_DPC_COMP_RSVD_S 13
#define IG3_PDOC_GLPDOC_DPC_COMP_RSVD GENMASK_ULL(13, 31)
#define IG3_PDOC_GLPDOC_DPC_COMP_COMP_FTYPE_S 11
#define IG3_PDOC_GLPDOC_DPC_COMP_COMP_FTYPE GENMASK_ULL(11, 12)
#define IG3_PDOC_GLPDOC_DPC_COMP_COMP_FNUM_S 1
#define IG3_PDOC_GLPDOC_DPC_COMP_COMP_FNUM GENMASK_ULL(1, 10)
#define IG3_PDOC_GLPDOC_DPC_COMP_COMP_VALID_S 0
#define IG3_PDOC_GLPDOC_DPC_COMP_COMP_VALID_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DPC_REQ 0x42880484
#define IG3_PDOC_GLPDOC_DPC_REQ_RSVD_S 12
#define IG3_PDOC_GLPDOC_DPC_REQ_RSVD GENMASK_ULL(12, 31)
#define IG3_PDOC_GLPDOC_DPC_REQ_REQ_FTYPE_S 10
#define IG3_PDOC_GLPDOC_DPC_REQ_REQ_FTYPE GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_DPC_REQ_REQ_FNUM_S 0
#define IG3_PDOC_GLPDOC_DPC_REQ_REQ_FNUM GENMASK_ULL(0, 9)
#define IG3_PDOC_GLPDOC_DTM_BUFFER_COUNT 0x428805B8
#define IG3_PDOC_GLPDOC_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_PDOC_GLPDOC_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PDOC_GLPDOC_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_CMD 0x428805CC
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_DATA_H 0x428805D8
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_DATA_L 0x428805D4
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_PTR 0x428805D0
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_CMD 0x428805BC
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_DATA_H 0x428805C8
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_DATA_L 0x428805C4
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_PTR 0x428805C0
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_PDOC_GLPDOC_DTM_CONTROL 0x42880580
#define IG3_PDOC_GLPDOC_DTM_CONTROL_RSVD1_S 25
#define IG3_PDOC_GLPDOC_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_PDOC_GLPDOC_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_CONTROL_RSVD2_S 17
#define IG3_PDOC_GLPDOC_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_PDOC_GLPDOC_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_PDOC_GLPDOC_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_CONTROL_RSVD3_S 9
#define IG3_PDOC_GLPDOC_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_PDOC_GLPDOC_DTM_CONTROL_BYPASS_S 8
#define IG3_PDOC_GLPDOC_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_CONTROL_RSVD4_S 1
#define IG3_PDOC_GLPDOC_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_PDOC_GLPDOC_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_PDOC_GLPDOC_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_ECC_COR_ERR 0x428805E8
#define IG3_PDOC_GLPDOC_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_PDOC_GLPDOC_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PDOC_GLPDOC_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_PDOC_GLPDOC_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PDOC_GLPDOC_DTM_ECC_UNCOR_ERR 0x428805E4
#define IG3_PDOC_GLPDOC_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_PDOC_GLPDOC_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PDOC_GLPDOC_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_PDOC_GLPDOC_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PDOC_GLPDOC_DTM_GROUP_CFG 0x4288058C
#define IG3_PDOC_GLPDOC_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_PDOC_GLPDOC_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_PDOC_GLPDOC_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_PDOC_GLPDOC_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_PDOC_GLPDOC_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_PDOC_GLPDOC_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_PDOC_GLPDOC_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_PDOC_GLPDOC_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_PDOC_GLPDOC_DTM_LOG_CFG 0x42880590
#define IG3_PDOC_GLPDOC_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_PDOC_GLPDOC_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_PDOC_GLPDOC_DTM_LOG_CFG_RSVD1_S 2
#define IG3_PDOC_GLPDOC_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_PDOC_GLPDOC_DTM_LOG_CFG_MODE_S 0
#define IG3_PDOC_GLPDOC_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_PDOC_GLPDOC_DTM_LOG_MASK 0x42880598
#define IG3_PDOC_GLPDOC_DTM_LOG_MASK_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_DTM_LOG_PATTERN 0x42880594
#define IG3_PDOC_GLPDOC_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_DTM_MAIN_CFG 0x42880584
#define IG3_PDOC_GLPDOC_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_PDOC_GLPDOC_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_PDOC_GLPDOC_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_PDOC_GLPDOC_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_PDOC_GLPDOC_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_PDOC_GLPDOC_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_PDOC_GLPDOC_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_PDOC_GLPDOC_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_PDOC_GLPDOC_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_PDOC_GLPDOC_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_PDOC_GLPDOC_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_MAIN_STS 0x42880588
#define IG3_PDOC_GLPDOC_DTM_MAIN_STS_RSVD1_S 9
#define IG3_PDOC_GLPDOC_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_PDOC_GLPDOC_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_PDOC_GLPDOC_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_MAIN_STS_RSVD2_S 1
#define IG3_PDOC_GLPDOC_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_PDOC_GLPDOC_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_PDOC_GLPDOC_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TIMESTAMP 0x428805B0
#define IG3_PDOC_GLPDOC_DTM_TIMESTAMP_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_DTM_TIMESTAMP_ROLLOVER 0x428805B4
#define IG3_PDOC_GLPDOC_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG 0x428805DC
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS 0x428805E0
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_PDOC_GLPDOC_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_DTM_TRIG_CFG 0x4288059C
#define IG3_PDOC_GLPDOC_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_PDOC_GLPDOC_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_PDOC_GLPDOC_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_PDOC_GLPDOC_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_PDOC_GLPDOC_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_PDOC_GLPDOC_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_PDOC_GLPDOC_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_PDOC_GLPDOC_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_PDOC_GLPDOC_DTM_TRIG_CFG_MODE_S 0
#define IG3_PDOC_GLPDOC_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_PDOC_GLPDOC_DTM_TRIG_COUNT 0x428805A8
#define IG3_PDOC_GLPDOC_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_DTM_TRIG_MASK 0x428805A4
#define IG3_PDOC_GLPDOC_DTM_TRIG_MASK_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_DTM_TRIG_PATTERN 0x428805A0
#define IG3_PDOC_GLPDOC_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_DTM_TRIG_TIMESTAMP 0x428805AC
#define IG3_PDOC_GLPDOC_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_PDOC_GLPDOC_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_ECC_CTL 0x4288046C
#define IG3_PDOC_GLPDOC_ECC_CTL_RSVD_S 8
#define IG3_PDOC_GLPDOC_ECC_CTL_RSVD GENMASK_ULL(8, 31)
#define IG3_PDOC_GLPDOC_ECC_CTL_CLIENT_ECC_INVERT2_S 7
#define IG3_PDOC_GLPDOC_ECC_CTL_CLIENT_ECC_INVERT2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_ECC_CTL_CLIENT_ECC_INVERT1_S 6
#define IG3_PDOC_GLPDOC_ECC_CTL_CLIENT_ECC_INVERT1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_ECC_CTL_CLIENT_ECC_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_ECC_CTL_CLIENT_ECC_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_ECC_CTL_CLIENT_ECC_EN_S 4
#define IG3_PDOC_GLPDOC_ECC_CTL_CLIENT_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_ECC_CTL_HOST_ECC_INVERT2_S 3
#define IG3_PDOC_GLPDOC_ECC_CTL_HOST_ECC_INVERT2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_ECC_CTL_HOST_ECC_INVERT1_S 2
#define IG3_PDOC_GLPDOC_ECC_CTL_HOST_ECC_INVERT1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_ECC_CTL_HOST_ECC_MASK_INT_S 1
#define IG3_PDOC_GLPDOC_ECC_CTL_HOST_ECC_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_ECC_CTL_HOST_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_ECC_CTL_HOST_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_ERRDATA0 0x4288045C
#define IG3_PDOC_GLPDOC_ERRDATA0_RSVD1_S 31
#define IG3_PDOC_GLPDOC_ERRDATA0_RSVD1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_ERRDATA0_PF_NUM_S 25
#define IG3_PDOC_GLPDOC_ERRDATA0_PF_NUM GENMASK_ULL(25, 30)
#define IG3_PDOC_GLPDOC_ERRDATA0_VDEV_VF_NUM_S 15
#define IG3_PDOC_GLPDOC_ERRDATA0_VDEV_VF_NUM GENMASK_ULL(15, 24)
#define IG3_PDOC_GLPDOC_ERRDATA0_VDEV_VF_TYPE_S 13
#define IG3_PDOC_GLPDOC_ERRDATA0_VDEV_VF_TYPE GENMASK_ULL(13, 14)
#define IG3_PDOC_GLPDOC_ERRDATA0_OBJ_TYPE_S 8
#define IG3_PDOC_GLPDOC_ERRDATA0_OBJ_TYPE GENMASK_ULL(8, 12)
#define IG3_PDOC_GLPDOC_ERRDATA0_RSVD0_S 6
#define IG3_PDOC_GLPDOC_ERRDATA0_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_ERRDATA0_ERROR_CODE_S 0
#define IG3_PDOC_GLPDOC_ERRDATA0_ERROR_CODE GENMASK_ULL(0, 5)
#define IG3_PDOC_GLPDOC_ERRDATA1 0x42880460
#define IG3_PDOC_GLPDOC_ERRDATA1_RSVD_S 28
#define IG3_PDOC_GLPDOC_ERRDATA1_RSVD GENMASK_ULL(28, 31)
#define IG3_PDOC_GLPDOC_ERRDATA1_OBJ_INDEX_S 0
#define IG3_PDOC_GLPDOC_ERRDATA1_OBJ_INDEX GENMASK_ULL(0, 27)
#define IG3_PDOC_GLPDOC_ERRDATA2 0x42880464
#define IG3_PDOC_GLPDOC_ERRDATA2_RSVD_S 23
#define IG3_PDOC_GLPDOC_ERRDATA2_RSVD GENMASK_ULL(23, 31)
#define IG3_PDOC_GLPDOC_ERRDATA2_OPTYPE_S 20
#define IG3_PDOC_GLPDOC_ERRDATA2_OPTYPE GENMASK_ULL(20, 22)
#define IG3_PDOC_GLPDOC_ERRDATA2_OFFSET_S 7
#define IG3_PDOC_GLPDOC_ERRDATA2_OFFSET GENMASK_ULL(7, 19)
#define IG3_PDOC_GLPDOC_ERRDATA2_LENGTH_S 0
#define IG3_PDOC_GLPDOC_ERRDATA2_LENGTH GENMASK_ULL(0, 6)
#define IG3_PDOC_GLPDOC_ERRDATA3 0x42880468
#define IG3_PDOC_GLPDOC_ERRDATA3_RSVD_S 15
#define IG3_PDOC_GLPDOC_ERRDATA3_RSVD GENMASK_ULL(15, 31)
#define IG3_PDOC_GLPDOC_ERRDATA3_TAG_S 0
#define IG3_PDOC_GLPDOC_ERRDATA3_TAG GENMASK_ULL(0, 14)
#define IG3_PDOC_GLPDOC_ERRINFO 0x42880458
#define IG3_PDOC_GLPDOC_ERRINFO_RSVD1_S 16
#define IG3_PDOC_GLPDOC_ERRINFO_RSVD1 GENMASK_ULL(16, 31)
#define IG3_PDOC_GLPDOC_ERRINFO_ERROR_CNT_S 8
#define IG3_PDOC_GLPDOC_ERRINFO_ERROR_CNT GENMASK_ULL(8, 15)
#define IG3_PDOC_GLPDOC_ERRINFO_RSVD0_S 1
#define IG3_PDOC_GLPDOC_ERRINFO_RSVD0 GENMASK_ULL(1, 7)
#define IG3_PDOC_GLPDOC_ERRINFO_ERROR_VALID_S 0
#define IG3_PDOC_GLPDOC_ERRINFO_ERROR_VALID_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG 0x428804BC
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_RSVD3_S 20
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_RM_S 16
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_RSVD2_S 14
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_RME_S 12
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_RSVD1_S 10
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_ERR_CNT_S 9
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_FIX_CNT_S 8
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_RSVD0_S 6
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_LS_BYPASS_S 4
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_LS_FORCE_S 3
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_EVICT_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS 0x428804C0
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS_RSVD1_S 30
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS_RSVD0_S 4
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS_INIT_DONE_S 2
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS_ECC_FIX_S 1
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS_ECC_ERR_S 0
#define IG3_PDOC_GLPDOC_EVICT_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG 0x428804B4
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_RSVD3_S 20
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_RM_S 16
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_RSVD2_S 14
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_RME_S 12
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_RSVD1_S 10
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_ERR_CNT_S 9
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_FIX_CNT_S 8
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_RSVD0_S 6
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_LS_BYPASS_S 4
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_LS_FORCE_S 3
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_FILL_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS 0x428804B8
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS_RSVD1_S 30
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS_RSVD0_S 4
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS_INIT_DONE_S 2
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS_ECC_FIX_S 1
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS_ECC_ERR_S 0
#define IG3_PDOC_GLPDOC_FILL_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_MAXOSR 0x42880474
#define IG3_PDOC_GLPDOC_MAXOSR_RSVD1_S 11
#define IG3_PDOC_GLPDOC_MAXOSR_RSVD1 GENMASK_ULL(11, 31)
#define IG3_PDOC_GLPDOC_MAXOSR_MAX_OSR_CLNT_WRPULL_S 10
#define IG3_PDOC_GLPDOC_MAXOSR_MAX_OSR_CLNT_WRPULL_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_MAXOSR_RSVD0_S 8
#define IG3_PDOC_GLPDOC_MAXOSR_RSVD0 GENMASK_ULL(8, 9)
#define IG3_PDOC_GLPDOC_MAXOSR_MAX_OSR_PMAT_FETCH_S 0
#define IG3_PDOC_GLPDOC_MAXOSR_MAX_OSR_PMAT_FETCH GENMASK_ULL(0, 7)
#define IG3_PDOC_GLPDOC_MEM_ECC_COR_ERR 0x42880558
#define IG3_PDOC_GLPDOC_MEM_ECC_COR_ERR_RSVD_S 12
#define IG3_PDOC_GLPDOC_MEM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PDOC_GLPDOC_MEM_ECC_COR_ERR_CNT_S 0
#define IG3_PDOC_GLPDOC_MEM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PDOC_GLPDOC_MEM_ECC_UNCOR_ERR 0x42880554
#define IG3_PDOC_GLPDOC_MEM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_PDOC_GLPDOC_MEM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PDOC_GLPDOC_MEM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_PDOC_GLPDOC_MEM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PDOC_GLPDOC_PLIST_DBG_CTL 0x4288054C
#define IG3_PDOC_GLPDOC_PLIST_DBG_CTL_DONE_S 31
#define IG3_PDOC_GLPDOC_PLIST_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_DBG_CTL_RD_EN_S 30
#define IG3_PDOC_GLPDOC_PLIST_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_DBG_CTL_RSVD_S 26
#define IG3_PDOC_GLPDOC_PLIST_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PDOC_GLPDOC_PLIST_DBG_CTL_DW_SEL_S 18
#define IG3_PDOC_GLPDOC_PLIST_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PDOC_GLPDOC_PLIST_DBG_CTL_ADR_S 0
#define IG3_PDOC_GLPDOC_PLIST_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PDOC_GLPDOC_PLIST_DBG_DATA 0x42880550
#define IG3_PDOC_GLPDOC_PLIST_DBG_DATA_RD_DW_S 0
#define IG3_PDOC_GLPDOC_PLIST_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG 0x428804AC
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_RSVD3_S 20
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_RM_S 16
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_RSVD2_S 14
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_RME_S 12
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_RSVD1_S 10
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_ERR_CNT_S 9
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_FIX_CNT_S 8
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_RSVD0_S 6
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_LS_BYPASS_S 4
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_LS_FORCE_S 3
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_PLIST_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS 0x428804B0
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS_RSVD1_S 30
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS_RSVD0_S 4
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS_INIT_DONE_S 2
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS_ECC_FIX_S 1
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS_ECC_ERR_S 0
#define IG3_PDOC_GLPDOC_PLIST_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PMATINV_CFG 0x4288047C
#define IG3_PDOC_GLPDOC_PMATINV_CFG_RSVD_S 6
#define IG3_PDOC_GLPDOC_PMATINV_CFG_RSVD GENMASK_ULL(6, 31)
#define IG3_PDOC_GLPDOC_PMATINV_CFG_WBINVBYPRNTANDFN_FENCE_EN_S 5
#define IG3_PDOC_GLPDOC_PMATINV_CFG_WBINVBYPRNTANDFN_FENCE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PMATINV_CFG_WBINVBYTYPEANDFN_FENCE_EN_S 4
#define IG3_PDOC_GLPDOC_PMATINV_CFG_WBINVBYTYPEANDFN_FENCE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PMATINV_CFG_WBINVBYFN_FENCE_EN_S 3
#define IG3_PDOC_GLPDOC_PMATINV_CFG_WBINVBYFN_FENCE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PMATINV_CFG_WBINVBYOBJ_FENCE_EN_S 2
#define IG3_PDOC_GLPDOC_PMATINV_CFG_WBINVBYOBJ_FENCE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PMATINV_CFG_INVBYTYPEANDFN_FENCE_EN_S 1
#define IG3_PDOC_GLPDOC_PMATINV_CFG_INVBYTYPEANDFN_FENCE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_PMATINV_CFG_INVBYFN_FENCE_EN_S 0
#define IG3_PDOC_GLPDOC_PMATINV_CFG_INVBYFN_FENCE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_STAT_CTL 0x42880404
#define IG3_PDOC_GLPDOC_STAT_CTL_RSVD_S 5
#define IG3_PDOC_GLPDOC_STAT_CTL_RSVD GENMASK_ULL(5, 31)
#define IG3_PDOC_GLPDOC_STAT_CTL_OBJECT_TYPE_S 0
#define IG3_PDOC_GLPDOC_STAT_CTL_OBJECT_TYPE GENMASK_ULL(0, 4)
#define IG3_PDOC_GLPDOC_STAT_FENCING_TIME_HI 0x4288044C
#define IG3_PDOC_GLPDOC_STAT_FENCING_TIME_HI_RSVD_S 24
#define IG3_PDOC_GLPDOC_STAT_FENCING_TIME_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PDOC_GLPDOC_STAT_FENCING_TIME_HI_CNT_HI_S 0
#define IG3_PDOC_GLPDOC_STAT_FENCING_TIME_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PDOC_GLPDOC_STAT_FENCING_TIME_LO 0x42880448
#define IG3_PDOC_GLPDOC_STAT_FENCING_TIME_LO_CNT_LO_S 0
#define IG3_PDOC_GLPDOC_STAT_FENCING_TIME_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_STAT_MAX_PENDING_ENTRIES 0x4288042C
#define IG3_PDOC_GLPDOC_STAT_MAX_PENDING_ENTRIES_RSVD_S 8
#define IG3_PDOC_GLPDOC_STAT_MAX_PENDING_ENTRIES_RSVD GENMASK_ULL(8, 31)
#define IG3_PDOC_GLPDOC_STAT_MAX_PENDING_ENTRIES_CNT_S 0
#define IG3_PDOC_GLPDOC_STAT_MAX_PENDING_ENTRIES_CNT GENMASK_ULL(0, 7)
#define IG3_PDOC_GLPDOC_STAT_MAX_PENDING_LIST_DEPTH 0x42880434
#define IG3_PDOC_GLPDOC_STAT_MAX_PENDING_LIST_DEPTH_RSVD_S 8
#define IG3_PDOC_GLPDOC_STAT_MAX_PENDING_LIST_DEPTH_RSVD GENMASK_ULL(8, 31)
#define IG3_PDOC_GLPDOC_STAT_MAX_PENDING_LIST_DEPTH_CNT_LO_S 0
#define IG3_PDOC_GLPDOC_STAT_MAX_PENDING_LIST_DEPTH_CNT_LO GENMASK_ULL(0, 7)
#define IG3_PDOC_GLPDOC_STAT_MAX_VIRT_PENDING_LISTS 0x42880430
#define IG3_PDOC_GLPDOC_STAT_MAX_VIRT_PENDING_LISTS_RSVD_S 8
#define IG3_PDOC_GLPDOC_STAT_MAX_VIRT_PENDING_LISTS_RSVD GENMASK_ULL(8, 31)
#define IG3_PDOC_GLPDOC_STAT_MAX_VIRT_PENDING_LISTS_CNT_LO_S 0
#define IG3_PDOC_GLPDOC_STAT_MAX_VIRT_PENDING_LISTS_CNT_LO GENMASK_ULL(0, 7)
#define IG3_PDOC_GLPDOC_STAT_OBJ_CNT 0x42880408
#define IG3_PDOC_GLPDOC_STAT_OBJ_CNT_RSVD_S 14
#define IG3_PDOC_GLPDOC_STAT_OBJ_CNT_RSVD GENMASK_ULL(14, 31)
#define IG3_PDOC_GLPDOC_STAT_OBJ_CNT_OBJECT_COUNT_S 0
#define IG3_PDOC_GLPDOC_STAT_OBJ_CNT_OBJECT_COUNT GENMASK_ULL(0, 13)
#define IG3_PDOC_GLPDOC_STAT_PENDLING_LIST_FULL_HI 0x42880444
#define IG3_PDOC_GLPDOC_STAT_PENDLING_LIST_FULL_HI_RSVD_S 24
#define IG3_PDOC_GLPDOC_STAT_PENDLING_LIST_FULL_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PDOC_GLPDOC_STAT_PENDLING_LIST_FULL_HI_CNT_HI_S 0
#define IG3_PDOC_GLPDOC_STAT_PENDLING_LIST_FULL_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PDOC_GLPDOC_STAT_PENDLING_LIST_FULL_LO 0x42880440
#define IG3_PDOC_GLPDOC_STAT_PENDLING_LIST_FULL_LO_CNT_LO_S 0
#define IG3_PDOC_GLPDOC_STAT_PENDLING_LIST_FULL_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_IDLE_HI 0x42880420
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_IDLE_HI_RSVD_S 24
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_IDLE_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_IDLE_HI_CNT_HI_S 0
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_IDLE_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_IDLE_LO 0x4288041C
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_IDLE_LO_CNT_LO_S 0
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_IDLE_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_XFER_HI 0x42880428
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_XFER_HI_RSVD_S 24
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_XFER_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_XFER_HI_CNT_HI_S 0
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_XFER_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_XFER_LO 0x42880424
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_XFER_LO_CNT_LO_S 0
#define IG3_PDOC_GLPDOC_STAT_RD_DATA_XFER_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_STAT_RD_HIT_HI 0x42880410
#define IG3_PDOC_GLPDOC_STAT_RD_HIT_HI_RSVD_S 24
#define IG3_PDOC_GLPDOC_STAT_RD_HIT_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PDOC_GLPDOC_STAT_RD_HIT_HI_CNT_HI_S 0
#define IG3_PDOC_GLPDOC_STAT_RD_HIT_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PDOC_GLPDOC_STAT_RD_HIT_LO 0x4288040C
#define IG3_PDOC_GLPDOC_STAT_RD_HIT_LO_CNT_LO_S 0
#define IG3_PDOC_GLPDOC_STAT_RD_HIT_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_STAT_RD_MISS_HI 0x42880418
#define IG3_PDOC_GLPDOC_STAT_RD_MISS_HI_RSVD_S 24
#define IG3_PDOC_GLPDOC_STAT_RD_MISS_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PDOC_GLPDOC_STAT_RD_MISS_HI_CNT_HI_S 0
#define IG3_PDOC_GLPDOC_STAT_RD_MISS_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PDOC_GLPDOC_STAT_RD_MISS_LO 0x42880414
#define IG3_PDOC_GLPDOC_STAT_RD_MISS_LO_CNT_LO_S 0
#define IG3_PDOC_GLPDOC_STAT_RD_MISS_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_STAT_REPLAY_TIME_HI 0x42880454
#define IG3_PDOC_GLPDOC_STAT_REPLAY_TIME_HI_RSVD_S 24
#define IG3_PDOC_GLPDOC_STAT_REPLAY_TIME_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PDOC_GLPDOC_STAT_REPLAY_TIME_HI_CNT_HI_S 0
#define IG3_PDOC_GLPDOC_STAT_REPLAY_TIME_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PDOC_GLPDOC_STAT_REPLAY_TIME_LO 0x42880450
#define IG3_PDOC_GLPDOC_STAT_REPLAY_TIME_LO_CNT_LO_S 0
#define IG3_PDOC_GLPDOC_STAT_REPLAY_TIME_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_STAT_WR_BUFF_FULL_HI 0x4288043C
#define IG3_PDOC_GLPDOC_STAT_WR_BUFF_FULL_HI_RSVD_S 24
#define IG3_PDOC_GLPDOC_STAT_WR_BUFF_FULL_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PDOC_GLPDOC_STAT_WR_BUFF_FULL_HI_CNT_HI_S 0
#define IG3_PDOC_GLPDOC_STAT_WR_BUFF_FULL_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PDOC_GLPDOC_STAT_WR_BUFF_FULL_LO 0x42880438
#define IG3_PDOC_GLPDOC_STAT_WR_BUFF_FULL_LO_CNT_LO_S 0
#define IG3_PDOC_GLPDOC_STAT_WR_BUFF_FULL_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_TAG_DBG_CTL 0x42880504
#define IG3_PDOC_GLPDOC_TAG_DBG_CTL_DONE_S 31
#define IG3_PDOC_GLPDOC_TAG_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_DBG_CTL_RD_EN_S 30
#define IG3_PDOC_GLPDOC_TAG_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_DBG_CTL_RSVD_S 26
#define IG3_PDOC_GLPDOC_TAG_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PDOC_GLPDOC_TAG_DBG_CTL_DW_SEL_S 18
#define IG3_PDOC_GLPDOC_TAG_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PDOC_GLPDOC_TAG_DBG_CTL_ADR_S 0
#define IG3_PDOC_GLPDOC_TAG_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PDOC_GLPDOC_TAG_DBG_DATA 0x42880508
#define IG3_PDOC_GLPDOC_TAG_DBG_DATA_RD_DW_S 0
#define IG3_PDOC_GLPDOC_TAG_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG 0x4288049C
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_RSVD3_S 20
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_RM_S 16
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_RSVD2_S 14
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_RME_S 12
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_RSVD1_S 10
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_ERR_CNT_S 9
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_FIX_CNT_S 8
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_RSVD0_S 6
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_LS_BYPASS_S 4
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_LS_FORCE_S 3
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_TAG_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS 0x428804A0
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS_RSVD1_S 30
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS_RSVD0_S 4
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS_INIT_DONE_S 2
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS_ECC_FIX_S 1
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS_ECC_ERR_S 0
#define IG3_PDOC_GLPDOC_TAG_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_TOTAL_TAG_HI 0x42880490
#define IG3_PDOC_GLPDOC_TOTAL_TAG_HI_RSVD_S 24
#define IG3_PDOC_GLPDOC_TOTAL_TAG_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PDOC_GLPDOC_TOTAL_TAG_HI_CNT_HI_S 0
#define IG3_PDOC_GLPDOC_TOTAL_TAG_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PDOC_GLPDOC_TOTAL_TAG_HIT_HI 0x42880498
#define IG3_PDOC_GLPDOC_TOTAL_TAG_HIT_HI_RSVD_S 24
#define IG3_PDOC_GLPDOC_TOTAL_TAG_HIT_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PDOC_GLPDOC_TOTAL_TAG_HIT_HI_CNT_HI_S 0
#define IG3_PDOC_GLPDOC_TOTAL_TAG_HIT_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PDOC_GLPDOC_TOTAL_TAG_HIT_LO 0x42880494
#define IG3_PDOC_GLPDOC_TOTAL_TAG_HIT_LO_CNT_LO_S 0
#define IG3_PDOC_GLPDOC_TOTAL_TAG_HIT_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_TOTAL_TAG_LO 0x4288048C
#define IG3_PDOC_GLPDOC_TOTAL_TAG_LO_CNT_LO_S 0
#define IG3_PDOC_GLPDOC_TOTAL_TAG_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG 0x428804A4
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_RSVD3_S 20
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_RM_S 16
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_RSVD2_S 14
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_RME_S 12
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_RSVD1_S 10
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_ERR_CNT_S 9
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_FIX_CNT_S 8
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_RSVD0_S 6
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_MASK_INT_S 5
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_LS_BYPASS_S 4
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_LS_FORCE_S 3
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_ECC_EN_S 0
#define IG3_PDOC_GLPDOC_WRBUF_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS 0x428804A8
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS_RSVD1_S 30
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS_RSVD0_S 4
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS_INIT_DONE_S 2
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS_ECC_FIX_S 1
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS_ECC_ERR_S 0
#define IG3_PDOC_GLPDOC_WRBUF_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_ARPTBLE_OBJOFST 0x4290007C
#define IG3_PBLOC0_GLPBLOC_ARPTBLE_OBJOFST_RSVD_S 10
#define IG3_PBLOC0_GLPBLOC_ARPTBLE_OBJOFST_RSVD GENMASK_ULL(10, 31)
#define IG3_PBLOC0_GLPBLOC_ARPTBLE_OBJOFST_OBJ_TYPE_OFFSET_S 0
#define IG3_PBLOC0_GLPBLOC_ARPTBLE_OBJOFST_OBJ_TYPE_OFFSET GENMASK_ULL(0, 9)
#define IG3_PBLOC0_GLPBLOC_CACHESIZE 0x429000AC
#define IG3_PBLOC0_GLPBLOC_CACHESIZE_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_CACHESIZE_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_CACHESIZE_WAYS_S 20
#define IG3_PBLOC0_GLPBLOC_CACHESIZE_WAYS GENMASK_ULL(20, 23)
#define IG3_PBLOC0_GLPBLOC_CACHESIZE_SETS_S 8
#define IG3_PBLOC0_GLPBLOC_CACHESIZE_SETS GENMASK_ULL(8, 19)
#define IG3_PBLOC0_GLPBLOC_CACHESIZE_WORD_SIZE_S 0
#define IG3_PBLOC0_GLPBLOC_CACHESIZE_WORD_SIZE GENMASK_ULL(0, 7)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_DBG_CTL 0x42900138
#define IG3_PBLOC0_GLPBLOC_CACHE_0_DBG_CTL_DONE_S 31
#define IG3_PBLOC0_GLPBLOC_CACHE_0_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_DBG_CTL_RD_EN_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_0_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_DBG_CTL_RSVD_S 26
#define IG3_PBLOC0_GLPBLOC_CACHE_0_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_DBG_CTL_DW_SEL_S 18
#define IG3_PBLOC0_GLPBLOC_CACHE_0_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_DBG_CTL_ADR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_0_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_DBG_DATA 0x4290013C
#define IG3_PBLOC0_GLPBLOC_CACHE_0_DBG_DATA_RD_DW_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_0_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG 0x429000F0
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_RSVD3_S 20
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_RM_S 16
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_RSVD2_S 14
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_RME_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_RSVD1_S 10
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_ERR_CNT_S 9
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_FIX_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_LS_FORCE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS 0x429000F4
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS_RSVD1_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS_RSVD0_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS_INIT_DONE_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS_ECC_FIX_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS_ECC_ERR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_0_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_DBG_CTL 0x42900140
#define IG3_PBLOC0_GLPBLOC_CACHE_1_DBG_CTL_DONE_S 31
#define IG3_PBLOC0_GLPBLOC_CACHE_1_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_DBG_CTL_RD_EN_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_1_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_DBG_CTL_RSVD_S 26
#define IG3_PBLOC0_GLPBLOC_CACHE_1_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_DBG_CTL_DW_SEL_S 18
#define IG3_PBLOC0_GLPBLOC_CACHE_1_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_DBG_CTL_ADR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_1_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_DBG_DATA 0x42900144
#define IG3_PBLOC0_GLPBLOC_CACHE_1_DBG_DATA_RD_DW_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_1_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG 0x429000F8
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_RSVD3_S 20
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_RM_S 16
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_RSVD2_S 14
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_RME_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_RSVD1_S 10
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_ERR_CNT_S 9
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_FIX_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_LS_BYPASS_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_LS_FORCE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS 0x429000FC
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS_RSVD1_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS_RSVD0_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS_INIT_DONE_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS_ECC_FIX_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS_ECC_ERR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_1_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_DBG_CTL 0x42900148
#define IG3_PBLOC0_GLPBLOC_CACHE_2_DBG_CTL_DONE_S 31
#define IG3_PBLOC0_GLPBLOC_CACHE_2_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_DBG_CTL_RD_EN_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_2_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_DBG_CTL_RSVD_S 26
#define IG3_PBLOC0_GLPBLOC_CACHE_2_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_DBG_CTL_DW_SEL_S 18
#define IG3_PBLOC0_GLPBLOC_CACHE_2_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_DBG_CTL_ADR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_2_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_DBG_DATA 0x4290014C
#define IG3_PBLOC0_GLPBLOC_CACHE_2_DBG_DATA_RD_DW_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_2_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG 0x42900100
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_RSVD3_S 20
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_RM_S 16
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_RSVD2_S 14
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_RME_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_RSVD1_S 10
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_ERR_CNT_S 9
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_FIX_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_LS_BYPASS_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_LS_FORCE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS 0x42900104
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS_RSVD1_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS_RSVD0_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS_INIT_DONE_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS_ECC_FIX_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS_ECC_ERR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_2_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_DBG_CTL 0x42900150
#define IG3_PBLOC0_GLPBLOC_CACHE_3_DBG_CTL_DONE_S 31
#define IG3_PBLOC0_GLPBLOC_CACHE_3_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_DBG_CTL_RD_EN_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_3_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_DBG_CTL_RSVD_S 26
#define IG3_PBLOC0_GLPBLOC_CACHE_3_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_DBG_CTL_DW_SEL_S 18
#define IG3_PBLOC0_GLPBLOC_CACHE_3_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_DBG_CTL_ADR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_3_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_DBG_DATA 0x42900154
#define IG3_PBLOC0_GLPBLOC_CACHE_3_DBG_DATA_RD_DW_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_3_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG 0x42900108
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_RSVD3_S 20
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_RM_S 16
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_RSVD2_S 14
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_RME_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_RSVD1_S 10
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_ERR_CNT_S 9
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_FIX_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_LS_BYPASS_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_LS_FORCE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS 0x4290010C
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS_RSVD1_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS_RSVD0_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS_INIT_DONE_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS_ECC_FIX_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS_ECC_ERR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_3_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_DBG_CTL 0x42900158
#define IG3_PBLOC0_GLPBLOC_CACHE_4_DBG_CTL_DONE_S 31
#define IG3_PBLOC0_GLPBLOC_CACHE_4_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_DBG_CTL_RD_EN_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_4_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_DBG_CTL_RSVD_S 26
#define IG3_PBLOC0_GLPBLOC_CACHE_4_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_DBG_CTL_DW_SEL_S 18
#define IG3_PBLOC0_GLPBLOC_CACHE_4_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_DBG_CTL_ADR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_4_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_DBG_DATA 0x4290015C
#define IG3_PBLOC0_GLPBLOC_CACHE_4_DBG_DATA_RD_DW_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_4_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG 0x42900110
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_RSVD3_S 20
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_RM_S 16
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_RSVD2_S 14
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_RME_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_RSVD1_S 10
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_ERR_CNT_S 9
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_FIX_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_LS_BYPASS_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_LS_FORCE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS 0x42900114
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS_RSVD1_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS_RSVD0_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS_INIT_DONE_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS_ECC_FIX_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS_ECC_ERR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_4_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_DBG_CTL 0x42900160
#define IG3_PBLOC0_GLPBLOC_CACHE_5_DBG_CTL_DONE_S 31
#define IG3_PBLOC0_GLPBLOC_CACHE_5_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_DBG_CTL_RD_EN_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_5_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_DBG_CTL_RSVD_S 26
#define IG3_PBLOC0_GLPBLOC_CACHE_5_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_DBG_CTL_DW_SEL_S 18
#define IG3_PBLOC0_GLPBLOC_CACHE_5_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_DBG_CTL_ADR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_5_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_DBG_DATA 0x42900164
#define IG3_PBLOC0_GLPBLOC_CACHE_5_DBG_DATA_RD_DW_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_5_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG 0x42900118
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_RSVD3_S 20
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_RM_S 16
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_RSVD2_S 14
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_RME_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_RSVD1_S 10
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_ERR_CNT_S 9
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_FIX_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_LS_BYPASS_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_LS_FORCE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS 0x4290011C
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS_RSVD1_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS_RSVD0_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS_INIT_DONE_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS_ECC_FIX_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS_ECC_ERR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_5_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_DBG_CTL 0x42900168
#define IG3_PBLOC0_GLPBLOC_CACHE_6_DBG_CTL_DONE_S 31
#define IG3_PBLOC0_GLPBLOC_CACHE_6_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_DBG_CTL_RD_EN_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_6_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_DBG_CTL_RSVD_S 26
#define IG3_PBLOC0_GLPBLOC_CACHE_6_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_DBG_CTL_DW_SEL_S 18
#define IG3_PBLOC0_GLPBLOC_CACHE_6_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_DBG_CTL_ADR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_6_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_DBG_DATA 0x4290016C
#define IG3_PBLOC0_GLPBLOC_CACHE_6_DBG_DATA_RD_DW_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_6_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG 0x42900120
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_RSVD3_S 20
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_RM_S 16
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_RSVD2_S 14
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_RME_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_RSVD1_S 10
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_ERR_CNT_S 9
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_FIX_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_LS_BYPASS_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_LS_FORCE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS 0x42900124
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS_RSVD1_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS_RSVD0_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS_INIT_DONE_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS_ECC_FIX_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS_ECC_ERR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_6_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_DBG_CTL 0x42900170
#define IG3_PBLOC0_GLPBLOC_CACHE_7_DBG_CTL_DONE_S 31
#define IG3_PBLOC0_GLPBLOC_CACHE_7_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_DBG_CTL_RD_EN_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_7_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_DBG_CTL_RSVD_S 26
#define IG3_PBLOC0_GLPBLOC_CACHE_7_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_DBG_CTL_DW_SEL_S 18
#define IG3_PBLOC0_GLPBLOC_CACHE_7_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_DBG_CTL_ADR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_7_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_DBG_DATA 0x42900174
#define IG3_PBLOC0_GLPBLOC_CACHE_7_DBG_DATA_RD_DW_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_7_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG 0x42900128
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_RSVD3_S 20
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_RM_S 16
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_RSVD2_S 14
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_RME_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_RSVD1_S 10
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_ERR_CNT_S 9
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_FIX_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_LS_BYPASS_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_LS_FORCE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS 0x4290012C
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS_RSVD1_S 30
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS_RSVD0_S 4
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS_INIT_DONE_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS_ECC_FIX_S 1
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS_ECC_ERR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_7_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CACHE_CTRL 0x42900000
#define IG3_PBLOC0_GLPBLOC_CACHE_CTRL_RSVD_S 2
#define IG3_PBLOC0_GLPBLOC_CACHE_CTRL_RSVD GENMASK_ULL(2, 31)
#define IG3_PBLOC0_GLPBLOC_CACHE_CTRL_SCALE_FACTOR_S 0
#define IG3_PBLOC0_GLPBLOC_CACHE_CTRL_SCALE_FACTOR GENMASK_ULL(0, 1)
#define IG3_PBLOC0_GLPBLOC_CECC_ERR 0x4290009C
#define IG3_PBLOC0_GLPBLOC_CECC_ERR_RSVD1_S 28
#define IG3_PBLOC0_GLPBLOC_CECC_ERR_RSVD1 GENMASK_ULL(28, 31)
#define IG3_PBLOC0_GLPBLOC_CECC_ERR_COR_ECC_ERR_CNT_S 16
#define IG3_PBLOC0_GLPBLOC_CECC_ERR_COR_ECC_ERR_CNT GENMASK_ULL(16, 27)
#define IG3_PBLOC0_GLPBLOC_CECC_ERR_RSVD0_S 12
#define IG3_PBLOC0_GLPBLOC_CECC_ERR_RSVD0 GENMASK_ULL(12, 15)
#define IG3_PBLOC0_GLPBLOC_CECC_ERR_UNCOR_ECC_ERR_CNT_S 0
#define IG3_PBLOC0_GLPBLOC_CECC_ERR_UNCOR_ECC_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PBLOC0_GLPBLOC_CSTATELKUP_CFG 0x429000A4
#define IG3_PBLOC0_GLPBLOC_CSTATELKUP_CFG_RSVD1_S 9
#define IG3_PBLOC0_GLPBLOC_CSTATELKUP_CFG_RSVD1 GENMASK_ULL(9, 31)
#define IG3_PBLOC0_GLPBLOC_CSTATELKUP_CFG_LKUP_REPLAY_ON_PEND_CLR_S 8
#define IG3_PBLOC0_GLPBLOC_CSTATELKUP_CFG_LKUP_REPLAY_ON_PEND_CLR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_CSTATELKUP_CFG_RSVD0_S 3
#define IG3_PBLOC0_GLPBLOC_CSTATELKUP_CFG_RSVD0 GENMASK_ULL(3, 7)
#define IG3_PBLOC0_GLPBLOC_CSTATELKUP_CFG_LKUP_RATE_LIMIT_WTCYCLES_S 0
#define IG3_PBLOC0_GLPBLOC_CSTATELKUP_CFG_LKUP_RATE_LIMIT_WTCYCLES GENMASK_ULL(0, 2)
#define IG3_PBLOC0_GLPBLOC_DPC_COMP 0x429000B4
#define IG3_PBLOC0_GLPBLOC_DPC_COMP_RSVD_S 13
#define IG3_PBLOC0_GLPBLOC_DPC_COMP_RSVD GENMASK_ULL(13, 31)
#define IG3_PBLOC0_GLPBLOC_DPC_COMP_COMP_FTYPE_S 11
#define IG3_PBLOC0_GLPBLOC_DPC_COMP_COMP_FTYPE GENMASK_ULL(11, 12)
#define IG3_PBLOC0_GLPBLOC_DPC_COMP_COMP_FNUM_S 1
#define IG3_PBLOC0_GLPBLOC_DPC_COMP_COMP_FNUM GENMASK_ULL(1, 10)
#define IG3_PBLOC0_GLPBLOC_DPC_COMP_COMP_VALID_S 0
#define IG3_PBLOC0_GLPBLOC_DPC_COMP_COMP_VALID_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DPC_REQ 0x429000B0
#define IG3_PBLOC0_GLPBLOC_DPC_REQ_RSVD_S 12
#define IG3_PBLOC0_GLPBLOC_DPC_REQ_RSVD GENMASK_ULL(12, 31)
#define IG3_PBLOC0_GLPBLOC_DPC_REQ_REQ_FTYPE_S 10
#define IG3_PBLOC0_GLPBLOC_DPC_REQ_REQ_FTYPE GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_DPC_REQ_REQ_FNUM_S 0
#define IG3_PBLOC0_GLPBLOC_DPC_REQ_REQ_FNUM GENMASK_ULL(0, 9)
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_COUNT 0x42900238
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_COUNT_RSVD1_S 20
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_COUNT_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_COUNT_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_COUNT_VALUE GENMASK_ULL(0, 19)
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_CMD 0x4290024C
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_CMD_RSVD1_S 1
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_CMD_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_CMD_VALUE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_DATA_H 0x42900258
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_DATA_H_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_DATA_L 0x42900254
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_DATA_L_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_PTR 0x42900250
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_PTR_RSVD1_S 20
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_PTR_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_RD_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_CMD 0x4290023C
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_CMD_RSVD1_S 1
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_CMD_RSVD1 GENMASK_ULL(1, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_CMD_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_CMD_VALUE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_DATA_H 0x42900248
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_DATA_H_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_DATA_H_VALUE GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_DATA_L 0x42900244
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_DATA_L_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_DATA_L_VALUE GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_PTR 0x42900240
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_PTR_RSVD1_S 20
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_PTR_RSVD1 GENMASK_ULL(20, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_PTR_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_BUFFER_WR_PTR_VALUE GENMASK_ULL(0, 19)
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL 0x42900200
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_RSVD1_S 25
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_RSVD1 GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_SOFT_CLEAR_S 24
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_SOFT_CLEAR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_RSVD2_S 17
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_RSVD2 GENMASK_ULL(17, 23)
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_FORCE_TRIG_S 16
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_FORCE_TRIG_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_RSVD3_S 9
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_RSVD3 GENMASK_ULL(9, 15)
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_BYPASS_S 8
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_RSVD4_S 1
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_RSVD4 GENMASK_ULL(1, 7)
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_LOCAL_EN_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_CONTROL_LOCAL_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_ECC_COR_ERR 0x42900268
#define IG3_PBLOC0_GLPBLOC_DTM_ECC_COR_ERR_RSVD_S 12
#define IG3_PBLOC0_GLPBLOC_DTM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_ECC_COR_ERR_CNT_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PBLOC0_GLPBLOC_DTM_ECC_UNCOR_ERR 0x42900264
#define IG3_PBLOC0_GLPBLOC_DTM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_PBLOC0_GLPBLOC_DTM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PBLOC0_GLPBLOC_DTM_GROUP_CFG 0x4290020C
#define IG3_PBLOC0_GLPBLOC_DTM_GROUP_CFG_RSVD1_S 24
#define IG3_PBLOC0_GLPBLOC_DTM_GROUP_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_GROUP_CFG_TRIG_GROUP_S 16
#define IG3_PBLOC0_GLPBLOC_DTM_GROUP_CFG_TRIG_GROUP GENMASK_ULL(16, 23)
#define IG3_PBLOC0_GLPBLOC_DTM_GROUP_CFG_LOG_MSGROUP_S 8
#define IG3_PBLOC0_GLPBLOC_DTM_GROUP_CFG_LOG_MSGROUP GENMASK_ULL(8, 15)
#define IG3_PBLOC0_GLPBLOC_DTM_GROUP_CFG_LOG_LSGROUP_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_GROUP_CFG_LOG_LSGROUP GENMASK_ULL(0, 7)
#define IG3_PBLOC0_GLPBLOC_DTM_LOG_CFG 0x42900210
#define IG3_PBLOC0_GLPBLOC_DTM_LOG_CFG_LOG_POST_TRIG_S 16
#define IG3_PBLOC0_GLPBLOC_DTM_LOG_CFG_LOG_POST_TRIG GENMASK_ULL(16, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_LOG_CFG_RSVD1_S 2
#define IG3_PBLOC0_GLPBLOC_DTM_LOG_CFG_RSVD1 GENMASK_ULL(2, 15)
#define IG3_PBLOC0_GLPBLOC_DTM_LOG_CFG_MODE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_LOG_CFG_MODE GENMASK_ULL(0, 1)
#define IG3_PBLOC0_GLPBLOC_DTM_LOG_MASK 0x42900218
#define IG3_PBLOC0_GLPBLOC_DTM_LOG_MASK_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_LOG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_LOG_PATTERN 0x42900214
#define IG3_PBLOC0_GLPBLOC_DTM_LOG_PATTERN_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_LOG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_CFG 0x42900204
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_CFG_RSVD1_S 26
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_CFG_RSVD1 GENMASK_ULL(26, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_CFG_EXTMODE_S 24
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_CFG_EXTMODE GENMASK_ULL(24, 25)
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_CFG_RSVD2_S 17
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_CFG_RSVD2 GENMASK_ULL(17, 23)
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_CFG_TIMESTAMP_DIS_S 16
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_CFG_TIMESTAMP_DIS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_CFG_RSVD3_S 1
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_CFG_RSVD3 GENMASK_ULL(1, 15)
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_CFG_EXT_TRIGOUT_DIS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_STS 0x42900208
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_STS_RSVD1_S 9
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_STS_RSVD1 GENMASK_ULL(9, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_STS_TRACE_ERR_S 8
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_STS_TRACE_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_STS_RSVD2_S 1
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_STS_RSVD2 GENMASK_ULL(1, 7)
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_STS_TRACE_DONE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_MAIN_STS_TRACE_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TIMESTAMP 0x42900230
#define IG3_PBLOC0_GLPBLOC_DTM_TIMESTAMP_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_TIMESTAMP_ROLLOVER 0x42900234
#define IG3_PBLOC0_GLPBLOC_DTM_TIMESTAMP_ROLLOVER_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_TIMESTAMP_ROLLOVER_VALUE GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG 0x4290025C
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_RSVD3_S 20
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_RM_S 16
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_RSVD2_S 14
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_RME_S 12
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_RSVD1_S 10
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_ERR_CNT_S 9
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_FIX_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_LS_BYPASS_S 4
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_LS_FORCE_S 3
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS 0x42900260
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS_RSVD1_S 30
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS_RSVD0_S 4
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS_INIT_DONE_S 2
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS_ECC_FIX_S 1
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS_ECC_ERR_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_TRACE_BUFFER_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_CFG 0x4290021C
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_CFG_RSVD1_S 24
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_CFG_RSVD1 GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_CFG_EVENT_WIDTH_S 16
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_CFG_EVENT_WIDTH GENMASK_ULL(16, 23)
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_CFG_COUNTDOWN_S 8
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_CFG_COUNTDOWN GENMASK_ULL(8, 15)
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_CFG_RSVD2_S 4
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_CFG_RSVD2 GENMASK_ULL(4, 7)
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_CFG_MODE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_CFG_MODE GENMASK_ULL(0, 3)
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_COUNT 0x42900228
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_COUNT_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_COUNT_VALUE GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_MASK 0x42900224
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_MASK_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_MASK_VALUE GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_PATTERN 0x42900220
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_PATTERN_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_PATTERN_VALUE GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_TIMESTAMP 0x4290022C
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_TIMESTAMP_VALUE_S 0
#define IG3_PBLOC0_GLPBLOC_DTM_TRIG_TIMESTAMP_VALUE GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_ECC_CTL 0x42900094
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_RSVD_S 8
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_RSVD GENMASK_ULL(8, 31)
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_CLIENT_ECC_INVERT2_S 7
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_CLIENT_ECC_INVERT2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_CLIENT_ECC_INVERT1_S 6
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_CLIENT_ECC_INVERT1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_CLIENT_ECC_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_CLIENT_ECC_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_CLIENT_ECC_EN_S 4
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_CLIENT_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_HOST_ECC_INVERT2_S 3
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_HOST_ECC_INVERT2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_HOST_ECC_INVERT1_S 2
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_HOST_ECC_INVERT1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_HOST_ECC_MASK_INT_S 1
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_HOST_ECC_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_HOST_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_ECC_CTL_HOST_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_ERRDATA0 0x42900084
#define IG3_PBLOC0_GLPBLOC_ERRDATA0_RSVD1_S 31
#define IG3_PBLOC0_GLPBLOC_ERRDATA0_RSVD1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_ERRDATA0_PF_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_ERRDATA0_PF_NUM GENMASK_ULL(25, 30)
#define IG3_PBLOC0_GLPBLOC_ERRDATA0_VDEV_VF_NUM_S 15
#define IG3_PBLOC0_GLPBLOC_ERRDATA0_VDEV_VF_NUM GENMASK_ULL(15, 24)
#define IG3_PBLOC0_GLPBLOC_ERRDATA0_VDEV_VF_TYPE_S 13
#define IG3_PBLOC0_GLPBLOC_ERRDATA0_VDEV_VF_TYPE GENMASK_ULL(13, 14)
#define IG3_PBLOC0_GLPBLOC_ERRDATA0_OBJ_TYPE_S 8
#define IG3_PBLOC0_GLPBLOC_ERRDATA0_OBJ_TYPE GENMASK_ULL(8, 12)
#define IG3_PBLOC0_GLPBLOC_ERRDATA0_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_ERRDATA0_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_ERRDATA0_ERROR_CODE_S 0
#define IG3_PBLOC0_GLPBLOC_ERRDATA0_ERROR_CODE GENMASK_ULL(0, 5)
#define IG3_PBLOC0_GLPBLOC_ERRDATA1 0x42900088
#define IG3_PBLOC0_GLPBLOC_ERRDATA1_RSVD_S 28
#define IG3_PBLOC0_GLPBLOC_ERRDATA1_RSVD GENMASK_ULL(28, 31)
#define IG3_PBLOC0_GLPBLOC_ERRDATA1_OBJ_INDEX_S 0
#define IG3_PBLOC0_GLPBLOC_ERRDATA1_OBJ_INDEX GENMASK_ULL(0, 27)
#define IG3_PBLOC0_GLPBLOC_ERRDATA2 0x4290008C
#define IG3_PBLOC0_GLPBLOC_ERRDATA2_RSVD_S 23
#define IG3_PBLOC0_GLPBLOC_ERRDATA2_RSVD GENMASK_ULL(23, 31)
#define IG3_PBLOC0_GLPBLOC_ERRDATA2_OPTYPE_S 20
#define IG3_PBLOC0_GLPBLOC_ERRDATA2_OPTYPE GENMASK_ULL(20, 22)
#define IG3_PBLOC0_GLPBLOC_ERRDATA2_OFFSET_S 7
#define IG3_PBLOC0_GLPBLOC_ERRDATA2_OFFSET GENMASK_ULL(7, 19)
#define IG3_PBLOC0_GLPBLOC_ERRDATA2_LENGTH_S 0
#define IG3_PBLOC0_GLPBLOC_ERRDATA2_LENGTH GENMASK_ULL(0, 6)
#define IG3_PBLOC0_GLPBLOC_ERRDATA3 0x42900090
#define IG3_PBLOC0_GLPBLOC_ERRDATA3_RSVD_S 15
#define IG3_PBLOC0_GLPBLOC_ERRDATA3_RSVD GENMASK_ULL(15, 31)
#define IG3_PBLOC0_GLPBLOC_ERRDATA3_TAG_S 0
#define IG3_PBLOC0_GLPBLOC_ERRDATA3_TAG GENMASK_ULL(0, 14)
#define IG3_PBLOC0_GLPBLOC_ERRINFO 0x42900080
#define IG3_PBLOC0_GLPBLOC_ERRINFO_RSVD1_S 16
#define IG3_PBLOC0_GLPBLOC_ERRINFO_RSVD1 GENMASK_ULL(16, 31)
#define IG3_PBLOC0_GLPBLOC_ERRINFO_ERROR_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_ERRINFO_ERROR_CNT GENMASK_ULL(8, 15)
#define IG3_PBLOC0_GLPBLOC_ERRINFO_RSVD0_S 1
#define IG3_PBLOC0_GLPBLOC_ERRINFO_RSVD0 GENMASK_ULL(1, 7)
#define IG3_PBLOC0_GLPBLOC_ERRINFO_ERROR_VALID_S 0
#define IG3_PBLOC0_GLPBLOC_ERRINFO_ERROR_VALID_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG 0x429000E8
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_RSVD3_S 20
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_RM_S 16
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_RSVD2_S 14
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_RME_S 12
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_RSVD1_S 10
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_ERR_CNT_S 9
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_FIX_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_LS_BYPASS_S 4
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_LS_FORCE_S 3
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS 0x429000EC
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS_RSVD1_S 30
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS_RSVD0_S 4
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS_INIT_DONE_S 2
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS_ECC_FIX_S 1
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS_ECC_ERR_S 0
#define IG3_PBLOC0_GLPBLOC_EVICT_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG 0x429000E0
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_RSVD3_S 20
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_RM_S 16
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_RSVD2_S 14
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_RME_S 12
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_RSVD1_S 10
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_ERR_CNT_S 9
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_FIX_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_LS_BYPASS_S 4
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_LS_FORCE_S 3
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS 0x429000E4
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS_RSVD1_S 30
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS_RSVD0_S 4
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS_INIT_DONE_S 2
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS_ECC_FIX_S 1
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS_ECC_ERR_S 0
#define IG3_PBLOC0_GLPBLOC_FILL_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_HECC_ERR 0x42900098
#define IG3_PBLOC0_GLPBLOC_HECC_ERR_RSVD1_S 28
#define IG3_PBLOC0_GLPBLOC_HECC_ERR_RSVD1 GENMASK_ULL(28, 31)
#define IG3_PBLOC0_GLPBLOC_HECC_ERR_COR_ECC_ERR_CNT_S 16
#define IG3_PBLOC0_GLPBLOC_HECC_ERR_COR_ECC_ERR_CNT GENMASK_ULL(16, 27)
#define IG3_PBLOC0_GLPBLOC_HECC_ERR_RSVD0_S 12
#define IG3_PBLOC0_GLPBLOC_HECC_ERR_RSVD0 GENMASK_ULL(12, 15)
#define IG3_PBLOC0_GLPBLOC_HECC_ERR_UNCOR_ECC_ERR_CNT_S 0
#define IG3_PBLOC0_GLPBLOC_HECC_ERR_UNCOR_ECC_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PBLOC0_GLPBLOC_MAXOSR 0x429000A0
#define IG3_PBLOC0_GLPBLOC_MAXOSR_RSVD1_S 11
#define IG3_PBLOC0_GLPBLOC_MAXOSR_RSVD1 GENMASK_ULL(11, 31)
#define IG3_PBLOC0_GLPBLOC_MAXOSR_MAX_OSR_CLNT_WRPULL_S 10
#define IG3_PBLOC0_GLPBLOC_MAXOSR_MAX_OSR_CLNT_WRPULL_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_MAXOSR_RSVD0_S 8
#define IG3_PBLOC0_GLPBLOC_MAXOSR_RSVD0 GENMASK_ULL(8, 9)
#define IG3_PBLOC0_GLPBLOC_MAXOSR_MAX_OSR_PMAT_FETCH_S 0
#define IG3_PBLOC0_GLPBLOC_MAXOSR_MAX_OSR_PMAT_FETCH GENMASK_ULL(0, 7)
#define IG3_PBLOC0_GLPBLOC_MEM_ECC_COR_ERR 0x42900184
#define IG3_PBLOC0_GLPBLOC_MEM_ECC_COR_ERR_RSVD_S 12
#define IG3_PBLOC0_GLPBLOC_MEM_ECC_COR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PBLOC0_GLPBLOC_MEM_ECC_COR_ERR_CNT_S 0
#define IG3_PBLOC0_GLPBLOC_MEM_ECC_COR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PBLOC0_GLPBLOC_MEM_ECC_UNCOR_ERR 0x42900180
#define IG3_PBLOC0_GLPBLOC_MEM_ECC_UNCOR_ERR_RSVD_S 12
#define IG3_PBLOC0_GLPBLOC_MEM_ECC_UNCOR_ERR_RSVD GENMASK_ULL(12, 31)
#define IG3_PBLOC0_GLPBLOC_MEM_ECC_UNCOR_ERR_CNT_S 0
#define IG3_PBLOC0_GLPBLOC_MEM_ECC_UNCOR_ERR_CNT GENMASK_ULL(0, 11)
#define IG3_PBLOC0_GLPBLOC_PBLE_OBJOFST 0x42900078
#define IG3_PBLOC0_GLPBLOC_PBLE_OBJOFST_RSVD_S 10
#define IG3_PBLOC0_GLPBLOC_PBLE_OBJOFST_RSVD GENMASK_ULL(10, 31)
#define IG3_PBLOC0_GLPBLOC_PBLE_OBJOFST_OBJ_TYPE_OFFSET_S 0
#define IG3_PBLOC0_GLPBLOC_PBLE_OBJOFST_OBJ_TYPE_OFFSET GENMASK_ULL(0, 9)
#define IG3_PBLOC0_GLPBLOC_PLIST_DBG_CTL 0x42900178
#define IG3_PBLOC0_GLPBLOC_PLIST_DBG_CTL_DONE_S 31
#define IG3_PBLOC0_GLPBLOC_PLIST_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_DBG_CTL_RD_EN_S 30
#define IG3_PBLOC0_GLPBLOC_PLIST_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_DBG_CTL_RSVD_S 26
#define IG3_PBLOC0_GLPBLOC_PLIST_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PBLOC0_GLPBLOC_PLIST_DBG_CTL_DW_SEL_S 18
#define IG3_PBLOC0_GLPBLOC_PLIST_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PBLOC0_GLPBLOC_PLIST_DBG_CTL_ADR_S 0
#define IG3_PBLOC0_GLPBLOC_PLIST_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PBLOC0_GLPBLOC_PLIST_DBG_DATA 0x4290017C
#define IG3_PBLOC0_GLPBLOC_PLIST_DBG_DATA_RD_DW_S 0
#define IG3_PBLOC0_GLPBLOC_PLIST_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG 0x429000D8
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_RSVD3_S 20
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_RM_S 16
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_RSVD2_S 14
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_RME_S 12
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_RSVD1_S 10
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_ERR_CNT_S 9
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_FIX_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_LS_BYPASS_S 4
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_LS_FORCE_S 3
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS 0x429000DC
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS_RSVD1_S 30
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS_RSVD0_S 4
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS_INIT_DONE_S 2
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS_ECC_FIX_S 1
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS_ECC_ERR_S 0
#define IG3_PBLOC0_GLPBLOC_PLIST_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG 0x429000A8
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG_RSVD_S 6
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG_RSVD GENMASK_ULL(6, 31)
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG_WBINVBYPRNTANDFN_FENCE_EN_S 5
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG_WBINVBYPRNTANDFN_FENCE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG_WBINVBYTYPEANDFN_FENCE_EN_S 4
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG_WBINVBYTYPEANDFN_FENCE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG_WBINVBYFN_FENCE_EN_S 3
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG_WBINVBYFN_FENCE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG_WBINVBYOBJ_FENCE_EN_S 2
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG_WBINVBYOBJ_FENCE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG_INVBYTYPEANDFN_FENCE_EN_S 1
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG_INVBYTYPEANDFN_FENCE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG_INVBYFN_FENCE_EN_S 0
#define IG3_PBLOC0_GLPBLOC_PMATINV_CFG_INVBYFN_FENCE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_STAT_CTL 0x42900004
#define IG3_PBLOC0_GLPBLOC_STAT_CTL_RSVD_S 5
#define IG3_PBLOC0_GLPBLOC_STAT_CTL_RSVD GENMASK_ULL(5, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_CTL_OBJECT_TYPE_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_CTL_OBJECT_TYPE GENMASK_ULL(0, 4)
#define IG3_PBLOC0_GLPBLOC_STAT_FENCING_TIME_HI 0x4290006C
#define IG3_PBLOC0_GLPBLOC_STAT_FENCING_TIME_HI_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_STAT_FENCING_TIME_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_FENCING_TIME_HI_CNT_HI_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_FENCING_TIME_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PBLOC0_GLPBLOC_STAT_FENCING_TIME_LO 0x42900068
#define IG3_PBLOC0_GLPBLOC_STAT_FENCING_TIME_LO_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_FENCING_TIME_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_PENDING_ENTRIES 0x4290004C
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_PENDING_ENTRIES_RSVD_S 8
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_PENDING_ENTRIES_RSVD GENMASK_ULL(8, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_PENDING_ENTRIES_CNT_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_PENDING_ENTRIES_CNT GENMASK_ULL(0, 7)
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_PENDING_LIST_DEPTH 0x42900054
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_PENDING_LIST_DEPTH_RSVD_S 8
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_PENDING_LIST_DEPTH_RSVD GENMASK_ULL(8, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_PENDING_LIST_DEPTH_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_PENDING_LIST_DEPTH_CNT_LO GENMASK_ULL(0, 7)
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_VIRT_PENDING_LISTS 0x42900050
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_VIRT_PENDING_LISTS_RSVD_S 8
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_VIRT_PENDING_LISTS_RSVD GENMASK_ULL(8, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_VIRT_PENDING_LISTS_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_MAX_VIRT_PENDING_LISTS_CNT_LO GENMASK_ULL(0, 7)
#define IG3_PBLOC0_GLPBLOC_STAT_OBJ_CNT 0x42900008
#define IG3_PBLOC0_GLPBLOC_STAT_OBJ_CNT_RSVD_S 14
#define IG3_PBLOC0_GLPBLOC_STAT_OBJ_CNT_RSVD GENMASK_ULL(14, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_OBJ_CNT_OBJECT_COUNT_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_OBJ_CNT_OBJECT_COUNT GENMASK_ULL(0, 13)
#define IG3_PBLOC0_GLPBLOC_STAT_PENDLING_LIST_FULL_HI 0x42900064
#define IG3_PBLOC0_GLPBLOC_STAT_PENDLING_LIST_FULL_HI_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_STAT_PENDLING_LIST_FULL_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_PENDLING_LIST_FULL_HI_CNT_HI_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_PENDLING_LIST_FULL_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PBLOC0_GLPBLOC_STAT_PENDLING_LIST_FULL_LO 0x42900060
#define IG3_PBLOC0_GLPBLOC_STAT_PENDLING_LIST_FULL_LO_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_PENDLING_LIST_FULL_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_IDLE_HI 0x42900030
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_IDLE_HI_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_IDLE_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_IDLE_HI_CNT_HI_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_IDLE_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_IDLE_LO 0x4290002C
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_IDLE_LO_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_IDLE_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_XFER_HI 0x42900038
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_XFER_HI_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_XFER_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_XFER_HI_CNT_HI_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_XFER_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_XFER_LO 0x42900034
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_XFER_LO_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_RD_DATA_XFER_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_RD_HIT_HI 0x42900010
#define IG3_PBLOC0_GLPBLOC_STAT_RD_HIT_HI_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_STAT_RD_HIT_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_RD_HIT_HI_CNT_HI_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_RD_HIT_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PBLOC0_GLPBLOC_STAT_RD_HIT_LO 0x4290000C
#define IG3_PBLOC0_GLPBLOC_STAT_RD_HIT_LO_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_RD_HIT_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_RD_MISS_HI 0x42900018
#define IG3_PBLOC0_GLPBLOC_STAT_RD_MISS_HI_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_STAT_RD_MISS_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_RD_MISS_HI_CNT_HI_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_RD_MISS_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PBLOC0_GLPBLOC_STAT_RD_MISS_LO 0x42900014
#define IG3_PBLOC0_GLPBLOC_STAT_RD_MISS_LO_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_RD_MISS_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_REPLAY_TIME_HI 0x42900074
#define IG3_PBLOC0_GLPBLOC_STAT_REPLAY_TIME_HI_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_STAT_REPLAY_TIME_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_REPLAY_TIME_HI_CNT_HI_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_REPLAY_TIME_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PBLOC0_GLPBLOC_STAT_REPLAY_TIME_LO 0x42900070
#define IG3_PBLOC0_GLPBLOC_STAT_REPLAY_TIME_LO_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_REPLAY_TIME_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_BUFF_FULL_HI 0x4290005C
#define IG3_PBLOC0_GLPBLOC_STAT_WR_BUFF_FULL_HI_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_STAT_WR_BUFF_FULL_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_BUFF_FULL_HI_CNT_HI_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_WR_BUFF_FULL_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_BUFF_FULL_LO 0x42900058
#define IG3_PBLOC0_GLPBLOC_STAT_WR_BUFF_FULL_LO_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_WR_BUFF_FULL_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_IDLE_HI 0x42900040
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_IDLE_HI_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_IDLE_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_IDLE_HI_CNT_HI_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_IDLE_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_IDLE_LO 0x4290003C
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_IDLE_LO_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_IDLE_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_XFER_HI 0x42900048
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_XFER_HI_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_XFER_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_XFER_HI_CNT_HI_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_XFER_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_XFER_LO 0x42900044
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_XFER_LO_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_WR_DATA_XFER_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_HIT_HI 0x42900020
#define IG3_PBLOC0_GLPBLOC_STAT_WR_HIT_HI_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_STAT_WR_HIT_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_HIT_HI_CNT_HI_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_WR_HIT_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_HIT_LO 0x4290001C
#define IG3_PBLOC0_GLPBLOC_STAT_WR_HIT_LO_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_WR_HIT_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_MISS_HI 0x42900028
#define IG3_PBLOC0_GLPBLOC_STAT_WR_MISS_HI_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_STAT_WR_MISS_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_MISS_HI_CNT_HI_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_WR_MISS_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PBLOC0_GLPBLOC_STAT_WR_MISS_LO 0x42900024
#define IG3_PBLOC0_GLPBLOC_STAT_WR_MISS_LO_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_STAT_WR_MISS_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_TAG_DBG_CTL 0x42900130
#define IG3_PBLOC0_GLPBLOC_TAG_DBG_CTL_DONE_S 31
#define IG3_PBLOC0_GLPBLOC_TAG_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_DBG_CTL_RD_EN_S 30
#define IG3_PBLOC0_GLPBLOC_TAG_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_DBG_CTL_RSVD_S 26
#define IG3_PBLOC0_GLPBLOC_TAG_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PBLOC0_GLPBLOC_TAG_DBG_CTL_DW_SEL_S 18
#define IG3_PBLOC0_GLPBLOC_TAG_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PBLOC0_GLPBLOC_TAG_DBG_CTL_ADR_S 0
#define IG3_PBLOC0_GLPBLOC_TAG_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PBLOC0_GLPBLOC_TAG_DBG_DATA 0x42900134
#define IG3_PBLOC0_GLPBLOC_TAG_DBG_DATA_RD_DW_S 0
#define IG3_PBLOC0_GLPBLOC_TAG_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG 0x429000C8
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_RSVD3_S 20
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_RM_S 16
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_RSVD2_S 14
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_RME_S 12
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_RSVD1_S 10
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_ERR_CNT_S 9
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_FIX_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_LS_BYPASS_S 4
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_LS_FORCE_S 3
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS 0x429000CC
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS_RSVD1_S 30
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS_RSVD0_S 4
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS_INIT_DONE_S 2
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS_ECC_FIX_S 1
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS_ECC_ERR_S 0
#define IG3_PBLOC0_GLPBLOC_TAG_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_HI 0x429000BC
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_HI_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_HI_CNT_HI_S 0
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_HIT_HI 0x429000C4
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_HIT_HI_RSVD_S 24
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_HIT_HI_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_HIT_HI_CNT_HI_S 0
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_HIT_HI_CNT_HI GENMASK_ULL(0, 23)
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_HIT_LO 0x429000C0
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_HIT_LO_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_HIT_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_LO 0x429000B8
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_LO_CNT_LO_S 0
#define IG3_PBLOC0_GLPBLOC_TOTAL_TAG_LO_CNT_LO GENMASK_ULL(0, 31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG 0x429000D0
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_RSVD3_S 20
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_RM_S 16
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_RSVD2_S 14
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_RME_S 12
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_RSVD1_S 10
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_ERR_CNT_S 9
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_FIX_CNT_S 8
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_RSVD0_S 6
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_MASK_INT_S 5
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_LS_BYPASS_S 4
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_LS_FORCE_S 3
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_ECC_INVERT_1_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_ECC_EN_S 0
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_CFG_ECC_EN_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS 0x429000D4
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS_RSVD1_S 30
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS_RSVD1 GENMASK_ULL(30, 31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS_ECC_ERROR_ADDRESS_S 12
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS_ECC_ERROR_ADDRESS GENMASK_ULL(12, 29)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS_RSVD0_S 4
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS_RSVD0 GENMASK_ULL(4, 11)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS_GLOBAL_INIT_DONE_S 3
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS_GLOBAL_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS_INIT_DONE_S 2
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS_INIT_DONE_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS_ECC_FIX_S 1
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS_ECC_FIX_M BIT_ULL(31)
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS_ECC_ERR_S 0
#define IG3_PBLOC0_GLPBLOC_WRBUF_MEM_STATUS_ECC_ERR_M BIT_ULL(31)
#define IG3_PBLOC1_GLPBLOC_ARPTBLE_OBJOFST 0x4290047C
#define IG3_PBLOC1_GLPBLOC_ARPTBLE_OBJOFST_RSVD_S 10
#define IG3_PBLOC1_GLPBLOC_ARPTBLE_OBJOFST_RSVD GENMASK_ULL(10, 31)
#define IG3_PBLOC1_GLPBLOC_ARPTBLE_OBJOFST_OBJ_TYPE_OFFSET_S 0
#define IG3_PBLOC1_GLPBLOC_ARPTBLE_OBJOFST_OBJ_TYPE_OFFSET GENMASK_ULL(0, 9)
#define IG3_PBLOC1_GLPBLOC_CACHESIZE 0x429004AC
#define IG3_PBLOC1_GLPBLOC_CACHESIZE_RSVD_S 24
#define IG3_PBLOC1_GLPBLOC_CACHESIZE_RSVD GENMASK_ULL(24, 31)
#define IG3_PBLOC1_GLPBLOC_CACHESIZE_WAYS_S 20
#define IG3_PBLOC1_GLPBLOC_CACHESIZE_WAYS GENMASK_ULL(20, 23)
#define IG3_PBLOC1_GLPBLOC_CACHESIZE_SETS_S 8
#define IG3_PBLOC1_GLPBLOC_CACHESIZE_SETS GENMASK_ULL(8, 19)
#define IG3_PBLOC1_GLPBLOC_CACHESIZE_WORD_SIZE_S 0
#define IG3_PBLOC1_GLPBLOC_CACHESIZE_WORD_SIZE GENMASK_ULL(0, 7)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_DBG_CTL 0x42900538
#define IG3_PBLOC1_GLPBLOC_CACHE_0_DBG_CTL_DONE_S 31
#define IG3_PBLOC1_GLPBLOC_CACHE_0_DBG_CTL_DONE_M BIT_ULL(31)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_DBG_CTL_RD_EN_S 30
#define IG3_PBLOC1_GLPBLOC_CACHE_0_DBG_CTL_RD_EN_M BIT_ULL(31)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_DBG_CTL_RSVD_S 26
#define IG3_PBLOC1_GLPBLOC_CACHE_0_DBG_CTL_RSVD GENMASK_ULL(26, 29)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_DBG_CTL_DW_SEL_S 18
#define IG3_PBLOC1_GLPBLOC_CACHE_0_DBG_CTL_DW_SEL GENMASK_ULL(18, 25)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_DBG_CTL_ADR_S 0
#define IG3_PBLOC1_GLPBLOC_CACHE_0_DBG_CTL_ADR GENMASK_ULL(0, 17)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_DBG_DATA 0x4290053C
#define IG3_PBLOC1_GLPBLOC_CACHE_0_DBG_DATA_RD_DW_S 0
#define IG3_PBLOC1_GLPBLOC_CACHE_0_DBG_DATA_RD_DW GENMASK_ULL(0, 31)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG 0x429004F0
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_ECC_INST_NUM_S 25
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_ECC_INST_NUM GENMASK_ULL(25, 31)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_RSVD3_S 20
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_RSVD3 GENMASK_ULL(20, 24)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_RM_S 16
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_RM GENMASK_ULL(16, 19)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_RSVD2_S 14
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_RSVD2 GENMASK_ULL(14, 15)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_POWER_GATE_EN_S 13
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_POWER_GATE_EN_M BIT_ULL(31)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_RME_S 12
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_RME_M BIT_ULL(31)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_RSVD1_S 10
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_RSVD1 GENMASK_ULL(10, 11)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_ERR_CNT_S 9
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_ERR_CNT_M BIT_ULL(31)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_FIX_CNT_S 8
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_FIX_CNT_M BIT_ULL(31)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_RSVD0_S 6
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_RSVD0 GENMASK_ULL(6, 7)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_MASK_INT_S 5
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_MASK_INT_M BIT_ULL(31)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_LS_BYPASS_S 4
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_LS_BYPASS_M BIT_ULL(31)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_LS_FORCE_S 3
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_LS_FORCE_M BIT_ULL(31)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_ECC_INVERT_2_S 2
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_ECC_INVERT_2_M BIT_ULL(31)
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_ECC_INVERT_1_S 1
#define IG3_PBLOC1_GLPBLOC_CACHE_0_MEM_CFG_ECC_INVERT